/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.HeapdumpListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class Heapdump
extends Base
implements HeapdumpListener {
    String filename;
    DataInputStream dis;
    DataOutputStream dos;
    Vector strings = new Vector();
    boolean output;
    int lastId;
    public int totalObjects;
    public long totalSize;
    public int totalRefs;
    public int version;
    static final int USE_BYTE_SIZES = 128;
    static final int USE_SHORT_SIZES = 64;
    static final int USE_SHORT_REFS = 32;
    static final int IS_LEAF = 16;
    static final int TAG_MASK = 15;
    static final boolean optimize = true;
    int[] counts = new int[256];
    int biggestGap;
    int totalGap;
    int where;
    static String[] primitiveArrayName = new String[]{"unknown array type", "primitive array", "array of references", "unknown array type", "array of boolean", "array of char", "array of float", "array of double", "array of byte", "array of short", "array of int", "array of long", "unknown array type", "unknown array type", "unknown array type", "unknown array type"};

    Heapdump() {
    }

    public Heapdump(String string, boolean bl) throws IOException {
        this.filename = string;
        this.output = bl;
        if (bl) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.dos = new DataOutputStream(bufferedOutputStream);
                this.dos.writeUTF("portable heap dump");
                this.dos.writeInt(3);
                this.dos.writeInt(this.totalObjects);
                this.dos.writeLong(this.totalSize);
                this.dos.writeInt(this.totalRefs);
            }
            catch (Exception exception) {
                throw new Error("unexpected error: " + exception);
            }
        } else {
            FileInputStream fileInputStream;
            Closeable closeable = new RandomAccessFile(string, "r");
            if (!this.checkHeader((DataInput)((Object)closeable)) && !this.checkHeader((DataInput)((Object)(closeable = new DataInputStream(new GZIPInputStream(fileInputStream = new FileInputStream(string))))))) {
                throw new Error("invalid header - are you sure this is a .phd file?");
            }
            if (this.version == 1) {
                throw new IOException("version 1 phd files no longer supported, please rerun Convert");
            }
            if (this.version > 1) {
                this.readTotals((DataInput)((Object)closeable));
            }
        }
    }

    String className() {
        return "Heapdump";
    }

    public void close() {
        try {
            if (this.output) {
                this.dos.close();
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.filename, "rw");
                this.checkHeader(randomAccessFile);
                randomAccessFile.writeInt(this.totalObjects);
                randomAccessFile.writeLong(this.totalSize);
                randomAccessFile.writeInt(this.totalRefs);
                randomAccessFile.close();
                for (int i = 0; i < 256; ++i) {
                    if (this.counts[i] == 0) continue;
                }
            }
        }
        catch (Exception exception) {
            throw new Error("unexpected error while closing file" + exception);
        }
    }

    boolean checkHeader(DataInput dataInput) {
        try {
            String string = dataInput.readUTF();
            if (string.equals("portable heap dump")) {
                this.version = dataInput.readInt();
                return this.version > 0 && this.version < 4;
            }
            return string.equals("binary heap dump");
        }
        catch (Exception exception) {
            return false;
        }
    }

    void readTotals(DataInput dataInput) throws IOException {
        this.totalObjects = dataInput.readInt();
        this.totalSize = dataInput.readLong();
        this.totalRefs = dataInput.readInt();
    }

    public void parse(String string, HeapdumpListener heapdumpListener) {
        int[][] nArrayArray = new int[][]{};
        try {
            byte by;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            this.dis = new DataInputStream(bufferedInputStream);
            if (!this.checkHeader(this.dis)) {
                bufferedInputStream.close();
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                this.dis = new DataInputStream(new GZIPInputStream(bufferedInputStream));
                if (!this.checkHeader(this.dis)) {
                    throw new Error("invalid header - are you sure this is a .phd file?");
                }
            }
            if (this.version > 1) {
                this.readTotals(this.dis);
                if (this.version == 2) {
                    this.dis = new DataInputStream(new GZIPInputStream(bufferedInputStream));
                }
            }
            block14: while (true) {
                by = this.dis.readByte();
                switch (by & 0xF) {
                    case 1: {
                        String string2 = this.dis.readUTF();
                        this.strings.addElement(string2);
                        heapdumpListener.stringDump(string2);
                        continue block14;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int n;
                        int n2;
                        int n3;
                        short s;
                        int n4 = 0;
                        if ((by & 0x80) != 0) {
                            s = this.dis.readByte();
                            n3 = this.dis.readByte() & 0xFF;
                            if ((by & 0x10) == 0) {
                                n4 = this.dis.readByte() & 0xFF;
                            }
                            n2 = this.lastId + s;
                        } else if ((by & 0x40) != 0) {
                            s = this.dis.readShort();
                            n3 = this.dis.readShort() & 0xFFFF;
                            if ((by & 0x10) == 0) {
                                n4 = this.dis.readShort() & 0xFFFF;
                            }
                            n2 = this.lastId + s;
                        } else {
                            n2 = this.dis.readInt();
                            n3 = this.dis.readInt();
                            if ((by & 0x10) == 0) {
                                n4 = this.dis.readInt();
                            }
                        }
                        this.lastId = n2;
                        s = (by & 0xF) == 5 ? (short)this.dis.readByte() : this.dis.readShort();
                        int[] nArray = null;
                        if (n4 >= nArrayArray.length) {
                            int[][] nArrayArray2 = new int[n4 + 1][];
                            for (n = 0; n < nArrayArray.length; ++n) {
                                nArrayArray2[n] = nArrayArray[n];
                            }
                            nArrayArray2[n4] = new int[n4];
                            nArrayArray = nArrayArray2;
                        }
                        if ((nArray = nArrayArray[n4]) == null) {
                            nArrayArray[n4] = nArray = new int[n4];
                        }
                        for (int i = 0; i < n4; ++i) {
                            if ((by & 0x20) == 0) {
                                nArray[i] = this.dis.readInt();
                                continue;
                            }
                            n = this.dis.readShort();
                            nArray[i] = n + n2;
                        }
                        switch (by & 0xF) {
                            case 2: {
                                heapdumpListener.objectDump(n2, s, 0, n3, nArray);
                                continue block14;
                            }
                            case 3: {
                                heapdumpListener.classDump(n2, s, 0, n3, nArray);
                                continue block14;
                            }
                            case 4: {
                                heapdumpListener.objectArrayDump(n2, s, 0, n3, nArray);
                                continue block14;
                            }
                            case 5: {
                                heapdumpListener.primitiveArrayDump(n2, s, 0, n3);
                                continue block14;
                            }
                        }
                        Heapdump.Assert(false);
                        continue block14;
                    }
                    case 6: {
                        this.readTotals(this.dis);
                        continue block14;
                    }
                }
                break;
            }
            throw new Error("unknown type " + by);
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("unexpected error: " + exception);
        }
    }

    public void stringDump(String string) {
        try {
            this.dos.writeByte(1);
            this.dos.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new Error("unexpected error " + iOException);
        }
    }

    void instanceDump(int n, int n2, int n3, int n4, int[] nArray) {
        ++this.totalObjects;
        this.totalSize += (long)n4;
        if (nArray != null) {
            this.totalRefs += nArray.length;
        }
        try {
            int n5;
            int n6;
            int n7;
            int n8 = nArray == null ? 0 : nArray.length;
            n = (int)((long)n & 0xFFFFFFFFL);
            if (n8 == 0) {
                n2 |= 0x10;
            } else {
                n7 = 1;
                for (n6 = 0; n6 < n8; ++n6) {
                    n5 = nArray[n6];
                    if (Math.abs(n5 - n) <= Short.MAX_VALUE) continue;
                    n7 = 0;
                }
                if (n7 != 0) {
                    n2 |= 0x20;
                }
            }
            n7 = n - this.lastId;
            if ((n2 & 0xF) != 3 && n7 > this.biggestGap && this.totalObjects > 1) {
                this.where = this.lastId;
                this.biggestGap = n7;
            }
            if ((n2 & 0xF) != 3 && this.totalObjects > 1) {
                this.totalGap += n7;
            }
            if (Math.abs(n7) < 128 && n4 < 256 && n8 < 256) {
                this.dos.writeByte(n2 |= 0x80);
                int n9 = n2;
                this.counts[n9] = this.counts[n9] + 1;
                this.dos.writeByte(n7);
                this.dos.writeByte(n4);
                if ((n2 & 0x10) == 0) {
                    this.dos.writeByte(n8);
                }
            } else if (Math.abs(n7) < 32768 && n4 < 65536 && n8 < 65536) {
                this.dos.writeByte(n2 |= 0x40);
                int n10 = n2;
                this.counts[n10] = this.counts[n10] + 1;
                this.dos.writeShort(n7);
                this.dos.writeShort(n4);
                if ((n2 & 0x10) == 0) {
                    this.dos.writeShort(n8);
                }
            } else {
                this.dos.writeByte(n2);
                int n11 = n2;
                this.counts[n11] = this.counts[n11] + 1;
                this.dos.writeInt(n);
                this.dos.writeInt(n4);
                if ((n2 & 0x10) == 0) {
                    this.dos.writeInt(n8);
                }
            }
            if ((n2 & 0xF) == 5) {
                this.dos.writeByte(n3);
            } else {
                this.dos.writeShort(n3);
            }
            for (n6 = 0; n6 < n8; ++n6) {
                if ((n2 & 0x20) == 0) {
                    this.dos.writeInt(nArray[n6]);
                    continue;
                }
                n5 = nArray[n6];
                this.dos.writeShort(n5 -= n);
            }
            this.lastId = n;
        }
        catch (IOException iOException) {
            throw new Error("unexpected error " + iOException);
        }
    }

    public void objectDump(int n, int n2, int n3, int n4, int[] nArray) {
        this.instanceDump(n, 2, n2, n4, nArray);
    }

    public void classDump(int n, int n2, int n3, int n4, int[] nArray) {
        this.instanceDump(n, 3, n2, n4, nArray);
    }

    public void objectArrayDump(int n, int n2, int n3, int n4, int[] nArray) {
        this.instanceDump(n, 4, n2, n4, nArray);
    }

    public void primitiveArrayDump(int n, int n2, int n3, int n4) {
        this.instanceDump(n, 5, n2, n4, null);
    }

    public static String primitiveArrayName(int n) {
        return primitiveArrayName[n];
    }
}

