/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import java.io.IOException;
import java.io.LineNumberReader;

class VersionDetector {
    static final String VERSIONSTR = "// Version: ";
    private boolean flags;

    public boolean hasFlags() {
        return this.flags;
    }

    public VersionDetector(LineNumberReader lineNumberReader) throws IOException {
        this.detect(lineNumberReader);
    }

    private void detect(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        String string2 = null;
        String string3 = null;
        if (string.startsWith(VERSIONSTR)) {
            string2 = string.substring(VERSIONSTR.length() + 1);
        } else {
            string3 = string;
        }
        while (string3 == null || string3.startsWith("//")) {
            string3 = lineNumberReader.readLine();
        }
        if (string3.length() <= 11) {
            throw new IOException("No size start marker at position 11 on line " + lineNumberReader.getLineNumber() + " :" + string3);
        }
        if (string3.charAt(11) == '[') {
            this.flags = false;
        } else if (string3.charAt(11) == '<') {
            this.flags = true;
        } else {
            throw new IOException("No size start marker at position 11 on line " + lineNumberReader.getLineNumber() + " :" + string3);
        }
        lineNumberReader.close();
    }
}

