/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.util.BitSetArrayElement;
import com.ibm.jvm.util.IntEnumeration;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.IntPairEnumeration;
import com.ibm.jvm.util.Memory;
import com.ibm.jvm.util.SubsetClass;
import com.ibm.jvm.util.SvcdumpProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;

public final class BitSetArray
implements Serializable {
    Memory memory = new Memory();
    int[] freeLists;
    int[] roots = new int[1];
    int slotsInUse;
    int freeMemory;
    IntHashtable treeUsage;
    int mediumUsage = 0;
    int largeUsage = 0;
    String name;
    static SubsetClass rootSubset;
    static WeakHashMap instances;
    static final int MAX_BITS = 28;
    static final int MAX_BIT = 0xFFFFFFF;
    static final int MAX_SMALL_SET_SIZE = 16;
    int maxmedium = 1024;
    static final int EMPTY_SET = 0;
    static final int ONE_MEMBER_SET = 1;
    static final int TWO_MEMBER_SET = 2;
    static final int THREE_MEMBER_SET = 3;
    static final int SMALL_SET = 4;
    static final int MEDIUM_SET = 5;
    static final int LARGE_SET = 6;
    static final int FULL_SET = 7;
    static final int CLOSED_SET = 8;
    static final int LOCAL_CLOSED_SET = 9;
    static final int PARTIAL_TREE = -3;
    static final int EMPTY_TREE = -2;
    static final int FULL_TREE = -1;
    static final boolean verbose;
    static final boolean noclose;
    static final boolean nocopyonwrite;
    public static final boolean usemedium;
    boolean copyonwrite = false;
    static int opcount;
    static final int[] nextBit;
    static final int[] nextUnsetBit;
    static final int[] unextBit;
    static final int[] unextUnsetBit;
    static boolean inPrintUsage;
    public static int printFreq;
    Encoder encoder = new Encoder();
    int[] tmpintervals;
    int[] tmplengths;
    static int[] bytePopulations;
    static final int[] log2bytes;

    public int freeMemory() {
        return this.freeMemory * 4;
    }

    public int usage() {
        return this.roots.length * 4 + this.memory.size() * 4;
    }

    static void printUsage() {
        if (verbose && !inPrintUsage && ++opcount % printFreq == 0) {
            inPrintUsage = true;
            System.out.println("done " + opcount + " bit set ops");
            Set set = instances.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                BitSetArray bitSetArray = (BitSetArray)iterator.next();
                bitSetArray.checkMemory();
                int n = bitSetArray.memoryUsage();
                System.out.println("    " + bitSetArray.name + ": " + n + " free " + bitSetArray.freeMemory() + " medium " + bitSetArray.mediumUsage + " large " + bitSetArray.largeUsage);
            }
            inPrintUsage = false;
        }
    }

    public BitSetArray(int n) {
        this(n, "Unknown");
    }

    public BitSetArray(int n, String string) {
        this.name = string;
        instances.put(this, null);
        this.freeLists = new int[2048];
        for (int i = 0; i < this.freeLists.length; ++i) {
            this.freeLists[i] = -1;
        }
        this.roots = new int[n];
        this.slotsInUse = n;
    }

    public BitSetArray(int n, String string, boolean bl, int n2) {
        this(n, string);
        if (!nocopyonwrite) {
            this.copyonwrite = bl;
        }
        this.maxmedium = n2;
    }

    public BitSetArray(int n, String string, boolean bl) {
        this(n, string, bl, 1024);
    }

    public BitSetArray(String string, boolean bl) {
        this(1, string, bl);
    }

    public BitSetArray() {
        this(1, "Unknown");
    }

    public BitSetArray(String string) {
        this(1, string);
    }

    public int addSlot() {
        if (this.slotsInUse < this.roots.length) {
            return this.slotsInUse++;
        }
        int n = this.roots.length == 0 ? 1 : this.roots.length * 2;
        int[] nArray = new int[n];
        System.arraycopy(this.roots, 0, nArray, 0, this.roots.length);
        this.roots = nArray;
        return this.slotsInUse++;
    }

    public BitSetArrayElement newElement() {
        this.addSlot();
        return new BitSetArrayElement(this, this.slotsInUse - 1);
    }

    public boolean isEmpty(int n) {
        return this.roots[n] == 0;
    }

    public boolean isEmpty() {
        return this.isEmpty(0);
    }

    void check(int n) {
        BitSetArray.Assert(n >= 0);
        BitSetArray.Assert(n < this.slotsInUse);
        BitSetArray.Assert(this.roots[n] != -1);
    }

    static int getType(int n) {
        return n >>> 28;
    }

    int setType(int n, int n2) {
        return n & 0xFFFFFFF | n2 << 28;
    }

    int alloc(int n) {
        this.checkFreeList(n);
        int n2 = this.freeLists[n - 1];
        if (n2 != -1) {
            this.freeLists[n - 1] = this.memory.get(n2);
            for (int i = 0; i < n; ++i) {
                this.memory.put(n2 + i, 0);
            }
            this.freeMemory -= n;
            return n2;
        }
        int n3 = this.memory.size();
        for (int i = 0; i < n; ++i) {
            this.memory.add(0);
        }
        return n3;
    }

    void CHECK() {
        if (this.freeLists != null) {
            for (int i = 0; i < this.freeLists.length; ++i) {
                int n = this.freeLists[i];
                while (n != -1) {
                    BitSetArray.Assert(n < this.memory.size());
                    for (int j = 1; j < i; ++j) {
                        BitSetArray.Assert(this.memory.get(n + j) == Integer.MAX_VALUE);
                    }
                    n = this.memory.get(n);
                }
            }
        }
    }

    int rootalloc(int n) {
        int n2 = this.alloc(n);
        return n2;
    }

    int copyalloc(int n, int n2, int n3) {
        int n4 = this.alloc(n3);
        for (int i = 0; i < n2; ++i) {
            this.memory.put(n4 + i, this.memory.get(n + i));
        }
        return n4;
    }

    void freeroot(int n, int n2) {
        this.free(n, n2);
    }

    void checkFreeList(int n) {
        if (n > this.freeLists.length) {
            int[] nArray = new int[n];
            System.arraycopy(this.freeLists, 0, nArray, 0, this.freeLists.length);
            for (int i = this.freeLists.length; i < nArray.length; ++i) {
                nArray[i] = -1;
            }
            this.freeLists = nArray;
        }
    }

    void free(int n, int n2) {
        BitSetArray.Assert(n < this.memory.size());
        this.checkFreeList(n2);
        for (int i = 0; i < n2; ++i) {
            this.memory.put(n + i, Integer.MAX_VALUE);
        }
        this.memory.put(n, this.freeLists[n2 - 1]);
        this.freeLists[n2 - 1] = n;
        this.freeMemory += n2;
    }

    public void clearAll(int n) {
        this.free(this.roots[n]);
        this.roots[n] = 0;
    }

    public void set(int n) {
        this.set(0, n);
    }

    public void setAll(int n, int n2) {
        this.roots[n] = this.setType(n2, 7);
    }

    public void setAll(int n) {
        this.setAll(0, n);
    }

    public void set(int n, int n2) {
        BitSetArray.printUsage();
        this.roots[n] = this._set(this.roots[n], n2);
    }

    public void set(int n, int n2, int n3) {
        this.roots[n] = this._set(this.roots[n], n2, n3);
    }

    void p(String string) {
        System.out.println(string);
    }

    int close(int n, Memory memory) {
        int n2 = this.roots[n];
        if (BitSetArray.getType(n2) == 0 || BitSetArray.getType(n2) == 1) {
            return n2;
        }
        this.encoder.reset();
        this.encoder.writeInt(8, 4);
        int n3 = 0;
        int n4 = 0;
        IntPairEnumeration intPairEnumeration = this.intPairs(n);
        while (intPairEnumeration.hasMoreElements()) {
            ++n4;
            intPairEnumeration.nextIntPair();
        }
        this.encoder.writeEncodedOn(n4);
        intPairEnumeration = this.intPairs(n);
        while (intPairEnumeration.hasMoreElements()) {
            long l = intPairEnumeration.nextIntPair();
            int n5 = (int)(l >> 32);
            int n6 = (int)l;
            this.encoder.writeEncodedOff(n5 - n3);
            this.encoder.writeEncodedOn(n6 - n5);
            n3 = n6;
        }
        if (memory == this.memory) {
            this.free(n2);
        }
        if (this.encoder.wordOffset == 0) {
            return this.setType(this.encoder.bits[0], 9);
        }
        if (memory == this.memory) {
            n2 = this.rootalloc(this.encoder.wordOffset + 1);
            for (int i = 0; i <= this.encoder.wordOffset; ++i) {
                this.memory.put(n2 + i, this.encoder.bits[i]);
            }
        } else {
            n2 = memory.size();
            for (int i = 0; i <= this.encoder.wordOffset; ++i) {
                memory.add(this.encoder.bits[i]);
            }
        }
        return this.setType(n2, 8);
    }

    public void close(int n) {
        if (noclose) {
            return;
        }
        this.roots[n] = this.close(n, this.memory);
    }

    public void close() {
        if (noclose) {
            return;
        }
        Memory memory = new Memory();
        int[] nArray = new int[this.slotsInUse];
        this.freeLists = null;
        this.freeMemory = 0;
        for (int i = 0; i < this.slotsInUse; ++i) {
            nArray[i] = this.close(i, memory);
        }
        this.memory = memory;
        this.roots = nArray;
        this.encoder = null;
    }

    void smallSet(int n, int n2, int n3, int n4) {
        int n5 = n4 + 1;
        for (int i = n4; i > 0; --i) {
            int n6 = this.memory.get(n + i);
            if (n3 != -1 && n3 > n6) {
                this.memory.put(n2 + n5--, n3);
                n3 = -1;
            }
            this.memory.put(n2 + n5--, n6);
        }
        if (n3 != -1) {
            BitSetArray.Assert(n5 == 1);
            this.memory.put(n2 + n5, n3);
        } else {
            BitSetArray.Assert(n5 == 0);
        }
    }

    int _set(int n, int n2, int n3) {
        if (BitSetArray.getType(n) == 0) {
            n = this.rootalloc(10);
            this.memory.put(n, 0);
            this.memory.put(n + 1, 4);
            n = this.setType(n, 5);
        } else {
            BitSetArray.Assert(BitSetArray.getType(n) == 5);
        }
        return this.intervalSet(n, n2, n3);
    }

    int _set(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        BitSetArray.Assert(n2 <= 0xFFFFFFF);
        if (this._get(n, n2)) {
            return n;
        }
        switch (BitSetArray.getType(n)) {
            case 0: {
                BitSetArray.Assert(n == 0);
                n = this.setType(n2, 1);
                break;
            }
            case 1: {
                n4 = this.rootalloc(2);
                if (n2 < (n & 0xFFFFFFF)) {
                    this.memory.put(n4, n2);
                    this.memory.put(n4 + 1, n & 0xFFFFFFF);
                } else {
                    this.memory.put(n4, n & 0xFFFFFFF);
                    this.memory.put(n4 + 1, n2);
                }
                n = this.setType(n4, 2);
                break;
            }
            case 2: {
                n3 = n & 0xFFFFFFF;
                n4 = this.copyalloc(n3, 2, 3);
                int n5 = this.memory.get(n3);
                int n6 = this.memory.get(n3 + 1);
                if (n2 < n5) {
                    this.memory.put(n4, n2);
                    this.memory.put(n4 + 1, n5);
                    this.memory.put(n4 + 2, n6);
                } else if (n2 > n6) {
                    this.memory.put(n4, n5);
                    this.memory.put(n4 + 1, n6);
                    this.memory.put(n4 + 2, n2);
                } else {
                    this.memory.put(n4, n5);
                    this.memory.put(n4 + 1, n2);
                    this.memory.put(n4 + 2, n6);
                }
                this.freeroot(n3, 2);
                n = this.setType(n4, 3);
                break;
            }
            case 3: {
                n3 = n & 0xFFFFFFF;
                n4 = this.rootalloc(5);
                this.memory.put(n4, 262148);
                this.smallSet(n3 - 1, n4, n2, 3);
                this.freeroot(n3, 3);
                n = this.setType(n4, 4);
                break;
            }
            case 4: {
                n3 = n & 0xFFFFFFF;
                int n7 = this.memory.get(n3) & 0xFFFF;
                int n8 = this.memory.get(n3) >>> 16;
                if (n7 < n8) {
                    this.smallSet(n3, n3, n2, n7);
                    this.memory.put(n3, n8 << 16 | ++n7);
                    break;
                }
                if ((n8 <<= 1) <= 16) {
                    n4 = this.copyalloc(n3, n7 + 1, n8 + 1);
                    this.freeroot(n3, n7 + 1);
                    this.smallSet(n4, n4, n2, n7);
                    this.memory.put(n4, n8 << 16 | ++n7);
                    n = this.setType(n4, 4);
                    break;
                }
                if (usemedium) {
                    n4 = this.rootalloc(10);
                    this.memory.put(n4, 0);
                    this.memory.put(n4 + 1, 4);
                    n = this.setType(n4, 5);
                    for (int i = 0; i < n7; ++i) {
                        n = this.intervalSet(n, this.memory.get(n3 + i + 1));
                    }
                    n = this.intervalSet(n, n2);
                    this.freeroot(n3, n7 + 1);
                    break;
                }
                int n9 = n;
                n = this.promoteToLarge(n);
                this.treeSet(rootSubset, n & 0xFFFFFFF, n2);
                this.free(n9);
                break;
            }
            case 5: {
                n = this.intervalSet(n, n2);
                break;
            }
            case 6: {
                this.treeSet(rootSubset, n & 0xFFFFFFF, n2);
                break;
            }
            default: {
                BitSetArray.Assert(false);
            }
        }
        return n;
    }

    int intervalStart(int n, int n2) {
        return this.memory.get((n &= 0xFFFFFFF) + 2 + n2);
    }

    int intervalLength(int n, int n2) {
        int n3 = this.memory.get((n &= 0xFFFFFFF) + 1);
        return this.memory.get(n + 2 + n3 + n2);
    }

    int intervalMerge(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = n & 0xFFFFFFF;
        int n7 = this.memory.get(n6 + 1);
        int n8 = n6 + 2;
        int n9 = n8 + n7;
        int n10 = this.mediumSetSize(n);
        int n11 = this.memory.get(n8 + n2);
        int n12 = this.memory.get(n8 + n2 + 1);
        int n13 = this.memory.get(n9 + n2);
        int n14 = this.memory.get(n9 + n2 + 1);
        int n15 = n11 + n13;
        int n16 = n12 + n14;
        if (n11 < n12) {
            this.memory.put(n8 + n2, n11);
            n5 = n11;
        } else {
            this.memory.put(n8 + n2, n12);
            n5 = n12;
        }
        if (n15 < n16) {
            this.memory.put(n9 + n2, n16 - n5);
        } else {
            this.memory.put(n9 + n2, n15 - n5);
        }
        if (n2 < n10 - 2) {
            n4 = n10 - (n2 + 2);
            for (n3 = 0; n3 < n4; ++n3) {
                this.memory.put(n8 + n2 + 1 + n3, this.memory.get(n8 + n2 + 2 + n3));
                this.memory.put(n9 + n2 + 1 + n3, this.memory.get(n9 + n2 + 2 + n3));
            }
        }
        BitSetArray.Assert(--n10 > 0);
        this.memory.put(n6, n10);
        if (n10 * 3 < n7) {
            n4 = n7;
            n3 = this.rootalloc(((n7 >>= 1) << 1) + 2);
            int n17 = n3 + 2;
            int n18 = n17 + n7;
            for (int i = 0; i < n10; ++i) {
                this.memory.put(n17 + i, this.memory.get(n8 + i));
                this.memory.put(n18 + i, this.memory.get(n9 + i));
            }
            this.memory.put(n3, n10);
            this.memory.put(n3 + 1, n7);
            n = this.setType(n3, 5);
            this.freeroot(n6, (n4 << 1) + 2);
            n8 = n17;
            n9 = n18;
        }
        if (n2 > 0 && this.memory.get(n8 + n2) <= this.memory.get(n8 + n2 - 1) + this.memory.get(n9 + n2 - 1)) {
            return this.intervalMerge(n, n2 - 1);
        }
        if (n2 < n10 - 1 && this.memory.get(n8 + n2) + this.memory.get(n9 + n2) >= this.memory.get(n8 + n2 + 1)) {
            return this.intervalMerge(n, n2);
        }
        return n;
    }

    int intervalSet(int n, int n2) {
        int n3;
        BitSetArray.Assert(BitSetArray.getType(n) == 5);
        int n4 = 0;
        int n5 = this.mediumSetSize(n);
        int n6 = n5 - 1;
        int n7 = -1;
        int n8 = -1;
        int n9 = n & 0xFFFFFFF;
        int n10 = n9 + 2;
        int n11 = this.memory.get(n9 + 1);
        int n12 = n10 + n11;
        if (n5 == 0) {
            BitSetArray.Assert(n11 > 0);
            this.memory.put(n9, 1);
            this.memory.put(n9 + 2, n2);
            this.memory.put(n9 + 2 + n11, 1);
            return n;
        }
        while (n4 <= n6) {
            n7 = n4 + n6 >> 1;
            n8 = this.memory.get(n10 + n7);
            if (n2 >= n8) {
                if (n2 < n8 + this.memory.get(n12 + n7)) {
                    return n;
                }
                if (n2 == n8 + this.memory.get(n12 + n7)) {
                    this.memory.put(n12 + n7, this.memory.get(n12 + n7) + 1);
                    if (n7 < n5 - 1 && n2 + 1 == this.memory.get(n10 + n7 + 1)) {
                        n = this.intervalMerge(n, n7);
                    }
                    return n;
                }
                n4 = n7 + 1;
                continue;
            }
            if (n2 == n8 - 1) {
                this.memory.put(n10 + n7, this.memory.get(n10 + n7) - 1);
                this.memory.put(n12 + n7, this.memory.get(n12 + n7) + 1);
                if (n7 > 0 && n2 == this.memory.get(n10 + n7 - 1) + this.memory.get(n12 + n7 - 1)) {
                    n = this.intervalMerge(n, n7 - 1);
                }
                return n;
            }
            n6 = n7 - 1;
        }
        if (n5 == n11) {
            if ((n11 <<= 1) <= this.maxmedium) {
                n3 = this.rootalloc((n11 << 1) + 2);
                int n13 = n3 + 2;
                int n14 = n13 + n11;
                for (int i = 0; i < n5; ++i) {
                    this.memory.put(n13 + i, this.memory.get(n10 + i));
                    this.memory.put(n14 + i, this.memory.get(n12 + i));
                }
                this.memory.put(n3, n5);
                this.memory.put(n3 + 1, n11);
                n = this.setType(n3, 5);
                this.freeroot(n9, n11 + 2);
                n9 = n3;
                n10 = n13;
                n12 = n14;
            } else {
                n = this.promoteToLarge(n);
                this.treeSet(rootSubset, n & 0xFFFFFFF, n2);
                this.freeroot(n9, n11 + 2);
                return n;
            }
        }
        if (n2 < this.memory.get(n10)) {
            for (n3 = n5 - 1; n3 >= 0; --n3) {
                this.memory.put(n10 + n3 + 1, this.memory.get(n10 + n3));
                this.memory.put(n12 + n3 + 1, this.memory.get(n12 + n3));
            }
            this.memory.put(n10, n2);
            this.memory.put(n12, 1);
        } else if (n2 > this.memory.get(n10 + n5 - 1)) {
            this.memory.put(n10 + n5, n2);
            this.memory.put(n12 + n5, 1);
        } else {
            if (n2 < n8) {
                --n7;
            }
            BitSetArray.Assert(n5 - n7 - 2 >= 0);
            for (n3 = n5 - n7 - 2; n3 >= 0; --n3) {
                this.memory.put(n10 + n7 + 2 + n3, this.memory.get(n10 + n7 + 1 + n3));
                this.memory.put(n12 + n7 + 2 + n3, this.memory.get(n12 + n7 + 1 + n3));
            }
            this.memory.put(n10 + n7 + 1, n2);
            this.memory.put(n12 + n7 + 1, 1);
        }
        this.memory.put(n9, ++n5);
        BitSetArray.Assert((n & 0xFFFFFFF) == n9);
        return n;
    }

    int intervalSet(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = this.mediumSetSize(n);
        int n7 = n6 - 1;
        int n8 = -1;
        int n9 = -1;
        int n10 = n & 0xFFFFFFF;
        int n11 = n10 + 2;
        int n12 = this.memory.get(n10 + 1);
        int n13 = n11 + n12;
        if (n6 == 0) {
            BitSetArray.Assert(n12 > 0);
            this.memory.put(n10, 1);
            this.memory.put(n10 + 2, n2);
            this.memory.put(n10 + 2 + n12, n3 - n2 + 1);
            return n;
        }
        while (n5 <= n7) {
            n8 = n5 + n7 >> 1;
            n9 = this.memory.get(n11 + n8);
            if (n2 >= n9) {
                n4 = n9 + this.memory.get(n13 + n8);
                if (n3 < n4) {
                    return n;
                }
                if (n2 <= n4) {
                    this.memory.put(n13 + n8, n3 - n9 + 1);
                    if (n8 < n6 - 1 && n3 + 1 >= this.memory.get(n11 + n8 + 1)) {
                        n = this.intervalMerge(n, n8);
                    }
                    return n;
                }
                n5 = n8 + 1;
                continue;
            }
            if (n3 >= n9 - 1) {
                this.memory.put(n11 + n8, n2);
                n4 = n9 + this.memory.get(n13 + n8) - 1;
                int n14 = n3 < n4 ? n4 - n2 + 1 : n3 - n2 + 1;
                this.memory.put(n13 + n8, n14);
                if (n8 > 0 && n2 <= this.memory.get(n11 + n8 - 1) + this.memory.get(n13 + n8 - 1)) {
                    n = this.intervalMerge(n, n8 - 1);
                } else if (n8 < n6 - 1 && n3 + 1 >= this.memory.get(n11 + n8 + 1)) {
                    n = this.intervalMerge(n, n8);
                }
                return n;
            }
            n7 = n8 - 1;
        }
        if (n6 == n12) {
            n4 = this.rootalloc(((n12 <<= 1) << 1) + 2);
            int n15 = n4 + 2;
            int n16 = n15 + n12;
            for (int i = 0; i < n6; ++i) {
                this.memory.put(n15 + i, this.memory.get(n11 + i));
                this.memory.put(n16 + i, this.memory.get(n13 + i));
            }
            this.memory.put(n4, n6);
            this.memory.put(n4 + 1, n12);
            n = this.setType(n4, 5);
            this.freeroot(n10, n12 + 2);
            n10 = n4;
            n11 = n15;
            n13 = n16;
        }
        if (n2 < this.memory.get(n11)) {
            for (n4 = n6 - 1; n4 >= 0; --n4) {
                this.memory.put(n11 + n4 + 1, this.memory.get(n11 + n4));
                this.memory.put(n13 + n4 + 1, this.memory.get(n13 + n4));
            }
            this.memory.put(n11, n2);
            this.memory.put(n13, n3 - n2 + 1);
        } else if (n2 > this.memory.get(n11 + n6 - 1)) {
            this.memory.put(n11 + n6, n2);
            this.memory.put(n13 + n6, n3 - n2 + 1);
        } else {
            if (n2 < n9) {
                --n8;
            }
            BitSetArray.Assert(n6 - n8 - 2 >= 0);
            for (n4 = n6 - n8 - 2; n4 >= 0; --n4) {
                this.memory.put(n11 + n8 + 2 + n4, this.memory.get(n11 + n8 + 1 + n4));
                this.memory.put(n13 + n8 + 2 + n4, this.memory.get(n13 + n8 + 1 + n4));
            }
            this.memory.put(n11 + n8 + 1, n2);
            this.memory.put(n13 + n8 + 1, n3 - n2 + 1);
        }
        this.memory.put(n10, ++n6);
        BitSetArray.Assert((n & 0xFFFFFFF) == n10);
        return n;
    }

    int intervalCopy(int n) {
        BitSetArray.Assert(BitSetArray.getType(n) == 5);
        int n2 = n & 0xFFFFFFF;
        int n3 = this.memory.get(n2);
        int n4 = this.memory.get(n2 + 1);
        int n5 = this.rootalloc((n4 << 1) + 2);
        int n6 = n2 + 2;
        int n7 = n6 + n4;
        int n8 = n5 + 2;
        int n9 = n8 + n4;
        for (int i = 0; i < n3; ++i) {
            this.memory.put(n8 + i, this.memory.get(n6 + i));
            this.memory.put(n9 + i, this.memory.get(n7 + i));
        }
        this.memory.put(n5, n3);
        this.memory.put(n5 + 1, n4);
        return this.setType(n5, 5);
    }

    int intervalOr(int n, int n2) {
        int n3;
        BitSetArray.Assert(BitSetArray.getType(n) == 5 && BitSetArray.getType(n2) == 5);
        int n4 = n & 0xFFFFFFF;
        int n5 = n2 & 0xFFFFFFF;
        int n6 = this.memory.get(n4);
        int n7 = this.memory.get(n5);
        BitSetArray.Assert(n6 != Integer.MAX_VALUE);
        BitSetArray.Assert(n7 != Integer.MAX_VALUE);
        int n8 = n4 + 2;
        int n9 = n5 + 2;
        int n10 = this.memory.get(n4 + 1);
        int n11 = n8 + n10;
        int n12 = n9 + this.memory.get(n5 + 1);
        if (this.tmpintervals == null || this.tmpintervals.length < n6 + n7) {
            this.tmpintervals = new int[n6 + n7];
            this.tmplengths = new int[n6 + n7];
        }
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        if (this.memory.get(n8) <= this.memory.get(n9)) {
            this.tmpintervals[0] = this.memory.get(n8);
            this.tmplengths[0] = this.memory.get(n11);
            ++n14;
        } else {
            this.tmpintervals[0] = this.memory.get(n9);
            this.tmplengths[0] = this.memory.get(n12);
            ++n15;
        }
        while (n14 < n6 || n15 < n7) {
            int n16;
            int n17;
            n3 = Integer.MAX_VALUE;
            int n18 = Integer.MAX_VALUE;
            if (n14 < n6) {
                n18 = this.memory.get(n8 + n14);
            }
            if (n15 < n7) {
                n3 = this.memory.get(n9 + n15);
            }
            if (n14 == n6 || n15 != n7 && n3 <= n18) {
                if (n3 > this.tmpintervals[n13] + this.tmplengths[n13]) {
                    this.tmpintervals[++n13] = n3;
                    this.tmplengths[n13] = this.memory.get(n12 + n15);
                } else {
                    n17 = this.tmpintervals[n13] + this.tmplengths[n13];
                    n16 = n3 + this.memory.get(n12 + n15);
                    this.tmplengths[n13] = n17 > n16 ? n17 - this.tmpintervals[n13] : n16 - this.tmpintervals[n13];
                }
                ++n15;
                continue;
            }
            if (n18 > this.tmpintervals[n13] + this.tmplengths[n13]) {
                this.tmpintervals[++n13] = n18;
                this.tmplengths[n13] = this.memory.get(n11 + n14);
            } else {
                n17 = this.tmpintervals[n13] + this.tmplengths[n13];
                n16 = n18 + this.memory.get(n11 + n14);
                this.tmplengths[n13] = n17 > n16 ? n17 - this.tmpintervals[n13] : n16 - this.tmpintervals[n13];
            }
            ++n14;
        }
        if (++n13 > n10) {
            this.free(n);
            n10 = n13 * 3 / 2;
            n = this.rootalloc((n10 << 1) + 2);
            n8 = n + 2;
            n11 = n8 + n10;
            this.memory.put(n + 1, n10);
        }
        for (n3 = 0; n3 < n13; ++n3) {
            this.memory.put(n8 + n3, this.tmpintervals[n3]);
            this.memory.put(n11 + n3, this.tmplengths[n3]);
        }
        this.memory.put(n & 0xFFFFFFF, n13);
        n = this.setType(n, 5);
        if (n10 > this.maxmedium) {
            n3 = n;
            n = this.promoteToLarge(n);
            this.free(n3);
            if (verbose) {
                System.out.println("promoted medium set of size " + n10);
            }
        }
        return n;
    }

    int promoteToLarge(int n) {
        int n2 = this.rootalloc(this.subsets(rootSubset));
        for (int i = 0; i < BitSetArray.rootSubset.subsets; ++i) {
            this.memory.put(n2 + i, -2);
        }
        if (this.copyonwrite) {
            this.memory.put(n2 + BitSetArray.rootSubset.subsets, 1);
        }
        PairEnum pairEnum = new PairEnum(n);
        while (pairEnum.hasMoreElements()) {
            long l = pairEnum.nextIntPair();
            int n3 = (int)(l >> 32);
            int n4 = (int)l;
            this.treeSet(rootSubset, n2, n3, n4);
        }
        return this.setType(n2, 6);
    }

    boolean copyOnWrite(SubsetClass subsetClass, int n) {
        if (!this.copyonwrite) {
            return false;
        }
        return this.memory.get(n + subsetClass.subsets) > 1;
    }

    void treeSet(SubsetClass subsetClass, int n, int n2) {
        if (subsetClass.next == null) {
            int n3 = n2 >> 5;
            BitSetArray.Assert(n3 < subsetClass.subsets);
            int n4 = this.memory.get(n + n3) | 1 << (n2 & 0x1F);
            this.memory.put(n + n3, n4);
            return;
        }
        int n5 = subsetClass.subsetIndex(n2);
        int n6 = this.memory.get(n + n5);
        if (n6 == -1) {
            return;
        }
        if (n6 == -2) {
            n6 = this.treeAlloc(subsetClass.next);
            this.memory.put(n + n5, n6);
        } else if (this.copyOnWrite(subsetClass.next, n6)) {
            n6 = this.treeShallowCopy(subsetClass.next, n6);
            this.memory.put(n + n5, n6);
        }
        this.treeSet(subsetClass.next, n6, subsetClass.subsetBits(n2));
        if (this.treeFull(subsetClass.next, n6)) {
            this.treeFree(subsetClass.next, n6);
            this.memory.put(n + n5, -1);
        }
    }

    void treeSet(SubsetClass subsetClass, int n, int n2, int n3) {
        if (subsetClass.next == null) {
            for (int i = n2; i <= n3; ++i) {
                int n4 = i >> 5;
                int n5 = this.memory.get(n + n4) | 1 << (i & 0x1F);
                this.memory.put(n + n4, n5);
            }
            return;
        }
        int n6 = subsetClass.subsetIndex(n2);
        int n7 = subsetClass.subsetIndex(n3);
        for (int i = n6; i <= n7; ++i) {
            int n8 = this.memory.get(n + i);
            if (n8 == -1) continue;
            if (i != n6 && i != n7) {
                if (n8 != -2) {
                    this.treeFree(subsetClass.next, n8);
                }
                this.memory.put(n + i, -1);
                continue;
            }
            if (n8 == -2) {
                n8 = this.treeAlloc(subsetClass.next);
                this.memory.put(n + i, n8);
            } else if (this.copyOnWrite(subsetClass.next, n8)) {
                n8 = this.treeShallowCopy(subsetClass.next, n8);
                this.memory.put(n + i, n8);
            }
            int n9 = i == n6 ? n2 : subsetClass.subsetOffset(i);
            int n10 = i == n7 ? n3 : subsetClass.subsetOffset(i + 1) - 1;
            this.treeSet(subsetClass.next, n8, subsetClass.subsetBits(n9), subsetClass.subsetBits(n10));
            if (!this.treeFull(subsetClass.next, n8)) continue;
            this.treeFree(subsetClass.next, n8);
            this.memory.put(n + i, -1);
        }
    }

    void treeFree(SubsetClass subsetClass, int n) {
        if (subsetClass.next != null) {
            for (int i = 0; i < subsetClass.subsets; ++i) {
                int n2 = this.memory.get(n + i);
                if (n2 == -1 || n2 == -2) continue;
                this.treeFree(subsetClass.next, n2);
            }
        }
        if (!this.copyOnWrite(subsetClass, n)) {
            this.free(n, this.subsets(subsetClass));
        } else {
            this.adjustRefCount(subsetClass, n, -1);
        }
    }

    int subsets(SubsetClass subsetClass) {
        return this.copyonwrite ? subsetClass.subsets + 1 : subsetClass.subsets;
    }

    int treeClone(SubsetClass subsetClass, int n) {
        if (!this.copyonwrite || subsetClass == rootSubset) {
            int n2 = this.alloc(this.subsets(subsetClass));
            for (int i = 0; i < subsetClass.subsets; ++i) {
                int n3;
                if (subsetClass.next != null) {
                    n3 = this.memory.get(n + i);
                    if (n3 != -1 && n3 != -2) {
                        this.memory.put(n2 + i, this.treeClone(subsetClass.next, n3));
                        continue;
                    }
                    this.memory.put(n2 + i, n3);
                    continue;
                }
                n3 = this.memory.get(n + i);
                this.memory.put(n2 + i, n3);
            }
            return n2;
        }
        if (subsetClass.next != null) {
            for (int i = 0; i < subsetClass.subsets; ++i) {
                int n4 = this.memory.get(n + i);
                if (n4 == -1 || n4 == -2) continue;
                this.treeClone(subsetClass.next, n4);
            }
        }
        this.adjustRefCount(subsetClass, n, 1);
        return n;
    }

    int treeMemoryUsage(SubsetClass subsetClass, int n) {
        int n2 = this.subsets(subsetClass) << 2;
        if (this.copyOnWrite(subsetClass, n)) {
            if (this.treeUsage.get(n) != null) {
                n2 = 0;
            } else {
                this.treeUsage.put(n, (Object)this.treeUsage);
            }
        }
        if (subsetClass.next != null) {
            for (int i = 0; i < subsetClass.subsets; ++i) {
                int n3 = this.memory.get(n + i);
                if (n3 == -1 || n3 == -2) continue;
                n2 += this.treeMemoryUsage(subsetClass.next, n3);
            }
        }
        return n2;
    }

    boolean treeFull(SubsetClass subsetClass, int n) {
        for (int i = 0; i < subsetClass.subsets; ++i) {
            if (this.memory.get(n + i) == -1) continue;
            return false;
        }
        return true;
    }

    boolean treeGet(SubsetClass subsetClass, int n, int n2) {
        if (subsetClass.next == null) {
            int n3 = n2 >> 5;
            BitSetArray.Assert(n3 < subsetClass.subsets);
            return (this.memory.get(n + n3) & 1 << (n2 & 0x1F)) != 0;
        }
        int n4 = subsetClass.subsetIndex(n2);
        int n5 = this.memory.get(n + n4);
        if (n5 == -1) {
            return true;
        }
        if (n5 == -2) {
            return false;
        }
        return this.treeGet(subsetClass.next, n5, subsetClass.subsetBits(n2));
    }

    int treeAlloc(SubsetClass subsetClass) {
        int n = this.alloc(this.subsets(subsetClass));
        if (subsetClass.next != null) {
            for (int i = 0; i < subsetClass.subsets; ++i) {
                this.memory.put(n + i, -2);
            }
        }
        if (this.copyonwrite) {
            this.memory.put(n + subsetClass.subsets, 1);
        }
        return n;
    }

    public boolean get(int n) {
        return this.get(0, n);
    }

    public boolean get(int n, int n2) {
        return this._get(this.roots[n], n2);
    }

    boolean _get(int n, int n2) {
        int n3 = n & 0xFFFFFFF;
        BitSetArray.Assert(n2 <= 0xFFFFFFF);
        switch (BitSetArray.getType(n)) {
            case 0: {
                BitSetArray.Assert(n == 0);
                return false;
            }
            case 1: {
                return n3 == n2;
            }
            case 2: {
                return this.memory.get(n3) == n2 || this.memory.get(n3 + 1) == n2;
            }
            case 3: {
                return this.memory.get(n3) == n2 || this.memory.get(n3 + 1) == n2 || this.memory.get(n3 + 2) == n2;
            }
            case 4: {
                int n4 = this.smallSetSize(n);
                for (int i = 0; i < n4; ++i) {
                    if (this.memory.get(n3 + i + 1) != n2) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                return this.intervalGet(n, n2);
            }
            case 6: {
                return this.treeGet(rootSubset, n & 0xFFFFFFF, n2);
            }
            case 7: {
                return n2 <= (n & 0xFFFFFFF);
            }
            case 8: 
            case 9: {
                return this.closedGet(n, n2);
            }
        }
        BitSetArray.Assert(false);
        return false;
    }

    boolean closedGet(int n, int n2) {
        Decoder decoder = new Decoder(n);
        int n3 = decoder.readInt(4);
        BitSetArray.Assert(n3 == 9 || n3 == 8);
        int n4 = decoder.readEncodedOn();
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = decoder.readEncodedOff() + n5;
            int n7 = decoder.readEncodedOn() + n6;
            if (n2 >= n6 && n2 <= n7) {
                return true;
            }
            n5 = n7;
        }
        return false;
    }

    private static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public int length(int n) {
        return this._length(this.roots[n]);
    }

    int _length(int n) {
        int n2 = n & 0xFFFFFFF;
        switch (BitSetArray.getType(n)) {
            case 0: {
                BitSetArray.Assert(n == 0);
                return 0;
            }
            case 1: {
                return n2 + 1;
            }
            case 2: {
                int n3 = this.memory.get(n2);
                int n4 = this.memory.get(n2 + 1);
                return BitSetArray.max(n3, n4) + 1;
            }
            case 3: {
                int n5 = this.memory.get(n2);
                int n6 = this.memory.get(n2 + 1);
                int n7 = this.memory.get(n2 + 2);
                int n8 = BitSetArray.max(n5, n6);
                int n9 = BitSetArray.max(n5, n7);
                return BitSetArray.max(n8, n9) + 1;
            }
            case 4: {
                int n10 = this.smallSetSize(n);
                int n11 = 0;
                for (int i = 0; i < n10; ++i) {
                    n11 = BitSetArray.max(this.memory.get(n2 + i + 1), n11);
                }
                return n11 + 1;
            }
            case 5: {
                int n12 = n2 + 2;
                int n13 = this.memory.get(n2 + 1);
                int n14 = n12 + n13;
                int n15 = this.memory.get(n2);
                int n16 = this.memory.get(n12 + n15 - 1);
                int n17 = this.memory.get(n14 + n15 - 1);
                return n16 + n17;
            }
            case 6: {
                return this.treeLastBit(rootSubset, n2) + 1;
            }
            case 7: {
                return n2 + 1;
            }
            case 8: 
            case 9: {
                Decoder decoder = new Decoder(n);
                int n18 = decoder.readInt(4);
                BitSetArray.Assert(n18 == 9 || n18 == 8);
                int n19 = decoder.readEncodedOn();
                int n20 = 0;
                int n21 = 0;
                for (int i = 0; i < n19; ++i) {
                    int n22 = decoder.readEncodedOff() + n20;
                    n20 = n21 = decoder.readEncodedOn() + n22;
                }
                return n21 + 1;
            }
        }
        BitSetArray.Assert(false);
        return -1;
    }

    public int length() {
        return this.length(0);
    }

    boolean intervalGet(int n, int n2) {
        BitSetArray.Assert(BitSetArray.getType(n) == 5);
        int n3 = 0;
        int n4 = this.mediumSetSize(n);
        int n5 = n4 - 1;
        int n6 = n & 0xFFFFFFF;
        int n7 = n6 + 2;
        int n8 = this.memory.get(n6 + 1);
        int n9 = n7 + n8;
        while (n3 <= n5) {
            int n10 = n3 + n5 >> 1;
            int n11 = this.memory.get(n7 + n10);
            if (n2 >= n11) {
                if (n2 < n11 + this.memory.get(n9 + n10)) {
                    return true;
                }
                n3 = n10 + 1;
                continue;
            }
            n5 = n10 - 1;
        }
        return false;
    }

    int treeHash(SubsetClass subsetClass, int n) {
        int n2 = 1;
        if (subsetClass.next == null) {
            for (int i = subsetClass.subsets - 1; i >= 0; --i) {
                n2 *= this.nonZeroGet(n + i);
            }
            return n2;
        }
        for (int i = subsetClass.subsets - 1; i >= 0; --i) {
            int n3 = this.memory.get(n + i);
            if (n3 == -1) {
                n2 += (i + 1 << subsetClass.shift) - 1;
                continue;
            }
            if (n3 == -2) continue;
            n2 += this.treeHash(subsetClass.next, n3);
        }
        return n2;
    }

    int treeLastBit(SubsetClass subsetClass, int n) {
        if (subsetClass.next == null) {
            for (int i = subsetClass.subsets - 1; i >= 0; --i) {
                int n2 = this.memory.get(n + i);
                for (int j = 31; j >= 0; --j) {
                    if ((1 << j & n2) == 0) continue;
                    return (i << 5) + j;
                }
            }
            BitSetArray.Assert(false);
            return -1;
        }
        for (int i = subsetClass.subsets - 1; i >= 0; --i) {
            int n3 = this.memory.get(n + i);
            if (n3 == -1) {
                return (i + 1 << subsetClass.shift) - 1;
            }
            if (n3 == -2) continue;
            int n4 = this.treeLastBit(subsetClass.next, n3);
            return (i << subsetClass.shift) + n4;
        }
        BitSetArray.Assert(false);
        return -1;
    }

    int treeNextBit(SubsetClass subsetClass, int n, int n2) {
        if (subsetClass.next == null) {
            int n3 = subsetClass.subsets;
            for (int i = n2 >> 5; i < n3; ++i) {
                int n4 = this.memory.get(n + i);
                for (int j = n2 & 0x1F; j <= 31; ++j) {
                    while (j <= 24) {
                        int n5 = nextBit[n4 >> j & 0xFF];
                        if (n5 != -1) {
                            return (i << 5) + j + n5;
                        }
                        j += 8;
                    }
                    if (j >= 32) break;
                    if ((1 << j & n4) == 0) continue;
                    return (i << 5) + j;
                }
                n2 = 0;
            }
            return -1;
        }
        int n6 = subsetClass.subsetIndex(n2);
        while (n6 < subsetClass.subsets) {
            int n7;
            int n8 = this.memory.get(n + n6);
            if (n8 == -1) {
                return (n6 << subsetClass.shift) + subsetClass.subsetBits(n2);
            }
            if (n8 != -2 && (n7 = this.treeNextBit(subsetClass.next, n8, subsetClass.subsetBits(n2))) != -1) {
                return (n6 << subsetClass.shift) + n7;
            }
            n2 = ++n6 << subsetClass.shift;
        }
        return -1;
    }

    int treeNextUnsetBit(SubsetClass subsetClass, int n, int n2) {
        if (subsetClass.next == null) {
            int n3 = subsetClass.subsets;
            for (int i = n2 >> 5; i < n3; ++i) {
                int n4 = this.memory.get(n + i);
                for (int j = n2 & 0x1F; j <= 31; ++j) {
                    while (j <= 24) {
                        int n5 = nextUnsetBit[n4 >> j & 0xFF];
                        if (n5 != -1) {
                            return (i << 5) + j + n5;
                        }
                        j += 8;
                    }
                    if (j >= 32) break;
                    if ((1 << j & n4) != 0) continue;
                    return (i << 5) + j;
                }
                n2 = 0;
            }
            return -1;
        }
        int n6 = subsetClass.subsetIndex(n2);
        while (n6 < subsetClass.subsets) {
            int n7 = this.memory.get(n + n6);
            if (n7 != -1) {
                if (n7 == -2) {
                    return (n6 << subsetClass.shift) + subsetClass.subsetBits(n2);
                }
                int n8 = this.treeNextUnsetBit(subsetClass.next, n7, subsetClass.subsetBits(n2));
                if (n8 != -1) {
                    return (n6 << subsetClass.shift) + n8;
                }
            }
            n2 = ++n6 << subsetClass.shift;
        }
        return -1;
    }

    void treeUnion(SubsetClass subsetClass, int n, int n2) {
        if (subsetClass.next == null) {
            for (int i = 0; i < subsetClass.subsets; ++i) {
                this.memory.put(n + i, this.memory.get(n + i) | this.memory.get(n2 + i));
            }
            return;
        }
        for (int i = 0; i < subsetClass.subsets; ++i) {
            int n3 = this.memory.get(n + i);
            int n4 = this.memory.get(n2 + i);
            if (n4 == -1) {
                if (n3 != -2 && n3 != -1) {
                    this.treeFree(subsetClass.next, n3);
                }
                this.memory.put(n + i, -1);
                continue;
            }
            if (n4 == -2 || n3 == -1) continue;
            if (n3 == -2) {
                n3 = this.treeClone(subsetClass.next, n4);
                this.memory.put(n + i, n3);
                continue;
            }
            if (this.treeIsSubset(subsetClass.next, n3, n4)) {
                this.treeFree(subsetClass.next, n3);
                n3 = this.treeClone(subsetClass.next, n4);
                this.memory.put(n + i, n3);
                continue;
            }
            if (this.treeIsSubset(subsetClass.next, n4, n3) || n3 == n4) continue;
            if (this.copyOnWrite(subsetClass.next, n3)) {
                n3 = this.treeShallowCopy(subsetClass.next, n3);
                this.memory.put(n + i, n3);
            }
            this.treeUnion(subsetClass.next, n3, n4);
            if (!this.treeFull(subsetClass.next, n3)) continue;
            this.treeFree(subsetClass.next, n3);
            this.memory.put(n + i, -1);
        }
    }

    boolean treeIsSubset(SubsetClass subsetClass, int n, int n2) {
        if (subsetClass.next == null) {
            for (int i = 0; i < subsetClass.subsets; ++i) {
                int n3;
                int n4 = this.memory.get(n + i);
                if ((n4 & (n3 = this.memory.get(n2 + i))) == n4) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < subsetClass.subsets; ++i) {
            int n5 = this.memory.get(n + i);
            int n6 = this.memory.get(n2 + i);
            if (n6 == -1) continue;
            if (n6 == -2) {
                if (n5 == -2) continue;
                return false;
            }
            if (n5 == -1) {
                return false;
            }
            if (n5 == -2 || n5 == n6 || this.treeIsSubset(subsetClass.next, n5, n6)) continue;
            return false;
        }
        return true;
    }

    void adjustRefCount(SubsetClass subsetClass, int n, int n2) {
        int n3 = this.memory.get(n + subsetClass.subsets);
        BitSetArray.Assert(n3 > 0);
        int n4 = n3 + n2;
        BitSetArray.Assert(n4 > 0);
        this.memory.put(n + subsetClass.subsets, n4);
    }

    int treeShallowCopy(SubsetClass subsetClass, int n) {
        BitSetArray.Assert(this.copyonwrite);
        int n2 = this.alloc(this.subsets(subsetClass));
        for (int i = 0; i < subsetClass.subsets; ++i) {
            this.memory.put(n2 + i, this.memory.get(n + i));
        }
        this.memory.put(n2 + subsetClass.subsets, 1);
        this.adjustRefCount(subsetClass, n, -1);
        return n2;
    }

    boolean treeEquals(SubsetClass subsetClass, int n, int n2) {
        if (subsetClass.next == null) {
            for (int i = 0; i < subsetClass.subsets; ++i) {
                int n3;
                int n4 = this.memory.get(n + i);
                if (n4 == (n3 = this.memory.get(n2 + i))) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < subsetClass.subsets; ++i) {
            int n5 = this.memory.get(n + i);
            int n6 = this.memory.get(n2 + i);
            if (!(n5 == -1 ? n6 != -1 : (n5 == -2 ? n6 != -2 : !this.treeEquals(subsetClass.next, n5, n6)))) continue;
            return false;
        }
        return true;
    }

    int treePopulation(SubsetClass subsetClass, int n) {
        int n2 = 0;
        if (subsetClass.next == null) {
            for (int i = 0; i < subsetClass.subsets; ++i) {
                for (int j = this.memory.get(n + i); j != 0; j >>>= 8) {
                    n2 += bytePopulations[j & 0xFF];
                }
            }
            return n2;
        }
        for (int i = 0; i < subsetClass.subsets; ++i) {
            int n3 = this.memory.get(n + i);
            if (n3 == -1) {
                n2 += subsetClass.size;
                continue;
            }
            if (n3 == -2) continue;
            n2 += this.treePopulation(subsetClass.next, n3);
        }
        return n2;
    }

    int smallSetSize(int n) {
        int n2 = n & 0xFFFFFFF;
        return this.memory.get(n2) & 0xFFFF;
    }

    int mediumSetSize(int n) {
        int n2 = n & 0xFFFFFFF;
        return this.memory.get(n2);
    }

    public void or(int n, int n2) {
        BitSetArray.printUsage();
        this.roots[n] = this._or(this.roots[n], this.roots[n2]);
    }

    int _or(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (BitSetArray.getType(n) == 0) {
            return this._clone(n2);
        }
        if (BitSetArray.getType(n2) == 6) {
            if (BitSetArray.getType(n) != 6) {
                int n3 = n;
                n = this.promoteToLarge(n);
                this.free(n3);
            }
            this.treeUnion(rootSubset, n & 0xFFFFFFF, n2 & 0xFFFFFFF);
        } else if (BitSetArray.getType(n2) == 5 && BitSetArray.getType(n) == 6) {
            int n4 = this.promoteToLarge(n2);
            this.treeUnion(rootSubset, n & 0xFFFFFFF, n4 & 0xFFFFFFF);
            this.free(n4);
        } else if (BitSetArray.getType(n) == 5 && BitSetArray.getType(n2) == 5) {
            n = this.intervalOr(n, n2);
        } else if (BitSetArray.getType(n) < 5 && BitSetArray.getType(n2) == 5) {
            int n5 = this.intervalCopy(n2);
            n5 = this._or(n5, n);
            this.free(n);
            n = n5;
        } else {
            BitEnum bitEnum = new BitEnum(n2);
            while (bitEnum.hasMoreElements()) {
                n = this._set(n, bitEnum.nextInt());
            }
        }
        return n;
    }

    public void and(int n, int n2) {
        BitSetArray.printUsage();
        this.roots[n] = this._and(this.roots[n], this.roots[n2]);
    }

    int _and(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n == n2) {
            return n;
        }
        if (BitSetArray.getType(n) == 7 && this._length(n) >= this._length(n2)) {
            this.free(n);
            return this._clone(n2);
        }
        if (BitSetArray.getType(n2) == 7 && this._length(n2) >= this._length(n)) {
            return n;
        }
        if (BitSetArray.getType(n) > BitSetArray.getType(n2)) {
            n3 = n2;
            n4 = n;
        }
        int n5 = 0;
        BitEnum bitEnum = new BitEnum(n3);
        while (bitEnum.hasMoreElements()) {
            int n6 = bitEnum.nextInt();
            if (!this._get(n4, n6)) continue;
            n5 = this._set(n5, n6);
        }
        this.free(n);
        return n5;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    public int memoryUsage() {
        this.treeUsage = new IntHashtable();
        this.mediumUsage = 0;
        this.largeUsage = 0;
        int n = this.slotsInUse << 2;
        for (int i = 0; i < this.slotsInUse; ++i) {
            n += this.memoryUsage(this.roots[i]);
        }
        this.treeUsage = null;
        return n;
    }

    public int totalMemory() {
        return this.slotsInUse + this.memory.size() + this.freeLists.length << 2;
    }

    void checkMemory() {
        this.CHECK();
        int n = this.memoryUsage() + this.freeMemory();
        int n2 = this.slotsInUse + this.memory.size() << 2;
        if (n != n2) {
            int n3;
            int[] nArray = new int[10];
            for (n3 = 0; n3 < this.slotsInUse; ++n3) {
                int n4 = BitSetArray.getType(this.roots[n3]);
                nArray[n4] = nArray[n4] + 1;
            }
            for (n3 = 0; n3 < 10; ++n3) {
                this.p("type " + n3 + " count " + nArray[n3]);
            }
            throw new Error("Memory mismatch in " + this.name + "! expected " + n + " actual " + n2 + " mem use " + this.memoryUsage() + " free " + this.freeMemory() + " slots " + this.slotsInUse + " mem size " + this.memory.size());
        }
    }

    public void printMemoryUsage() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.slotsInUse; ++i) {
            int n3 = this.roots[i];
            int n4 = this.memoryUsage(n3);
            int n5 = this.numberOfElements(i);
            int n6 = BitSetArray.getType(n3);
            System.out.println("i " + i + " type " + n6 + " usage " + n4 + " elements " + n5 + " total elements " + (n2 += n5) + " running total " + (n += n4));
        }
        System.out.println("roots length " + this.roots.length * 4 + " mem length " + this.memory.size() * 4);
    }

    int memoryUsage(int n) {
        switch (BitSetArray.getType(n)) {
            case 0: {
                BitSetArray.Assert(n == 0);
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 12;
            }
            case 4: {
                int n2 = (this.memory.get(n & 0xFFFFFFF) >>> 16 << 2) + 4;
                return n2;
            }
            case 5: {
                int n3 = this.memory.get((n & 0xFFFFFFF) + 1) * 8 + 8;
                this.mediumUsage += n3;
                return n3;
            }
            case 6: {
                int n4 = this.treeMemoryUsage(rootSubset, n & 0xFFFFFFF);
                this.largeUsage += n4;
                return n4;
            }
            case 7: 
            case 9: {
                return 0;
            }
            case 8: {
                Decoder decoder = new Decoder(n);
                int n5 = decoder.readInt(4);
                BitSetArray.Assert(n5 == 9 || n5 == 8);
                int n6 = decoder.readEncodedOn();
                for (int i = 0; i < n6; ++i) {
                    decoder.readEncodedOff();
                    decoder.readEncodedOn();
                }
                return decoder.wordOffset + 1 << 2;
            }
        }
        BitSetArray.Assert(false);
        return 0;
    }

    public int cappedNumberOfElements(int n) {
        switch (BitSetArray.getType(this.roots[n])) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 4;
    }

    public int elementAt(int n, int n2) {
        int n3 = this.roots[n];
        int n4 = n3 & 0xFFFFFFF;
        switch (BitSetArray.getType(n3)) {
            case 1: {
                return n4;
            }
            case 2: 
            case 3: {
                return this.memory.get(n4 + n2);
            }
        }
        BitSetArray.Assert(false);
        return -1;
    }

    public int numberOfElements() {
        return this.numberOfElements(0);
    }

    public int numberOfElements(int n) {
        return this._numberOfElements(this.roots[n]);
    }

    int _numberOfElements(int n) {
        switch (BitSetArray.getType(n)) {
            case 0: {
                BitSetArray.Assert(n == 0);
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return this.memory.get(n & 0xFFFFFFF) & 0xFFFF;
            }
            case 5: {
                int n2 = 0;
                int n3 = n & 0xFFFFFFF;
                int n4 = this.memory.get(n3);
                int n5 = this.memory.get(n3 + 1);
                for (int i = 0; i < n4; ++i) {
                    n2 += this.memory.get(n3 + 2 + n5 + i);
                }
                return n2;
            }
            case 6: {
                return this.treePopulation(rootSubset, n & 0xFFFFFFF);
            }
            case 7: {
                return (n & 0xFFFFFFF) + 1;
            }
            case 8: 
            case 9: {
                Decoder decoder = new Decoder(n);
                int n6 = decoder.readInt(4);
                BitSetArray.Assert(n6 == 9 || n6 == 8);
                int n7 = decoder.readEncodedOn();
                int n8 = 0;
                int n9 = 0;
                for (int i = 0; i < n7; ++i) {
                    int n10 = decoder.readEncodedOff() + n8;
                    int n11 = decoder.readEncodedOn() + n10;
                    n9 += n11 - n10 + 1;
                    n8 = n11;
                }
                return n9;
            }
        }
        BitSetArray.Assert(false);
        return 0;
    }

    public void copy(int n, int n2) {
        int n3 = this._clone(this.roots[n]);
        this.free(this.roots[n2]);
        this.roots[n2] = n3;
    }

    int _clone(int n) {
        int n2 = n & 0xFFFFFFF;
        switch (BitSetArray.getType(n)) {
            case 0: {
                BitSetArray.Assert(n == 0);
                return n;
            }
            case 1: {
                return n;
            }
            case 2: {
                int n3 = this.copyalloc(n2, 2, 2);
                n3 = this.setType(n3, 2);
                return n3;
            }
            case 3: {
                int n4 = this.copyalloc(n2, 3, 3);
                n4 = this.setType(n4, 3);
                return n4;
            }
            case 4: {
                int n5 = this.memory.get(n2) >>> 16;
                int n6 = this.copyalloc(n2, n5 + 1, n5 + 1);
                n6 = this.setType(n6, 4);
                return n6;
            }
            case 5: {
                int n7 = this.memory.get(n2 + 1);
                int n8 = this.copyalloc(n2, n7 * 2 + 2, n7 * 2 + 2);
                n8 = this.setType(n8, 5);
                return n8;
            }
            case 6: {
                int n9 = this.treeClone(rootSubset, n2);
                n9 = this.setType(n9, 6);
                return n9;
            }
            case 8: {
                int n10 = this.memoryUsage(n) >> 2;
                int n11 = this.copyalloc(n2, n10, n10);
                n11 = this.setType(n11, 8);
                return n11;
            }
            case 7: 
            case 9: {
                return n;
            }
        }
        BitSetArray.Assert(false);
        return 0;
    }

    public Object clone() {
        BitSetArray bitSetArray = new BitSetArray();
        bitSetArray.roots = (int[])this.roots.clone();
        bitSetArray.freeMemory = this.freeMemory;
        bitSetArray.memory = (Memory)this.memory.clone();
        return bitSetArray;
    }

    int nonZeroGet(int n) {
        int n2 = this.memory.get(n);
        return n2 == 0 ? 1 : n2;
    }

    int hashCode(int n) {
        int n2 = this.roots[n];
        int n3 = n2 & 0xFFFFFFF;
        switch (BitSetArray.getType(n2)) {
            case 0: {
                BitSetArray.Assert(n2 == 0);
                return n2;
            }
            case 1: {
                return n2;
            }
            case 2: {
                return this.nonZeroGet(n3) * this.nonZeroGet(n3 + 1);
            }
            case 3: {
                return this.nonZeroGet(n3) * this.nonZeroGet(n3 + 1) * this.nonZeroGet(n3 + 2);
            }
            case 4: {
                int n4 = this.memory.get(n3) & 0xFFFF;
                int n5 = 1;
                for (int i = 0; i < n4; ++i) {
                    n5 *= this.nonZeroGet(n3 + i + 1);
                }
                return n5;
            }
            case 5: {
                int n6 = this.memory.get(n3);
                int n7 = this.memory.get(n3 + 1);
                int n8 = 1;
                for (int i = 0; i < n6; ++i) {
                    n8 *= this.nonZeroGet(n3 + 2 + i);
                    n8 *= this.nonZeroGet(n3 + 2 + n7 + i);
                }
                return n8;
            }
            case 6: {
                return this.treeHash(rootSubset, n3);
            }
        }
        BitSetArray.Assert(false);
        return 0;
    }

    public boolean equals(Object object) {
        BitSetArray bitSetArray = (BitSetArray)object;
        if (this.slotsInUse != bitSetArray.slotsInUse) {
            return false;
        }
        for (int i = 0; i < this.slotsInUse; ++i) {
            if (this.length(i) != bitSetArray.length(i)) {
                return false;
            }
            if (BitSetArray.getType(this.roots[i]) == 7 && BitSetArray.getType(bitSetArray.roots[i]) == 7) {
                return true;
            }
            if (this.numberOfElements(i) != bitSetArray.numberOfElements(i)) {
                return false;
            }
            int n = this.length(i);
            for (int j = 0; j < n; ++j) {
                if (this.get(i, j) == bitSetArray.get(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(int n, int n2) {
        return this._equals(this.roots[n], this.roots[n2]);
    }

    boolean _equals(int n, int n2) {
        if (BitSetArray.getType(n) == 5 && BitSetArray.getType(n2) == 5) {
            int n3;
            int n4 = n & 0xFFFFFFF;
            int n5 = n2 & 0xFFFFFFF;
            int n6 = this.memory.get(n4);
            if (n6 != (n3 = this.memory.get(n5))) {
                return false;
            }
            int n7 = this.memory.get(n4 + 1);
            int n8 = this.memory.get(n5 + 1);
            for (int i = 0; i < n6; ++i) {
                if (this.memory.get(n4 + i + 2) != this.memory.get(n5 + i + 2)) {
                    return false;
                }
                if (this.memory.get(n4 + i + n7 + 2) == this.memory.get(n5 + i + n8 + 2)) continue;
                return false;
            }
            return true;
        }
        if (BitSetArray.getType(n) == 6 && BitSetArray.getType(n2) == 6) {
            return this.treeEquals(rootSubset, n & 0xFFFFFFF, n2 & 0xFFFFFFF);
        }
        if (this._length(n) != this._length(n2)) {
            return false;
        }
        if (BitSetArray.getType(n) == 7 && BitSetArray.getType(n2) == 7) {
            return true;
        }
        if (this._numberOfElements(n) != this._numberOfElements(n2)) {
            return false;
        }
        int n9 = this._length(n);
        for (int i = 0; i < n9; ++i) {
            if (this._get(n, i) == this._get(n2, i)) continue;
            return false;
        }
        return true;
    }

    public IntEnumeration elements() {
        return this.elements(0);
    }

    public IntEnumeration elements(int n, IntEnumeration intEnumeration) {
        BitEnum bitEnum = (BitEnum)intEnumeration;
        bitEnum.reset(this.roots[n]);
        return bitEnum;
    }

    public IntEnumeration elements(int n) {
        return new BitEnum(this.roots[n]);
    }

    public IntPairEnumeration intPairs(int n) {
        return new PairEnum(this.roots[n]);
    }

    protected void finalize() throws Throwable {
        if (verbose) {
            System.out.println("finalize: " + this.name);
        }
    }

    public void free(int n) {
        int n2 = n & 0xFFFFFFF;
        switch (BitSetArray.getType(n)) {
            case 0: {
                BitSetArray.Assert(n == 0);
            }
            case 1: {
                return;
            }
            case 2: {
                this.freeroot(n2, 2);
                return;
            }
            case 3: {
                this.freeroot(n2, 3);
                return;
            }
            case 4: {
                int n3 = this.memory.get(n2) >>> 16;
                this.freeroot(n2, n3 + 1);
                return;
            }
            case 5: {
                int n4 = this.memory.get(n2 + 1);
                this.freeroot(n2, n4 * 2 + 2);
                return;
            }
            case 6: {
                this.treeFree(rootSubset, n2);
                return;
            }
            case 7: {
                return;
            }
        }
        BitSetArray.Assert(false);
    }

    void treeWriteObject(ObjectOutputStream objectOutputStream, SubsetClass subsetClass, int n) throws IOException {
        for (int i = 0; i < subsetClass.subsets; ++i) {
            int n2 = this.memory.get(n + i);
            if (subsetClass.next != null && n2 != -2 && n2 != -1) {
                objectOutputStream.writeInt(-3);
                this.treeWriteObject(objectOutputStream, subsetClass.next, n2);
                continue;
            }
            objectOutputStream.writeInt(n2);
        }
    }

    int treeReadObject(ObjectInputStream objectInputStream, SubsetClass subsetClass) throws IOException {
        int n = this.treeAlloc(subsetClass);
        for (int i = 0; i < subsetClass.subsets; ++i) {
            int n2 = objectInputStream.readInt();
            if (subsetClass.next != null && n2 == -3) {
                n2 = this.treeReadObject(objectInputStream, subsetClass.next);
            }
            this.memory.put(n + i, n2);
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.slotsInUse);
        for (int i = 0; i < this.slotsInUse; ++i) {
            this.writeRoot(objectOutputStream, this.roots[i]);
        }
    }

    public void writeRoot(ObjectOutputStream objectOutputStream, int n) throws IOException {
        objectOutputStream.writeInt(n);
        int n2 = n & 0xFFFFFFF;
        switch (BitSetArray.getType(n)) {
            case 0: {
                BitSetArray.Assert(n == 0);
            }
            case 1: {
                return;
            }
            case 2: {
                objectOutputStream.writeInt(this.memory.get(n2));
                objectOutputStream.writeInt(this.memory.get(n2 + 1));
                return;
            }
            case 3: {
                objectOutputStream.writeInt(this.memory.get(n2));
                objectOutputStream.writeInt(this.memory.get(n2 + 1));
                objectOutputStream.writeInt(this.memory.get(n2 + 2));
                return;
            }
            case 4: {
                int n3 = this.memory.get(n2) >>> 16;
                objectOutputStream.writeInt(this.memory.get(n2));
                for (int i = 0; i < n3; ++i) {
                    objectOutputStream.writeInt(this.memory.get(n2 + 1 + i));
                }
                return;
            }
            case 5: {
                int n4 = this.memory.get(n2 + 1);
                objectOutputStream.writeInt(this.memory.get(n2));
                objectOutputStream.writeInt(this.memory.get(n2 + 1));
                for (int i = 0; i < n4 * 2; ++i) {
                    objectOutputStream.writeInt(this.memory.get(n2 + 2 + i));
                }
                return;
            }
            case 6: {
                this.treeWriteObject(objectOutputStream, rootSubset, n2);
                return;
            }
            case 7: {
                return;
            }
        }
        BitSetArray.Assert(false);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.slotsInUse = objectInputStream.readInt();
        this.roots = new int[this.slotsInUse];
        this.memory = new Memory();
        this.freeLists = new int[256];
        for (int i = 0; i < this.slotsInUse; ++i) {
            this.roots[i] = this.readRoot(objectInputStream);
        }
    }

    public int readRoot(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        int n2 = BitSetArray.getType(n);
        switch (n2) {
            case 0: {
                BitSetArray.Assert(n == 0);
            }
            case 1: {
                return n;
            }
            case 2: {
                n = this.rootalloc(2);
                this.memory.put(n, objectInputStream.readInt());
                this.memory.put(n + 1, objectInputStream.readInt());
                return this.setType(n, n2);
            }
            case 3: {
                n = this.rootalloc(3);
                this.memory.put(n, objectInputStream.readInt());
                this.memory.put(n + 1, objectInputStream.readInt());
                this.memory.put(n + 2, objectInputStream.readInt());
                return this.setType(n, n2);
            }
            case 4: {
                int n3 = objectInputStream.readInt();
                int n4 = n3 & 0xFFFF;
                int n5 = n3 >>> 16;
                n = this.rootalloc(n5 + 1);
                this.memory.put(n, n3);
                for (int i = 0; i < n5; ++i) {
                    this.memory.put(n + 1 + i, objectInputStream.readInt());
                }
                return this.setType(n, n2);
            }
            case 5: {
                int n6 = objectInputStream.readInt();
                int n7 = objectInputStream.readInt();
                n = this.rootalloc(n7 * 2 + 2);
                this.memory.put(n, n6);
                this.memory.put(n + 1, n7);
                for (int i = 0; i < n7 * 2; ++i) {
                    this.memory.put(n + 2 + i, objectInputStream.readInt());
                }
                return this.setType(n, n2);
            }
            case 6: {
                n = this.treeReadObject(objectInputStream, rootSubset);
                return this.setType(n, n2);
            }
            case 7: {
                return n;
            }
        }
        BitSetArray.Assert(false);
        return 0;
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }

    public static void main(String[] stringArray) {
        int n;
        TestBits testBits = new TestBits(0, 128);
        testBits.expect(0, 1, 128);
        testBits.set(128, 255);
        testBits.expect(0, 1, 256);
        testBits = new TestBits(0, 1);
        for (n = 2; n < 1000; n += 2) {
            testBits.set(n, n);
        }
        testBits.expect(0, 2, 1000);
        for (n = 1; n < 1000; n += 2) {
            testBits.set(n, n);
        }
        testBits.expect(0, 1, 1000);
        TestBits.sets.printMemoryUsage();
        TestBits testBits2 = new TestBits(0, 2, 59);
        testBits2.close();
        testBits = new TestBits(0, 2, 65);
        testBits.expect(0, 2, 65);
        System.out.println("first ok");
        testBits = new TestBits(0, 2, 2049);
        testBits.expect(0, 2, 2049);
        TestBits testBits3 = new TestBits(6833, 71, 7034);
        testBits3.compare();
        TestBits testBits4 = (TestBits)testBits3.clone();
        testBits4.compare();
        testBits = new TestBits(0, 1, 1000);
        testBits.expect(0, 1, 1000);
        testBits = new TestBits(0, 2, 1000);
        testBits.expect(0, 2, 1000);
        testBits2 = new TestBits(1, 2, 1000);
        testBits2.close();
        testBits2.expect(1, 2, 1000);
        testBits.or(testBits2);
        testBits.expect(0, 1, 1000);
        testBits2 = new TestBits(1000, 2, 2000);
        testBits2.expect(1000, 2, 2000);
        testBits.or(testBits2);
        testBits2.expect(1000, 2, 2000);
        testBits2 = new TestBits(1001, 2, 2000);
        testBits2.close();
        testBits.or(testBits2);
        testBits2.expect(1001, 2, 2000);
        testBits.expect(0, 1, 2000);
        testBits = new TestBits(0, 2, 8000);
        testBits2 = new TestBits(1, 2, 2);
        testBits2.or(testBits);
        testBits = new TestBits(3, 2, 8000);
        TestBits testBits5 = new TestBits(3, 2, 8000);
        testBits5.or(testBits2);
        testBits5.expect(0, 1, 8000);
        testBits5 = new TestBits(3, 2, 4);
        testBits5.or(testBits2);
        testBits5.or(new TestBits(0, 1, 3));
        TestBits testBits6 = new TestBits(3, 2, 4);
        testBits6.or(testBits2);
        testBits5.or(testBits6);
        testBits5.or(new TestBits(3, 2, 8000));
        testBits5.expect(0, 1, 8000);
        testBits2.or(testBits);
        testBits2.expect(0, 1, 8000);
        for (int i = 0; i < 1000; ++i) {
            System.out.println("doing " + i);
            testBits = new TestBits(0, 100, i);
            testBits.expect(0, 100, i);
            testBits = new TestBits(0, 2, i);
            testBits.expect(0, 2, i);
            testBits = new TestBits(0, 1, i);
            testBits.expect(0, 1, i);
            testBits = new TestBits(0, 1, i);
            testBits.check();
            testBits2 = new TestBits(0, 2, i);
            testBits5 = new TestBits(i);
            testBits2.close();
            testBits5.close();
            testBits.and(testBits2);
            testBits.check();
            testBits.and(testBits5);
            testBits.expect(0, 2, i);
            testBits = new TestBits(0, 256, i);
            testBits2 = new TestBits(0, 128, i);
            testBits.or(testBits2);
            testBits.expect(0, 128, i);
            testBits2.clearAll();
            testBits2 = new TestBits(0, 4, i);
            testBits.or(testBits2);
            testBits.expect(0, 4, i);
            testBits5 = new TestBits(0, 1, i);
            testBits2.or(testBits5);
            testBits.expect(0, 4, i);
            testBits = new TestBits(0, 2, i);
            testBits2 = new TestBits(0, 1, i);
            testBits.or(testBits2);
            testBits.expect(0, 1, i);
            testBits.closeAll();
        }
        Random random = new Random(23L);
        for (int i = 0; i < 10000; ++i) {
            int n2 = random.nextInt(100);
            int n3 = random.nextInt(10000);
            int n4 = n3 + random.nextInt(10000);
            System.out.println("i = " + i + " doing min " + n3 + " int " + n2 + " max " + n4);
            testBits = new TestBits(n3, n2, n4);
            testBits.compare();
            testBits.close();
            testBits.expect(n3, n2, n4);
            testBits = new TestBits(n3, n2, n4);
            n2 = random.nextInt(100);
            n3 = random.nextInt(10000);
            n4 = n3 + random.nextInt(10000);
            System.out.println("doing min " + n3 + " int " + n2 + " max " + n4);
            testBits2 = new TestBits(n3, n2, n4);
            testBits2.close();
            testBits2.expect(n3, n2, n4);
            testBits.or(testBits2);
            testBits.compare();
            n2 = random.nextInt(100);
            n3 = random.nextInt(10000);
            n4 = n3 + random.nextInt(10000);
            System.out.println("doing min " + n3 + " int " + n2 + " max " + n4);
            testBits5 = new TestBits(n3, n2, n4);
            testBits5.and(testBits);
            testBits5.compare();
            for (int j = 0; j < 100; ++j) {
                testBits.set(random.nextInt(1000));
                testBits.set(random.nextInt(10000));
                testBits5.set(random.nextInt(1000));
            }
            testBits.compare();
            testBits2.compare();
            testBits5.compare();
            testBits.close();
            testBits.compare();
            TestBits testBits7 = (TestBits)testBits.clone();
            testBits7.compare();
            TestBits testBits8 = (TestBits)testBits2.clone();
            testBits8.compare();
            TestBits testBits9 = (TestBits)testBits5.clone();
            testBits9.compare();
            testBits9.clearAll();
            testBits9.compare();
            testBits.closeAll();
        }
    }

    static int log2(int n) {
        int n2 = 0;
        while ((n & 0xFFFFFF00) != 0) {
            n2 += 8;
            n >>>= 8;
        }
        return n2 + log2bytes[n];
    }

    static {
        int n;
        int n2;
        instances = new WeakHashMap();
        verbose = SvcdumpProperties.getBooleanProperty("findroots.verbose", false);
        noclose = SvcdumpProperties.getBooleanProperty("findroots.noclose", false);
        nocopyonwrite = SvcdumpProperties.getBooleanProperty("findroots.nocopyonwrite", false);
        usemedium = SvcdumpProperties.getBooleanProperty("findroots.usemedium", true);
        nextBit = new int[256];
        nextUnsetBit = new int[256];
        unextBit = new int[256];
        unextUnsetBit = new int[256];
        block0: for (n2 = 0; n2 < 256; ++n2) {
            BitSetArray.nextBit[n2] = -1;
            for (n = 0; n < 8; ++n) {
                if ((1 << n & n2) == 0) continue;
                BitSetArray.nextBit[n2] = n;
                break;
            }
            BitSetArray.nextUnsetBit[n2] = -1;
            for (n = 0; n < 8; ++n) {
                if ((1 << n & n2) != 0) continue;
                BitSetArray.nextUnsetBit[n2] = n;
                break;
            }
            BitSetArray.unextBit[n2] = -1;
            for (n = 0; n < 8; ++n) {
                if ((128 >> n & n2) == 0) continue;
                BitSetArray.unextBit[n2] = n;
                break;
            }
            BitSetArray.unextUnsetBit[n2] = -1;
            for (n = 0; n < 8; ++n) {
                if ((128 >> n & n2) != 0) continue;
                BitSetArray.unextUnsetBit[n2] = n;
                continue block0;
            }
        }
        n2 = 7;
        rootSubset = new SubsetClass(null, n2);
        n = 2;
        while (n2 + n < 28) {
            rootSubset = new SubsetClass(rootSubset, n);
            n2 += n;
        }
        if (n2 < 28) {
            rootSubset = new SubsetClass(rootSubset, 28 - n2);
        }
        if ((n = BitSetArray.rootSubset.shift + BitSetArray.rootSubset.bits) != 28) {
            throw new Error("total bits is " + n + " but should be " + 28);
        }
        printFreq = 0x100000;
        bytePopulations = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
        log2bytes = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    }

    final class Decoder {
        int bitOffset;
        int wordOffset;
        int root;
        int currentWord;

        Decoder(int n) {
            this.root = n;
            this.currentWord = this.readWord(0);
        }

        void reset(int n) {
            this.root = n;
            this.bitOffset = 0;
            this.wordOffset = 0;
            this.currentWord = this.readWord(0);
        }

        int readWord(int n) {
            if (BitSetArray.getType(this.root) == 9) {
                return this.root;
            }
            return BitSetArray.this.memory.get((this.root & 0xFFFFFFF) + n);
        }

        int readIntInWord(int n) {
            BitSetArray.Assert(n > 0);
            int n2 = this.currentWord >> 32 - (this.bitOffset + n) & (1 << n) - 1;
            this.bitOffset += n;
            return n2;
        }

        int readInt(int n) {
            if (n > 30) {
                throw new Error("bad length: " + n);
            }
            if (n < 32 - this.bitOffset) {
                return this.readIntInWord(n);
            }
            int n2 = 32 - this.bitOffset;
            int n3 = n + this.bitOffset - 32;
            int n4 = 0;
            if (n2 > 0) {
                n4 = this.readIntInWord(n2);
            }
            int n5 = 0;
            if (n3 > 0) {
                this.nextWord();
                n5 = this.readIntInWord(n3);
            }
            return n4 << n3 | n5;
        }

        int readEncodedOff() {
            int n = this.readDelta();
            return n;
        }

        int readEncodedOn() {
            int n = this.readGamma();
            return n;
        }

        void nextWord() {
            ++this.wordOffset;
            this.currentWord = this.readWord(this.wordOffset);
            this.bitOffset = 0;
        }

        int readGamma() {
            int n = this.readUnary();
            return n == 0 ? 0 : (1 << n | this.readInt(n)) - 1;
        }

        int readDelta() {
            int n = this.readGamma();
            return n == 0 ? 0 : (1 << n | this.readInt(n)) - 1;
        }

        int readUnary() {
            int n = this.currentWord;
            int n2 = this.bitOffset;
            int n3 = 0;
            while (n2 <= 24) {
                int n4 = unextUnsetBit[n >> 24 - n2 & 0xFF];
                if (n4 != -1) {
                    this.bitOffset = n2 + n4 + 1;
                    return n3 + n4;
                }
                n2 += 8;
                n3 += 8;
            }
            while (true) {
                if (n2 == 32) {
                    this.nextWord();
                    n = this.currentWord;
                    n2 = 0;
                }
                if ((n & Integer.MIN_VALUE >>> n2) == 0) {
                    this.bitOffset = n2 + 1;
                    return n3;
                }
                ++n3;
                ++n2;
            }
        }
    }

    final class Encoder {
        int[] bits = new int[1];
        int bitOffset;
        int wordOffset;

        Encoder() {
        }

        void reset() {
            this.wordOffset = 0;
            this.bitOffset = 0;
            this.bits[0] = 0;
        }

        void writeIntInWord(int n, int n2) {
            BitSetArray.Assert(n2 > 0);
            int n3 = this.wordOffset;
            this.bits[n3] = this.bits[n3] | (n & (1 << n2) - 1) << 32 - (this.bitOffset + n2);
            this.bitOffset += n2;
        }

        void writeInt(int n, int n2) {
            if (n2 > 30) {
                throw new Error("bad length: " + n2);
            }
            if (n2 < 32 - this.bitOffset) {
                this.writeIntInWord(n, n2);
            } else {
                int n3 = 32 - this.bitOffset;
                int n4 = n2 + this.bitOffset - 32;
                if (n3 > 0) {
                    this.writeIntInWord(n >>> n4, n3);
                }
                if (n4 > 0) {
                    this.nextWord();
                    this.bits[this.wordOffset] = 0;
                    this.writeIntInWord(n, n4);
                }
            }
        }

        void writeEncodedOff(int n) {
            if (n < 0) {
                throw new Error("bad number: " + n);
            }
            this.writeDelta(n);
        }

        void writeEncodedOn(int n) {
            if (n < 0) {
                throw new Error("bad number: " + n);
            }
            this.writeGamma(n);
        }

        void nextWord() {
            if (++this.wordOffset == this.bits.length) {
                int[] nArray = new int[this.bits.length + 1];
                System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
                this.bits = nArray;
            }
            this.bitOffset = 0;
        }

        void writeGamma(int n) {
            int n2 = BitSetArray.log2(++n);
            this.writeUnary(n2);
            if (n2 != 0) {
                this.writeInt(n, n2);
            }
        }

        void writeDelta(int n) {
            int n2 = BitSetArray.log2(++n);
            this.writeGamma(n2);
            if (n2 != 0) {
                this.writeInt(n, n2);
            }
        }

        void writeUnary(int n) {
            for (int i = 0; i < n; ++i) {
                this.writeInt(1, 1);
            }
            this.writeInt(0, 1);
        }
    }

    static class TestBits {
        BitSet bits;
        static BitSetArray sets = new BitSetArray(0, "TestBits");
        int set;
        static boolean closed;

        TestBits(int n, int n2, int n3) {
            if (closed) {
                sets = new BitSetArray(0, "TestBits");
                closed = false;
            }
            this.set = sets.addSlot();
            this.bits = new BitSet();
            if (n2 == 0) {
                n2 = 1;
            }
            for (int i = n; i < n3; i += n2) {
                sets.set(this.set, i);
                this.bits.set(i);
            }
            sets.checkMemory();
        }

        TestBits(int n) {
            if (closed) {
                sets = new BitSetArray(0, "TestBits");
                closed = false;
            }
            this.set = sets.addSlot();
            this.bits = new BitSet();
            for (int i = 0; i < n; ++i) {
                this.bits.set(i);
            }
            sets.setAll(this.set, n - 1);
            sets.checkMemory();
        }

        TestBits(int n, int n2) {
            if (closed) {
                sets = new BitSetArray(0, "TestBits");
                closed = false;
            }
            this.set = sets.addSlot();
            this.bits = new BitSet();
            this.set(n, n2 - 1);
            sets.checkMemory();
        }

        TestBits() {
            if (closed) {
                sets = new BitSetArray(0, "TestBits");
                closed = false;
            }
        }

        void closeAll() {
            sets.checkMemory();
            sets.close();
            sets.checkMemory();
            closed = true;
        }

        void close() {
            sets.checkMemory();
            sets.close(this.set);
            sets.checkMemory();
        }

        public Object clone() {
            TestBits testBits = new TestBits();
            testBits.bits = (BitSet)this.bits.clone();
            testBits.set = sets.addSlot();
            TestBits.sets.roots[testBits.set] = sets._clone(TestBits.sets.roots[this.set]);
            sets.checkMemory();
            return testBits;
        }

        void set(int n, int n2) {
            sets.set(this.set, n, n2);
            for (int i = n; i <= n2; ++i) {
                this.bits.set(i);
            }
            sets.checkMemory();
        }

        void set(int n) {
            sets.set(this.set, n);
            this.bits.set(n);
            sets.checkMemory();
        }

        void and(TestBits testBits) {
            if (this.set < 0) {
                throw new Error("bad");
            }
            if (testBits.set < 0) {
                throw new Error("bad");
            }
            sets.and(this.set, testBits.set);
            this.bits.and(testBits.bits);
            sets.checkMemory();
        }

        void or(TestBits testBits) {
            sets.or(this.set, testBits.set);
            this.bits.or(testBits.bits);
            sets.checkMemory();
        }

        void clearAll() {
            sets.clearAll(this.set);
            this.bits = new BitSet();
            sets.checkMemory();
        }

        void check() {
            sets.check(this.set);
        }

        void compare() {
            int n = this.bits.length();
            if (n != sets.length(this.set)) {
                throw new Error("length mismatch, bits = " + n + " set = " + sets.length(this.set));
            }
            for (int i = 0; i < n; ++i) {
                if (this.bits.get(i) == sets.get(this.set, i)) continue;
                throw new Error("mismatch on bit " + i);
            }
        }

        void expect(int n, int n2, int n3) {
            sets.checkMemory();
            int n4 = 0;
            boolean bl = false;
            int n5 = n;
            while (n5 < n3) {
                bl = true;
                if (!sets.get(this.set, n5)) {
                    throw new Error("i " + n5 + " was not set!");
                }
                n5 += n2;
                ++n4;
            }
            if (bl && sets.length(this.set) != n5 - n2 + 1) {
                throw new Error("expected length " + (n5 - n2) + " but found " + sets.length(this.set));
            }
            if (sets.numberOfElements(this.set) != n4) {
                throw new Error("expected " + n4 + " found " + sets.numberOfElements(this.set));
            }
            for (n5 = n3; n5 < n3 * 2; ++n5) {
                if (!sets.get(this.set, n5)) continue;
                throw new Error("i " + n5 + " IS set!");
            }
            BitSet bitSet = new BitSet();
            IntEnumeration intEnumeration = sets.elements(this.set);
            while (intEnumeration.hasMoreElements()) {
                n5 = intEnumeration.nextInt();
                if (!this.bits.get(n5)) {
                    throw new Error("i " + n5 + " was not set!");
                }
                bitSet.set(n5);
            }
            if (!this.bits.equals(bitSet)) {
                throw new Error("enum did not match");
            }
        }
    }

    class PairEnum
    extends BitEnum
    implements IntPairEnumeration {
        PairEnum(int n) {
            super(n);
        }

        public Object nextElement() {
            return new Long(this.nextIntPair());
        }

        long makePair(int n, int n2) {
            return (long)n << 32 | (long)n2;
        }

        public long nextIntPair() {
            int n = this.root & 0xFFFFFFF;
            switch (BitSetArray.getType(this.root)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    int n2;
                    int n3 = n2 = this.nextInt();
                    while (this.hasMoreElements() && this.peekInt() == n3 + 1) {
                        n3 = this.nextInt();
                    }
                    BitSetArray.Assert(n3 >= n2);
                    return this.makePair(n2, n3);
                }
                case 5: {
                    int n4 = BitSetArray.this.memory.get(n + 2 + this.index);
                    int n5 = BitSetArray.this.memory.get(n + 1);
                    int n6 = n4 + BitSetArray.this.memory.get(n + 2 + n5 + this.index) - 1;
                    ++this.index;
                    return this.makePair(n4, n6);
                }
                case 6: {
                    int n7 = this.index;
                    int n8 = BitSetArray.this.treeNextUnsetBit(rootSubset, n, this.index + 1) - 1;
                    BitSetArray.Assert(n8 != -1);
                    this.index = BitSetArray.this.treeNextBit(rootSubset, n, n8 + 1);
                    return this.makePair(n7, n8);
                }
                case 7: {
                    int n9 = 0;
                    int n10 = this.root & 0xFFFFFFF;
                    this.index = n10 + 1;
                    return this.makePair(n9, n10);
                }
                case 8: 
                case 9: {
                    long l = this.makePair(this.lower, this.upper);
                    if (++this.index < this.numPairs) {
                        this.lower = this.decoder.readEncodedOff() + this.last;
                        this.last = this.upper = this.decoder.readEncodedOn() + this.lower;
                        this.offset = this.lower;
                    }
                    return l;
                }
            }
            BitSetArray.Assert(false);
            return -1L;
        }
    }

    class BitEnum
    implements IntEnumeration {
        int index;
        int offset;
        int root;
        Decoder decoder;
        int numPairs;
        int last;
        int lower;
        int upper;

        BitEnum(int n) {
            this.root = n;
            this.reset();
        }

        void reset(int n) {
            this.root = n;
            this.reset();
        }

        public boolean hasMoreElements() {
            switch (BitSetArray.getType(this.root)) {
                case 0: {
                    BitSetArray.Assert(this.root == 0);
                    return false;
                }
                case 1: {
                    return this.index == 0;
                }
                case 2: {
                    return this.index <= 1;
                }
                case 3: {
                    return this.index <= 2;
                }
                case 4: {
                    return this.index < (BitSetArray.this.memory.get(this.root & 0xFFFFFFF) & 0xFFFF);
                }
                case 5: {
                    return this.index < BitSetArray.this.memory.get(this.root & 0xFFFFFFF);
                }
                case 6: {
                    return this.index != -1;
                }
                case 7: {
                    return this.index <= (this.root & 0xFFFFFFF);
                }
                case 8: 
                case 9: {
                    return this.index < this.numPairs;
                }
            }
            BitSetArray.Assert(false);
            return false;
        }

        public Object nextElement() {
            return new Integer(this.nextInt());
        }

        public int nextInt() {
            int n = this.root & 0xFFFFFFF;
            switch (BitSetArray.getType(this.root)) {
                case 1: {
                    ++this.index;
                    return this.root & 0xFFFFFFF;
                }
                case 2: 
                case 3: {
                    return BitSetArray.this.memory.get(n + this.index++);
                }
                case 4: {
                    return BitSetArray.this.memory.get(n + 1 + this.index++);
                }
                case 5: {
                    int n2 = BitSetArray.this.memory.get(n + 2 + this.index) + this.offset;
                    int n3 = BitSetArray.this.memory.get(n + 1);
                    if (++this.offset >= BitSetArray.this.memory.get(n + 2 + n3 + this.index)) {
                        ++this.index;
                        this.offset = 0;
                    }
                    return n2;
                }
                case 6: {
                    int n4 = this.index;
                    this.index = BitSetArray.this.treeNextBit(rootSubset, n, this.index + 1);
                    return n4;
                }
                case 7: {
                    return this.index++;
                }
                case 8: 
                case 9: {
                    int n5 = this.offset++;
                    if (this.offset > this.upper && ++this.index < this.numPairs) {
                        this.lower = this.decoder.readEncodedOff() + this.last;
                        this.last = this.upper = this.decoder.readEncodedOn() + this.lower;
                        this.offset = this.lower;
                    }
                    return n5;
                }
            }
            BitSetArray.Assert(false);
            return -1;
        }

        public int peekInt() {
            int n = this.root & 0xFFFFFFF;
            switch (BitSetArray.getType(this.root)) {
                case 1: {
                    return this.root & 0xFFFFFFF;
                }
                case 2: 
                case 3: {
                    return BitSetArray.this.memory.get(n + this.index);
                }
                case 4: {
                    return BitSetArray.this.memory.get(n + 1 + this.index);
                }
                case 5: {
                    return BitSetArray.this.memory.get(n + 2 + this.index) + this.offset;
                }
                case 6: {
                    return this.index;
                }
                case 7: {
                    return this.index;
                }
                case 8: 
                case 9: {
                    return this.offset;
                }
            }
            BitSetArray.Assert(false);
            return -1;
        }

        public void reset() {
            this.index = 0;
            this.offset = 0;
            this.last = 0;
            if (BitSetArray.getType(this.root) == 6) {
                this.index = BitSetArray.this.treeNextBit(rootSubset, this.root & 0xFFFFFFF, 0);
            } else if (BitSetArray.getType(this.root) == 9 || BitSetArray.getType(this.root) == 8) {
                if (this.decoder == null) {
                    this.decoder = new Decoder(this.root);
                } else {
                    this.decoder.reset(this.root);
                }
                int n = this.decoder.readInt(4);
                this.numPairs = this.decoder.readEncodedOn();
                if (this.numPairs > 0) {
                    this.lower = this.decoder.readEncodedOff();
                    this.upper = this.decoder.readEncodedOn() + this.lower;
                    this.offset = this.lower;
                    this.last = this.upper;
                }
            }
        }
    }
}

