/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.util.SortListener;
import java.io.Serializable;
import java.util.Random;

public final class IntegerArray
implements Serializable,
SortListener {
    static final int shift = 12;
    static final int CHUNK_SIZE = 4096;
    static final int mask = 4095;
    int[][] chunks = new int[1][4096];
    int chunkOffset;
    SortListener listener;
    int size;
    Random random = new Random();

    public IntegerArray() {
    }

    public IntegerArray(int n, int n2) {
        for (int i = 0; i < n; ++i) {
            this.add(n2);
        }
    }

    public Object clone() {
        IntegerArray integerArray = new IntegerArray();
        integerArray.chunks = new int[this.chunks.length][4096];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, integerArray.chunks[i], 0, 4096);
        }
        integerArray.chunkOffset = this.chunkOffset;
        integerArray.size = this.size;
        return integerArray;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, nArray, i << 12, i == this.chunks.length - 1 ? this.chunkOffset : 4096);
        }
        return nArray;
    }

    public void add(int n) {
        if (this.chunkOffset >= 4096) {
            int[][] nArrayArray = new int[this.chunks.length + 1][];
            for (int i = 0; i < this.chunks.length; ++i) {
                nArrayArray[i] = this.chunks[i];
            }
            nArrayArray[this.chunks.length] = new int[4096];
            this.chunks = nArrayArray;
            this.chunkOffset = 0;
        }
        this.chunks[this.chunks.length - 1][this.chunkOffset++] = n;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public int get(int n) {
        if (n >= this.size) {
            throw new Error("Attempt to get " + n + " greater than size " + this.size);
        }
        return this.chunks[n >> 12][n & 0xFFF];
    }

    public void put(int n, int n2) {
        if (n >= this.size) {
            throw new Error("Attempt to put " + n + " greater than size " + this.size);
        }
        this.chunks[n >> 12][n & 0xFFF] = n2;
    }

    public void add(int n, int n2) {
        for (int i = 0; i < n + 1 - this.size; ++i) {
            this.add(0);
        }
        this.put(n, n2);
    }

    public void putAll(int n) {
        for (int i = 0; i < this.size; ++i) {
            this.put(i, n);
        }
    }

    String hex(int n) {
        return Integer.toHexString(n);
    }

    public int indexOf(int n) {
        int n2 = 0;
        int n3 = this.size - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = this.get(n4);
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -1;
    }

    public void sort() {
        this.sort(null);
    }

    public void reverseSort() {
        this.reverseSort(null);
    }

    public void sort(SortListener sortListener) {
        this.listener = sortListener;
        this.quickSort(0, this.size - 1);
        this.listener = null;
    }

    public void reverseSort(SortListener sortListener) {
        this.listener = sortListener;
        this.quickSort(0, this.size - 1);
        int n = 0;
        for (int i = this.size - 1; n < i; ++n, --i) {
            this.swap(n, i);
        }
        this.listener = null;
    }

    public void swap(int n, int n2) {
        int n3 = this.get(n);
        this.put(n, this.get(n2));
        this.put(n2, n3);
        if (this.listener != null) {
            this.listener.swap(n, n2);
        }
    }

    void quickSort(int n, int n2) {
        if (n2 - n < 7) {
            for (int i = n; i <= n2; ++i) {
                for (int j = i; j > n && this.get(j - 1) > this.get(j); --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        if (n < n2) {
            int n3 = this.randomPartition(n, n2);
            this.quickSort(n, n3);
            this.quickSort(n3 + 1, n2);
        }
    }

    int randomPartition(int n, int n2) {
        int n3 = this.random.nextInt(n2 - n + 1) + n;
        this.swap(n, n3);
        return this.partition(n, n2);
    }

    int partition(int n, int n2) {
        int n3 = this.get(n);
        int n4 = n - 1;
        int n5 = n2 + 1;
        while (true) {
            if (this.get(--n5) > n3) {
                continue;
            }
            while (this.get(++n4) < n3) {
            }
            if (n4 >= n5) break;
            this.swap(n4, n5);
        }
        return n5;
    }
}

