/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.module.PKCS11Principal;
import com.ibm.crypto.pkcs11impl.provider.JarVerifier;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.pkcs11.PKCS11Slot;
import com.ibm.pkcs11.nat.NativePKCS11;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import javax.security.auth.Subject;

public final class IBMPKCS11Impl
extends Provider {
    private static String info = "IBMPKCS11Impl Provider implements the following:\nSignature algorithms               : SHA1withDSA, SHA1withRSA, MD5withRSA, MD2withRSA \nCipher algorithms                  : DES, TripleDES, RSA,\nKey (pair) generator               : DSA, RSA, DES, TripleDES\nMessage digest                     : MD2, MD5, SHA-1\nAlgorithm parameter generator      : DSA\nAlgorithm parameter                : DSA, DES, TripleDES\nKey factory                        : DSA, RSA\nSecret key factory                 : DES, TripleDES\nCertificate                        : X.509\nSecure random                      : PKCS11DeviceRNG (IBMSecureRandom)\nKey store                          : PKCS11IMPLKS\n";
    static final boolean debug2 = false;
    private static boolean verifiedJce = false;
    private static boolean verifiedSelfIntegrity = false;
    private static X509Certificate[] trustedCaCerts = null;
    protected static PKCS11Session session = null;
    private static PKCS11Slot tokenSlot = null;
    private static PKCS11 pkcs11 = null;
    private static final byte[][] bytesOfTrustedCaCerts = new byte[][]{{48, -126, 3, 79, 48, -126, 3, 13, -96, 3, 2, 1, 2, 2, 4, 57, 36, -91, 85, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 53, 49, 57, 48, 50, 50, 50, 49, 51, 90, 23, 13, 48, 54, 48, 53, 49, 56, 48, 50, 50, 50, 49, 51, 90, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -22, 107, 0, -57, -33, 16, 59, -71, 116, 53, -89, -31, 109, 102, -126, 77, -9, 91, 86, 113, -62, 38, 69, 39, 114, 61, 81, 16, 98, -1, -77, -36, 16, -55, -5, 81, 19, -44, -83, -117, -88, 37, 110, 93, -55, 120, -46, 91, 39, -45, 19, 65, 71, 20, 6, 124, -53, -126, 56, 94, -58, 11, 97, -96, 76, -125, 45, -108, -52, -116, 46, -124, -112, 58, -113, 66, 10, 105, 82, -45, 116, 38, 119, -92, 20, 125, 42, 113, 65, -120, -119, 119, -90, 45, 98, -102, -95, 88, -104, 109, 108, -49, -50, -88, -22, -70, -35, -24, -95, 16, 68, -116, -124, 66, -63, -72, 31, 43, -76, -68, -77, 93, 116, 96, -128, -115, 66, 84, -93, 83, 48, 81, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 28, -17, -10, -64, 92, -19, -109, 112, 34, -31, 75, -55, 15, -16, -99, 122, 9, -18, -122, -122, 2, 20, 18, 119, 71, 98, -62, -97, 25, 97, -36, 41, -6, -71, 73, -91, 25, -42, -91, -68, 69, 77}, {48, -126, 3, -64, 48, -126, 3, 126, -96, 3, 2, 1, 2, 2, 1, 1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 23, 13, 48, 54, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -73, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -21, -81, 55, 4, 30, -54, 81, 30, 105, 93, -80, -14, -113, -10, -75, 73, 31, -58, -92, -103, 5, -41, 41, -65, 116, -73, 106, -11, 25, -40, 30, -28, 27, -8, 10, 1, -102, -104, -1, 112, -85, -30, 74, 86, -122, 108, 83, -77, -4, -31, -56, -127, -116, 49, -16, -60, -13, -80, -117, -26, 112, 6, -20, -9, 105, 104, -37, -125, 76, 114, 41, -119, 41, 54, 23, 92, 59, 74, 7, -96, 32, 2, 42, 70, -105, 81, 29, 112, -56, 8, 24, 11, -50, 12, 110, -101, 118, -9, 5, -29, -25, -5, -45, 97, 121, -31, 96, -102, 36, -115, 6, -107, -125, 60, 81, 32, -31, 48, -49, 56, 87, -126, -90, 26, 114, 13, -50, -45, 2, 21, 0, -124, 37, 69, -31, -70, -71, -87, 98, -85, 121, -24, 91, 48, -72, -119, 107, 27, -1, 123, 117, 2, -127, -127, 0, -85, -55, 116, 123, 116, -17, -18, 66, -75, 106, 83, 77, 59, -35, -112, 6, 114, 104, -111, 15, 11, -92, 41, 118, 46, 85, 59, -43, -82, 77, 101, 92, 126, 42, 58, 4, -90, 103, -90, -48, 113, -86, -91, -41, -73, -30, -63, 114, 13, -92, -47, -86, 30, -110, 84, 76, 32, 0, 9, -94, -80, 9, 65, 25, 51, 0, -78, -61, 92, -82, 66, -8, -79, -117, -54, 124, -106, -40, 16, 127, 55, 68, 91, -86, -52, 120, -56, -41, 114, 118, 55, 107, 64, -103, -88, 85, 102, -6, -88, 3, 30, -117, 74, 17, 2, 105, -53, 76, -72, 37, 6, 28, -96, 119, -46, -55, -84, -46, 61, -23, 10, 16, -6, 118, 112, -73, -5, -36, 3, -127, -124, 0, 2, -127, -128, 45, 9, -104, 92, -84, -72, -100, -57, -103, 126, -18, 32, 25, 42, 52, -112, -7, -41, -85, -85, -82, -35, 107, 114, -107, 13, 102, -8, -17, 39, -113, 68, -78, -19, 40, 68, -57, -2, -81, -80, -90, 39, 111, 0, 103, 69, -126, 91, 7, -88, 86, 86, 59, -46, 41, 81, 97, 94, 105, 57, -41, 46, 116, 119, 18, -49, 25, 74, -11, 45, -56, -53, 114, 97, -60, 78, 111, -6, 71, 67, 63, 20, -69, -6, -68, 24, 102, 40, -62, -39, 102, -117, 122, 45, 47, -62, 96, -110, 75, 20, -2, 88, 62, 33, 127, 104, 98, -66, 108, 72, 73, -7, -96, 75, 94, -123, -99, 25, 16, -7, 21, 69, 81, 27, 113, -44, -9, 11, -93, 102, 48, 100, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 36, -97, 2, -61, -5, 49, -43, -111, 59, -7, 126, 86, 111, -106, -33, 100, 10, 4, -104, -76, 2, 20, 110, 121, -124, -89, -18, 104, -93, 2, 114, 49, 99, -37, 67, -85, 8, -20, 77, -17, 22, 58}};
    static final long serialVersionUID = -7311315630492398086L;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl";
    static /* synthetic */ Class class$com$ibm$crypto$pkcs11impl$provider$IBMPKCS11Impl;

    public IBMPKCS11Impl() {
        super("IBMPKCS11Impl", 1.0, info);
        if (debug != null) {
            System.out.println("new IBMPKCS11Impl instance");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IBMPKCS11Impl.this.put("Alg.Alias.Signature.DONTUSETHIS", "IBMPKCS11Impl");
                return null;
            }
        });
        session = null;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String string = preferences.get("IBMPKCSImpl DLL", null);
        String string2 = preferences.get("IBMPKCSImpl password", null);
        try {
            if (string == null) {
                this.Init(null, null);
            } else {
                char[] cArray = null;
                if (string2 != null) {
                    cArray = new char[string2.length()];
                    string2.getChars(0, string2.length(), cArray, 0);
                }
                this.Init(string, cArray);
                int n = 0;
                while (n < cArray.length) {
                    cArray[n] = '\u0000';
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            throw new PKCS11Exception(iOException.getMessage());
        }
    }

    public IBMPKCS11Impl(String string) {
        super("IBMPKCS11Impl", 1.0, info);
        if (debug != null) {
            System.out.println("new IBMPKCS11Impl instance");
        }
        session = null;
        try {
            this.Init(string, null);
        }
        catch (IOException iOException) {
            throw new PKCS11Exception(iOException.getMessage());
        }
    }

    protected PKCS11Session getSession() {
        return session;
    }

    public static void removeSession() {
        if (session != null) {
            session.close();
            session = null;
        }
        if (tokenSlot != null) {
            tokenSlot.closeAllSessions();
            tokenSlot = null;
        }
        if (pkcs11 != null) {
            pkcs11.libFinalize();
            pkcs11 = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void Init(String var1_1, char[] var2_2) throws IOException {
        block51: {
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            var6_6 = var2_2;
            var7_7 = 0;
            var8_8 = 0;
            if (IBMPKCS11Impl.debug != null) {
                IBMPKCS11Impl.debug.entry(16384L, (Object)IBMPKCS11Impl.className, "Init", (Object)var1_1, (Object)var2_2);
            }
            if (IBMPKCS11Impl.session == null) {
                if (var1_1 == null) {
                    var9_9 = AccessController.getContext();
                    try {
                        block52: {
                            var10_17 = Subject.getSubject(var9_9);
                            var11_20 = null;
                            var12_21 = null;
                            if (var10_17 == null) break block51;
                            try {
                                var12_21 = var10_17.getPrincipals(Class.forName("com.ibm.crypto.pkcs11impl.module.PKCS11Principal"));
                            }
                            catch (Exception var13_22) {
                                if (IBMPKCS11Impl.debug == null) break block52;
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Got unexpected exception 1: " + var13_22.getMessage());
                            }
                        }
                        if (var12_21.size() != 0) {
                            var13_23 = var12_21.iterator();
                            var11_20 = (PKCS11Principal)var13_23.next();
                            IBMPKCS11Impl.session = var11_20.getSession();
                        }
                        break block51;
                    }
                    catch (NullPointerException var10_18) {
                        if (IBMPKCS11Impl.debug != null) {
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "ACC is null: " + var10_18.getMessage());
                        }
                        break block51;
                    }
                }
                var4_4 = var1_1.trim();
                if (var4_4.toLowerCase().indexOf(".dll") < 0) {
                    if (var4_4.toLowerCase().indexOf(".so") < 0) {
                        if (IBMPKCS11Impl.debug != null) {
                            System.out.println("dllName=" + var4_4);
                            System.out.println("dllName.toLowerCase().indexOf()=" + var4_4.toLowerCase().indexOf(".so"));
                        }
                        throw new IOException("Invalid library name");
                    }
                    if (IBMPKCS11Impl.debug != null) {
                        System.out.println("a unix lib:" + var4_4);
                    }
                    var7_7 = var4_4.toLowerCase().indexOf(".so:") + 3;
                    if (IBMPKCS11Impl.debug != null) {
                        System.out.println("findex=" + var7_7);
                    }
                    if (var7_7 > 2) {
                        var5_5 = var4_4.substring(0, var7_7);
                        try {
                            if (IBMPKCS11Impl.debug != null) {
                                System.out.println("substring=" + var4_4.substring(var7_7 + 1, var4_4.length()));
                            }
                            var8_8 = Integer.valueOf(var4_4.substring(var7_7 + 1, var4_4.length()));
                            if (IBMPKCS11Impl.debug == null) ** GOTO lbl73
                            System.out.println("slotIndex=" + var8_8);
                        }
                        catch (NumberFormatException var9_10) {
                            if (IBMPKCS11Impl.debug != null) {
                                var9_10.printStackTrace();
                            }
                            throw new IOException("Invalid slot number");
                        }
                    } else {
                        var7_7 = var4_4.toLowerCase().indexOf(".so64:") + 3;
                        if (var7_7 > 2) {
                            var5_5 = var4_4.substring(0, var7_7 += 2);
                            try {
                                if (IBMPKCS11Impl.debug != null) {
                                    System.out.println("substring=" + var4_4.substring(var7_7 + 1, var4_4.length()));
                                }
                                var8_8 = Integer.valueOf(var4_4.substring(var7_7 + 1, var4_4.length()));
                                if (IBMPKCS11Impl.debug == null) ** GOTO lbl73
                                System.out.println("slotIndex=" + var8_8);
                            }
                            catch (NumberFormatException var9_11) {
                                throw new IOException("Invalid slot number");
                            }
                        } else {
                            var5_5 = var4_4;
                        }
                    }
lbl73:
                    // 5 sources

                    var9_12 = new File(var5_5);
                    var10_19 = var9_12.getName();
                    if (var10_19 != null && var10_19.toLowerCase().startsWith("lib")) {
                        var5_5 = var9_12.getParent() + File.separator + var10_19.substring(3);
                    }
                    if (var5_5.toLowerCase().endsWith(".so")) {
                        var5_5 = var5_5.substring(0, var5_5.length() - 3);
                    }
                } else {
                    if (IBMPKCS11Impl.debug != null) {
                        System.out.println("P4");
                    }
                    if (IBMPKCS11Impl.debug != null) {
                        IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "dllName: " + var4_4);
                    }
                    if ((var7_7 = var4_4.toLowerCase().indexOf(".dll:") + 4) > 3) {
                        var5_5 = var4_4.substring(0, var7_7);
                        if (IBMPKCS11Impl.debug != null) {
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "fileName: " + var5_5);
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "findex: " + var7_7);
                        }
                        try {
                            var8_8 = Integer.valueOf(var4_4.substring(var7_7 + 1, var4_4.length()));
                            if (IBMPKCS11Impl.debug == null) ** GOTO lbl97
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "slotIndex=" + var8_8);
                        }
                        catch (NumberFormatException var9_13) {
                            throw new IOException("Invalid slot number");
                        }
                    } else {
                        var5_5 = var4_4;
                    }
lbl97:
                    // 3 sources

                    if (var5_5.toLowerCase().endsWith(".dll")) {
                        var5_5 = var5_5.substring(0, var5_5.length() - 4);
                    }
                }
                if (IBMPKCS11Impl.debug != null) {
                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "fileName = " + var5_5);
                }
                try {
                    IBMPKCS11Impl.pkcs11 = new NativePKCS11(var5_5);
                }
                catch (PKCS11Exception var9_14) {
                    throw new IOException("Invalid dll name : " + var5_5);
                }
                if (IBMPKCS11Impl.debug != null) {
                    System.out.println("P5");
                }
                IBMPKCS11Impl.pkcs11.libInitialize();
                try {
                    IBMPKCS11Impl.pkcs11.libInitialize();
                }
                catch (PKCS11Exception var9_15) {
                    // empty catch block
                }
                var3_3 = IBMPKCS11Impl.pkcs11.getSlotList(true);
                if (var8_8 < 0 || var8_8 > var3_3.length - 1) {
                    throw new IOException("Invalid slot number : " + var8_8);
                }
                IBMPKCS11Impl.tokenSlot = var3_3[var8_8];
                if (IBMPKCS11Impl.debug != null) {
                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Slot Info:" + IBMPKCS11Impl.tokenSlot.getInfo().toString());
                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Token Info:" + IBMPKCS11Impl.tokenSlot.getTokenInfo().toString());
                }
                try {
                    IBMPKCS11Impl.session = IBMPKCS11Impl.tokenSlot.openSession(6, null, null);
                }
                catch (PKCS11Exception var9_16) {
                    if (IBMPKCS11Impl.debug != null) {
                        IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Creation of read write session failed:" + var9_16.getMessage());
                    }
                    if (var9_16.getCode() == 226) {
                        IBMPKCS11Impl.session = IBMPKCS11Impl.tokenSlot.openSession(4, null, null);
                    }
                    throw new IOException(var9_16.getMessage());
                }
                if (var6_6 == null) {
                    IBMPKCS11Impl.session.login(false, null);
                } else {
                    IBMPKCS11Impl.session.login(false, (Object)new String(var6_6));
                }
            }
        }
        if (IBMPKCS11Impl.session != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IBMPKCS11Impl.this.clear();
                    int[] nArray = session.getSlot().getMechanismList();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    int n = 0;
                    while (n < nArray.length) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "Init", "Mechanism: " + nArray[n]);
                        }
                        switch (nArray[n]) {
                            case 17: {
                                bl2 = true;
                                IBMPKCS11Impl.this.put("Signature.DSAforSSL", "com.ibm.crypto.pkcs11impl.provider.PKCS11SSLHashingwithDSA");
                                break;
                            }
                            case 6: {
                                bl10 = true;
                                IBMPKCS11Impl.this.put("Signature.SHA1withRSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.PKCS11SHA1withRSA", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA-1withRSA", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA-1/RSA", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA1/RSA", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA/RSA", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHAwithRSA", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.RSA", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.26", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.26", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", "SHA1withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", "SHA1withRSA");
                                break;
                            }
                            case 4: {
                                bl8 = true;
                                IBMPKCS11Impl.this.put("Signature.MD2withRSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11MD2withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.PKCS11MD2withRSA", "MD2withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.MD2/RSA", "MD2withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.2", "MD2withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.2.840.113549.1.1.2", "MD2withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.24", "MD2withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.24", "MD2withRSA");
                                break;
                            }
                            case 5: {
                                bl9 = true;
                                IBMPKCS11Impl.this.put("Signature.MD5withRSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11MD5withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.PKCS11MD5withRSA", "MD5withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.MD5/RSA", "MD5withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.4", "MD5withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.2.840.113549.1.1.4", "MD5withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.25", "MD5withRSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.25", "MD5withRSA");
                                break;
                            }
                            case 18: {
                                bl7 = true;
                                IBMPKCS11Impl.this.put("Signature.SHA1withDSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.PKCS11SHA1withDSA", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA-1withDSA", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA-1/DSA", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA1/DSA", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA/DSA", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.DSA", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.DSS", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHAwithDSA", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.DSAWithSHA1", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.2.840.10040.4.3", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.2.840.10040.4.3", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.13", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.13", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.27", "SHA1withDSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.27", "SHA1withDSA");
                                break;
                            }
                            case 289: 
                            case 290: 
                            case 293: {
                                IBMPKCS11Impl.this.put("Cipher.DES", "com.ibm.crypto.pkcs11impl.provider.DESCipher");
                                break;
                            }
                            case 306: 
                            case 307: 
                            case 310: {
                                IBMPKCS11Impl.this.put("Cipher.DESede", "com.ibm.crypto.pkcs11impl.provider.DESedeCipher");
                                IBMPKCS11Impl.this.put("Alg.Alias.Cipher.TripleDES", "DESede");
                                IBMPKCS11Impl.this.put("Alg.Alias.Cipher.3DES", "DESede");
                                break;
                            }
                            case 288: {
                                IBMPKCS11Impl.this.put("KeyGenerator.DES", "com.ibm.crypto.pkcs11impl.provider.DESPKCS11KeyGenerator");
                                IBMPKCS11Impl.this.put("AlgorithmParameters.DES", "com.ibm.crypto.pkcs11impl.provider.DESParameters");
                                IBMPKCS11Impl.this.put("SecretKeyFactory.DES", "com.ibm.crypto.pkcs11impl.provider.DESPKCS11KeyFactory");
                                break;
                            }
                            case 305: {
                                IBMPKCS11Impl.this.put("KeyGenerator.DESede", "com.ibm.crypto.pkcs11impl.provider.DESedePKCS11KeyGenerator");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyGenerator.TripleDES", "DESede");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyGenerator.3DES", "DESede");
                                IBMPKCS11Impl.this.put("AlgorithmParameters.DESede", "com.ibm.crypto.pkcs11impl.provider.DESedeParameters");
                                IBMPKCS11Impl.this.put("Alg.Alias.AlgorithmParameters.TripleDES", "DESede");
                                IBMPKCS11Impl.this.put("Alg.Alias.AlgorithmParameters.3DES", "DESede");
                                IBMPKCS11Impl.this.put("SecretKeyFactory.DESede", "com.ibm.crypto.pkcs11impl.provider.DESedePKCS11KeyFactory");
                                IBMPKCS11Impl.this.put("Alg.Alias.SecretKeyFactory.TripleDES", "DESede");
                                IBMPKCS11Impl.this.put("Alg.Alias.SecretKeyFactory.3DES", "DESede");
                                break;
                            }
                            case 16: {
                                IBMPKCS11Impl.this.put("KeyPairGenerator.DSA", "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyPairGenerator");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyPairGenerator.OID.1.2.840.10040.4.1", "DSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyPairGenerator.1.2.840.10040.4.1", "DSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyPairGenerator.OID.1.3.14.3.2.12", "DSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyPairGenerator.1.3.14.3.2.12", "DSA");
                                IBMPKCS11Impl.this.put("AlgorithmParameterGenerator.DSA", "com.ibm.crypto.pkcs11impl.provider.DSAParameterGenerator");
                                IBMPKCS11Impl.this.put("AlgorithmParameters.DSA", "com.ibm.crypto.pkcs11impl.provider.DSAParameters");
                                IBMPKCS11Impl.this.put("Alg.Alias.AlgorithmParameters.1.3.14.3.2.12", "DSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.AlgorithmParameters.1.2.840.10040.4.1", "DSA");
                                IBMPKCS11Impl.this.put("KeyFactory.DSA", "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyFactory");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyFactory.OID.1.3.14.3.2.12", "DSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyFactory.1.3.14.3.2.12", "DSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyFactory.OID.1.2.840.10040.4.1", "DSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyFactory.1.2.840.10040.4.1", "DSA");
                                break;
                            }
                            case 0: {
                                IBMPKCS11Impl.this.put("KeyPairGenerator.RSA", "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyPairGenerator");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyPairGenerator.OID.1.2.5.8.1.1", "RSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyPairGenerator.1.2.5.8.1.1", "RSA");
                                IBMPKCS11Impl.this.put("KeyFactory.RSA", "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyFactory");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyFactory.OID.1.2.5.8.1.1", "RSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyFactory.1.2.5.8.1.1", "RSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyFactory.OID.1.2.840.113549.1.1.1", "RSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.KeyFactory.1.2.840.113549.1.1.1", "RSA");
                                break;
                            }
                            case 512: {
                                bl4 = true;
                                IBMPKCS11Impl.this.put("MessageDigest.MD2", "com.ibm.crypto.pkcs11impl.provider.MD2");
                                break;
                            }
                            case 528: {
                                bl5 = true;
                                IBMPKCS11Impl.this.put("MessageDigest.MD5", "com.ibm.crypto.pkcs11impl.provider.MD5");
                                break;
                            }
                            case 544: {
                                bl6 = true;
                                IBMPKCS11Impl.this.put("MessageDigest.SHA", "com.ibm.crypto.pkcs11impl.provider.SHA");
                                IBMPKCS11Impl.this.put("Alg.Alias.MessageDigest.SHA-1", "SHA");
                                IBMPKCS11Impl.this.put("Alg.Alias.MessageDigest.SHA1", "SHA");
                                break;
                            }
                            case 1: {
                                bl3 = true;
                                IBMPKCS11Impl.this.put("Signature.RSAforSSL", "com.ibm.crypto.pkcs11impl.provider.PKCS11SSLHashingwithRSA");
                            }
                            case 3: {
                                IBMPKCS11Impl.this.put("Cipher.RSA", "com.ibm.crypto.pkcs11impl.provider.RSACipher");
                                IBMPKCS11Impl.this.put("Alg.Alias.Cipher.RSAforSSL", "RSA");
                                IBMPKCS11Impl.this.put("Alg.Alias.Cipher.RSA/SSL/PKCS1Padding", "RSA");
                            }
                        }
                        ++n;
                    }
                    if (!bl8 && bl3 && bl4) {
                        IBMPKCS11Impl.this.put("Signature.MD2withRSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11MD2withRSASingle");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.PKCS11MD2withRSA", "MD2withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.MD2/RSA", "MD2withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.2", "MD2withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.2.840.113549.1.1.2", "MD2withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.24", "MD2withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.24", "MD2withRSA");
                    }
                    if (!bl9 && bl3 && bl5) {
                        IBMPKCS11Impl.this.put("Signature.MD5withRSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11MD5withRSASingle");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.PKCS11MD5withRSA", "MD5withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.MD5/RSA", "MD5withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.4", "MD5withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.2.840.113549.1.1.4", "MD5withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.25", "MD5withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.25", "MD5withRSA");
                    }
                    if (!bl10 && bl3 && bl6) {
                        IBMPKCS11Impl.this.put("Signature.SHA1withRSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11SHA1withRSASingle");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.PKCS11SHA1withRSA", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA-1withRSA", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA-1/RSA", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA1/RSA", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA/RSA", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHAwithRSA", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.RSA", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.26", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.26", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", "SHA1withRSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", "SHA1withRSA");
                    }
                    if (!bl7 && bl2 && bl6) {
                        IBMPKCS11Impl.this.put("Signature.SHA1withDSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11SHA1withDSASingle");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.PKCS11SHA1withDSA", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA-1withDSA", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA-1/DSA", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA1/DSA", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHA/DSA", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.DSA", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.DSS", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.SHAwithDSA", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.DSAWithSHA1", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.2.840.10040.4.3", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.2.840.10040.4.3", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.13", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.13", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.OID.1.3.14.3.2.27", "SHA1withDSA");
                        IBMPKCS11Impl.this.put("Alg.Alias.Signature.1.3.14.3.2.27", "SHA1withDSA");
                    }
                    IBMPKCS11Impl.this.put("SecureRandom.IBMSecureRandom", "com.ibm.crypto.pkcs11impl.provider.SecureRandom");
                    IBMPKCS11Impl.this.put("Alg.Alias.SecureRandom.PKCS11DeviceRNG", "IBMSecureRandom");
                    IBMPKCS11Impl.this.put("CertificateFactory.X509", "com.ibm.crypto.pkcs11impl.provider.X509Factory");
                    IBMPKCS11Impl.this.put("Alg.Alias.CertificateFactory.X.509", "X509");
                    IBMPKCS11Impl.this.put("KeyStore.PKCS11IMPLKS", "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore");
                    return null;
                }
            });
        }
    }

    static final void verifyJceJar() {
        if (verifiedJce) {
            return;
        }
        String string = System.getProperty("java.version");
        if (string.compareTo("1.4") >= 0) {
            verifiedJce = true;
            return;
        }
        IBMPKCS11Impl.doVerifyJceJar();
    }

    private static final synchronized void doVerifyJceJar() {
        Object object;
        Object object2;
        if (verifiedJce) {
            return;
        }
        URL uRL = null;
        try {
            object2 = class$com$ibm$crypto$pkcs11impl$provider$IBMPKCS11Impl == null ? (class$com$ibm$crypto$pkcs11impl$provider$IBMPKCS11Impl = IBMPKCS11Impl.class$("com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl")) : class$com$ibm$crypto$pkcs11impl$provider$IBMPKCS11Impl;
            object = ((Class)object2).getClassLoader();
            URL uRL2 = (URL)AccessController.doPrivileged(new PrivilegedAction((ClassLoader)object){
                private final /* synthetic */ ClassLoader val$cl;
                {
                    this.val$cl = classLoader;
                }

                public Object run() {
                    return this.val$cl.getResource("javax/crypto/Cipher.class");
                }
            });
            if (uRL2 == null) {
                throw new SecurityException("Cannot get the JCE framework URL. Check that IBMPKCS11Impl can read the JCE framework");
            }
            int n = IBMPKCS11Impl.indexOfBang(uRL2.toString());
            if (n == -1) {
                throw new SecurityException("The JCE framework is invalid");
            }
            uRL = new URL(uRL2.toString().substring(0, n + 1));
            int n2 = 4;
            URL uRL3 = new URL(uRL2.toString().substring(n2, n - 1));
            if (!uRL3.getProtocol().equalsIgnoreCase("file")) {
                throw new SecurityException("JCE should be deployed as an installed extension");
            }
        }
        catch (IOException iOException) {
            throw new SecurityException("The provider IBMPKCS11Impl cannot authenticate JCE framework" + iOException);
        }
        try {
            object = uRL;
            object2 = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction((URL)object){
                private final /* synthetic */ URL val$url;
                {
                    this.val$url = uRL;
                }

                public Object run() throws Exception {
                    return ((JarURLConnection)this.val$url.openConnection()).getJarFile();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new SecurityException("Cannot authenticate JCE framework " + privilegedActionException);
        }
        try {
            IBMPKCS11Impl.verifySingleJarFile((JarFile)object2);
        }
        catch (Exception exception) {
            throw new SecurityException("Cannot authenticate JCE framework " + exception);
        }
        verifiedJce = true;
    }

    private static void verifySingleJarFile(JarFile jarFile) throws IOException, CertificateException {
        Object object;
        Cloneable cloneable;
        Vector<Manifest> vector = new Vector<Manifest>();
        byte[] byArray = new byte[8192];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            cloneable = enumeration.nextElement();
            vector.addElement((Manifest)cloneable);
            object = jarFile.getInputStream((ZipEntry)cloneable);
            while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
            }
            ((InputStream)object).close();
        }
        cloneable = jarFile.getManifest();
        if (cloneable == null) {
            throw new SecurityException("The JCE framework is not signed");
        }
        trustedCaCerts = IBMPKCS11Impl.setupTrustedCaCerts();
        object = new Vector(2);
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            JarEntry jarEntry = (JarEntry)enumeration2.nextElement();
            if (jarEntry.isDirectory()) continue;
            Certificate[] certificateArray = jarEntry.getCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                if (jarEntry.getName().startsWith("META-INF")) continue;
                throw new SecurityException("The JCE framework has unsigned class files.");
            }
            Certificate[] certificateArray2 = IBMPKCS11Impl.getChainRoots(certificateArray);
            boolean bl = false;
            int n = 0;
            while (n < certificateArray2.length) {
                if (((Vector)object).contains((X509Certificate)certificateArray2[n])) {
                    bl = true;
                    break;
                }
                if (IBMPKCS11Impl.isTrusted((X509Certificate)certificateArray2[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            throw new SecurityException("JCE framework is not signed by a trusted signer");
        }
    }

    private static boolean isTrusted(X509Certificate x509Certificate) {
        int n = 0;
        while (n < trustedCaCerts.length) {
            if (x509Certificate.getSubjectDN().equals(trustedCaCerts[n].getSubjectDN()) && x509Certificate.equals(trustedCaCerts[n])) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < trustedCaCerts.length) {
            if (x509Certificate.getIssuerDN().equals(trustedCaCerts[n2].getSubjectDN())) {
                try {
                    x509Certificate.verify(trustedCaCerts[n2].getPublicKey());
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return false;
    }

    private static Certificate[] getChainRoots(Certificate[] certificateArray) {
        Vector<Certificate> vector = new Vector<Certificate>(3);
        int n = 0;
        while (n < certificateArray.length - 1) {
            if (!((X509Certificate)certificateArray[n + 1]).getSubjectDN().equals(((X509Certificate)certificateArray[n]).getIssuerDN())) {
                vector.addElement(certificateArray[n]);
            }
            ++n;
        }
        vector.addElement(certificateArray[certificateArray.length - 1]);
        Object[] objectArray = new Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static X509Certificate[] setupTrustedCaCerts() throws IOException, CertificateException {
        int n = bytesOfTrustedCaCerts.length;
        X509Certificate[] x509CertificateArray = new X509Certificate[n];
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        int n2 = 0;
        while (n2 < n) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytesOfTrustedCaCerts[n2]);
            x509CertificateArray[n2] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            byteArrayInputStream.close();
            ++n2;
        }
        return x509CertificateArray;
    }

    private static int indexOfBang(String string) {
        int n = string.lastIndexOf(".jar!/");
        if (n > 0) {
            return n + 5;
        }
        return -1;
    }

    static final boolean verifySelfIntegrity(Class clazz) {
        if (verifiedSelfIntegrity) {
            return true;
        }
        return IBMPKCS11Impl.doSelfVerification(clazz);
    }

    private static final synchronized boolean doSelfVerification(Class clazz) {
        Class clazz2;
        URL uRL;
        if (verifiedSelfIntegrity) {
            return true;
        }
        if (trustedCaCerts == null) {
            try {
                trustedCaCerts = IBMPKCS11Impl.setupTrustedCaCerts();
            }
            catch (Exception exception) {
                return false;
            }
        }
        if ((uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(clazz2 = clazz){
            private final /* synthetic */ Class val$cc;
            {
                this.val$cc = clazz;
            }

            public Object run() {
                CodeSource codeSource = this.val$cc.getProtectionDomain().getCodeSource();
                return codeSource.getLocation();
            }
        })) == null) {
            return false;
        }
        JarVerifier jarVerifier = new JarVerifier(uRL);
        try {
            jarVerifier.verify(trustedCaCerts);
        }
        catch (Exception exception) {
            return false;
        }
        verifiedSelfIntegrity = true;
        return true;
    }

    private static Certificate[] getSignerCertificates(Class clazz) {
        final Class clazz2 = clazz;
        return (Certificate[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource codeSource = clazz2.getProtectionDomain().getCodeSource();
                return codeSource.getCertificates();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

