/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAKeyPairParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class RSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int modlen = 1024;
    private PKCS11Session session = null;
    private byte[] id = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean sign = new Boolean(true);
    private Boolean encrypt = new Boolean(true);
    private Boolean wrapping = new Boolean(true);
    private Boolean extractable = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyPairGenerator";

    public RSAPKCS11KeyPairGenerator() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)algorithmParameterSpec, (Object)secureRandom);
        }
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11RSAKeyPairParameterSpec)) {
            throw new InvalidAlgorithmParameterException("PKCS11 RSA KeyPair Parameters must be specified");
        }
        PKCS11RSAKeyPairParameterSpec pKCS11RSAKeyPairParameterSpec = (PKCS11RSAKeyPairParameterSpec)algorithmParameterSpec;
        this.modlen = pKCS11RSAKeyPairParameterSpec.getStrength();
        if (pKCS11RSAKeyPairParameterSpec.getKeyID() != null) {
            try {
                this.id = pKCS11RSAKeyPairParameterSpec.getKeyID().getBytes("8859_1");
            }
            catch (Exception exception) {
                this.id = pKCS11RSAKeyPairParameterSpec.getKeyID().getBytes();
            }
        }
        if (pKCS11RSAKeyPairParameterSpec.getSubject() != null) {
            try {
                this.subject = pKCS11RSAKeyPairParameterSpec.getSubject().getBytes("8859_1");
            }
            catch (Exception exception) {
                this.subject = pKCS11RSAKeyPairParameterSpec.getSubject().getBytes();
            }
        }
        this.label = pKCS11RSAKeyPairParameterSpec.getLabel();
        this.isSensitive = pKCS11RSAKeyPairParameterSpec.getSensitive();
        this.isToken = pKCS11RSAKeyPairParameterSpec.getToken();
        this.sign = pKCS11RSAKeyPairParameterSpec.getSign();
        this.encrypt = pKCS11RSAKeyPairParameterSpec.getEncrypt();
        this.wrapping = pKCS11RSAKeyPairParameterSpec.getWrap();
        this.extractable = pKCS11RSAKeyPairParameterSpec.getExtractable();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + n), (Object)secureRandom);
            debug.exit(16384L, (Object)className, "initialize");
        }
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public void initialize(int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + n));
            debug.exit(16384L, (Object)className, "initialize");
        }
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public KeyPair generateKeyPair() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateKeyPair");
        }
        int n = 9;
        int n2 = 9;
        int n3 = 0;
        if (this.isToken == null) {
            --n2;
            --n;
        }
        if (this.isSensitive == null) {
            --n2;
        }
        if (this.sign == null) {
            --n;
            --n2;
        }
        if (this.encrypt == null) {
            --n;
            --n2;
        }
        if (this.wrapping == null) {
            --n;
            --n2;
        }
        if (this.extractable == null) {
            --n2;
        }
        int[] nArray = new int[n];
        Object[] objectArray = new Object[n];
        nArray[n3] = 289;
        objectArray[n3++] = new Integer(this.modlen);
        nArray[n3] = 290;
        objectArray[n3++] = new BigInteger("65537");
        nArray[n3] = 258;
        objectArray[n3++] = this.id;
        nArray[n3] = 257;
        objectArray[n3++] = this.subject;
        nArray[n3] = 3;
        objectArray[n3++] = this.label;
        if (this.isToken != null) {
            nArray[n3] = 1;
            objectArray[n3++] = this.isToken;
        }
        if (this.sign != null) {
            nArray[n3] = 266;
            objectArray[n3++] = this.sign;
        }
        if (this.encrypt != null) {
            nArray[n3] = 260;
            objectArray[n3++] = this.encrypt;
        }
        if (this.wrapping != null) {
            nArray[n3] = 262;
            objectArray[n3++] = this.wrapping;
        }
        int[] nArray2 = new int[n2];
        Object[] objectArray2 = new Object[n2];
        n3 = 0;
        nArray2[n3] = 258;
        objectArray2[n3++] = this.id;
        nArray2[n3] = 257;
        objectArray2[n3++] = this.subject;
        nArray2[n3] = 3;
        objectArray2[n3++] = this.label;
        if (this.isToken != null) {
            nArray2[n3] = 1;
            objectArray2[n3++] = this.isToken;
        }
        if (this.isSensitive != null) {
            nArray2[n3] = 259;
            objectArray2[n3++] = this.isSensitive;
        }
        if (this.encrypt != null) {
            nArray2[n3] = 261;
            objectArray2[n3++] = this.encrypt;
        }
        if (this.sign != null) {
            nArray2[n3] = 264;
            objectArray2[n3++] = this.sign;
        }
        if (this.wrapping != null) {
            nArray2[n3] = 263;
            objectArray2[n3++] = this.wrapping;
        }
        if (this.extractable != null) {
            nArray2[n3] = 354;
            objectArray2[n3] = this.extractable;
        }
        String string = "";
        PKCS11Object[] pKCS11ObjectArray = null;
        KeyPair keyPair = null;
        try {
            pKCS11ObjectArray = this.session.generateKeyPair(0, null, nArray, objectArray, nArray2, objectArray2);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)exception);
            }
            throw new RuntimeException(exception.getMessage());
        }
        PKCS11Object[] pKCS11ObjectArray2 = this.orderObjects(pKCS11ObjectArray);
        PKCS11Object pKCS11Object = pKCS11ObjectArray2[0];
        PKCS11Object pKCS11Object2 = pKCS11ObjectArray2[1];
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(pKCS11Object, this.id, this.subject, this.label, this.isToken, this.sign, this.encrypt, this.wrapping, (BigInteger)this.getValue(pKCS11Object, 288), (Integer)this.getValue(pKCS11Object, 289), (BigInteger)this.getValue(pKCS11Object, 290));
            RSAPrivateKey rSAPrivateKey = null;
            if (this.isSensitive.booleanValue()) {
                rSAPrivateKey = new RSAPrivateKey(pKCS11Object2, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(pKCS11Object2, 288), (BigInteger)this.getValue(pKCS11Object2, 290));
            } else {
                try {
                    rSAPrivateKey = new RSAPrivateKey(pKCS11Object2, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(pKCS11Object2, 288), (BigInteger)this.getValue(pKCS11Object2, 290), (BigInteger)this.getValue(pKCS11Object2, 291), (BigInteger)this.getValue(pKCS11Object2, 292), (BigInteger)this.getValue(pKCS11Object2, 293), (BigInteger)this.getValue(pKCS11Object2, 294), (BigInteger)this.getValue(pKCS11Object2, 295), (BigInteger)this.getValue(pKCS11Object2, 296));
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)exception);
                    }
                    rSAPrivateKey = new RSAPrivateKey(pKCS11Object2, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(pKCS11Object2, 288), (BigInteger)this.getValue(pKCS11Object2, 290));
                }
            }
            keyPair = new KeyPair(rSAPublicKey, rSAPrivateKey);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_3", (Throwable)exception);
            }
            keyPair = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return keyPair;
    }

    private PKCS11Object[] orderObjects(PKCS11Object[] pKCS11ObjectArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "orderObjects", (Object[])pKCS11ObjectArray);
        }
        Integer n = (Integer)this.getValue(pKCS11ObjectArray[0], 0);
        Integer n2 = (Integer)this.getValue(pKCS11ObjectArray[1], 0);
        PKCS11Object pKCS11Object = null;
        PKCS11Object pKCS11Object2 = null;
        if (n.equals(PKCS11Object.PUBLIC_KEY) && n2.equals(PKCS11Object.PRIVATE_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[0];
            pKCS11Object = pKCS11ObjectArray[1];
        } else if (n.equals(PKCS11Object.PRIVATE_KEY) && n2.equals(PKCS11Object.PUBLIC_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[1];
            pKCS11Object = pKCS11ObjectArray[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        pKCS11ObjectArray[0] = pKCS11Object2;
        pKCS11ObjectArray[1] = pKCS11Object;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects", (Object)pKCS11ObjectArray);
        }
        return pKCS11ObjectArray;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }
}

