/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.BASE64Decoder;
import com.ibm.security.cert.CertPathImpl;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CertificateFactoryImpl
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static int defaultExpectedLineLength = 80;
    private Iterator supported_encodings;
    protected static final String pkcs7String = "PKCS7";
    protected static final String pkipString = "PkiPath";
    protected static final String x509String = "X.509";
    private ArrayList supported_encodings_vector = new ArrayList(2);

    public CertificateFactoryImpl() {
        this.supported_encodings_vector.add(pkipString);
        this.supported_encodings_vector.add(pkcs7String);
        this.supported_encodings = Collections.unmodifiableList(this.supported_encodings_vector).iterator();
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CertImpl(byArray);
            }
            return new X509CertImpl(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!inputStream.markSupported()) {
                byte[] byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            return this.parseX509orPKCS7Cert(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CRLImpl(byArray);
            }
            return new X509CRLImpl(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            if (!inputStream.markSupported()) {
                byte[] byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            return this.parseX509orPKCS7CRL(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    private Collection parseX509orPKCS7Cert(InputStream inputStream) throws CertificateException, IOException {
        ArrayList<X509CertImpl> arrayList = new ArrayList<X509CertImpl>();
        boolean bl = true;
        while (inputStream.available() != 0) {
            InputStream inputStream2 = inputStream;
            if (this.isBase64(inputStream2)) {
                inputStream2 = new ByteArrayInputStream(this.base64_to_binary(inputStream2));
            }
            if (bl) {
                inputStream2.mark(inputStream2.available());
            }
            try {
                arrayList.add(new X509CertImpl(inputStream2));
            }
            catch (CertificateException certificateException) {
                if (bl) {
                    inputStream2.reset();
                    byte[] byArray = new byte[inputStream2.available()];
                    inputStream2.read(byArray);
                    Certificate[] certificateArray = null;
                    try {
                        SignedData signedData = new SignedData(byArray);
                        certificateArray = signedData.getCertificates();
                    }
                    catch (IOException iOException) {
                        try {
                            ContentInfo contentInfo = new ContentInfo(byArray);
                            Content content = contentInfo.getContent();
                            if (content instanceof SignedData) {
                                certificateArray = ((SignedData)content).getCertificates();
                            }
                        }
                        catch (IOException iOException2) {
                            throw new CertificateException("Fail to parse input stream");
                        }
                    }
                    if (certificateArray != null) {
                        return Arrays.asList(certificateArray);
                    }
                    return new ArrayList(0);
                }
                throw certificateException;
            }
            if (!bl) continue;
            bl = false;
        }
        return arrayList;
    }

    private Collection parseX509orPKCS7CRL(InputStream inputStream) throws CRLException, IOException {
        ArrayList<X509CRLImpl> arrayList = new ArrayList<X509CRLImpl>();
        boolean bl = true;
        while (inputStream.available() != 0) {
            InputStream inputStream2 = inputStream;
            if (this.isBase64(inputStream)) {
                inputStream2 = new ByteArrayInputStream(this.base64_to_binary(inputStream2));
            }
            if (bl) {
                inputStream2.mark(inputStream2.available());
            }
            try {
                arrayList.add(new X509CRLImpl(inputStream2));
            }
            catch (CRLException cRLException) {
                if (bl) {
                    inputStream2.reset();
                    byte[] byArray = new byte[inputStream2.available()];
                    inputStream2.read(byArray);
                    X509CRL[] x509CRLArray = null;
                    try {
                        SignedData signedData = new SignedData(byArray);
                        x509CRLArray = (X509CRL[])signedData.getCRLs();
                    }
                    catch (IOException iOException) {
                        try {
                            ContentInfo contentInfo = new ContentInfo(byArray);
                            Content content = contentInfo.getContent();
                            if (content instanceof SignedData) {
                                x509CRLArray = (X509CRL[])((SignedData)content).getCRLs();
                            }
                        }
                        catch (IOException iOException2) {
                            throw new CRLException("Fail to parse input stream");
                        }
                    }
                    if (x509CRLArray != null) {
                        return Arrays.asList(x509CRLArray);
                    }
                    return new ArrayList(0);
                }
                throw cRLException;
            }
            if (!bl) continue;
            bl = false;
        }
        return arrayList;
    }

    private byte[] base64_to_binary(InputStream inputStream) throws IOException {
        long l = 0L;
        inputStream.mark(inputStream.available());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStreamReader = new InputStreamReader(bufferedInputStream);
        }
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = this.readLine(bufferedReader);
        if (string == null || !string.startsWith("-----BEGIN")) {
            throw new IOException("Unsupported encoding");
        }
        l += (long)string.length();
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine(bufferedReader)) != null && !string.startsWith("-----END")) {
            stringBuffer.append(string);
        }
        if (string == null) {
            throw new IOException("Unsupported encoding");
        }
        l += (long)string.length();
        inputStream.reset();
        inputStream.skip(l += (long)stringBuffer.length());
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(stringBuffer.toString());
    }

    private byte[] getTotalBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        byteArrayOutputStream.reset();
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private boolean isBase64(InputStream inputStream) throws IOException {
        if (inputStream.available() >= 10) {
            inputStream.mark(10);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            int n9 = inputStream.read();
            int n10 = inputStream.read();
            inputStream.reset();
            return n == 45 && n2 == 45 && n3 == 45 && n4 == 45 && n5 == 45 && n6 == 66 && n7 == 69 && n8 == 71 && n9 == 73 && n10 == 78;
        }
        throw new IOException("Cannot determine encoding format");
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        int n;
        char[] cArray = new char[]{'-', '-', '-', '-', '-', 'E', 'N', 'D'};
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(defaultExpectedLineLength);
        do {
            n = bufferedReader.read();
            if (bl && n2 < cArray.length) {
                boolean bl3 = bl = (char)n == cArray[n2++];
            }
            if (!bl2) {
                bl2 = bl && n2 == cArray.length;
            }
            stringBuffer.append((char)n);
        } while (n != -1 && n != 10 && n != 13);
        if (!bl2 && n == -1) {
            return null;
        }
        if (n == 13) {
            bufferedReader.mark(1);
            int n3 = bufferedReader.read();
            if (n3 == 10) {
                stringBuffer.append((char)n);
            } else {
                bufferedReader.reset();
            }
        }
        return stringBuffer.toString();
    }

    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("input stream is null");
        }
        try {
            DerInputStream derInputStream;
            DerValue[] derValueArray;
            byte[] byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (this.isBase64(byteArrayInputStream)) {
                byArray = this.base64_to_binary(byteArrayInputStream);
            }
            if ((derValueArray = (derInputStream = new DerInputStream(byArray)).getSequence(3)).length == 0) {
                return new CertPathImpl(x509String, Collections.EMPTY_LIST);
            }
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>(derValueArray.length);
            for (int i = derValueArray.length - 1; i >= 0; --i) {
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(derValueArray[i].toByteArray());
                arrayList.add(this.engineGenerateCertificate(byteArrayInputStream2));
                byteArrayInputStream2.close();
            }
            return new CertPathImpl(x509String, Collections.unmodifiableList(arrayList));
        }
        catch (IOException iOException) {
            throw new CertificateException("IOException parsing PkiPath data: " + iOException);
        }
    }

    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        CertPath certPath = null;
        if (string.equals(pkcs7String)) {
            Collection collection = this.engineGenerateCertificates(inputStream);
            LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                linkedList.add(x509Certificate);
            }
            certPath = this.engineGenerateCertPath(linkedList);
        } else if (string.equals(pkipString)) {
            certPath = this.engineGenerateCertPath(inputStream);
        } else {
            throw new CertificateException("Encoding: " + string + " not valid.");
        }
        return certPath;
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        int n;
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
        boolean bl = false;
        int n2 = 0;
        int n3 = list.size();
        int n4 = 0;
        boolean bl2 = false;
        try {
            list.toArray(x509CertificateArray);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new CertificateException("Not X.509 certificates");
        }
        if (n3 > 1) {
            for (n = 0; n < n3 - 1; ++n) {
                if (!((Object)x509CertificateArray[n].getIssuerDN()).equals(x509CertificateArray[n + 1].getSubjectDN())) continue;
                ++n2;
            }
        }
        if (n3 - 1 == n2 || n3 < 2) {
            bl2 = true;
            for (n = 0; n < n3; ++n) {
                linkedList.add(x509CertificateArray[n]);
            }
        }
        if (!bl2) {
            linkedList.add(x509CertificateArray[0]);
            x509CertificateArray[0] = null;
            ++n4;
            while (!bl2) {
                for (n = 0; n < x509CertificateArray.length; ++n) {
                    if (x509CertificateArray[n] == null) continue;
                    if (((Object)((X509Certificate)linkedList.getFirst()).getSubjectDN()).equals(x509CertificateArray[n].getIssuerDN())) {
                        linkedList.addFirst(x509CertificateArray[n]);
                        x509CertificateArray[n] = null;
                        ++n4;
                        bl = true;
                        continue;
                    }
                    if (!((Object)((X509Certificate)linkedList.getLast()).getIssuerDN()).equals(x509CertificateArray[n].getSubjectDN())) continue;
                    linkedList.addLast(x509CertificateArray[n]);
                    x509CertificateArray[n] = null;
                    ++n4;
                    bl = true;
                }
                if (!bl) {
                    for (n = 0; n < x509CertificateArray.length; ++n) {
                        if (x509CertificateArray[n] == null) continue;
                        linkedList.addLast(x509CertificateArray[n]);
                        x509CertificateArray[n] = null;
                        ++n4;
                    }
                } else {
                    bl = false;
                }
                if (n4 != n3) continue;
                bl2 = true;
            }
        }
        CertPathImpl certPathImpl = new CertPathImpl(x509String, linkedList);
        return certPathImpl;
    }

    public Iterator engineGetCertPathEncodings() {
        return this.supported_encodings;
    }
}

