/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.cert.IBMCertPathHelper;
import com.ibm.security.cert.MemoryCache;
import com.ibm.security.cert.X509CertificatePair;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivilegedAction;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.x500.X500Principal;

public class LDAPCertStoreImpl
extends CertStoreSpi {
    private static final String USER_CERT = "userCertificate";
    private static final String CA_CERT = "cACertificate";
    private static final String CROSS_CERT = "crossCertificatePair";
    private static final String CRL = "certificateRevocationList";
    private static final String ARL = "authorityRevocationList";
    private static final String DELTA_CRL = "deltaRevocationList";
    private static final String USER_CERT_BIN = "userCertificate;binary";
    private static final String CA_CERT_BIN = "cACertificate;binary";
    private static final String CROSS_CERT_BIN = "crossCertificatePair;binary";
    private static final String CRL_BIN = "certificateRevocationList;binary";
    private static final String ARL_BIN = "authorityRevocationList;binary";
    private static final String DELTA_CRL_BIN = "deltaRevocationList;binary";
    private static final Attributes EMPTY_ATTRIBUTES = new BasicAttributes();
    private static final byte[][] EMPTY_VALUES = new byte[0][];
    private static final int DEFAULT_CACHE_SIZE = 750;
    private static final int DEFAULT_CACHE_LIFETIME = 30;
    private static int LIFETIME;
    private static final String PROP_LIFETIME = "ibm.security.certpath.ldap.cache.lifetime";
    private DirContext ctx;
    private boolean prefetchCRLs = false;
    private final MemoryCache valueCache;
    private static final Debug debug;

    public LDAPCertStoreImpl(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof LDAPCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be LDAPCertStoreParameters");
        }
        this.init((LDAPCertStoreParameters)certStoreParameters);
        this.valueCache = LIFETIME <= 0 ? new MemoryCache(750, 0) : new MemoryCache(750, LIFETIME);
    }

    public void init(LDAPCertStoreParameters lDAPCertStoreParameters) throws InvalidAlgorithmParameterException {
        Properties properties = new Properties();
        String string = null;
        String string2 = new String("ldap://");
        int n = -1;
        try {
            properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            properties.put("java.naming.factory.url.pkgs", "com.sun.jndi.ldap");
            if (!(lDAPCertStoreParameters instanceof LDAPCertStoreParameters)) {
                throw new InvalidAlgorithmParameterException();
            }
            string = lDAPCertStoreParameters.getServerName();
            n = lDAPCertStoreParameters.getPort();
            if (string == null || n < 0) {
                throw new InvalidAlgorithmParameterException();
            }
            String string3 = string2 + string + ":" + n;
            properties.put("java.naming.provider.url", string3);
            this.ctx = new InitialDirContext(properties);
        }
        catch (NamingException namingException) {
            InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException(namingException.getMessage());
            invalidAlgorithmParameterException.initCause(namingException);
            throw invalidAlgorithmParameterException;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            InvalidAlgorithmParameterException invalidAlgorithmParameterException2 = new InvalidAlgorithmParameterException(invalidAlgorithmParameterException.getMessage());
            invalidAlgorithmParameterException2.initCause(invalidAlgorithmParameterException);
            throw invalidAlgorithmParameterException2;
        }
    }

    private Collection getCertificates(LDAPRequest lDAPRequest, String string, CertSelector certSelector) throws CertStoreException {
        byte[][] byArray;
        try {
            byArray = lDAPRequest.getValues(string);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        int n = byArray.length;
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<X509CertImpl> arrayList = new ArrayList<X509CertImpl>(n);
        for (int i = 0; i < n; ++i) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[i]);
            try {
                X509CertImpl x509CertImpl = new X509CertImpl((InputStream)byteArrayInputStream);
                if (!certSelector.match((Certificate)x509CertImpl)) continue;
                if (debug != null) {
                    System.out.println("CERTPATH: found a matched cert");
                }
                arrayList.add(x509CertImpl);
                continue;
            }
            catch (CertificateException certificateException) {
                if (debug == null) continue;
                System.out.println("CERTPATH: receive bad cert data ");
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[ " + hexDumpEncoder.encodeBuffer(byArray[i]) + " ]");
            }
        }
        return arrayList;
    }

    private Collection getCertPairs(LDAPRequest lDAPRequest, String string) throws CertStoreException {
        byte[][] byArray;
        try {
            byArray = lDAPRequest.getValues(string);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        int n = byArray.length;
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<X509CertificatePair> arrayList = new ArrayList<X509CertificatePair>(n);
        for (int i = 0; i < n; ++i) {
            try {
                X509CertificatePair x509CertificatePair = new X509CertificatePair(byArray[i]);
                arrayList.add(x509CertificatePair);
                continue;
            }
            catch (CertificateException certificateException) {
                if (debug == null) continue;
                System.out.println("CERTPATH: receive bad certificate pair data ");
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[ " + hexDumpEncoder.encodeBuffer(byArray[i]) + " ]");
            }
        }
        return arrayList;
    }

    private Collection getMatchingCrossCerts(LDAPRequest lDAPRequest, CertSelector certSelector, CertSelector certSelector2) throws CertStoreException {
        Collection collection = this.getCertPairs(lDAPRequest, CROSS_CERT);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate;
            X509CertificatePair x509CertificatePair = (X509CertificatePair)iterator.next();
            if (certSelector != null && (x509Certificate = x509CertificatePair.getForward()) != null && certSelector.match(x509Certificate)) {
                arrayList.add(x509Certificate);
            }
            if (certSelector2 == null || (x509Certificate = x509CertificatePair.getReverse()) == null || !certSelector2.match(x509Certificate)) continue;
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    public synchronized Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        LDAPRequest lDAPRequest;
        X509CertSelector x509CertSelector = null;
        if (certSelector == null) {
            x509CertSelector = new X509CertSelector();
        }
        if (!(certSelector instanceof X509CertSelector)) {
            throw new CertStoreException("LDAPCertStore needs an X509CertSelector to find certs");
        }
        x509CertSelector = (X509CertSelector)certSelector;
        HashSet hashSet = new HashSet();
        X500Name x500Name = IBMCertPathHelper.getSubject(x509CertSelector);
        X500Name x500Name2 = IBMCertPathHelper.getIssuer(x509CertSelector);
        String string = null;
        if (x500Name != null) {
            string = x500Name.getRFC1779Name();
        }
        String string2 = null;
        if (x500Name2 != null) {
            string2 = x500Name2.getRFC1779Name();
        }
        int n = x509CertSelector.getBasicConstraints();
        if (string != null) {
            lDAPRequest = new LDAPRequest(string);
            if (n > -2) {
                lDAPRequest.addRequestedAttribute(CROSS_CERT);
                lDAPRequest.addRequestedAttribute(CROSS_CERT_BIN);
                lDAPRequest.addRequestedAttribute(CA_CERT);
                lDAPRequest.addRequestedAttribute(CA_CERT_BIN);
                lDAPRequest.addRequestedAttribute(ARL);
                lDAPRequest.addRequestedAttribute(ARL_BIN);
                if (this.prefetchCRLs) {
                    lDAPRequest.addRequestedAttribute(CRL);
                    lDAPRequest.addRequestedAttribute(CRL_BIN);
                }
            }
            if (n < 0) {
                lDAPRequest.addRequestedAttribute(USER_CERT);
                lDAPRequest.addRequestedAttribute(USER_CERT_BIN);
            }
            if (n > -2) {
                hashSet.addAll(this.getMatchingCrossCerts(lDAPRequest, x509CertSelector, null));
                hashSet.addAll(this.getCertificates(lDAPRequest, CA_CERT, x509CertSelector));
                hashSet.addAll(this.getCertificates(lDAPRequest, CA_CERT_BIN, x509CertSelector));
            }
            if (n < 0) {
                hashSet.addAll(this.getCertificates(lDAPRequest, USER_CERT, x509CertSelector));
                hashSet.addAll(this.getCertificates(lDAPRequest, USER_CERT_BIN, x509CertSelector));
            }
        } else {
            if (debug != null) {
                System.out.println("CERTPATH: LDAP type certstore, subject is null");
            }
            if (n == -2) {
                throw new CertStoreException("need subject to find EE certs");
            }
            if (string2 == null) {
                throw new CertStoreException("need subject or issuer to find certs");
            }
        }
        if (string2 != null && n > -2) {
            lDAPRequest = new LDAPRequest(string2);
            lDAPRequest.addRequestedAttribute(CROSS_CERT);
            lDAPRequest.addRequestedAttribute(CROSS_CERT_BIN);
            lDAPRequest.addRequestedAttribute(CA_CERT);
            lDAPRequest.addRequestedAttribute(CA_CERT_BIN);
            lDAPRequest.addRequestedAttribute(ARL);
            lDAPRequest.addRequestedAttribute(ARL_BIN);
            if (this.prefetchCRLs) {
                lDAPRequest.addRequestedAttribute(CRL);
                lDAPRequest.addRequestedAttribute(CRL_BIN);
            }
            hashSet.addAll(this.getMatchingCrossCerts(lDAPRequest, null, x509CertSelector));
            hashSet.addAll(this.getCertificates(lDAPRequest, CA_CERT, x509CertSelector));
            hashSet.addAll(this.getCertificates(lDAPRequest, CA_CERT_BIN, x509CertSelector));
        }
        if (debug != null) {
            System.out.println("CERTPATH: LDAP type certstore returning certs size=" + hashSet.size());
        }
        return hashSet;
    }

    private Collection getCRLs(LDAPRequest lDAPRequest, String string, CRLSelector cRLSelector) throws CertStoreException {
        byte[][] byArray;
        try {
            byArray = lDAPRequest.getValues(string);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        int n = byArray.length;
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<X509CRLImpl> arrayList = new ArrayList<X509CRLImpl>(n);
        for (int i = 0; i < n; ++i) {
            try {
                X509CRLImpl x509CRLImpl = new X509CRLImpl((InputStream)new ByteArrayInputStream(byArray[i]));
                if (!cRLSelector.match((CRL)x509CRLImpl)) continue;
                arrayList.add(x509CRLImpl);
                continue;
            }
            catch (CRLException cRLException) {
                if (debug == null) continue;
                System.out.println("CERTPATH: receive bad CRL data ");
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[ " + hexDumpEncoder.encodeBuffer(byArray[i]) + " ]");
            }
        }
        return arrayList;
    }

    public synchronized Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        Object object;
        if (debug != null) {
            System.out.println("CERTPATH: selector used to retrieve CRLs from LDAP CertStore: " + cRLSelector);
        }
        if (cRLSelector == null) {
            cRLSelector = new X509CRLSelector();
        }
        if (!(cRLSelector instanceof X509CRLSelector)) {
            throw new CertStoreException("need X509CRLSelector to find CRLs");
        }
        X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
        HashSet hashSet = new HashSet();
        Collection<Object> collection = new HashSet();
        X509Certificate x509Certificate = x509CRLSelector.getCertificateChecking();
        if (x509Certificate != null) {
            if (x509Certificate instanceof X509CertImpl) {
                collection.add(((X500Name)x509Certificate.getIssuerDN()).getName());
            } else {
                object = x509Certificate.getIssuerX500Principal();
                collection.add(((X500Principal)object).getName("RFC2253"));
            }
        } else {
            collection = x509CRLSelector.getIssuerNames();
            if (collection == null) {
                throw new CertStoreException("need issuerNames or certChecking to find CRLs");
            }
        }
        object = collection.iterator();
        while (object.hasNext()) {
            LDAPRequest lDAPRequest;
            boolean bl;
            String string;
            block20: {
                Collection collection2;
                block19: {
                    Object e = object.next();
                    if (e instanceof byte[]) {
                        try {
                            collection2 = new X500Name((byte[])e);
                            string = collection2.getName();
                            break block19;
                        }
                        catch (IOException iOException) {
                            if (debug == null) continue;
                            System.out.println("CERTPATH: non fatal error happens while getting CRLs from LDAP CertStore " + iOException);
                            continue;
                        }
                    }
                    string = (String)e;
                }
                collection2 = Collections.EMPTY_LIST;
                bl = true;
                if (x509Certificate == null || x509Certificate.getBasicConstraints() != -1) {
                    lDAPRequest = new LDAPRequest(string);
                    lDAPRequest.addRequestedAttribute(CROSS_CERT);
                    lDAPRequest.addRequestedAttribute(CROSS_CERT_BIN);
                    lDAPRequest.addRequestedAttribute(CA_CERT);
                    lDAPRequest.addRequestedAttribute(CA_CERT_BIN);
                    lDAPRequest.addRequestedAttribute(ARL);
                    lDAPRequest.addRequestedAttribute(ARL_BIN);
                    if (this.prefetchCRLs) {
                        lDAPRequest.addRequestedAttribute(CRL);
                        lDAPRequest.addRequestedAttribute(CRL_BIN);
                    }
                    try {
                        collection2 = this.getCRLs(lDAPRequest, ARL, x509CRLSelector);
                        if (!collection2.isEmpty()) {
                            hashSet.addAll(collection2);
                            bl = false;
                        }
                        if (!(collection2 = this.getCRLs(lDAPRequest, ARL_BIN, x509CRLSelector)).isEmpty()) {
                            hashSet.addAll(collection2);
                            bl = false;
                        }
                        if (bl) {
                            this.prefetchCRLs = true;
                        }
                    }
                    catch (CertStoreException certStoreException) {
                        if (debug == null) break block20;
                        System.out.println("CERTPATH: error getting CRLs from LDAP CertStore " + certStoreException);
                        certStoreException.printStackTrace();
                    }
                }
            }
            if (!bl && x509Certificate != null) continue;
            lDAPRequest = new LDAPRequest(string);
            lDAPRequest.addRequestedAttribute(CRL);
            lDAPRequest.addRequestedAttribute(CRL_BIN);
            hashSet.addAll(this.getCRLs(lDAPRequest, CRL, x509CRLSelector));
            hashSet.addAll(this.getCRLs(lDAPRequest, CRL_BIN, x509CRLSelector));
        }
        return hashSet;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(LDAPCertStoreImpl.PROP_LIFETIME);
            }
        });
        if (string != null) {
            try {
                LIFETIME = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LIFETIME = 30;
            }
        } else {
            LIFETIME = 30;
        }
        debug = Debug.getInstance((String)"certpath");
    }

    private class LDAPRequest {
        private final String name;
        private Map valueMap;
        private final ArrayList requestedAttributes;
        private Attributes attrs;

        LDAPRequest(String string) {
            this.name = string;
            this.requestedAttributes = new ArrayList(5);
        }

        String getName() {
            return this.name;
        }

        void addRequestedAttribute(String string) {
            if (this.valueMap != null) {
                throw new IllegalStateException("Request already sent");
            }
            this.requestedAttributes.add(string);
        }

        byte[][] getValues(String string) throws NamingException {
            String[] stringArray;
            String string2 = this.name + string;
            Object object = null;
            object = (byte[][])LDAPCertStoreImpl.this.valueCache.get(string2);
            if (object != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: got matched values from LDAP CertStore cache, key=" + string2);
                }
                return object;
            }
            if (this.valueMap != null) {
                object = (byte[][])this.valueMap.get(string);
            } else {
                this.valueMap = new HashMap(5);
            }
            if (object != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: got values from LDAP CertStore local memory");
                }
                return object;
            }
            if (this.attrs == null) {
                stringArray = new String[this.requestedAttributes.size()];
                this.requestedAttributes.toArray(stringArray);
                try {
                    this.attrs = LDAPCertStoreImpl.this.ctx.getAttributes(this.name, stringArray);
                }
                catch (NamingException namingException) {
                    if (debug != null) {
                        System.out.println("CERTPATH: failed to get attrs of LDAP context");
                        namingException.printStackTrace();
                    }
                    this.attrs = null;
                    return EMPTY_VALUES;
                }
            }
            stringArray = this.requestedAttributes.iterator();
            while (stringArray.hasNext()) {
                String string3 = (String)stringArray.next();
                Attribute attribute = this.attrs.get(string3);
                if (attribute != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH: retrieved the attribute with id " + string3);
                    }
                    byte[][] byArrayArray = new byte[attribute.size()][];
                    for (int i = 0; i < attribute.size(); ++i) {
                        Object object2 = attribute.get(i);
                        if (object2 instanceof byte[]) {
                            byArrayArray[i] = (byte[])object2;
                            continue;
                        }
                        if (debug == null) continue;
                        System.out.println("CERTPATH: attribute with id " + string3 + " has non byte[] value");
                    }
                    this.valueMap.put(string3, byArrayArray);
                    LDAPCertStoreImpl.this.valueCache.put(this.name + string3, byArrayArray);
                    if (debug != null) {
                        System.out.println("CERTPATH: put the retrieved bytes into value map, key=" + this.name + string3);
                    }
                    if (!string3.equals(string)) continue;
                    if (debug != null) {
                        System.out.println("CERTPATH: find the values for attribute " + this.name + "with id " + string3);
                    }
                    object = byArrayArray;
                    continue;
                }
                this.valueMap.put(string3, EMPTY_VALUES);
                LDAPCertStoreImpl.this.valueCache.put(this.name + string3, EMPTY_VALUES);
            }
            if (object == null) {
                return EMPTY_VALUES;
            }
            return object;
        }
    }
}

