/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KDCOptions;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbAsRep;
import com.ibm.security.krb5.KrbAsReq;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.KrbTgsRep;
import com.ibm.security.krb5.KrbTgsReq;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.a;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.LoginOptions;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.ServiceName;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.krb5.internal.TicketFlags;
import com.ibm.security.krb5.internal.ccache.c;
import com.ibm.security.krb5.internal.ccache.d;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.security.krb5.internal.ktab.KeyTabEntry;
import com.ibm.security.krb5.internal.ktab.g;
import com.ibm.security.krb5.internal.l;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Date;

public class Credentials {
    Ticket a;
    PrincipalName b;
    PrincipalName c;
    EncryptionKey d;
    TicketFlags e;
    KerberosTime f;
    KerberosTime g;
    KerberosTime h;
    KerberosTime i;
    HostAddresses j;
    EncryptionKey[] k;
    private static d l;
    private static boolean m;
    private static boolean n;

    private static native Credentials acquireDefaultNativeCreds();

    public Credentials(Ticket ticket, PrincipalName principalName, PrincipalName principalName2, EncryptionKey encryptionKey, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses) {
        this.a = ticket;
        this.b = principalName;
        this.c = principalName2;
        this.d = encryptionKey;
        this.e = ticketFlags;
        this.f = kerberosTime;
        this.g = kerberosTime2;
        this.h = kerberosTime3;
        this.i = kerberosTime4;
        this.j = hostAddresses;
    }

    public Credentials(byte[] byArray, String string, String string2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws KrbException, IOException {
        this(new Ticket(byArray), new PrincipalName(string), new PrincipalName(string2), new EncryptionKey(n2, byArray2), blArray == null ? null : new TicketFlags(blArray), date == null ? null : new KerberosTime(date), date2 == null ? null : new KerberosTime(date2), date3 == null ? null : new KerberosTime(date3), date4 == null ? null : new KerberosTime(date4), null);
    }

    public Credentials(PrincipalName principalName, EncryptionKey encryptionKey) throws RealmException {
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("g|M\u0019\u0019HdD"));
        }
        if (encryptionKey == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("g|M\u0019\u001cLp"));
        }
        this.b = principalName;
        this.k = new EncryptionKey[1];
        this.k[0] = (EncryptionKey)encryptionKey.clone();
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
            krb5Debug.out(9, Credentials.b("\u00177\u001fU\u0014[lE\u00109]`@\u0019$\u0013)b\u00072H}D\u0011wj{D\u00112G}H\u0014;Z)V\u001c#A)\u0010U<Lp\u0001\u001a1\t}X\u00052\t") + EncryptedData.encTypeToString(this.k[0].getEType()));
        }
    }

    public Credentials(String string, EncryptionKey encryptionKey) throws RealmException {
        this(new PrincipalName(string), encryptionKey);
    }

    public Credentials(String string, EncryptionKey[] encryptionKeyArray) throws RealmException {
        this(new PrincipalName(string), encryptionKeyArray);
    }

    public Credentials(PrincipalName principalName, EncryptionKey[] encryptionKeyArray) throws RealmException {
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("g|M\u0019\u0019HdD"));
        }
        if (encryptionKeyArray == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("g|M\u0019\u001cLp"));
        }
        this.b = principalName;
        this.k = new EncryptionKey[encryptionKeyArray.length];
        for (int i2 = 0; i2 < encryptionKeyArray.length; ++i2) {
            this.k[i2] = (EncryptionKey)encryptionKeyArray[i2].clone();
        }
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
            krb5Debug.out(9, Credentials.b("\u00177\u001fU\u0014[lE\u00109]`@\u0019$\u0013)b\u00072H}D\u0011wj{D\u00112G}H\u0014;Z)V\u001c#A)") + encryptionKeyArray.length + Credentials.b("\tbD\f$\u0007)j\u0010.\t}X\u00052Z3"));
            for (int i3 = 0; i3 < encryptionKeyArray.length; ++i3) {
                krb5Debug.out(9, Credentials.b(" R") + (i3 + 1) + Credentials.b("t)") + EncryptedData.encTypeToString(this.k[i3].getEType()));
            }
        }
    }

    public final PrincipalName getClient() {
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + ":");
            krb5Debug.out(9, Credentials.b("jeH\u00109])o\u0014:L3") + this.b.toString());
        }
        return this.b;
    }

    public final PrincipalName getServer() {
        return this.c;
    }

    public EncryptionKey getSessionKey() {
        if (this.d == null) {
            Krb5Debug krb5Debug;
            if (Krb5Debug.on(9)) {
                krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + ":");
                krb5Debug.out(9, Credentials.b("zlR\u0006>Fg\u0001>2P)H\u0006wo`S\u0006#\tZD\u0007!@jDU\u001cLp"));
            }
            if (this.k != null) {
                return (EncryptionKey)this.k[0].clone();
            }
            if (Krb5Debug.on(9)) {
                krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + ":");
                krb5Debug.out(9, Credentials.b("heMU\u001cLpRU6[l\u0001;\"Ee"));
            }
            return null;
        }
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
            krb5Debug.out(9, Credentials.b("zlR\u0006>Fg\u0001>2P)H\u0006wfgM\fwzlS\u0003>Jl\u0001>2P)"));
        }
        return this.d;
    }

    public final Date getStartTime() {
        if (this.g != null) {
            return this.g.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.h != null) {
            return this.h.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.i != null) {
            return this.i.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.e == null) {
            return null;
        }
        return this.e.a();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.j == null) {
            return null;
        }
        return this.j.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                byArray = this.a.asn1Encode();
            }
            catch (Asn1Exception asn1Exception) {
                if (Krb5Debug.on(6)) {
                    Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
                    krb5Debug.out(9, asn1Exception);
                }
            }
            catch (IOException iOException) {
                if (!Krb5Debug.on(6)) break block4;
                Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
                krb5Debug.out(9, iOException);
            }
        }
        return byArray;
    }

    public boolean isRenewable() {
        return this.e.get(8);
    }

    public Ticket getTicket() {
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + ":");
            krb5Debug.out(9, Credentials.b("{lU\u0000%G`O\u0012w}`B\u001e2]"));
        }
        return this.a;
    }

    public TicketFlags getTicketFlags() {
        return this.e;
    }

    public boolean checkDelegate() {
        boolean bl2 = false;
        try {
            bl2 = this.e.get(13);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    public Credentials renew() throws KrbException, IOException {
        KDCOptions kDCOptions = new KDCOptions();
        kDCOptions.set(30, true);
        kDCOptions.set(8, true);
        KrbTgsReq krbTgsReq = new KrbTgsReq(kDCOptions, this, this.c, null, null, null, null, this.j, null, null, null);
        String string = null;
        KrbTgsRep krbTgsRep = null;
        try {
            string = krbTgsReq.send();
            krbTgsRep = krbTgsReq.getReply(this);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbTgsReq.a(this.c.getRealmString(), string, true);
                krbTgsRep = krbTgsReq.getReply(this);
            }
            throw krbException;
        }
        return krbTgsRep.getCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, String string) throws KrbException, IOException {
        d d2 = com.ibm.security.krb5.internal.ccache.d.a(principalName, string);
        if (d2 == null) {
            return null;
        }
        c c2 = d2.f();
        return c2.c();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, InputStream inputStream) throws KrbException, IOException {
        d d2 = com.ibm.security.krb5.internal.ccache.d.a(principalName, inputStream);
        if (d2 == null) {
            return null;
        }
        c c2 = d2.f();
        return c2.c();
    }

    public static Credentials acquireTGT(PrincipalName principalName, EncryptionKey encryptionKey) throws KrbException, IOException {
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("g|M\u0019\u0019HdD"));
        }
        if (encryptionKey == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("g|M\u0019\u001cLp"));
        }
        KrbAsReq krbAsReq = new KrbAsReq(principalName, encryptionKey);
        String string = null;
        KrbAsRep krbAsRep = null;
        try {
            string = krbAsReq.send();
            krbAsRep = krbAsReq.getReply(encryptionKey);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbAsReq.a(principalName.getRealmString(), string, true);
                krbAsRep = krbAsReq.getReply(encryptionKey);
            }
            throw krbException;
        }
        return krbAsRep.getCreds();
    }

    public static Credentials acquireDefaultCreds() {
        Credentials credentials = null;
        if (l == null) {
            l = com.ibm.security.krb5.internal.ccache.d.a();
        }
        if (l != null) {
            Object object;
            if (Krb5Debug.on(9)) {
                object = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
                ((Krb5Debug)object).out(9, Credentials.b("\u00177\u001f>%KJS\u00103Z)G\u001a\"Gm\u0001\u0001?L)E\u00101H|M\u0001w]`B\u001e2])F\u00076G}H\u001b0\t}H\u0016<L}\u0001\u001c9\tjS\u00103LgU\u001c6E)B\u00144Al\u000f"));
            }
            object = l.f();
            credentials = ((c)object).c();
        } else {
            credentials = Credentials.getDefaultNativeCreds();
        }
        return credentials;
    }

    static Credentials a(String string) {
        return Credentials.acquireCreds(string, null);
    }

    public static Credentials acquireCreds(String string, String string2) {
        Credentials credentials = null;
        try {
            PrincipalName principalName = new PrincipalName(string);
            String string3 = string2;
            if (string3 == null) {
                string3 = Config.getInstance().getDefaultRealm();
            }
            if (principalName.getRealm() == null) {
                if (string3 != null) {
                    principalName.setRealm(string3);
                }
            } else if (string3 == null) {
                string3 = principalName.getRealmString();
            }
            if (string3 != null) {
                credentials = Credentials.a(principalName, string3, null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return credentials;
    }

    public static Credentials getServiceCreds(String string, File file) {
        block12: {
            Object object;
            Object var2_2 = null;
            PrincipalName principalName = null;
            PrincipalName principalName2 = null;
            if (string != null) {
                try {
                    principalName = new PrincipalName(string);
                    if (principalName.getRealm() == null) {
                        object = Config.getInstance().getDefaultRealm();
                        if (object == null) {
                            return null;
                        }
                        principalName.setRealm((String)object);
                    }
                }
                catch (Exception exception) {
                    if (Krb5Debug.on(6)) {
                        Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
                        krb5Debug.out(9, Credentials.b("\u00177\u001fU\u0014[lE\u00109]`@\u0019$\u0007nD\u0001\u0004L{W\u001c4LJS\u00103Z)D\r4LyU\u001c8G)B\u00072H}H\u001b0\tzD\u0007!@jDU9HdDU1F{\u0001") + string + Credentials.b("\u0013)") + exception.toString());
                    }
                    return null;
                }
            }
            if ((object = file == null ? KeyTab.getInstance() : KeyTab.getInstance(file)) != null) {
                if (principalName == null) {
                    KeyTabEntry keyTabEntry = ((KeyTab)object).getEntry(principalName);
                    if (keyTabEntry == null) {
                        return null;
                    }
                    principalName2 = keyTabEntry.getService();
                    if (principalName2 == null || principalName2 != principalName) {
                        return null;
                    }
                }
                try {
                    return new Credentials(principalName, ((KeyTab)object).getAllKeys(principalName));
                }
                catch (Exception exception) {
                    if (!Krb5Debug.on(6)) break block12;
                    Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
                    krb5Debug.out(9, Credentials.b("\u00177\u001fU\u0014[lE\u00109]`@\u0019$\u0007nD\u0001\u0004L{W\u001c4LJS\u00103Z)D\r4LyU\u001c8G3\u0001") + exception.toString());
                }
            }
        }
        return null;
    }

    public static Credentials getServiceCreds(PrincipalName principalName, InputStream inputStream) throws IOException, KrbException {
        g g2 = new g(inputStream);
        if (principalName == null) {
            KeyTabEntry keyTabEntry = g2.a(principalName);
            if (keyTabEntry == null) {
                return null;
            }
            principalName = keyTabEntry.getService();
            if (principalName == null) {
                return null;
            }
        }
        return new Credentials(principalName, g2.b(principalName));
    }

    private static Credentials a(PrincipalName principalName, String string, String string2, LoginOptions loginOptions) {
        Realm realm = null;
        PrincipalName principalName2 = null;
        Credentials credentials = null;
        try {
            if (principalName != null && string != null) {
                c c2;
                principalName2 = new PrincipalName(Credentials.b("B{C\u00010]&") + string + new Character('@') + string);
                realm = new Realm(string);
                if (l != null && !l.c().match(principalName)) {
                    l.g();
                    l = null;
                }
                if (l == null) {
                    l = string2 == null ? com.ibm.security.krb5.internal.ccache.d.a(principalName) : com.ibm.security.krb5.internal.ccache.d.a(principalName, string2);
                }
                if (l != null && l.e() != null && (c2 = l.a(loginOptions, principalName2, realm)) != null && c2.a()) {
                    if (Krb5Debug.on(9)) {
                        Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
                        krb5Debug.out(9, Credentials.b("\u00177\u001f>%KJS\u00103Z)G\u001a\"Gm\u0001\u0001?L)W\u0014;@m\u0001\u0001>JbD\u0001wN{@\u001b#@gFU#@jJ\u0010#\t`OU4[lE\u00109]`@\u0019wJhB\u001d2\u0007"));
                    }
                    credentials = c2.c();
                }
            }
        }
        catch (Exception exception) {
            credentials = null;
        }
        if (credentials == null) {
            l = null;
        }
        return credentials;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws Exception {
        ServiceName serviceName = new ServiceName(string);
        return Credentials.acquireServiceCreds(serviceName, credentials, null, null);
    }

    public static Credentials acquireServiceCreds(PrincipalName principalName, Credentials credentials) throws Exception {
        return Credentials.acquireServiceCreds(principalName, credentials, null, null);
    }

    public static Credentials acquireServiceCreds(PrincipalName principalName, Credentials credentials, KDCOptions kDCOptions, HostAddresses hostAddresses) throws KrbException, Exception {
        Credentials credentials2 = com.ibm.security.krb5.internal.l.a(principalName, credentials, kDCOptions, hostAddresses);
        if (credentials2 != null && Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
            krb5Debug.out(9, Credentials.b("\u00177\u001f6%LmD\u001b#@hM\u0006yHjP\u0000>[lr\u0010%_`B\u0010\u0014[lE\u0006m\t{D\u0001\"[gH\u001b0\tjS\u00103Z3"));
            krb5Debug.out(9, Credentials.b("\u00177\u001f6%LmD\u001b#@hM\u0006yHjP\u0000>[lr\u0010%_`B\u0010\u0014[lE\u0006m\t{D\u0001\"[gH\u001b0\tjS\u00103Z3"));
            krb5Debug.out(9, Credentials.b("\u00177\u001f1\u0012k\\fOw\u0004$\fX\u0014[lE\u00109]`@\u0019$\u0004$\fX"));
            krb5Debug.out(9, Credentials.b(" jM\u001c2G}\u001bU") + credentials2.b.toString());
            krb5Debug.out(9, Credentials.b(" zD\u0007!L{\u001bU") + credentials2.c.toString());
            krb5Debug.out(9, Credentials.b(" }H\u0016<L}\u001bU%LhM\u0018m\t") + credentials2.a.getRealm().toString());
            krb5Debug.out(9, Credentials.b(" )\u0001Uw\t)\u0001U$GhL\u0010m\t") + credentials2.a.getServer().toString());
            if (credentials2.g != null) {
                krb5Debug.out(9, Credentials.b(" zU\u0014%]]H\u00182\u0013)") + credentials2.g.getTime());
            } else {
                krb5Debug.out(9, Credentials.b(" zU\u0014%]]H\u00182\u0013)o \u001be"));
            }
            if (credentials2.h != null) {
                krb5Debug.out(9, Credentials.b(" lO\u0011\u0003@dDOw") + credentials2.h.getTime());
            } else {
                krb5Debug.out(9, Credentials.b(" lO\u0011\u0003@dDOwg\\m9"));
            }
            krb5Debug.out(9, Credentials.b("\t)\u0001Uw\t)\u0001Xz\u0004$b\u00072MlO\u0001>HeRU2Gm\fXz\u0004"));
        }
        return credentials2;
    }

    public d getCache() {
        return l;
    }

    public EncryptionKey getServiceKey() {
        if (this.k != null) {
            return (EncryptionKey)this.k[0].clone();
        }
        return null;
    }

    public EncryptionKey getServiceKey(int n2) {
        if (this.k == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            if (this.k[i2].getEType() != n2) continue;
            return (EncryptionKey)this.k[i2].clone();
        }
        return null;
    }

    public EncryptionKey[] getServiceKeys() {
        if (this.k == null) {
            return null;
        }
        EncryptionKey[] encryptionKeyArray = new EncryptionKey[this.k.length];
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            encryptionKeyArray[i2] = (EncryptionKey)this.k[i2].clone();
        }
        return encryptionKeyArray;
    }

    public void setServiceKey(EncryptionKey encryptionKey) throws Exception {
        if (encryptionKey == null) {
            I18NException.throwException(Credentials.b("g|M\u0019\u001cLp"));
        }
        if (this.k != null) {
            I18NException.throwException(Credentials.b("lqH\u0006#@gF>2Pz"));
        }
        this.k = new EncryptionKey[1];
        this.k[0] = (EncryptionKey)encryptionKey.clone();
    }

    public void setServiceKeys(EncryptionKey[] encryptionKeyArray) throws Exception {
        if (encryptionKeyArray == null) {
            I18NException.throwException(Credentials.b("g|M\u0019\u001cLp"));
        }
        if (this.k != null) {
            I18NException.throwException(Credentials.b("lqH\u0006#@gF>2Pz"));
        }
        this.k = new EncryptionKey[encryptionKeyArray.length];
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            this.k[i2] = (EncryptionKey)encryptionKeyArray[i2].clone();
        }
    }

    private static void a(Credentials credentials) {
        System.out.println(Credentials.b("\u00177\u001f1\u0012k\\fOw\u0004$\fX\u0014[lE\u00109]`@\u0019$\u0004$\fX"));
        System.out.println(Credentials.b(" jM\u001c2G}\u001bU") + credentials.b.toString());
        System.out.println(Credentials.b(" zD\u0007!L{\u001bU") + credentials.c.toString());
        System.out.println(Credentials.b(" }H\u0016<L}\u001bU%LhM\u0018m\t") + credentials.a.getRealm().toString());
        System.out.println(Credentials.b(" )\u0001Uw\t)\u0001U$GhL\u0010m\t") + credentials.a.getServer().toString());
        if (credentials.g != null) {
            System.out.println(Credentials.b(" zU\u0014%]]H\u00182\u0013)") + credentials.g.getTime());
        } else {
            System.out.println(Credentials.b(" zU\u0014%]]H\u00182\u0013)o \u001be"));
        }
        if (credentials.h != null) {
            System.out.println(Credentials.b(" lO\u0011\u0003@dDOw") + credentials.h.getTime());
        } else {
            System.out.println(Credentials.b(" lO\u0011\u0003@dDOwg\\m9"));
        }
        System.out.println(Credentials.b("\t)\u0001Uw\t)\u0001Xz\u0004$b\u00072MlO\u0001>HeRU2Gm\fXz\u0004"));
    }

    private static synchronized void a() {
        block5: {
            if (m || n) {
                return;
            }
            n = true;
            try {
                AccessController.doPrivileged(new a());
                m = true;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (Krb5Debug.on(6)) {
                    exception.printStackTrace();
                    Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
                    krb5Debug.out(9, Credentials.b("lqB\u0010']`N\u001bwEf@\u0011>Gn\u0001\u001b6]`W\u0010wJfE\u0010m\t") + exception);
                }
            }
            catch (Exception exception) {
                if (!Krb5Debug.on(6)) break block5;
                exception.printStackTrace();
                Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
                krb5Debug.out(9, Credentials.b("lqB\u0010']`N\u001bwEf@\u0011>Gn\u0001\u001b6]`W\u0010wJfE\u0010m\t") + exception);
            }
        }
    }

    public static Credentials getDefaultNativeCreds() {
        Credentials.a();
        if (m) {
            return Credentials.acquireDefaultNativeCreds();
        }
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("j{D\u00112G}H\u0014;Z3") + Thread.currentThread().getName() + Credentials.b("\u0013)"));
            krb5Debug.out(9, Credentials.b("\u00177\u001f6%LmD\u001b#@hM\u0006m\tgNU9H}H\u00032\tjN\u00112\teN\u00143Lm"));
        }
        return null;
    }

    public Date getAuthTime() {
        if (this.f == null) {
            return null;
        }
        return this.f.toDate();
    }

    static {
        m = false;
        n = false;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String b(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 41;
                        break;
                    }
                    case 1: {
                        n5 = 9;
                        break;
                    }
                    case 2: {
                        n5 = 33;
                        break;
                    }
                    case 3: {
                        n5 = 117;
                        break;
                    }
                    default: {
                        n5 = 87;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

