/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;

public final class MD5
extends MessageDigestSpi
implements Cloneable {
    private static final int MD5_LENGTH = 16;
    private static final int BLOCK_LENGTH = 64;
    private int[] state = new int[5];
    private byte[] buffer;
    private int bufferIndex;
    private int bufferLeft;

    public MD5() {
        this.init();
    }

    private MD5(MD5 mD5) {
        this();
        this.state = (int[])mD5.state.clone();
        this.buffer = (byte[])mD5.buffer.clone();
        this.bufferIndex = mD5.bufferIndex;
        this.bufferLeft = mD5.bufferLeft;
    }

    private static int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return ((n += (n2 & n3 | ~n2 & n4) + n5 + n7) << n6 | n >>> 32 - n6) + n2;
    }

    private static int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return ((n += (n2 & n4 | n3 & ~n4) + n5 + n7) << n6 | n >>> 32 - n6) + n2;
    }

    private static int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return ((n += (n2 ^ n3 ^ n4) + n5 + n7) << n6 | n >>> 32 - n6) + n2;
    }

    private static int II(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return ((n += (n3 ^ (n2 | ~n4)) + n5 + n7) << n6 | n >>> 32 - n6) + n2;
    }

    public Object clone() {
        MD5 mD5 = null;
        try {
            mD5 = (MD5)super.clone();
            mD5.state = (int[])this.state.clone();
            mD5.buffer = (byte[])this.buffer.clone();
            mD5.bufferIndex = this.bufferIndex;
            mD5.bufferLeft = this.bufferLeft;
            return mD5;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return mD5;
        }
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[16];
        this.processBuffer(this.buffer, 0, this.bufferIndex, byArray, 0);
        this.init();
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        byte[] byArray2 = new byte[16];
        this.processBuffer(this.buffer, 0, this.bufferIndex, byArray2, 0);
        if (n2 < 16) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n < 16) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(byArray2, 0, byArray, n, 16);
        this.init();
        return 16;
    }

    protected int engineGetDigestLength() {
        return 16;
    }

    protected void engineReset() {
        this.init();
    }

    protected synchronized void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        this.bufferLeft = 64 - this.bufferIndex;
        for (int i = 0; i < n2; i += this.bufferLeft) {
            if (this.bufferLeft <= n2 - i) {
                System.arraycopy(byArray, i + n, this.buffer, this.bufferIndex, this.bufferLeft);
                this.processBuffer(this.buffer, 0, this.buffer.length, null, 0);
                this.bufferIndex = 0;
                this.bufferLeft = 64;
                continue;
            }
            System.arraycopy(byArray, i + n, this.buffer, this.bufferIndex, n2 - i);
            this.bufferIndex += n2 - i;
            this.bufferLeft = 64 - this.bufferIndex;
            i = n2;
            break;
        }
    }

    public void init() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = 0;
        this.buffer = new byte[64];
        this.bufferIndex = 0;
        this.bufferLeft = 64;
    }

    private static void lsbf(int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        do {
            byArray[n2 + n4] = (byte)(n >>> n4 * 8);
        } while (++n4 < n3);
    }

    private static int lsbf(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    static int lsbf(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        do {
            n4 |= (byArray[n + n3] & 0xFF) << n3 * 8;
        } while (++n3 < n2);
        return n4;
    }

    void processBuffer(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = this.state[0];
        int n5 = this.state[1];
        int n6 = this.state[2];
        int n7 = this.state[3];
        int[] nArray = new int[16];
        int n8 = n2 / 4;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            int n9;
            int n10 = 0;
            while (n10 < 16 && n8 > 0) {
                nArray[n10++] = MD5.lsbf(byArray, n);
                --n8;
                n += 4;
            }
            if (n10 < 16) {
                if (byArray2 == null) break;
                if (!bl2) {
                    n9 = n2 % 4;
                    int n11 = nArray[n10++] = n9 != 0 ? MD5.lsbf(byArray, n, n9) | 128 << n9 * 8 : 128;
                    if (n10 == 15) {
                        nArray[15] = 0;
                    }
                    bl2 = true;
                }
                if (n10 <= 14) {
                    while (n10 < 14) {
                        nArray[n10++] = 0;
                    }
                    if (this.state != null) {
                        n2 += this.state[4];
                    }
                    nArray[14] = n2 << 3;
                    nArray[15] = n2 >>> 29;
                    bl = true;
                }
            }
            n9 = n4;
            n4 = MD5.FF(n9, n5, n6, n7, nArray[0], 7, -680876936);
            int n12 = n7;
            n7 = MD5.FF(n12, n4, n5, n6, nArray[1], 12, -389564586);
            int n13 = n6;
            n6 = MD5.FF(n13, n7, n4, n5, nArray[2], 17, 606105819);
            int n14 = n5;
            n5 = MD5.FF(n14, n6, n7, n4, nArray[3], 22, -1044525330);
            n4 = MD5.FF(n4, n5, n6, n7, nArray[4], 7, -176418897);
            n7 = MD5.FF(n7, n4, n5, n6, nArray[5], 12, 1200080426);
            n6 = MD5.FF(n6, n7, n4, n5, nArray[6], 17, -1473231341);
            n5 = MD5.FF(n5, n6, n7, n4, nArray[7], 22, -45705983);
            n4 = MD5.FF(n4, n5, n6, n7, nArray[8], 7, 1770035416);
            n7 = MD5.FF(n7, n4, n5, n6, nArray[9], 12, -1958414417);
            n6 = MD5.FF(n6, n7, n4, n5, nArray[10], 17, -42063);
            n5 = MD5.FF(n5, n6, n7, n4, nArray[11], 22, -1990404162);
            n4 = MD5.FF(n4, n5, n6, n7, nArray[12], 7, 1804603682);
            n7 = MD5.FF(n7, n4, n5, n6, nArray[13], 12, -40341101);
            n6 = MD5.FF(n6, n7, n4, n5, nArray[14], 17, -1502002290);
            n5 = MD5.FF(n5, n6, n7, n4, nArray[15], 22, 1236535329);
            n4 = MD5.GG(n4, n5, n6, n7, nArray[1], 5, -165796510);
            n7 = MD5.GG(n7, n4, n5, n6, nArray[6], 9, -1069501632);
            n6 = MD5.GG(n6, n7, n4, n5, nArray[11], 14, 643717713);
            n5 = MD5.GG(n5, n6, n7, n4, nArray[0], 20, -373897302);
            n4 = MD5.GG(n4, n5, n6, n7, nArray[5], 5, -701558691);
            n7 = MD5.GG(n7, n4, n5, n6, nArray[10], 9, 38016083);
            n6 = MD5.GG(n6, n7, n4, n5, nArray[15], 14, -660478335);
            n5 = MD5.GG(n5, n6, n7, n4, nArray[4], 20, -405537848);
            n4 = MD5.GG(n4, n5, n6, n7, nArray[9], 5, 568446438);
            n7 = MD5.GG(n7, n4, n5, n6, nArray[14], 9, -1019803690);
            n6 = MD5.GG(n6, n7, n4, n5, nArray[3], 14, -187363961);
            n5 = MD5.GG(n5, n6, n7, n4, nArray[8], 20, 1163531501);
            n4 = MD5.GG(n4, n5, n6, n7, nArray[13], 5, -1444681467);
            n7 = MD5.GG(n7, n4, n5, n6, nArray[2], 9, -51403784);
            n6 = MD5.GG(n6, n7, n4, n5, nArray[7], 14, 1735328473);
            n5 = MD5.GG(n5, n6, n7, n4, nArray[12], 20, -1926607734);
            n4 = MD5.HH(n4, n5, n6, n7, nArray[5], 4, -378558);
            n7 = MD5.HH(n7, n4, n5, n6, nArray[8], 11, -2022574463);
            n6 = MD5.HH(n6, n7, n4, n5, nArray[11], 16, 1839030562);
            n5 = MD5.HH(n5, n6, n7, n4, nArray[14], 23, -35309556);
            n4 = MD5.HH(n4, n5, n6, n7, nArray[1], 4, -1530992060);
            n7 = MD5.HH(n7, n4, n5, n6, nArray[4], 11, 1272893353);
            n6 = MD5.HH(n6, n7, n4, n5, nArray[7], 16, -155497632);
            n5 = MD5.HH(n5, n6, n7, n4, nArray[10], 23, -1094730640);
            n4 = MD5.HH(n4, n5, n6, n7, nArray[13], 4, 681279174);
            n7 = MD5.HH(n7, n4, n5, n6, nArray[0], 11, -358537222);
            n6 = MD5.HH(n6, n7, n4, n5, nArray[3], 16, -722521979);
            n5 = MD5.HH(n5, n6, n7, n4, nArray[6], 23, 76029189);
            n4 = MD5.HH(n4, n5, n6, n7, nArray[9], 4, -640364487);
            n7 = MD5.HH(n7, n4, n5, n6, nArray[12], 11, -421815835);
            n6 = MD5.HH(n6, n7, n4, n5, nArray[15], 16, 530742520);
            n5 = MD5.HH(n5, n6, n7, n4, nArray[2], 23, -995338651);
            n4 = MD5.II(n4, n5, n6, n7, nArray[0], 6, -198630844);
            n7 = MD5.II(n7, n4, n5, n6, nArray[7], 10, 1126891415);
            n6 = MD5.II(n6, n7, n4, n5, nArray[14], 15, -1416354905);
            n5 = MD5.II(n5, n6, n7, n4, nArray[5], 21, -57434055);
            n4 = MD5.II(n4, n5, n6, n7, nArray[12], 6, 1700485571);
            n7 = MD5.II(n7, n4, n5, n6, nArray[3], 10, -1894986606);
            n6 = MD5.II(n6, n7, n4, n5, nArray[10], 15, -1051523);
            n5 = MD5.II(n5, n6, n7, n4, nArray[1], 21, -2054922799);
            n4 = MD5.II(n4, n5, n6, n7, nArray[8], 6, 1873313359);
            n7 = MD5.II(n7, n4, n5, n6, nArray[15], 10, -30611744);
            n6 = MD5.II(n6, n7, n4, n5, nArray[6], 15, -1560198380);
            n5 = MD5.II(n5, n6, n7, n4, nArray[13], 21, 1309151649);
            n4 = MD5.II(n4, n5, n6, n7, nArray[4], 6, -145523070);
            n7 = MD5.II(n7, n4, n5, n6, nArray[11], 10, -1120210379);
            n6 = MD5.II(n6, n7, n4, n5, nArray[2], 15, 718787259);
            n5 = MD5.II(n5, n6, n7, n4, nArray[9], 21, -343485551);
            n4 += n9;
            n5 += n14;
            n6 += n13;
            n7 += n12;
        }
        if (byArray2 == null) {
            this.state[0] = n4;
            this.state[1] = n5;
            this.state[2] = n6;
            this.state[3] = n7;
            this.state[4] = this.state[4] + n2;
        } else {
            MD5.lsbf(n4, byArray2, n3, 4);
            MD5.lsbf(n5, byArray2, n3 + 4, 4);
            MD5.lsbf(n6, byArray2, n3 + 8, 4);
            MD5.lsbf(n7, byArray2, n3 + 12, 4);
        }
    }
}

