/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.bootstrap;

import com.ibm.security.bootstrap.DSAPublicKeyImpl;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAKeyFactory
extends KeyFactorySpi {
    static /* synthetic */ Class class$java$security$spec$DSAPublicKeySpec;

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
                return new DSAPublicKeyImpl(dSAPublicKeySpec.getY(), dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DSAPublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + invalidKeyException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Bootstrap provider does not support Private Keys.");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof DSAPublicKey) {
                Class<?> clazz2 = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<?> clazz3 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (clazz2.isAssignableFrom(clazz)) {
                    DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
                    DSAParams dSAParams = dSAPublicKey.getParams();
                    return new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof DSAPrivateKey) {
                throw new InvalidKeySpecException("Bootstrap provider does not support Private Keys.");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof DSAPublicKey) {
                if (key instanceof DSAPublicKeyImpl) {
                    return key;
                }
                DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)this.engineGetKeySpec(key, class$java$security$spec$DSAPublicKeySpec == null ? (class$java$security$spec$DSAPublicKeySpec = DSAKeyFactory.class$("java.security.spec.DSAPublicKeySpec")) : class$java$security$spec$DSAPublicKeySpec);
                return this.engineGeneratePublic(dSAPublicKeySpec);
            }
            if (key instanceof DSAPrivateKey) {
                throw new InvalidKeyException("Bootstrap provider does not support Private Keys.");
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key: " + invalidKeySpecException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

