/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import com.ibm.security.auth.PolicyFile;
import com.ibm.security.util.Debug;
import java.io.Serializable;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.Subject;

public class SubjectDomainCombiner
implements DomainCombiner {
    private Subject subject;
    private Map cachedPDs = new WeakHashMap();
    private Set principalSet;
    private Principal[] principals;
    private static boolean checkedCacheProperty = false;
    private static boolean allowCaching = true;
    private static PermissionCollection newPerms = null;
    private static final AllPermission ALL_PERMISSION = new AllPermission();
    private static final Debug debug = Debug.getInstance("combiner", "\t[SubjectDomainCombiner]");

    public SubjectDomainCombiner(Subject subject) {
        this.subject = subject;
        if (subject.isReadOnly()) {
            this.principalSet = subject.getPrincipals();
            this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
        }
        if (!checkedCacheProperty) {
            allowCaching = this.cachePolicy();
            checkedCacheProperty = true;
        }
    }

    public Subject getSubject() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubjectFromDomainCombiner"));
        }
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectionDomain[] combine(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n;
        Object object;
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            return this.optimize(protectionDomainArray2, null);
        }
        if (debug != null) {
            if (this.subject == null) {
                debug.println("null subject");
            } else {
                object = this.subject;
                AccessController.doPrivileged(new PrivilegedAction((Subject)object){
                    private final /* synthetic */ Subject val$s;
                    {
                        this.val$s = subject;
                    }

                    public Object run() {
                        debug.println(this.val$s.toString());
                        return null;
                    }
                });
            }
            this.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        protectionDomainArray2 = this.optimize(protectionDomainArray2, null);
        protectionDomainArray = this.optimize(protectionDomainArray, protectionDomainArray2);
        if (debug != null) {
            debug.println("after optimize");
            this.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        if (protectionDomainArray == null && protectionDomainArray2 == null) {
            return null;
        }
        object = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        if (!(object instanceof PolicyFile)) {
            if (debug != null) {
                debug.println("Providing backwards compatibility for javax.security.auth.policy implementation: " + object.toString());
            }
            return this.combineJavaxPolicy(protectionDomainArray, protectionDomainArray2);
        }
        int n2 = protectionDomainArray == null ? 0 : protectionDomainArray.length;
        int n3 = protectionDomainArray2 == null ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2 + n3];
        Map map = this.cachedPDs;
        synchronized (map) {
            if (!this.subject.isReadOnly() && !this.subject.getPrincipals().equals(this.principalSet)) {
                this.principalSet = new HashSet(this.subject.getPrincipals());
                this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            n = 0;
            while (n < n2) {
                ProtectionDomain protectionDomain = protectionDomainArray[n];
                ProtectionDomain protectionDomain2 = (ProtectionDomain)this.cachedPDs.get(protectionDomain);
                if (protectionDomain2 == null) {
                    protectionDomain2 = new ProtectionDomain(protectionDomain.getCodeSource(), protectionDomain.getPermissions(), protectionDomain.getClassLoader(), this.principals);
                    this.cachedPDs.put(protectionDomain, protectionDomain2);
                }
                protectionDomainArray3[n] = protectionDomain2;
                ++n;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            n = 0;
            while (n < n2) {
                debug.println("\tupdated[" + n + "] = " + this.printDomain(protectionDomainArray3[n]));
                ++n;
            }
        }
        if (n3 > 0) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n2, n3);
        }
        protectionDomainArray3 = this.optimize(protectionDomainArray3, null);
        if (debug != null) {
            if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                n = 0;
                while (n < protectionDomainArray3.length) {
                    debug.println("newDomain " + n + ": " + this.printDomain(protectionDomainArray3[n]));
                    ++n;
                }
            }
        }
        if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
            return null;
        }
        return protectionDomainArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProtectionDomain[] combineJavaxPolicy(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!allowCaching) {
                    Policy.getPolicy().refresh();
                }
                return null;
            }
        });
        int n2 = protectionDomainArray == null ? 0 : protectionDomainArray.length;
        int n3 = protectionDomainArray2 == null ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2 + n3];
        boolean bl = false;
        Map map = this.cachedPDs;
        synchronized (map) {
            if (!this.subject.isReadOnly() && !this.subject.getPrincipals().equals(this.principalSet)) {
                this.principalSet = new HashSet(this.subject.getPrincipals());
                this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            n = 0;
            while (n < n2) {
                ProtectionDomain protectionDomain = protectionDomainArray[n];
                ProtectionDomain protectionDomain2 = (ProtectionDomain)this.cachedPDs.get(protectionDomain);
                if (protectionDomain2 == null) {
                    Serializable serializable;
                    Permissions permissions = new Permissions();
                    Enumeration enumeration = protectionDomainArray[n].getPermissions().elements();
                    while (enumeration.hasMoreElements()) {
                        serializable = enumeration.nextElement();
                        permissions.add((Permission)serializable);
                    }
                    serializable = protectionDomainArray[n].getCodeSource();
                    final Subject subject = this.subject;
                    newPerms = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction((CodeSource)serializable){
                        private final /* synthetic */ CodeSource val$finalCs;
                        {
                            this.val$finalCs = codeSource;
                        }

                        public Object run() {
                            return Policy.getPolicy().getPermissions(subject, this.val$finalCs);
                        }
                    });
                    enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return newPerms.elements();
                        }
                    });
                    while (enumeration.hasMoreElements()) {
                        Permission permission = (Permission)enumeration.nextElement();
                        if (permissions.implies(permission)) continue;
                        permissions.add(permission);
                        if (debug == null) continue;
                        debug.println("Adding perm " + permission + "\n");
                    }
                    protectionDomain2 = new ProtectionDomain((CodeSource)serializable, permissions);
                    if (allowCaching) {
                        this.cachedPDs.put(protectionDomain, protectionDomain2);
                    }
                }
                protectionDomainArray3[n] = protectionDomain2;
                ++n;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            n = 0;
            while (n < n2) {
                debug.println("\tupdated[" + n + "] = " + protectionDomainArray3[n]);
                ++n;
            }
        }
        if (n3 > 0) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n2, n3);
        }
        if (debug != null) {
            if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                n = 0;
                while (n < protectionDomainArray3.length) {
                    debug.println("newDomain " + n + ": " + protectionDomainArray3[n].toString());
                    ++n;
                }
            }
        }
        if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
            return null;
        }
        return protectionDomainArray3;
    }

    ProtectionDomain[] optimize(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        if (protectionDomainArray == null) {
            return null;
        }
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[protectionDomainArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < protectionDomainArray.length) {
            if (protectionDomainArray[n2] != null) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < n) {
                    if (protectionDomainArray3[n3] == protectionDomainArray[n2]) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    if (protectionDomainArray2 == null) {
                        protectionDomainArray3[n++] = protectionDomainArray[n2];
                    } else {
                        boolean bl2 = false;
                        int n4 = 0;
                        while (n4 < protectionDomainArray2.length) {
                            if (protectionDomainArray2[n4] == protectionDomainArray[n2]) {
                                bl2 = true;
                                break;
                            }
                            ++n4;
                        }
                        if (!bl2) {
                            protectionDomainArray3[n++] = protectionDomainArray[n2];
                        }
                    }
                }
            }
            ++n2;
        }
        if (n < protectionDomainArray.length) {
            ProtectionDomain[] protectionDomainArray4 = new ProtectionDomain[n];
            System.arraycopy(protectionDomainArray3, 0, protectionDomainArray4, 0, protectionDomainArray4.length);
            protectionDomainArray3 = protectionDomainArray4;
        }
        return protectionDomainArray3.length == 0 ? null : protectionDomainArray3;
    }

    private boolean cachePolicy() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("cache.auth.policy");
            }
        });
        if (string != null) {
            Boolean bl = new Boolean(string);
            return bl;
        }
        return true;
    }

    private void printInputDomains(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n;
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            debug.println("currentDomains null or 0 length");
        } else {
            n = 0;
            while (protectionDomainArray != null && n < protectionDomainArray.length) {
                if (protectionDomainArray[n] == null) {
                    debug.println("currentDomain " + n + ": SystemDomain");
                } else {
                    debug.println("currentDomain " + n + ": " + this.printDomain(protectionDomainArray[n]));
                }
                ++n;
            }
        }
        if (protectionDomainArray2 == null || protectionDomainArray2.length == 0) {
            debug.println("assignedDomains null or 0 length");
        } else {
            debug.println("assignedDomains = ");
            n = 0;
            while (protectionDomainArray2 != null && n < protectionDomainArray2.length) {
                if (protectionDomainArray2[n] == null) {
                    debug.println("assignedDomain " + n + ": SystemDomain");
                } else {
                    debug.println("assignedDomain " + n + ": " + this.printDomain(protectionDomainArray2[n]));
                }
                ++n;
            }
        }
    }

    private String printDomain(final ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return "null";
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return protectionDomain.toString();
            }
        });
    }
}

