/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.kerberos.ServicePermission;

final class KrbServicePermissionCollection
extends PermissionCollection
implements Serializable {
    private Vector permissions = new Vector();

    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission np = (ServicePermission)permission;
        int desired = np.getMask();
        int effective = 0;
        int needed = desired;
        Enumeration e = this.permissions.elements();
        while (e.hasMoreElements()) {
            ServicePermission x = (ServicePermission)e.nextElement();
            if ((needed & x.getMask()) == 0 || !x.impliesIgnoreMask(np)) continue;
            if (((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            needed = desired ^ effective;
        }
        return false;
    }

    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.permissions.add(0, permission);
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

