/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import com.ibm.security.util.Debug;
import com.ibm.security.util.ResourcesMgr;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;

public class LoginContext {
    private static final String INIT_METHOD = "initialize";
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private boolean loginSucceeded = false;
    private CallbackHandler callbackHandler;
    private Map state = new HashMap();
    private Configuration config;
    private ModuleInfo[] moduleStack;
    private ClassLoader contextClassLoader = null;
    private static final Class[] PARAMS = new Class[0];
    private static final Debug debug = Debug.getInstance("logincontext", "\t[LoginContext]");

    private void init(String string) throws LoginException {
        AppConfigurationEntry[] appConfigurationEntryArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("createLoginContext." + string));
        }
        if (string == null) {
            throw new LoginException(ResourcesMgr.getString("Invalid null input: name"));
        }
        if (this.config == null) {
            this.config = (Configuration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Configuration.getConfiguration();
                }
            });
        }
        if ((appConfigurationEntryArray = this.config.getAppConfigurationEntry(string)) == null) {
            if (securityManager != null) {
                securityManager.checkPermission(new AuthPermission("createLoginContext.other"));
            }
            if ((appConfigurationEntryArray = this.config.getAppConfigurationEntry(OTHER)) == null) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("No LoginModules configured for name"));
                Object[] objectArray = new Object[]{string};
                throw new LoginException(messageFormat.format(objectArray));
            }
        }
        this.moduleStack = new ModuleInfo[appConfigurationEntryArray.length];
        int n = 0;
        while (n < appConfigurationEntryArray.length) {
            this.moduleStack[n] = new ModuleInfo(new AppConfigurationEntry(appConfigurationEntryArray[n].getLoginModuleName(), appConfigurationEntryArray[n].getControlFlag(), appConfigurationEntryArray[n].getOptions()), null);
            ++n;
        }
        this.contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private void loadDefaultCallbackHandler() throws LoginException {
        try {
            final ClassLoader classLoader = this.contextClassLoader;
            this.callbackHandler = (CallbackHandler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string = Security.getProperty(LoginContext.DEFAULT_HANDLER);
                    if (string == null || string.length() == 0) {
                        return null;
                    }
                    Class<?> clazz = Class.forName(string, true, classLoader);
                    return clazz.newInstance();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new LoginException(privilegedActionException.getException().toString());
        }
        if (this.callbackHandler != null) {
            this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), this.callbackHandler);
        }
    }

    public LoginContext(String string) throws LoginException {
        this.init(string);
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String string, Subject subject) throws LoginException {
        this.init(string);
        if (subject == null) {
            throw new LoginException(ResourcesMgr.getString("invalid null Subject provided"));
        }
        this.subject = subject;
        this.subjectProvided = true;
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        this.init(string);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid null CallbackHandler provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(string, subject);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid null CallbackHandler provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login() throws LoginException {
        this.loginSucceeded = false;
        LoginContext loginContext = this;
        synchronized (loginContext) {
            if (this.subject == null) {
                this.subject = new Subject();
            }
        }
        try {
            this.invokeModule(LOGIN_METHOD);
            this.invokeModule(COMMIT_METHOD);
            this.loginSucceeded = true;
        }
        catch (LoginException loginException) {
            try {
                this.invokeModule(ABORT_METHOD);
            }
            catch (LoginException loginException2) {
                throw loginException;
            }
            throw loginException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws LoginException {
        LoginContext loginContext = this;
        synchronized (loginContext) {
            if (this.subject == null) {
                throw new LoginException(ResourcesMgr.getString("null subject - logout called before login"));
            }
        }
        this.invokeModule(LOGOUT_METHOD);
    }

    public Subject getSubject() {
        if (!this.loginSucceeded && !this.subjectProvided) {
            return null;
        }
        return this.subject;
    }

    private void throwException(LoginException loginException, LoginException loginException2) throws LoginException {
        LoginException loginException3 = loginException != null ? loginException : loginException2;
        throw loginException3;
    }

    private void invokeModule(String string) throws LoginException {
        try {
            final String string2 = string;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws LoginException {
                    LoginContext.this.invoke(string2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (LoginException)privilegedActionException.getException();
        }
    }

    private void invoke(String string) throws LoginException {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        boolean bl = false;
        int n = 0;
        while (n < this.moduleStack.length) {
            block34: {
                Object[] objectArray3;
                Object object;
                Method[] methodArray;
                try {
                    int n2 = 0;
                    methodArray = null;
                    if (this.moduleStack[n].module != null) {
                        methodArray = this.moduleStack[n].module.getClass().getMethods();
                    } else {
                        object = Class.forName(this.moduleStack[n].entry.getLoginModuleName(), true, this.contextClassLoader);
                        Constructor constructor = ((Class)object).getConstructor(PARAMS);
                        Object[] objectArray4 = new Object[]{};
                        this.moduleStack[n].module = constructor.newInstance(objectArray4);
                        methodArray = this.moduleStack[n].module.getClass().getMethods();
                        n2 = 0;
                        while (n2 < methodArray.length) {
                            if (methodArray[n2].getName().equals(INIT_METHOD)) break;
                            ++n2;
                        }
                        objectArray3 = new Object[]{this.subject, this.callbackHandler, this.state, this.moduleStack[n].entry.getOptions()};
                        methodArray[n2].invoke(this.moduleStack[n].module, objectArray3);
                    }
                    n2 = 0;
                    while (n2 < methodArray.length) {
                        if (methodArray[n2].getName().equals(string)) break;
                        ++n2;
                    }
                    object = new Object[]{};
                    boolean bl2 = (Boolean)methodArray[n2].invoke(this.moduleStack[n].module, (Object[])object);
                    if (bl2) {
                        if (!string.equals(ABORT_METHOD) && !string.equals(LOGOUT_METHOD) && this.moduleStack[n].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && objectArray2 == null) {
                            if (debug != null) {
                                debug.println(string + " SUFFICIENT success");
                            }
                            return;
                        }
                        if (debug != null) {
                            debug.println(string + " success");
                        }
                        bl = true;
                    } else if (debug != null) {
                        debug.println(string + " ignored");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    methodArray = new MessageFormat(ResourcesMgr.getString("unable to instantiate LoginModule, module, because it does not provide a no-argument constructor"));
                    object = new Object[]{this.moduleStack[n].entry.getLoginModuleName()};
                    throw new LoginException(methodArray.format(object));
                }
                catch (InstantiationException instantiationException) {
                    throw new LoginException(ResourcesMgr.getString("unable to instantiate LoginModule: ") + instantiationException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new LoginException(ResourcesMgr.getString("unable to find LoginModule class: ") + classNotFoundException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LoginException(ResourcesMgr.getString("unable to access LoginModule: ") + illegalAccessException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof LoginException) {
                        objectArray3 = (Object[])invocationTargetException.getCause();
                    } else {
                        StringWriter stringWriter = new StringWriter();
                        invocationTargetException.getCause().printStackTrace(new PrintWriter(stringWriter));
                        stringWriter.flush();
                        objectArray3 = new LoginException(stringWriter.toString());
                    }
                    if (this.moduleStack[n].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                        if (debug != null) {
                            debug.println(string + " REQUISITE failure");
                        }
                        if (string.equals(ABORT_METHOD) || string.equals(LOGOUT_METHOD)) {
                            if (objectArray2 == null) {
                                objectArray2 = objectArray3;
                            }
                        } else {
                            this.throwException((LoginException)objectArray2, (LoginException)objectArray3);
                        }
                    }
                    if (this.moduleStack[n].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                        if (debug != null) {
                            debug.println(string + " REQUIRED failure");
                        }
                        if (objectArray2 == null) {
                            objectArray2 = objectArray3;
                        }
                    }
                    if (debug != null) {
                        debug.println(string + " OPTIONAL failure");
                    }
                    if (objectArray != null) break block34;
                    objectArray = objectArray3;
                }
            }
            ++n;
        }
        if (objectArray2 != null) {
            this.throwException((LoginException)objectArray2, null);
        } else if (!bl && objectArray != null) {
            this.throwException((LoginException)objectArray, null);
        } else if (!bl) {
            this.throwException(new LoginException(ResourcesMgr.getString("Login Failure: all modules ignored")), null);
        } else {
            return;
        }
    }

    private static class ModuleInfo {
        AppConfigurationEntry entry;
        Object module;

        ModuleInfo(AppConfigurationEntry appConfigurationEntry, Object object) {
            this.entry = appConfigurationEntry;
            this.module = object;
        }
    }

    private class SecureCallbackHandler
    implements CallbackHandler {
        private final AccessControlContext acc;
        private final CallbackHandler ch;

        SecureCallbackHandler(AccessControlContext accessControlContext, CallbackHandler callbackHandler) {
            this.acc = accessControlContext;
            this.ch = callbackHandler;
        }

        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            try {
                Callback[] callbackArray2 = callbackArray;
                AccessController.doPrivileged(new PrivilegedExceptionAction(this, callbackArray2){
                    private final /* synthetic */ Callback[] val$finalCallbacks;
                    private final /* synthetic */ SecureCallbackHandler this$1;
                    {
                        this.this$1 = secureCallbackHandler;
                        this.val$finalCallbacks = callbackArray;
                    }

                    public Object run() throws IOException, UnsupportedCallbackException {
                        SecureCallbackHandler.access$100(this.this$1).handle(this.val$finalCallbacks);
                        return null;
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                throw (UnsupportedCallbackException)privilegedActionException.getException();
            }
        }

        static /* synthetic */ CallbackHandler access$100(SecureCallbackHandler secureCallbackHandler) {
            return secureCallbackHandler.ch;
        }
    }
}

