/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.Permission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.security.util.ResourcesMgr;

class SelfPermission
extends Permission {
    static final long serialVersionUID = -8315562579967246806L;
    private String type;
    private String name;
    private String actions;
    private Certificate[] certs;

    public SelfPermission(String string, String string2, String string3, Certificate[] certificateArray) {
        super(string);
        if (string == null) {
            throw new NullPointerException(ResourcesMgr.getString("type can't be null"));
        }
        this.type = string;
        this.name = string2;
        this.actions = string3;
        if (certificateArray != null) {
            int n = 0;
            while (n < certificateArray.length) {
                if (!(certificateArray[n] instanceof X509Certificate)) {
                    this.certs = (Certificate[])certificateArray.clone();
                    break;
                }
                ++n;
            }
            if (this.certs == null) {
                int n2 = 0;
                int n3 = 0;
                while (n2 < certificateArray.length) {
                    ++n3;
                    while (n2 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n2]).getIssuerDN().equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                        ++n2;
                    }
                    ++n2;
                }
                if (n3 == certificateArray.length) {
                    this.certs = (Certificate[])certificateArray.clone();
                }
                if (this.certs == null) {
                    ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
                    n2 = 0;
                    while (n2 < certificateArray.length) {
                        arrayList.add(certificateArray[n2]);
                        while (n2 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n2]).getIssuerDN().equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                            ++n2;
                        }
                        ++n2;
                    }
                    this.certs = new Certificate[arrayList.size()];
                    arrayList.toArray(this.certs);
                }
            }
        }
    }

    public boolean implies(Permission permission) {
        return false;
    }

    public boolean equals(Object object) {
        int n;
        boolean bl;
        if (object == this) {
            return true;
        }
        if (!(object instanceof SelfPermission)) {
            return false;
        }
        SelfPermission selfPermission = (SelfPermission)object;
        if (!(this.type.equals(selfPermission.type) && this.name.equals(selfPermission.name) && this.actions.equals(selfPermission.actions))) {
            return false;
        }
        if (this.certs.length != selfPermission.certs.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.certs.length) {
            bl = false;
            n = 0;
            while (n < selfPermission.certs.length) {
                if (this.certs[n2].equals(selfPermission.certs[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < selfPermission.certs.length) {
            bl = false;
            n = 0;
            while (n < this.certs.length) {
                if (selfPermission.certs[n2].equals(this.certs[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        if (this.name != null) {
            n ^= this.name.hashCode();
        }
        if (this.actions != null) {
            n ^= this.actions.hashCode();
        }
        return n;
    }

    public String getActions() {
        return "";
    }

    public String getSelfType() {
        return this.type;
    }

    public String getSelfName() {
        return this.name;
    }

    public String getSelfActions() {
        return this.actions;
    }

    public Certificate[] getCerts() {
        return this.certs;
    }

    public String toString() {
        return "(SelfPermission " + this.type + " " + this.name + " " + this.actions + ")";
    }
}

