/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidKeyException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

final class PKCS11Cipher {
    private boolean decrypting = false;
    private PKCS11Session session;
    private PKCS11Object key;
    private int mechanism;
    private int blocksize = 0;
    private boolean isWrap;
    private boolean isUpdate = false;
    private byte[] param = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher";

    protected PKCS11Cipher(int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS11Cipher", (Object)(" " + n));
        }
        this.mechanism = n;
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "PKCS11Cipher");
        }
    }

    protected void engineInit(int n, PKCS11Object pKCS11Object, byte[] byArray, int n2) throws InvalidKeyException {
        if (debug != null) {
            Object[] objectArray = new Object[]{new Integer(n), pKCS11Object, byArray};
            debug.entry(16384L, (Object)className, "engineInit", objectArray);
        }
        this.isUpdate = false;
        if (pKCS11Object == null) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("No key given"));
                debug.exit(16384L, (Object)className, "engineInit");
            }
            throw new InvalidKeyException("No key given");
        }
        this.decrypting = n == 2 || n == 4;
        this.isWrap = n == 4 || n == 3;
        this.param = byArray;
        this.key = pKCS11Object;
        this.blocksize = n2;
        if (this.decrypting && !this.isWrap) {
            this.session.decryptInit(this.mechanism, (Object)byArray, pKCS11Object);
        } else if (!this.decrypting && !this.isWrap) {
            this.session.encryptInit(this.mechanism, (Object)byArray, pKCS11Object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        int n3 = 0;
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2)};
            debug.entry(16384L, (Object)className, "engineUpdate", objectArray);
        }
        if (this.isWrap) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new IllegalStateException("This can not be called for (un)wrapping keys");
        }
        this.isUpdate = true;
        byArray2 = new byte[n2 + this.blocksize];
        try {
            n3 = this.decrypting ? this.session.decryptUpdate(byArray, n, n2, byArray2, 0) : this.session.encryptUpdate(byArray, n, n2, byArray2, 0);
            if (n3 > byArray2.length) {
                throw new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size.");
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            int n4 = pKCS11Exception.getCode();
            if (n4 == 336) {
                byArray2 = new byte[n3];
                n3 = this.decrypting ? this.session.decryptUpdate(byArray, n, n2, byArray2, 0) : this.session.encryptUpdate(byArray, n, n2, byArray2, 0);
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_2", (Throwable)new PKCS11Exception(n4));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new PKCS11Exception(n4);
        }
        if (n3 < byArray2.length) {
            byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
        } else {
            byArray3 = byArray2;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return byArray3;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4 = 0;
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2), byArray2, new Integer(n3)};
            debug.entry(16384L, (Object)className, "engineUpdate", objectArray);
        }
        if (this.isWrap) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new IllegalStateException("This can not be called for (un)wrapping keys");
        }
        if (byArray2 == null || byArray2.length - n3 < n2) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_2", (Throwable)new ShortBufferException("Output buffer must be (at least) " + n2 + " bytes long"));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new ShortBufferException("Output buffer must be (at least) " + n2 + " bytes long");
        }
        this.isUpdate = true;
        try {
            n4 = this.decrypting ? this.session.decryptUpdate(byArray, n, n2, byArray2, n3) : this.session.encryptUpdate(byArray, n, n2, byArray2, n3);
        }
        catch (PKCS11Exception pKCS11Exception) {
            int n5 = pKCS11Exception.getCode();
            if (n5 == 336) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineUpdate_3", (Throwable)new ShortBufferException("Output buffer must be (at least) " + n4 + " bytes long"));
                    debug.exit(16384L, (Object)className, "engineUpdate");
                }
                throw new ShortBufferException("Output buffer must be (at least) " + n4 + " bytes long");
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_4", (Throwable)new PKCS11Exception(n5));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new PKCS11Exception(n5);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return n4;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3;
        int n4;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        block34: {
            byArray4 = null;
            byArray3 = null;
            byArray2 = null;
            n4 = 0;
            n3 = 0;
            if (debug != null) {
                Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2)};
                debug.entry(16384L, (Object)className, "engineDoFinal", objectArray);
            }
            if (this.isWrap) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineDoFinal_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                    debug.exit(16384L, (Object)className, "engineDoFinal");
                }
                throw new IllegalStateException("This can not be called for (un)wrapping keys");
            }
            byArray4 = new byte[n2 + this.blocksize];
            if (this.isUpdate) {
                int n5;
                try {
                    if (n2 > 0 && (n4 = this.decrypting ? this.session.decryptUpdate(byArray, n, n2, byArray4, 0) : this.session.encryptUpdate(byArray, n, n2, byArray4, 0)) > byArray4.length) {
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineDoFinal_2", (Throwable)new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size."));
                            debug.exit(16384L, (Object)className, "engineDoFinal");
                        }
                        throw new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size.");
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    n5 = pKCS11Exception.getCode();
                    if (n5 == 336) {
                        byArray4 = new byte[n4];
                        try {
                            n4 = this.decrypting ? this.session.decryptUpdate(byArray, n, n2, byArray4, 0) : this.session.encryptUpdate(byArray, n, n2, byArray4, 0);
                        }
                        catch (PKCS11Exception pKCS11Exception2) {
                            n5 = pKCS11Exception2.getCode();
                            if (debug != null) {
                                debug.exception(16384L, (Object)className, "engineDoFinal_3", (Throwable)new PKCS11Exception(n5));
                                debug.exit(16384L, (Object)className, "engineDoFinal");
                            }
                            throw new PKCS11Exception(n5);
                        }
                    }
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineDoFinal_4", (Throwable)new PKCS11Exception(n5));
                        debug.exit(16384L, (Object)className, "engineDoFinal");
                    }
                    throw new PKCS11Exception(n5);
                }
                byArray3 = new byte[n2 + this.blocksize];
                try {
                    n3 = this.decrypting ? this.session.decryptFinal(byArray3, 0) : this.session.encryptFinal(byArray3, 0);
                    if (n3 > byArray3.length) {
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineDoFinal_5", (Throwable)new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size."));
                            debug.exit(16384L, (Object)className, "engineDoFinal");
                        }
                        throw new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size.");
                    }
                    break block34;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    n5 = pKCS11Exception.getCode();
                    if (n5 == 336) {
                        byArray3 = new byte[n3];
                        try {
                            n3 = this.decrypting ? this.session.decryptFinal(byArray3, 0) : this.session.encryptFinal(byArray3, 0);
                            break block34;
                        }
                        catch (PKCS11Exception pKCS11Exception3) {
                            n5 = pKCS11Exception3.getCode();
                            if (debug != null) {
                                debug.exception(16384L, (Object)className, "engineDoFinal_6", (Throwable)new PKCS11Exception(n5));
                                debug.exit(16384L, (Object)className, "engineDoFinal");
                            }
                            throw new PKCS11Exception(n5);
                        }
                    }
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineDoFinal_7", (Throwable)new PKCS11Exception(n5));
                        debug.exit(16384L, (Object)className, "engineDoFinal");
                    }
                    throw new PKCS11Exception(n5);
                }
            }
            try {
                n4 = this.decrypting ? this.session.decrypt(byArray, n, n2, byArray4, 0) : this.session.encrypt(byArray, n, n2, byArray4, 0);
                if (n4 > byArray4.length) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineDoFinal_8", (Throwable)new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size."));
                        debug.exit(16384L, (Object)className, "engineDoFinal");
                    }
                    throw new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size.");
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                int n6 = pKCS11Exception.getCode();
                if (n6 == 336) {
                    byArray4 = new byte[n4];
                    try {
                        n4 = this.decrypting ? this.session.decrypt(byArray, n, n2, byArray4, 0) : this.session.encrypt(byArray, n, n2, byArray4, 0);
                    }
                    catch (PKCS11Exception pKCS11Exception4) {
                        n6 = pKCS11Exception4.getCode();
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineDoFinal_9", (Throwable)new PKCS11Exception(n6));
                            debug.exit(16384L, (Object)className, "engineDoFinal");
                        }
                        throw new PKCS11Exception(n6);
                    }
                }
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineDoFinal_10", (Throwable)new PKCS11Exception(n6));
                    debug.exit(16384L, (Object)className, "engineDoFinal");
                }
                throw new PKCS11Exception(n6);
            }
            catch (Exception exception) {
                System.out.println("here: " + exception.getMessage());
            }
        }
        byArray2 = new byte[n4 + n3];
        System.arraycopy(byArray4, 0, byArray2, 0, n4);
        if (n3 > 0) {
            System.arraycopy(byArray3, 0, byArray2, n4, n3);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int n4 = 0;
        int n5 = 0;
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2), byArray2, new Integer(n3)};
            debug.entry(16384L, (Object)className, "engineDoFinal", objectArray);
        }
        if (this.isWrap) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineDoFinal_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                debug.exit(16384L, (Object)className, "engineDoFinal");
            }
            throw new IllegalStateException("This can not be called for (un)wrapping keys");
        }
        if (this.isUpdate) {
            n4 = this.decrypting ? this.session.decryptUpdate(byArray, n, n2, byArray2, n3) : this.session.encryptUpdate(byArray, n, n2, byArray2, n3);
            if (n4 > byArray2.length - n3) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineDoFinal_2", (Throwable)new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size."));
                    debug.exit(16384L, (Object)className, "engineDoFinal");
                }
                throw new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size.");
            }
            n5 = this.decrypting ? this.session.decryptFinal(byArray2, n3 + n4) : this.session.encryptFinal(byArray2, n3 + n4);
            if (n5 + n4 > byArray2.length - n3) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineDoFinal_3", (Throwable)new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size."));
                    debug.exit(16384L, (Object)className, "engineDoFinal");
                }
                throw new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size.");
            }
        } else {
            n4 = this.decrypting ? this.session.decrypt(byArray, n, n2, byArray2, n3) : this.session.encrypt(byArray, n, n2, byArray2, n3);
            if (n4 > byArray2.length - n3) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineDoFinal_4", (Throwable)new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size."));
                    debug.exit(16384L, (Object)className, "engineDoFinal");
                }
                throw new IllegalStateException("This card does not support the BUFFER_TOO SMALL exception used to determine the needed output buffer size.");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return n4 + n5;
    }

    protected byte[] engineWrap(PKCS11Object pKCS11Object, int n) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = new byte[n];
        byte[] byArray2 = null;
        int n2 = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineWrap");
        }
        try {
            n2 = this.session.wrapKey(this.mechanism, (Object)this.param, this.key, pKCS11Object, byArray, 0);
        }
        catch (PKCS11Exception pKCS11Exception) {
            int n3 = pKCS11Exception.getCode();
            if (n3 == 336) {
                byArray = new byte[n2];
                try {
                    n2 = this.session.wrapKey(this.mechanism, (Object)this.param, this.key, pKCS11Object, byArray, 0);
                }
                catch (PKCS11Exception pKCS11Exception2) {
                    int n4 = pKCS11Exception2.getCode();
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineWrap_1", (Throwable)new PKCS11Exception(n4));
                        debug.exit(16384L, (Object)className, "engineWrap");
                    }
                    throw new PKCS11Exception(n4);
                }
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineWrap_2", (Throwable)new PKCS11Exception(n3));
                debug.exit(16384L, (Object)className, "engineWrap");
            }
            throw new PKCS11Exception(n3);
        }
        byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineWrap");
        }
        return byArray2;
    }

    protected PKCS11Object engineUnwrap(byte[] byArray, int[] nArray, Object[] objectArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUnwrap");
        }
        PKCS11Object pKCS11Object = this.session.unwrapKey(this.mechanism, (Object)this.param, this.key, byArray, 0, byArray.length, nArray, objectArray);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUnwrap");
        }
        return pKCS11Object;
    }
}

