/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.Elf;
import com.ibm.jvm.dump.extract.ElfType;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.ExThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.frame.ThreadContext;
import com.ibm.jvm.dump.sdff.DvFileReader;
import java.io.IOException;
import java.util.HashMap;

class ElfLkp
extends ElfType {
    int signal;
    LwpStatus lwp;
    static final int CF_T_PRSTATUS = 10;
    static final int CF_T_FPREGS = 12;
    static final int CF_T_PRPSINFO = 13;
    static final int CF_T_PRCRED = 14;
    static final int CF_T_UTSNAME = 15;
    static final int CF_T_LWPSTATUS = 16;
    static final int CF_T_LWPSINFO = 17;
    static final String[] regName = new String[]{"gs      ", "fs      ", "es      ", "ds      ", "edi     ", "esi     ", "ebp     ", "dummy   ", "ebx     ", "edx     ", "ecx     ", "eax     ", "dummy   ", "dummy   ", "eip     ", "cs      ", "efl     ", "esp     ", "ss      "};

    ElfLkp(Elf elf) {
        super(elf);
    }

    void readNote(int n, long l) throws IOException {
        switch (n) {
            case 10: {
                if (this.process != null) {
                    System.err.println("JVMRAS008: Ignoring unexpected duplicate CF_T_PRSTATUS section.");
                    break;
                }
                this.process = new PStatus();
                break;
            }
            case 13: {
                if (this.process == null) {
                    System.err.println("JVMRAS009: Ignoring CF_T_PSRPINFO section found before CF_T_PRSTATUS section.");
                    break;
                }
                new PsInfo(this.process);
                break;
            }
            case 16: {
                this.lwp = new LwpStatus();
                this.process.thread.add(this.lwp);
                break;
            }
            case 17: {
                if (this.lwp == null) break;
                new LwpInfo(this.lwp);
                break;
            }
            case 14: {
                this.reader.setPos(l);
                break;
            }
            case 15: {
                new PlatformData();
                break;
            }
            default: {
                System.err.println("JVMRAS010: Unexpected note type " + n + " found in " + "core file - ignored.");
                this.reader.setPos(l);
            }
        }
    }

    class MContext {
        MContext(ExThread exThread) throws IOException {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            int n = 0;
            while (n < regName.length) {
                long l = ElfLkp.this.reader.readWord();
                DvUtils.trace(regName[n] + Long.toHexString(l), 2, false);
                if (!regName[n].startsWith("dummy")) {
                    hashMap.put(regName[n], new Long(l));
                }
                ++n;
            }
            long l = (Long)hashMap.get("esp     ");
            long l2 = (Long)hashMap.get("eip     ");
            long l3 = (Long)hashMap.get("ebp     ");
            long l4 = 0L;
            exThread.context = new ThreadContext(0L, l2, l4, l, l3);
            byte[] byArray = new byte[380];
            ElfLkp.this.reader.read(byArray);
            exThread.register.setSpecial(hashMap, 4);
        }
    }

    class UContext {
        UContext(ExThread exThread) throws IOException {
            long l = ElfLkp.this.reader.readWord();
            long l2 = ElfLkp.this.reader.readAddress();
            byte[] byArray = new byte[16];
            ElfLkp.this.reader.read(byArray);
            byte[] byArray2 = new byte[12];
            ElfLkp.this.reader.read(byArray2);
            new MContext(exThread);
            long l3 = ElfLkp.this.reader.readAddress();
            long l4 = ElfLkp.this.reader.readAddress();
            byte[] byArray3 = new byte[12];
            ElfLkp.this.reader.read(byArray3);
        }
    }

    class LwpInfo {
        LwpInfo(LwpStatus lwpStatus) throws IOException {
            long l = ElfLkp.this.reader.readWord();
            long l2 = ElfLkp.this.reader.readWord();
            long l3 = ElfLkp.this.reader.readAddress();
            long l4 = ElfLkp.this.reader.readAddress();
            long l5 = ElfLkp.this.reader.readByte();
            long l6 = ElfLkp.this.reader.readByte();
            long l7 = ElfLkp.this.reader.readByte();
            long l8 = ElfLkp.this.reader.readByte();
            long l9 = ElfLkp.this.reader.readWord();
            long l10 = ElfLkp.this.reader.readWord();
            long l11 = ElfLkp.this.reader.readWord();
            long l12 = ElfLkp.this.reader.readLong();
            String string = ElfLkp.this.reader.readString(16);
            long l13 = ElfLkp.this.reader.readWord();
            long l14 = ElfLkp.this.reader.readWord();
            long l15 = ElfLkp.this.reader.readWord();
            long l16 = ElfLkp.this.reader.readWord();
            byte[] byArray = new byte[7];
            ElfLkp.this.reader.read(byArray);
            DvUtils.trace("flags = " + Long.toHexString(l), 2, false);
            DvUtils.trace("lwpid = " + Long.toHexString(l2), 2, false);
            DvUtils.trace("address = " + Long.toHexString(l3), 2, false);
            DvUtils.trace("channel = " + Long.toHexString(l4), 2, false);
            DvUtils.trace("sync = " + Long.toHexString(l5), 2, false);
            DvUtils.trace("state = " + Long.toHexString(l6), 2, false);
            DvUtils.trace("sname = " + Long.toHexString(l7), 2, false);
            DvUtils.trace("nice = " + Long.toHexString(l8), 2, false);
            DvUtils.trace("priority = " + Long.toHexString(l9), 2, false);
            DvUtils.trace("lwptime = " + Long.toHexString(l10), 2, false);
            DvUtils.trace("schedulingclass = " + Long.toHexString(l12), 2, false);
            DvUtils.trace("processorRun = " + Long.toHexString(l13), 2, false);
            DvUtils.trace("processorBound = " + Long.toHexString(l14), 2, false);
            DvUtils.trace("processorExBound = " + Long.toHexString(l15), 2, false);
            DvUtils.trace("cgHome = " + Long.toHexString(l16), 2, false);
        }
    }

    class LwpStatus
    extends ExThread {
        LwpStatus() throws IOException {
            DvFileReader dvFileReader = ElfLkp.this.elf.reader;
            long l = dvFileReader.readWord();
            long l2 = dvFileReader.readHalf();
            long l3 = dvFileReader.readHalf();
            long l4 = dvFileReader.readWord();
            long l5 = dvFileReader.readHalf();
            dvFileReader.readHalf();
            byte[] byArray = new byte[16];
            dvFileReader.read(byArray);
            byte[] byArray2 = new byte[128];
            dvFileReader.read(byArray2);
            byte[] byArray3 = new byte[12];
            dvFileReader.read(byArray3);
            byte[] byArray4 = new byte[32];
            dvFileReader.read(byArray4);
            long l6 = dvFileReader.readHalf();
            long l7 = dvFileReader.readHalf();
            byte[] byArray5 = new byte[32];
            dvFileReader.read(byArray5);
            long l8 = dvFileReader.readLong();
            long l9 = dvFileReader.readWord();
            new UContext(this);
            byte[] byArray6 = new byte[100];
            dvFileReader.read(byArray6);
            byte[] byArray7 = new byte[32];
            dvFileReader.read(byArray7);
            byte[] byArray8 = new byte[528];
            dvFileReader.read(byArray8);
            DvUtils.trace("flags = " + Long.toHexString(l), 2, false);
            DvUtils.trace("lwpid = " + Long.toHexString(l4), 2, false);
            DvUtils.trace("why = " + Long.toHexString(l2), 2, false);
            DvUtils.trace("what = " + Long.toHexString(l3), 2, false);
            DvUtils.trace("cursig = " + Long.toHexString(l5), 2, false);
            DvUtils.trace("syscall = " + Long.toHexString(l6), 2, false);
            DvUtils.trace("nsysarg = " + Long.toHexString(l7), 2, false);
            DvUtils.trace("instr = " + Long.toHexString(l9), 2, false);
        }
    }

    class PsInfo {
        PsInfo(ExProcess exProcess) throws IOException {
            DvFileReader dvFileReader = ElfLkp.this.elf.reader;
            DvUtils.trace("Read PsInfo", 1, false);
            long l = dvFileReader.readWord();
            long l2 = dvFileReader.readWord();
            long l3 = dvFileReader.readWord();
            long l4 = dvFileReader.readWord();
            Long l5 = new Long(dvFileReader.readWord());
            long l6 = dvFileReader.readWord();
            long l7 = dvFileReader.readWord();
            long l8 = dvFileReader.readWord();
            long l9 = dvFileReader.readAddress();
            long l10 = dvFileReader.readWord();
            long l11 = dvFileReader.readWord();
            long l12 = dvFileReader.readWord();
            long l13 = dvFileReader.readWord();
            long l14 = dvFileReader.readWord();
            long l15 = dvFileReader.readWord();
            long l16 = dvFileReader.readWord();
            String string = dvFileReader.readString(16).trim();
            String string2 = dvFileReader.readString(80).trim();
            byte[] byArray = new byte[100];
            dvFileReader.read(byArray);
            exProcess.generateExecutable(string, string2);
            DvUtils.trace("flags = " + Long.toHexString(l), 2, false);
            DvUtils.trace("numLwp = " + l2, 2, false);
            DvUtils.trace("pid = " + l5, 2, false);
            DvUtils.trace("ppid = " + l6, 2, false);
            DvUtils.trace("pgid = " + Long.toHexString(l7), 2, false);
            DvUtils.trace("sid = " + Long.toHexString(l8), 2, false);
            DvUtils.trace("uid = " + l3, 2, false);
            DvUtils.trace("gid = " + l4, 2, false);
            DvUtils.trace("processAddress = " + Long.toHexString(l9), 2, false);
            DvUtils.trace("processSize = " + Long.toHexString(l10), 2, false);
            DvUtils.trace("residentSize = " + Long.toHexString(l11), 2, false);
            DvUtils.trace("tty = " + Long.toHexString(l16), 2, false);
            DvUtils.trace("startTime = " + Long.toHexString(l12), 2, false);
            DvUtils.trace("startTime_ms = " + Long.toHexString(l13), 2, false);
            DvUtils.trace("cpuTime = " + Long.toHexString(l14), 2, false);
            DvUtils.trace("cpuTime_ms = " + Long.toHexString(l15), 2, false);
        }
    }

    class PStatus
    extends ExProcess {
        PStatus() throws IOException {
            DvUtils.trace("Read PStatus", 1, false);
            long l = ElfLkp.this.reader.readWord();
            long l2 = ElfLkp.this.reader.readHalf();
            ElfLkp.this.reader.readHalf();
            byte[] byArray = new byte[16];
            ElfLkp.this.reader.read(byArray);
            long l3 = ElfLkp.this.reader.readAddress();
            long l4 = ElfLkp.this.reader.readWord();
            long l5 = ElfLkp.this.reader.readAddress();
            long l6 = ElfLkp.this.reader.readWord();
            this.pid = ElfLkp.this.reader.readWord();
            long l7 = ElfLkp.this.reader.readWord();
            long l8 = ElfLkp.this.reader.readWord();
            long l9 = ElfLkp.this.reader.readWord();
            long l10 = ElfLkp.this.reader.readWord();
            long l11 = ElfLkp.this.reader.readWord();
            long l12 = ElfLkp.this.reader.readWord();
            long l13 = ElfLkp.this.reader.readWord();
            long l14 = ElfLkp.this.reader.readWord();
            long l15 = ElfLkp.this.reader.readWord();
            long l16 = ElfLkp.this.reader.readWord();
            long l17 = ElfLkp.this.reader.readWord();
            byte[] byArray2 = new byte[16];
            ElfLkp.this.reader.read(byArray2);
            byte[] byArray3 = new byte[16];
            ElfLkp.this.reader.read(byArray3);
            byte[] byArray4 = new byte[64];
            ElfLkp.this.reader.read(byArray4);
            byte[] byArray5 = new byte[64];
            ElfLkp.this.reader.read(byArray5);
            long l18 = ElfLkp.this.reader.readLong();
            this.thread.add(new LwpStatus());
            DvUtils.trace("flags = " + Long.toHexString(l), 2, false);
            DvUtils.trace("numThreads = " + Long.toHexString(l2), 2, false);
            DvUtils.trace("pid = " + Long.toHexString(this.pid), 2, false);
            DvUtils.trace("ppid = " + Long.toHexString(l7), 2, false);
            DvUtils.trace("pgid = " + Long.toHexString(l8), 2, false);
            DvUtils.trace("sid = " + Long.toHexString(l9), 2, false);
            DvUtils.trace("sigpend = " + byArray, 2, false);
            DvUtils.trace("brkbase = " + Long.toHexString(l3), 2, false);
            DvUtils.trace("brksize = " + Long.toHexString(l4), 2, false);
            DvUtils.trace("stkbase = " + Long.toHexString(l5), 2, false);
            DvUtils.trace("stksize = " + Long.toHexString(l6), 2, false);
            DvUtils.trace("cpu = " + Long.toHexString(l10), 2, false);
            DvUtils.trace("cpu_ms = " + Long.toHexString(l11), 2, false);
            DvUtils.trace("sys = " + Long.toHexString(l12), 2, false);
            DvUtils.trace("sys_ms = " + Long.toHexString(l13), 2, false);
            DvUtils.trace("ccpu = " + Long.toHexString(l14), 2, false);
            DvUtils.trace("ccpu_ms = " + Long.toHexString(l15), 2, false);
            DvUtils.trace("csys = " + Long.toHexString(l16), 2, false);
            DvUtils.trace("csys_ms = " + Long.toHexString(l17), 2, false);
            DvUtils.trace("sigtrace = " + byArray2, 2, false);
            DvUtils.trace("sysentry = " + byArray4, 2, false);
        }
    }

    class PlatformData {
        PlatformData() throws IOException {
            DvUtils.trace("Read UTSName", 2, false);
            String string = ElfLkp.this.reader.readString(257);
            String string2 = ElfLkp.this.reader.readString(257);
            String string3 = ElfLkp.this.reader.readString(257);
            String string4 = ElfLkp.this.reader.readString(257);
            String string5 = ElfLkp.this.reader.readString(257);
            DvUtils.trace("sysname = " + string.trim(), 2, false);
            DvUtils.trace("nodeName = " + string2.trim(), 2, false);
            DvUtils.trace("release = " + string3.trim(), 2, false);
            DvUtils.trace("version = " + string4.trim(), 2, false);
            DvUtils.trace("machine = " + string5.trim(), 2, false);
        }
    }
}

