/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.ElfSegment;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.Mapper;
import com.ibm.jvm.dump.sdff.SDFFMemoryMap;
import com.ibm.jvm.dump.sdff.SDFFProcess;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.Segment;
import java.io.IOException;

class MemoryMap
extends SDFFMemoryMap
implements Mapper {
    SDFFProcess process;

    MemoryMap() {
    }

    void addSegment(DvFileReader dvFileReader, ElfSegment elfSegment) throws IOException {
        Segment segment;
        DvUtils.trace("Adding memory segment", 2, false);
        if (elfSegment.fileSize > 0L) {
            int n = 2;
            segment = new Segment("", elfSegment.address, elfSegment.length, n, dvFileReader, elfSegment.offset);
            DvUtils.trace("Data Segment", 2, false);
        } else {
            int n = 1;
            segment = new Segment("", elfSegment.address, elfSegment.length, n);
            DvUtils.trace("Text Segment", 2, false);
        }
        this.segments.add(segment);
        DvUtils.trace(Long.toHexString(elfSegment.length) + " " + Long.toHexString(elfSegment.offset) + " " + Long.toHexString(elfSegment.address) + " " + Long.toHexString(elfSegment.length), 2, false);
    }

    void addSegment(DvFileReader dvFileReader, long l, long l2, long l3, String string) throws IOException {
        DvUtils.trace("Adding memory segment", 2, false);
        this.segments.add(new Segment("", l2, l, 2, dvFileReader, l3));
        DvUtils.trace(Long.toHexString(l) + " " + Long.toHexString(l3) + " " + Long.toHexString(l2) + " " + Long.toHexString(l), 2, false);
    }

    public Segment getSegmentContaining(long l) {
        DvUtils.trace("getSegmentContaining(" + Long.toHexString(l) + ")", 2, false);
        int n = 0;
        while (n < this.segments.size()) {
            Segment segment = (Segment)this.segments.get(n);
            if (l >= segment.moduleAddress.getAddressAsLong() && l < segment.moduleAddress.getAddressAsLong() + segment.moduleSize) {
                return segment;
            }
            ++n;
        }
        throw new RuntimeException("Can't find segment containing 0x" + Long.toHexString(l));
    }

    public long getOffset(long l) {
        DvUtils.trace("getOffset(" + Long.toHexString(l) + ")", 2, false);
        Segment segment = this.getSegmentContaining(l);
        if (segment != null) {
            DvUtils.trace("Segment start=" + Long.toHexString(segment.moduleAddress.getAddressAsLong()) + " offset=" + Long.toHexString(segment.offset) + " return=" + Long.toHexString(segment.offset + l - segment.moduleAddress.getAddressAsLong()), 2, false);
            return segment.offset + l - segment.moduleAddress.getAddressAsLong();
        }
        return 0L;
    }

    Segment getSegment(long l) {
        int n = 0;
        while (n < this.segments.size()) {
            Segment segment = (Segment)this.segments.get(n);
            if (l == segment.moduleAddress.getAddressAsLong()) {
                return segment;
            }
            ++n;
        }
        return null;
    }

    void dump() {
        int n = 0;
        while (n < this.segments.size()) {
            Segment segment = (Segment)this.segments.get(n);
            DvUtils.trace("Segment " + n, 2, false);
            DvUtils.trace("\tStarts at 0x" + Long.toHexString(segment.moduleAddress.getAddressAsLong()), 2, false);
            DvUtils.trace("\tSize is 0x" + Long.toHexString(segment.moduleSize), 2, false);
            DvUtils.trace("\tOffset is 0x" + Long.toHexString(segment.offset), 2, false);
            ++n;
        }
    }

    public void printSdff(Sdff sdff) throws IOException {
        this.dump();
        super.printSdff(sdff);
    }
}

