/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class DvAddressIndexFile
extends RandomAccessFile {
    private static String file_name;
    private static IndexHeader IH;
    private static RandomAccessFile self;
    private static long[] indexArray;
    private static long next_record_pos;
    private static int index_table_size;
    private long saved_prev_position = 0L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DvAddressIndexFile(String string, String string2, int n, int n2, int n3, long l) throws IOException {
        super(string, string2);
        self = this;
        if (string2.equals("r")) {
            IH = IndexHeader.readExistingHeader();
            if (IndexHeader.magic != l) throw new IOException("Magic numbers mismatch");
            this.seek(IndexHeader.index_ptr);
            indexArray = new long[IndexHeader.index_table_size];
            int n4 = 0;
            while (n4 < IndexHeader.index_table_size) {
                DvAddressIndexFile.indexArray[n4] = this.readLong();
                ++n4;
            }
            return;
        } else {
            DvAddressIndexFile.initTheIndex(n, n2, n3, l);
        }
    }

    public boolean write(long l, short s) {
        block3: {
            long l2 = this.hashTheKey(l);
            int n = 0;
            n = (int)(l2 % (long)IndexHeader.index_table_size);
            long l3 = IndexHeader.index_ptr + (long)(8 * n);
            try {
                this.seek(l3);
                long l4 = this.readLong();
                if (-1L == l4) {
                    long l5 = this.writeNewKeyRecord(l3, l, l4);
                    this.seek(l3);
                    this.writeLong(l5);
                    break block3;
                }
                long l6 = this.writeNewKeyRecord(l3, l, l4);
                this.seek(l3);
                this.writeLong(l6);
            }
            catch (IOException iOException) {
                System.out.println("IOException " + l3 + " " + l);
            }
        }
        return true;
    }

    private long writeNewKeyRecord(long l, long l2, long l3) {
        long l4 = 0L;
        try {
            this.seek(this.length());
            long l5 = this.getFilePointer();
            this.writeByte(75);
            this.writeByte(58);
            this.writeLong(l2);
            if (-1L != l3) {
                this.writeLong(l3);
            } else {
                this.writeLong(0L);
            }
            this.writeLong(0L);
            this.writeLong(0L);
            this.writeLong(0L);
            this.writeLong(0L);
            l4 = l5;
        }
        catch (IOException iOException) {
            System.err.println("IOException in writeNewKeyRecord");
        }
        return l4;
    }

    private long writeNewDataRecord(long l, long l2, long l3) {
        long l4 = 0L;
        try {
            this.seek(this.length());
            l4 = this.getFilePointer();
            this.writeByte(79);
            this.writeByte(98);
            this.writeByte(106);
            this.writeByte(58);
            this.writeInt(1);
            this.writeLong(l);
            int n = 0;
            while (n < 8) {
                this.writeLong(0L);
                ++n;
            }
            this.seek(l2);
            this.writeLong(l4);
            if (0L != l3) {
                this.seek(l3);
                this.writeLong(l4);
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException in writeNewDataRecord");
        }
        return l4;
    }

    private static boolean initTheIndex(int n, int n2, int n3, long l) throws IOException {
        IH = new IndexHeader(n, n2, l);
        indexArray = new long[n];
        int n4 = 0;
        while (n4 < n) {
            DvAddressIndexFile.indexArray[n4] = -1L;
            ++n4;
        }
        return true;
    }

    private long hashTheKey(long l) {
        long l2 = 0L;
        l2 = l >>> 3;
        return l2 %= (long)IndexHeader.index_table_size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean checkForKnownObject(long l) {
        long l2 = this.hashTheKey(l);
        int n = (int)(l2 % (long)IndexHeader.index_table_size);
        long l3 = IndexHeader.index_ptr + (long)(8 * n);
        boolean bl = false;
        try {
            this.seek(l3);
            long l4 = this.readLong();
            while (l4 != 0L) {
                if (l4 == -1L) return bl;
                if (bl) {
                    return bl;
                }
                dataRecord dataRecord2 = new dataRecord(l4);
                if (dataRecord2.key == l) {
                    bl = true;
                    continue;
                }
                l4 = dataRecord2.prevPtr;
            }
            return bl;
        }
        catch (IOException iOException) {
            System.err.println("IOError in checkForKnownObject");
            return bl;
        }
    }

    public int sizeOfIndex() {
        return IndexHeader.index_table_size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllObjectsAtIndex(int n) {
        Vector<Long> vector = new Vector<Long>();
        long l = IndexHeader.index_ptr + (long)(8 * n);
        byte[] byArray = new byte[2];
        try {
            long l2 = l;
            this.seek(l2);
            l2 = this.readLong();
            while (l2 != 0L) {
                if (l2 == -1L) {
                    return vector;
                }
                this.seek(l2);
                this.read(byArray);
                l2 = this.readLong();
                vector.add(new Long(l2));
                l2 = this.readLong();
            }
            return vector;
        }
        catch (IOException iOException) {
            System.err.println("IOError in getAllObjectsAtIndex");
            return vector;
        }
    }

    static {
        next_record_pos = 0L;
        index_table_size = 0;
    }

    private static class dataRecord {
        byte[] eye = new byte[2];
        long key;
        long prevPtr;
        long rtoPtr;
        long lastRtoDRA;
        long rfrPtr;
        long lastRfroDRA;

        private dataRecord(long l) {
            try {
                self.seek(l);
                self.read(this.eye);
                this.key = self.readLong();
                this.prevPtr = self.readLong();
                this.rtoPtr = self.readLong();
                this.lastRtoDRA = self.readLong();
                this.rfrPtr = self.readLong();
                this.lastRfroDRA = self.readLong();
            }
            catch (IOException iOException) {
                System.err.println("IOexception in dataRecord constructor");
            }
        }
    }

    private static class IndexHeader {
        static long magic;
        static int index_table_size;
        static int record_size;
        static int key_size;
        static long index_ptr;

        private IndexHeader() {
        }

        private IndexHeader(int n, int n2, long l) throws IOException {
            magic = l;
            index_table_size = n / 256 * 256;
            record_size = n2;
            this.writeIH();
        }

        private int loadIH() {
            return 0;
        }

        private static IndexHeader readExistingHeader() throws IOException {
            IndexHeader indexHeader = new IndexHeader();
            self.seek(0L);
            magic = self.readLong();
            index_table_size = self.readInt();
            record_size = self.readInt();
            key_size = self.readInt();
            self.readInt();
            index_ptr = self.readLong();
            next_record_pos = self.length();
            return indexHeader;
        }

        private boolean writeIH() throws IOException {
            self.writeLong(magic);
            self.writeInt(index_table_size);
            System.out.println("index_table_size:" + index_table_size);
            self.writeInt(record_size);
            self.writeInt(key_size);
            self.writeInt(0);
            long l = self.getFilePointer();
            self.writeLong(0L);
            self.writeLong(0L);
            self.writeLong(0L);
            self.writeLong(0L);
            self.writeLong(0L);
            int n = 0;
            while (n < 4) {
                self.writeByte(105);
                self.writeByte(110);
                self.writeByte(100);
                self.writeByte(120);
                ++n;
            }
            index_ptr = self.getFilePointer();
            int n2 = 0;
            while (n2 < index_table_size) {
                self.writeLong(-1L);
                ++n2;
            }
            int n3 = 0;
            while (n3 < 4) {
                self.writeByte(100);
                self.writeByte(97);
                self.writeByte(116);
                self.writeByte(97);
                ++n3;
            }
            long l2 = self.getFilePointer();
            self.seek(l);
            self.writeLong(index_ptr);
            self.writeLong(l2);
            next_record_pos = l2;
            return true;
        }
    }
}

