/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.DvObject;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.CommandPluginResponse;
import java.lang.reflect.Method;
import java.util.Vector;

public class DvHeap {
    Vector subHeaps = new Vector();
    CommandPluginResponse cpr;
    public Vector theOutput = new Vector();
    public Object gui;
    Vector godV = null;
    Vector heapScanV = null;
    long totalObjectCount = 0L;
    static DvHeap selfref;
    static /* synthetic */ Class class$com$ibm$jvm$dump$format$DvHeap;
    static /* synthetic */ Class class$com$ibm$jvm$dump$format$DvObject;

    public DvHeap() {
        selfref = this;
        DvHeap.reset();
    }

    public static void reset() {
        DvHeap.selfref.subHeaps.clear();
        DvHeap.selfref.totalObjectCount = 0L;
    }

    public boolean doScan(CommandPluginResponse commandPluginResponse) {
        boolean bl = true;
        this.cpr = commandPluginResponse;
        if (null == this.heapScanV) {
            this.heapScanV = DvUtils.findMethodForCurrentSuffix("heapScan", new Class[]{class$com$ibm$jvm$dump$format$DvHeap == null ? (class$com$ibm$jvm$dump$format$DvHeap = DvHeap.class$("com.ibm.jvm.dump.format.DvHeap")) : class$com$ibm$jvm$dump$format$DvHeap});
        }
        if (null != this.heapScanV) {
            try {
                Method method = (Method)this.heapScanV.get(1);
                CommandPlugin commandPlugin = (CommandPlugin)this.heapScanV.get(0);
                Boolean bl2 = (Boolean)method.invoke((Object)commandPlugin, this);
                bl = bl2;
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find heapScan method supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
                bl = false;
            }
        } else {
            DvUtils.trace("*** Unable to find a heapScan method supporting " + DvUtils.getSuffix(), 0, true);
            bl = false;
        }
        return bl;
    }

    public void createSubHeap(long l, long l2, String string, DvThread dvThread, long l3, boolean bl) {
        DvSubHeap dvSubHeap = new DvSubHeap(l, l2, string, dvThread, l3, bl);
        this.subHeaps.add(dvSubHeap);
        this.totalObjectCount += l3;
    }

    public Vector getSubHeapsIndexesForJvm(long l) {
        Vector vector;
        if (-1L == l) {
            vector = this.subHeaps;
        } else {
            int n = this.subHeaps.size();
            vector = new Vector();
            int n2 = 0;
            while (n2 < n) {
                DvSubHeap dvSubHeap = (DvSubHeap)this.subHeaps.get(n2);
                ++n2;
            }
        }
        return vector;
    }

    public String toString() {
        return this.toString(this.subHeaps);
    }

    public String toString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n=================================");
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append("\n======= heap component: " + n + "=======");
            stringBuffer.append(((DvSubHeap)vector.get(n)).toString());
            ++n;
        }
        stringBuffer.append("\n=================================");
        return stringBuffer.toString();
    }

    public void doOutput(String string, boolean bl) {
        this.theOutput.add(string);
        if (bl && null == this.gui) {
            this.cpr.output(this.theOutput);
            this.theOutput.clear();
        }
    }

    public String establishHeapName(long l) {
        int n = 0;
        while (n < this.subHeaps.size()) {
            DvSubHeap dvSubHeap = (DvSubHeap)this.subHeaps.get(n);
            if (l >= dvSubHeap.subHeapStart && l <= dvSubHeap.subHeapEnd) {
                String string = dvSubHeap.subHeapName;
                if (null != dvSubHeap.thread) {
                    string = string + " (thread= " + dvSubHeap.thread.id();
                }
                return string;
            }
            ++n;
        }
        return null;
    }

    public DvObject getObjectDetails(long l) {
        DvObject dvObject = new DvObject();
        dvObject.address = l;
        if (null == this.godV) {
            this.godV = DvUtils.findMethodForCurrentSuffix("getObjectDetails", new Class[]{class$com$ibm$jvm$dump$format$DvObject == null ? (class$com$ibm$jvm$dump$format$DvObject = DvHeap.class$("com.ibm.jvm.dump.format.DvObject")) : class$com$ibm$jvm$dump$format$DvObject, class$com$ibm$jvm$dump$format$DvHeap == null ? (class$com$ibm$jvm$dump$format$DvHeap = DvHeap.class$("com.ibm.jvm.dump.format.DvHeap")) : class$com$ibm$jvm$dump$format$DvHeap});
        }
        if (null != this.godV) {
            try {
                Method method = (Method)this.godV.get(1);
                CommandPlugin commandPlugin = (CommandPlugin)this.godV.get(0);
                method.invoke((Object)commandPlugin, dvObject, this);
                dvObject.heapName = this.establishHeapName(l);
                if (null == dvObject.heapName) {
                    dvObject.heapName = "??????";
                }
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find getObjectDetails supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Unable to find a getObjectDetails method supporting " + DvUtils.getSuffix(), 0, true);
        }
        return dvObject;
    }

    public String getObjectSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append("\n\n Objects Summary\n ===============\n");
        int n = 0;
        while (n < this.subHeaps.size()) {
            stringBuffer.append(this.subHeaps.get(n).toString());
            ++n;
        }
        stringBuffer.append("\n Total number of objects found via all Heaps     = " + this.totalObjectCount);
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DvSubHeap {
        private String subHeapName;
        private long subHeapStart;
        private long subHeapEnd;
        private DvThread thread;
        private long objCount;
        private boolean subHeapNormalTraversal;

        public DvSubHeap(long l, long l2, String string, DvThread dvThread, long l3, boolean bl) {
            this.subHeapName = string;
            this.subHeapStart = l;
            this.subHeapEnd = l2;
            this.thread = dvThread;
            this.objCount = l3;
            bl = this.subHeapNormalTraversal;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n" + this.subHeapName);
            if (null != this.thread) {
                stringBuffer.append(this.thread.getThreadName(null));
            }
            stringBuffer.append("\n\tstart address: 0x" + Long.toHexString(this.subHeapStart));
            if (this.subHeapEnd != -1L) {
                stringBuffer.append("\n\tend   address: 0x" + Long.toHexString(this.subHeapEnd));
                stringBuffer.append("\n\theap  size   : 0x" + Long.toHexString(this.subHeapEnd - this.subHeapStart) + "  " + (this.subHeapEnd - this.subHeapStart));
            } else {
                stringBuffer.append("\n\tend   address: un-measured (non meaningful)");
            }
            stringBuffer.append("\n\tObjects found : " + this.objCount);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

