/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvMemoryFind;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.Dvifm;
import com.ibm.jvm.dump.format.SwingWorker;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class DvMemoryFindResults
implements ActionListener {
    Dvifm theIFM = DvUtils.getTheIFM();
    JInternalFrame jif;
    DvConsole dvConsole;
    DvMemoryFind dvMemoryFind;
    int occurrencesToFind;
    String findString;
    JTextArea jtext;
    String resultsAsString;
    static String waitPrompt = "\nSearching....results will appear shortly....";
    Font thisFont;
    JPanel panel;
    JButton findNextBtn;
    JButton cancelBtn;

    public DvMemoryFindResults(JInternalFrame jInternalFrame, DvConsole dvConsole, DvMemoryFind dvMemoryFind) {
        this.jif = jInternalFrame;
        this.dvConsole = dvConsole;
        this.dvMemoryFind = dvMemoryFind;
        this.constructWindow();
        this.findString = "FINDPTR ";
        try {
            Long.decode(this.dvMemoryFind.findText);
        }
        catch (NumberFormatException numberFormatException) {
            this.findString = "FIND ";
        }
        this.findString = this.findString + this.dvMemoryFind.findText + ",";
        this.findString = this.findString + this.dvMemoryFind.startAddress + ",";
        this.findString = this.findString + this.dvMemoryFind.finishAddress + ",";
        this.findString = this.findString + this.dvMemoryFind.byteBoundary + ",";
        this.findString = this.findString + this.dvMemoryFind.displayBytes + ",";
        this.findString = this.findString + this.dvMemoryFind.occurences;
        this.occurrencesToFind = this.dvMemoryFind.occurences;
    }

    public void DoFindResults() {
        DvUtils.writetoTrace(" DoFindResults() entry");
        SwingWorker swingWorker = new SwingWorker(){
            boolean resultFound = false;

            public Object construct() {
                Object var1_1 = null;
                DvMemoryFindResults.this.resultsAsString = "";
                this.resultFound = DvMemoryFindResults.this.getFindResults(DvMemoryFindResults.this.findString);
                return var1_1;
            }

            public void finished() {
                DvMemoryFindResults.this.displayResults(this.resultFound);
            }
        };
        swingWorker.start();
        DvUtils.writetoTrace(" DoFindResults() exit");
    }

    private void constructWindow() {
        JPanel jPanel = new JPanel();
        this.thisFont = new Font("Monospaced", 0, 12);
        this.jtext = new JTextArea("", 8, 25);
        this.jtext.setEditable(false);
        this.jtext.setFont(this.thisFont);
        this.theIFM.addContentToFrame(this.jif, this.jtext, jPanel);
        this.findNextBtn = new JButton("Find Next");
        this.cancelBtn = new JButton("Cancel");
        jPanel.add(this.findNextBtn);
        jPanel.add(this.cancelBtn);
        this.findNextBtn.setToolTipText("Click this button to find Next occurence.");
        this.cancelBtn.setToolTipText("Click this button to cancel Find.");
        this.findNextBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.jtext.setText(waitPrompt);
    }

    private boolean getFindResults(String string) {
        this.resultsAsString = "";
        boolean bl = false;
        DvUtils.writetoTrace("getFindResults entry:" + string);
        Dumpviewer.waitingOnConsoleCommand = true;
        this.dvConsole.execValidCommand(string);
        while (Dumpviewer.waitingOnConsoleCommand) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("\nInterruptedException");
            }
        }
        if (Dumpviewer.savedConsoleOutput instanceof Vector) {
            Vector vector = Dumpviewer.savedConsoleOutput;
            int n = 0;
            while (n < vector.size()) {
                ++n;
            }
            if (vector.size() > 2) {
                bl = true;
                Vector vector2 = (Vector)vector.get(this.occurrencesToFind > 1 ? this.occurrencesToFind + 1 : this.occurrencesToFind);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    Object e = vector2.get(n2);
                    this.resultsAsString = this.resultsAsString + (String)e;
                    this.resultsAsString = this.resultsAsString + "\n";
                    ++n2;
                }
                StringBuffer stringBuffer = new StringBuffer(this.resultsAsString);
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer.deleteCharAt(0);
                this.resultsAsString = stringBuffer.toString();
                if (this.occurrencesToFind > 1) {
                    this.resultsAsString = this.resultsAsString + "\n";
                    int n3 = 1;
                    while (n3 <= this.occurrencesToFind) {
                        this.resultsAsString = this.resultsAsString + "\n" + vector.get(n3);
                        ++n3;
                    }
                }
            } else {
                bl = false;
                this.resultsAsString = vector.get(0) + "\n";
            }
        } else {
            bl = false;
            this.resultsAsString = "Unexpected response from console\n";
        }
        Dumpviewer.savedConsoleOutput.clear();
        DvUtils.writetoTrace("getFindResults exit");
        return bl;
    }

    private void displayResults(boolean bl) {
        DvUtils.writetoTrace("displayResults entry: " + (bl ? "true" : "false"));
        this.jtext.setText(this.resultsAsString);
        if (!bl) {
            this.findNextBtn.setEnabled(false);
        }
        DvUtils.writetoTrace("displayResults exit " + (bl ? "true" : "false"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.findNextBtn) {
            DvUtils.writetoTrace("findNextBtn pressed in FindResults");
            this.jtext.setText(waitPrompt);
            this.occurrencesToFind = 1;
            this.findString = "FN";
            this.DoFindResults();
        } else if (actionEvent.getSource() == this.cancelBtn) {
            DvUtils.writetoTrace("cancelBtn pressed in FindResults");
            this.jif.setVisible(false);
            this.theIFM.removeIFrame(this.jif, true);
        }
    }
}

