/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.FreeList;
import com.ibm.jvm.dump.plugins.OutputStrategy;
import com.ibm.jvm.dump.plugins.STGlobalData;

public abstract class ChunkVisitor {
    boolean verbose = false;
    STGlobalData sTGlobalData;
    FreeList freeListToWalk;
    OutputStrategy outputStrategy;

    ChunkVisitor(boolean bl, FreeList freeList, OutputStrategy outputStrategy) {
        this.verbose = bl;
        this.sTGlobalData = STGlobalData.getSTGlobalData();
        this.freeListToWalk = freeList;
        this.outputStrategy = outputStrategy;
    }

    ChunkVisitor(FreeList freeList, OutputStrategy outputStrategy) {
        this(false, freeList, outputStrategy);
    }

    boolean visitChunk(long l) {
        if (this.verbose) {
            this.reportVisit(l);
        }
        if (this.isValidChunk(l)) {
            return this.processChunk(l);
        }
        return false;
    }

    protected void reportVisit(long l) {
        this.outputStrategy.output("Visiting Chunk 0x" + DvUtils.rJustifyZ(Long.toHexString(l), 0) + " in " + this.freeListToWalk.getFreeListName());
    }

    private boolean isValidChunk(long l) {
        STGlobalData sTGlobalData = STGlobalData.getSTGlobalData();
        if (0L != l && !DvUtils.checkAddressInDump(new DvAddress(l), sTGlobalData.getCurrentAddressSpace())) {
            this.outputStrategy.output("0x" + Long.toHexString(l) + " is not a valid address in the Dump");
            this.outputStrategy.output("The chain is broken");
            long l2 = sTGlobalData.getAddressItemAsLong("real_heapbase");
            long l3 = sTGlobalData.getAddressItemAsLong("real_heaptop");
            if (l2 >= l && l3 <= l) {
                this.outputStrategy.output("0x" + Long.toHexString(l) + " is not with in the real heap ranges");
            } else {
                this.outputStrategy.output("BUT 0x" + Long.toHexString(l) + " is within the real heap ranges");
            }
            this.outputStrategy.output("real_heaptop = 0x" + Long.toHexString(l3));
            this.outputStrategy.output("real_heapbase = 0x" + Long.toHexString(l2));
            DvUtils.writetoTrace("Exit:1 DvStorageCommands.freelistCheckAddress");
            return false;
        }
        DvUtils.writetoTrace("Exit:2 DvStorageCommands.freelistCheckAddress");
        return true;
    }

    abstract boolean processChunk(long var1);
}

