/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DVExitListener;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvFileHistory;
import com.ibm.jvm.dump.format.DvFindInMemory;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvMemoryFind;
import com.ibm.jvm.dump.format.DvMemoryScroller;
import com.ibm.jvm.dump.format.DvMenu;
import com.ibm.jvm.dump.format.DvMenuItem;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.Dvifm;
import com.ibm.jvm.dump.format.DvifmFrame;
import com.ibm.jvm.dump.plugins.DvBaseCommands;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;

public class DvBaseCommandsGui
extends DvBaseCommands
implements DvFileHistory.IFileHistory {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvBaseCommandsGui";
    public static DvFileHistory fileHistory;
    public static DvBaseCommandsGui selfRef;

    public DvBaseCommandsGui() {
        selfRef = this;
    }

    public Vector guiMenus() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new DvMenuItem("File", "Open", -1, null, false, "doOpenFile", thisName, null, null, null, null, false, "Identify a dump file"));
        vector.add(new DvMenuItem("Edit", "Preferences", -1, null, false, "doPreferences", thisName, null, null, null, null, false, "Set Dumpviewer preferences"));
        vector.add(new DvMenuItem("Edit", "Plugin Management", -1, null, false, "doPluginMgmt", thisName, null, null, null, null, false, "Add,remove,display,refresh plugins"));
        vector.add(new DvMenuItem("File", "Set FormatFile", -1, null, false, "doSetFF", thisName, null, null, null, null, false, "Types file to be used when no imbedded types in dump"));
        vector.add(new DvMenuItem("File", "Set WorkDir", -1, null, false, "doSetWorkDir", thisName, null, null, null, null, false, "Set the working directory"));
        vector.add(new DvMenu("Memory", 77, false));
        vector.add(new DvMenuItem("Memory", "Map", -1, null, false, "displayMemoryMap", thisName, null, "mmapDoubleClick", null, null, false, "Display the memory ranges"));
        vector.add(new DvMenuItem("Memory", "Display", -1, null, false, "displayMemory", thisName, null, null, null, null, false, "Display memory at a specified address"));
        vector.add(new DvMenuItem("Memory", "Find", -1, null, false, "findInMemory", thisName, null, null, null, null, false, "Search through memory"));
        vector.add(new DvMenuItem("System", "Set JVM", -1, null, false, "setValueJvm", thisName, null, null, null, null, false, "Set current jvm for this dump"));
        vector.add(new DvMenuItem("System", "Set Thread", -1, null, false, "setValueThread", thisName, null, null, null, null, false, "Set current thread for this dump"));
        vector.add(new DvMenuItem("System", "Set Process", -1, null, false, "setValueProcess", thisName, null, null, null, null, false, "Set current Process for this dump"));
        vector.add(new DvMenuItem("System", "Set Address Space", -1, null, false, "setValueAs", thisName, null, null, null, null, false, "Set current address space for this dump"));
        vector.add(new DvMenuItem("System", "Dump Info", -1, null, false, "displaySystemSummary", thisName, null, null, null, null, false, "Information on the system that produced this dump"));
        vector.add(new DvMenuItem("System", "Sanity Check", -1, null, false, "displaySanityCheck", thisName, null, null, null, null, false, "Do the JVM eyecatchers look good?"));
        return vector;
    }

    public static void doOpenFile(String string) {
        Serializable serializable;
        String string2 = "Dump format not recognised";
        boolean bl = false;
        DvUtils.writetoTrace("DvBaseCommands: doOpenFile entry: " + string);
        int n = 0;
        if (string.toUpperCase().equals("OPEN")) {
            serializable = new JFileChooser(System.getProperty("user.dir"));
            ((JFileChooser)serializable).setFileSelectionMode(0);
            ((JFileChooser)serializable).setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return true;
                }

                public String getDescription() {
                    return "*.*";
                }
            });
            n = ((JFileChooser)serializable).showOpenDialog(Dumpviewer.desktop);
            if (n == 0) {
                Dumpviewer.theFileName = ((JFileChooser)serializable).getSelectedFile().getPath();
            }
        } else {
            Dumpviewer.theFileName = string;
        }
        if (n == 0) {
            serializable = new File(Dumpviewer.theFileName);
            if (((File)serializable).exists()) {
                DvConsole.theDump = DvUtils.findDumpPlugin(Dumpviewer.theFileName);
                if (null != DvConsole.theDump) {
                    Object object;
                    String string3 = DvUtils.getSuffix();
                    if (null != string3) {
                        object = "Dv" + string3 + ".properties";
                        Dumpviewer.showMessage("Suffix established as " + string3, true);
                        Dumpviewer.showMessage("\n   Will now attempt load of " + (String)object, true);
                        Dumpviewer.showMessage("\n   to find supplemental command plugins\n", true);
                        DvConsole.supplementalP = DvUtils.findPropertiesFile("Dv" + string3 + ".properties");
                        if (null != DvConsole.supplementalP) {
                            String string4 = DvUtils.getSuppProperty("CommandPlugins");
                            Dumpviewer.showMessage("\n" + (String)object + " found \n", true);
                            if (null != string4) {
                                Vector vector = new Vector();
                                DvConsole.commandPlugins = DvUtils.findCommandPlugins(true, vector);
                                if (null != vector) {
                                    int n2 = 0;
                                    while (n2 < vector.size()) {
                                        Dumpviewer.showMessage((String)vector.get(n2), true);
                                        ++n2;
                                    }
                                }
                                DvConsole.refreshCommands();
                                Dumpviewer.refreshMenuBar();
                            }
                        } else {
                            Dumpviewer.showMessage("\n !!! " + (String)object + " not found !!!", true);
                            Dumpviewer.showMessage(" !!! Previously loaded plugins remain in place.\n", true);
                        }
                    } else {
                        Dumpviewer.showMessage("Suffix was null - command plugins might need hand loading", true);
                        Dumpviewer.showMessage("   \"Dis pl verbose\" will show what plugins and commands available\n", true);
                    }
                    if (DvConsole.setTheDump(DvConsole.theDump, (Vector)(object = new Vector()), Dumpviewer.theFileName)) {
                        fileHistory.insertPathname(Dumpviewer.theFileName);
                        bl = true;
                    }
                    if (0 != ((Vector)object).size()) {
                        int n3 = 0;
                        while (n3 < ((Vector)object).size()) {
                            DvUtils.writetoTrace((String)((Vector)object).get(n3));
                            ++n3;
                        }
                    }
                }
            } else {
                string2 = "File " + Dumpviewer.theFileName + " not found";
            }
        }
        if (bl) {
            DvBaseCommandsGui.showASIDFrame();
        } else if (n == 0) {
            DvUtils.writetoTrace("!!!!!!!!\n" + string2 + "\n!!!!!!!!");
            Dumpviewer.setStatusLine(string2);
            Dumpviewer.genericInfoMessage(string2);
        }
        DvUtils.writetoTrace("DvBaseCommands: doOpenFile exit - " + (bl ? "true" : "false"));
    }

    public void loadFile(String string) {
        DvUtils.writetoTrace("DvBaseCommands: loadFile entry: " + string);
        DvBaseCommandsGui.doOpenFile(string);
        DvUtils.writetoTrace("DvBaseCommands: loadFile exit: " + string);
    }

    public static String setUpFileHistory(String string, boolean bl) {
        if (bl) {
            fileHistory = null;
        }
        if (null == fileHistory) {
            fileHistory = new DvFileHistory(selfRef);
            fileHistory.initFileMenuHistory();
        }
        String string2 = null;
        if (string.startsWith("f")) {
            string2 = fileHistory.getFFName();
        }
        if (string.startsWith("w")) {
            string2 = fileHistory.getWDName();
        }
        Dumpviewer.exitListener = new DVExitListener(fileHistory);
        Dumpviewer.selfRef.addWindowListener(Dumpviewer.exitListener);
        return string2;
    }

    public static void doSetWorkDir(String string) {
        DvUtils.writetoTrace("DVBaseCommands:doSetWorkDir entry");
        String string2 = DvUtils.getValue("WorkDir");
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(new File(string2));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public String getDescription() {
                return "*.*";
            }
        });
        jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    File file = (File)propertyChangeEvent.getNewValue();
                    jFileChooser.setSelectedFile(file);
                }
            }
        });
        int n = jFileChooser.showOpenDialog(Dumpviewer.desktop);
        if (n == 0) {
            String string3 = jFileChooser.getSelectedFile().getPath();
            File file = new File(string3);
            if (file.exists()) {
                String string4 = System.getProperty("file.separator");
                DvUtils.setValue("WORKDIR", string3 + string4);
                fileHistory.setWDName(string3 + string4);
                Dumpviewer.savedWorkDir.setText("Set WorkDir (" + string3 + ")");
            } else {
                Dumpviewer.genericInfoMessage("Directory " + string3 + " invalid");
            }
        }
        DvUtils.writetoTrace("DVBaseCommands:doSetWorkDir exit");
    }

    public static void doSetFF(String string) {
        DvUtils.writetoTrace("DVBaseCommands:doSetFF entry");
        String string2 = DvUtils.getValue("FORMATFILE");
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setSelectedFile(new File(string2));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public String getDescription() {
                return "*.*";
            }
        });
        int n = jFileChooser.showOpenDialog(Dumpviewer.desktop);
        if (n == 0) {
            String string3 = jFileChooser.getSelectedFile().getPath();
            File file = new File(string3);
            if (file.exists()) {
                DvUtils.setValue("FORMATFILE", string3);
                fileHistory.setFFName(string3);
                Dumpviewer.savedSetFF.setText("Set FormatFile (" + string3 + ")");
            } else {
                Dumpviewer.genericInfoMessage("File " + string3 + " does not exist");
            }
        }
        DvUtils.writetoTrace("DVBaseCommands:doSetFF exit");
    }

    public static void doPluginMgmt(String string) {
        JCheckBox[] jCheckBoxArray;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = DvUtils.findCommandPlugins();
        Vector<JCheckBox[]> vector2 = new Vector<JCheckBox[]>();
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                jCheckBoxArray = (JCheckBox[])vector.get(n);
                if (jCheckBoxArray.endsWith("Gui")) {
                    vector2.add(jCheckBoxArray);
                }
                ++n;
            }
        }
        JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame("Command Plugins", Dumpviewer.theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 230, 350, 5, Dumpviewer.selfRef.getHeight() - 330);
        jCheckBoxArray = new JCheckBox[vector2.size()];
        if (vector2.size() > 0) {
            int n = 0;
            while (n < vector2.size()) {
                String string2 = (String)vector2.get(n);
                jCheckBoxArray[n] = new JCheckBox(string2);
                if (DvUtils.checkIfPluginLoaded(string2)) {
                    jCheckBoxArray[n].setSelected(true);
                }
                ++n;
            }
        }
        PMMouseListener pMMouseListener = new PMMouseListener(){};
        Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jCheckBoxArray, pMMouseListener);
    }

    public static void displayMemoryMap(String string) {
        DvMemRanges[] dvMemRangesArray = DvConsole.theDump.getAddressSpaces()[0].getMemRanges();
        String[] stringArray = new String[]{"Start Address", "End Address  ", "Length   "};
        JTable jTable = null;
        int n = dvMemRangesArray.length;
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        long[] lArray = new long[n];
        DvAddress dvAddress = null;
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = dvMemRangesArray[n2].addressStart().convertToHex();
            lArray[n2] = dvMemRangesArray[n2].length();
            dvAddress = new DvAddress(dvMemRangesArray[n2].addressStart().getAddressAsLong() + lArray[n2]);
            stringArray3[n2] = dvAddress.convertToHex();
            ++n2;
        }
        MmapTableModel mmapTableModel = new MmapTableModel(stringArray2, stringArray3, lArray, n, stringArray);
        jTable = new JTable(mmapTableModel);
        jTable.setAutoResizeMode(0);
        jTable.setSelectionMode(0);
        JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame("Memory Mapping", Dumpviewer.theIFM.getDefaultProperties(), 5, string);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 300, 250, 100, 100);
        JScrollPane jScrollPane = new JScrollPane(jTable, 20, 32);
        jInternalFrame.getContentPane().setLayout(new BorderLayout());
        jInternalFrame.setPreferredSize(new Dimension(300, 300));
        jInternalFrame.getContentPane().add("Center", jScrollPane);
        Dumpviewer.addMouseListener(jInternalFrame, jTable);
    }

    public static void displayMemory(String string) {
        JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame("Memory Scroller ????????", Dumpviewer.theIFM.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 400, 550, 250, 50);
        DvMemoryScroller dvMemoryScroller = new DvMemoryScroller(jInternalFrame, Dumpviewer.dvConsole);
    }

    public static void displayMemory(DvAddress dvAddress, long l) {
        JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame("Memory Scroller " + dvAddress.convertToHex(), Dumpviewer.theIFM.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 400, 550, 250, 50);
        DvMemoryScroller dvMemoryScroller = new DvMemoryScroller(jInternalFrame, Dumpviewer.dvConsole, dvAddress, l);
    }

    public static void findInMemory(String string) {
        JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame("Memory Find", Dumpviewer.theIFM.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 270, 320, 350, 200);
        if (null == DvBaseCommands.dvMemoryFind) {
            DvBaseCommands.dvMemoryFind = new DvMemoryFind();
        }
        DvFindInMemory dvFindInMemory = new DvFindInMemory(jInternalFrame, Dumpviewer.dvConsole, DvBaseCommands.dvMemoryFind);
    }

    public static JInternalFrame setupASIDframe() {
        JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame("Asid-Process-Threads", Dumpviewer.theIFM.getDefaultProperties() - 2, 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 360, (Dumpviewer.selfRef.getWidth() - 10) / 2, 0, 0);
        JTree jTree = Dumpviewer.createASIDTree();
        Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTree);
        return jInternalFrame;
    }

    public static void showASIDFrame() {
        String string = "unknown";
        String string2 = "unknown";
        String string3 = "unknown";
        boolean bl = false;
        String string4 = "unknown";
        String string5 = "unknown";
        JInternalFrame jInternalFrame = DvBaseCommandsGui.setupASIDframe();
        int n = DvConsole.theDump.getArchitecture();
        String string6 = DvBaseCommands.asidState();
        if (Dumpviewer.is32BitDump) {
            string = "32-Bit";
        } else if (Dumpviewer.is64BitDump) {
            string = "64-Bit";
        }
        if (Dumpviewer.isBigEndDump) {
            string2 = "Big Endian";
        } else if (Dumpviewer.isLittleEndDump) {
            string2 = "Little Endian";
        }
        Dumpviewer.setStatusLine(string6);
    }

    public static void mmapDoubleClick(JInternalFrame jInternalFrame, MouseEvent mouseEvent) {
        DvUtils.writetoTrace("DVBaseCommands:mmapDoubleClick entry");
        Object object = mouseEvent.getSource();
        if (object instanceof JTable) {
            int n;
            if (null != object && -1 != (n = ((JTable)object).getSelectedRow())) {
                DvAddressSpace[] dvAddressSpaceArray = DvConsole.theDump.getAddressSpaces();
                DvAddress dvAddress = dvAddressSpaceArray[Dumpviewer.currentAS].getMemRanges()[n].addressStart();
                long l = dvAddressSpaceArray[Dumpviewer.currentAS].getMemRanges()[n].length();
                DvBaseCommandsGui.displayMemory(dvAddress, l);
            }
        } else {
            DvUtils.writetoTrace(" .... event not associated with our JTable !!! ");
        }
        DvUtils.writetoTrace("DVBaseCommands:mmapDoubleClick exit");
    }

    public static void displaySystemSummary(String string) {
        DvUtils.writetoTrace("DVBaseCommands:displaySystemSummary entry");
        Vector vector = new Vector();
        selfRef.displaySystem(vector);
        String string2 = DvUtils.convertResponse(vector, true);
        JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame("Dump Info", Dumpviewer.theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 230, 250, 5, Dumpviewer.selfRef.getHeight() - 330);
        JTextArea jTextArea = new JTextArea(string2, 8, 25);
        jTextArea.setEditable(false);
        Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTextArea);
        DvUtils.writetoTrace("DVBaseCommands:displaySystemSummary exit");
    }

    public static void displaySanityCheck(String string) {
        String string2 = DvUtils.convertResponse(DvConsole.sanityCheckVector, false);
        JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame("Sanity Check Information", Dumpviewer.theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 230, 350, 5, Dumpviewer.selfRef.getHeight() - 330);
        JTextArea jTextArea = new JTextArea(string2, 8, 25);
        jTextArea.setEditable(false);
        Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTextArea);
    }

    public static void setValueJvm(String string) {
        String[] stringArray = null;
        String string2 = string.toUpperCase();
        Vector vector = DvConsole.getJvmsInDump();
        int n = vector.size();
        if (n < 2) {
            Dumpviewer.genericInfoMessage(" Only 1 JVM - no need for change");
        }
        if (n > 0) {
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = "0x" + Long.toHexString((Long)vector.get(n2));
                ++n2;
            }
            int n3 = Dumpviewer.chooseAValue(stringArray, "Choose a Jvm");
            if (-1 != n3) {
                if (-1 == stringArray[n3].indexOf(DvUtils.getValue("CURRJVM"))) {
                    selfRef.setParamString(stringArray[n3]);
                    selfRef.setCurrentJvm();
                    String string3 = DvBaseCommands.asidState();
                    Dumpviewer.setStatusLine(string3);
                    Dumpviewer.genericInfoMessage(" JVM changed to " + stringArray[n3]);
                } else {
                    Dumpviewer.genericInfoMessage(" JVM is already " + stringArray[n3] + " no need for change");
                }
            }
        }
    }

    public static void setValueThread(String string) {
        Object object;
        String string2 = DvUtils.getValue("PID");
        String string3 = DvUtils.getValue("THREAD");
        String string4 = DvUtils.getValue("ASID");
        DvAddressSpace dvAddressSpace = null;
        DvProcess dvProcess = null;
        boolean bl = false;
        DvAddressSpace[] dvAddressSpaceArray = DvConsole.theDump.getAddressSpaces();
        int n = 0;
        while (n < dvAddressSpaceArray.length && !bl) {
            if (string4.equals(dvAddressSpaceArray[n].id())) {
                dvAddressSpace = dvAddressSpaceArray[n];
                object = dvAddressSpace.getProcesses();
                int n2 = 0;
                while (n2 < ((DvProcess[])object).length && !bl) {
                    if (object[n2].id().equals(string2)) {
                        bl = true;
                        dvProcess = object[n2];
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (bl) {
            object = null;
            bl = false;
            DvThread[] dvThreadArray = dvProcess.getThreads();
            int n3 = dvThreadArray.length;
            int n4 = 0;
            while (n4 < n3 && !bl) {
                if (dvThreadArray[n4].id().equals(string3)) {
                    object = dvThreadArray[n4];
                    bl = true;
                }
                ++n4;
            }
            if (n3 > 1) {
                int n5 = 0;
                String[] stringArray = new String[n3];
                String[] stringArray2 = null;
                int n6 = 0;
                while (n6 < n3) {
                    if (dvThreadArray[n6].isJava() && DvUtils.sameJvm(dvAddressSpace, (DvThread)object, dvAddressSpace, dvThreadArray[n6])) {
                        stringArray[n5] = dvThreadArray[n6].id();
                        ++n5;
                    }
                    ++n6;
                }
                if (n5 > 1) {
                    stringArray2 = new String[n5];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n5);
                    int n7 = Dumpviewer.chooseAValue(stringArray2, "Choose a Thread from this jvm");
                    if (-1 != n7) {
                        if (-1 == stringArray2[n7].indexOf(DvUtils.getValue("THREAD"))) {
                            selfRef.setParamString(stringArray2[n7]);
                            selfRef.setThread();
                            String string5 = DvBaseCommands.asidState();
                            Dumpviewer.setStatusLine(string5);
                            Dumpviewer.genericInfoMessage(" Thread changed to " + stringArray2[n7]);
                        } else {
                            Dumpviewer.genericInfoMessage(" Thread is already " + stringArray2[n7] + " no need for change");
                        }
                    }
                } else {
                    Dumpviewer.genericInfoMessage(" 1 (or 0) threads found for  this Jvm else request ignored");
                }
            } else {
                Dumpviewer.genericInfoMessage(" 1 (or 0) threads found -  therefore request ignored");
            }
        }
    }

    public static void setValueProcess(String string) {
        String string2 = DvUtils.getValue("PID");
        String string3 = DvUtils.getValue("THREAD");
        String string4 = DvUtils.getValue("ASID");
        boolean bl = false;
        DvAddressSpace[] dvAddressSpaceArray = DvConsole.theDump.getAddressSpaces();
        int n = dvAddressSpaceArray.length;
        DvAddressSpace dvAddressSpace = null;
        int n2 = 0;
        while (n2 < n && !bl) {
            if (string4.equals(dvAddressSpaceArray[n2].id())) {
                dvAddressSpace = dvAddressSpaceArray[n2];
                bl = true;
            }
            ++n2;
        }
        DvProcess[] dvProcessArray = dvAddressSpace.getProcesses();
        n = dvProcessArray.length;
        if (n < 2) {
            Dumpviewer.genericInfoMessage(" 1 (or 0) processes found -  therefore request ignored");
        } else {
            String[] stringArray = new String[n];
            int n3 = 0;
            while (n3 < n) {
                stringArray[n3] = dvProcessArray[n3].id();
                ++n3;
            }
            int n4 = Dumpviewer.chooseAValue(stringArray, "Choose a process from this AddressSpace");
            if (-1 != n4) {
                if (-1 == stringArray[n4].indexOf(DvUtils.getValue("PID"))) {
                    selfRef.setParamString(stringArray[n4]);
                    selfRef.setPID();
                    String string5 = DvBaseCommands.asidState();
                    Dumpviewer.setStatusLine(string5);
                    Dumpviewer.genericInfoMessage(" Process changed to " + stringArray[n4]);
                } else {
                    Dumpviewer.genericInfoMessage(" Process is already " + stringArray[n4] + " no need for change");
                }
            }
        }
    }

    public static void setValueAs(String string) {
        String string2 = DvUtils.getValue("ASID");
        DvAddressSpace[] dvAddressSpaceArray = DvConsole.theDump.getAddressSpaces();
        int n = dvAddressSpaceArray.length;
        if (n < 2) {
            Dumpviewer.genericInfoMessage(" 1 (or 0) address spaces found -  therefore request ignored");
        } else {
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = dvAddressSpaceArray[n2].id();
                ++n2;
            }
            int n3 = Dumpviewer.chooseAValue(stringArray, "Choose an AddressSpace from this dump");
            if (-1 != n3) {
                if (-1 == stringArray[n3].indexOf(DvUtils.getValue("ASID"))) {
                    selfRef.setParamString(stringArray[n3]);
                    selfRef.setASID();
                    String string3 = DvBaseCommands.asidState();
                    Dumpviewer.setStatusLine(string3);
                    Dumpviewer.genericInfoMessage(" AddressSpace changed to " + stringArray[n3]);
                } else {
                    Dumpviewer.genericInfoMessage(" AddressSpace is already " + stringArray[n3] + " no need for change");
                }
            }
        }
    }

    public String getApplicationName() {
        return "DUMPVIEWER";
    }

    public JMenu getFileMenu() {
        return Dumpviewer.mainmenubar.getMenu(0);
    }

    static class MmapTableModel
    extends AbstractTableModel {
        boolean valsgiven = false;
        String[] col1_vals;
        String[] col2_vals;
        long[] col3_vals;
        String[] columnNames = new String[]{"C1", "C2", "C3", "C4", "C5", "C6"};
        int nRows;
        int nColumns;

        public int getColumnCount() {
            return this.nColumns;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.nRows;
        }

        public Object getValueAt(int n, int n2) {
            if (!this.valsgiven) {
                return new Integer(0);
            }
            if (n2 == 0) {
                return new String(this.col1_vals[n]);
            }
            if (n2 == 1) {
                return new String(this.col2_vals[n]);
            }
            if (n2 == 2) {
                return new Long(this.col3_vals[n]);
            }
            return new Long(999L);
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public MmapTableModel(int n, int n2, String[] stringArray) {
            this.nRows = n;
            this.nColumns = n2;
            try {
                this.columnNames[0] = stringArray[0];
                this.columnNames[1] = stringArray[1];
                this.columnNames[2] = stringArray[2];
                this.columnNames[3] = stringArray[3];
                this.columnNames[4] = stringArray[4];
                this.columnNames[5] = stringArray[5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }

        public MmapTableModel(String[] stringArray, String[] stringArray2, long[] lArray, int n, String[] stringArray3) {
            this.valsgiven = true;
            this.nRows = n;
            this.nColumns = stringArray3.length;
            this.col1_vals = stringArray;
            this.col2_vals = stringArray2;
            this.col3_vals = lArray;
            try {
                this.columnNames[0] = stringArray3[0];
                this.columnNames[1] = stringArray3[1];
                this.columnNames[2] = stringArray3[2];
                this.columnNames[3] = stringArray3[3];
                this.columnNames[4] = stringArray3[4];
                this.columnNames[5] = stringArray3[5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    private static class PMMouseListener
    implements MouseListener {
        private PMMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            block10: {
                Object object = mouseEvent.getSource();
                if (!(object instanceof JButton)) break block10;
                JButton jButton = (JButton)object;
                JInternalFrame jInternalFrame = Dvifm.getCurrentJif();
                if (jButton.getText().toUpperCase().equals("CANCEL")) {
                    try {
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    Object object2;
                    DvifmFrame dvifmFrame = Dvifm.findDvifmFrame(jInternalFrame);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("com.ibm.jvm.dump.plugins.DvBaseCommandsGui");
                    int n = 0;
                    while (n < dvifmFrame.cbArray.length) {
                        if (dvifmFrame.cbArray[n].isSelected() && !((String)(object2 = dvifmFrame.cbArray[n].getText())).equals("com.ibm.jvm.dump.plugins.DvBaseCommandsGui")) {
                            stringBuffer.append(",");
                            stringBuffer.append((String)object2);
                        }
                        ++n;
                    }
                    object2 = new Vector();
                    DvConsole.commandPlugins = DvUtils.findCommandClasses(stringBuffer.toString(), object2);
                    if (null != object2) {
                        int n2 = 0;
                        while (n2 < ((Vector)object2).size()) {
                            Dumpviewer.showMessage((String)((Vector)object2).get(n2), true);
                            ++n2;
                        }
                    }
                    DvConsole.refreshCommands();
                    Dumpviewer.refreshMenuBar();
                    try {
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

