/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.FreeList;
import com.ibm.jvm.dump.plugins.Chunk;
import com.ibm.jvm.dump.plugins.ChunkVisitor;
import com.ibm.jvm.dump.plugins.OutputStrategy;
import java.util.Vector;

public class SummariseChunkVisitor
extends ChunkVisitor {
    private int noOfSegments;
    private int noOfLargeChunks;
    private Vector largeChunks;
    private long AmountOfHeapFree = 0L;
    private float segmentSize;
    private Vector stats;
    private int positionOfSmallest;

    SummariseChunkVisitor(boolean bl, FreeList freeList, int n, int n2, OutputStrategy outputStrategy) {
        super(bl, freeList, outputStrategy);
        this.noOfSegments = n;
        this.noOfLargeChunks = n2;
        long l = this.sTGlobalData.getAddressItemAsLong("real_heapbase");
        long l2 = this.sTGlobalData.getAddressItemAsLong("real_heaptop");
        long l3 = l2 - l;
        this.segmentSize = l3 / (long)n;
        this.stats = new Vector();
        int n3 = 0;
        while (n3 < n) {
            this.stats.addElement(new Integer(0));
            ++n3;
        }
        this.largeChunks = new Vector();
        int n4 = 0;
        while (n4 < n2) {
            this.largeChunks.addElement(new BigChunk(0L, 0L));
            ++n4;
        }
        this.positionOfSmallest = this.findSmallestElement(this.largeChunks);
        this.AmountOfHeapFree = 0L;
    }

    SummariseChunkVisitor(FreeList freeList, int n, int n2, OutputStrategy outputStrategy) {
        this(false, freeList, n, n2, outputStrategy);
    }

    boolean processChunk(long l) {
        long l2 = Chunk.getHeader(l);
        this.AmountOfHeapFree += l2;
        if (l2 > ((BigChunk)this.largeChunks.elementAt(this.positionOfSmallest)).getSize()) {
            this.largeChunks.remove(this.positionOfSmallest);
            this.largeChunks.addElement(new BigChunk(l, l2));
            this.positionOfSmallest = this.findSmallestElement(this.largeChunks);
        }
        int n = 0;
        while (n < this.noOfSegments) {
            if ((float)l2 < (float)n * this.segmentSize) {
                Integer n2 = (Integer)this.stats.elementAt(n);
                this.stats.setElementAt(new Integer(n2 + 1), n);
                break;
            }
            ++n;
        }
        return true;
    }

    void report(FreeList freeList) {
        this.outputStrategy.output("AmountOfHeapFree 0x" + Long.toHexString(this.AmountOfHeapFree) + "  " + this.AmountOfHeapFree);
        this.outputStrategy.output("");
        this.outputStrategy.output("Start of freelist 0x" + Long.toHexString(freeList.getFreeList()));
        this.outputStrategy.output("Hint: can use \"for 0x" + Long.toHexString(freeList.getFreeList()) + " as Chunk\" " + "to show the first entry on the freelist");
        this.outputStrategy.output("");
        this.outputStrategy.output("Summary of the number of freelist chunk sizes over " + this.noOfSegments + " segments of freelist");
        this.outputStrategy.output("The largest segments of the heap are not shown until the first non zero segment");
        this.outputStrategy.output("");
        this.outputStrategy.output("sizes of chunk :\n \t no of chunks");
        boolean bl = false;
        int n = this.noOfSegments - 1;
        while (n >= 0) {
            if (0 != (Integer)this.stats.elementAt(n)) {
                bl = true;
            }
            if (bl) {
                this.outputStrategy.output("0x" + Integer.toHexString(new Float((float)(n + 1) * this.segmentSize).intValue()) + ":\n \t  " + this.stats.elementAt(n));
            }
            --n;
        }
        this.outputStrategy.output("0x" + Integer.toHexString(new Float(0.0f * this.segmentSize).intValue()) + ":\n");
        this.outputStrategy.output("");
        this.outputStrategy.output("This the size of the " + this.largeChunks.size() + " largest chunks on the freelist");
        this.outputStrategy.output("");
        this.positionOfSmallest = this.findSmallestElement(this.largeChunks);
        this.outputStrategy.output("Start address of Chunk : Chunk size");
        while (this.largeChunks.size() > 0) {
            if (0L < ((BigChunk)this.largeChunks.elementAt(this.positionOfSmallest)).getSize()) {
                this.outputStrategy.output("0x" + Long.toHexString(((BigChunk)this.largeChunks.elementAt(this.positionOfSmallest)).getAddress()) + "             : 0x" + Long.toHexString(((BigChunk)this.largeChunks.elementAt(this.positionOfSmallest)).getSize()));
            }
            this.largeChunks.remove(this.positionOfSmallest);
            this.positionOfSmallest = this.findSmallestElement(this.largeChunks);
        }
    }

    private int findSmallestElement(Vector vector) {
        int n = 0;
        long l = Long.MAX_VALUE;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (((BigChunk)vector.elementAt(n2)).getSize() < l) {
                l = ((BigChunk)vector.elementAt(n2)).getSize();
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public class BigChunk {
        long address = 0L;
        long header = 0L;

        public BigChunk(long l, long l2) {
            this.setAddress(l);
            this.setSize(l2);
        }

        public long getAddress() {
            return this.address;
        }

        public long getSize() {
            return this.header;
        }

        public void setAddress(long l) {
            this.address = l;
        }

        public void setSize(long l) {
            this.header = l;
        }
    }
}

