/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.BigEnd;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.LittleEnd;
import com.ibm.jvm.dump.sdff.SDFFAddress;
import com.ibm.jvm.dump.sdff.SDFFDump;
import com.ibm.jvm.dump.sdff.SDFFMemRanges;
import com.ibm.jvm.dump.sdff.SDFFMemoryMap;
import com.ibm.jvm.dump.sdff.SDFFProcess;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.SdffConstants;
import com.ibm.jvm.dump.sdff.SdffStd;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

public class SDFFAddressSpace
extends DvAddressSpace {
    private long mmapOffset;
    private long mmapLength;
    private static SDFFMemRanges[] theMemRanges = null;
    private RandomAccessFile sdffFile;
    private RandomAccessFile memoryFile;
    private Vector processes = new Vector();
    private Vector process_offsets = new Vector();
    private long id;
    private int arrayPosition;
    private long processCount;
    private SDFFDump owningDump;
    private static long[] startCache;
    private static long[] endCache;
    private static int[] rangeCache;
    private static int[] cacheHits;
    private static final int CACHE_SIZE = 20;

    public SDFFAddressSpace(long l, long l2, long l3, long l4, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, int n) {
        this.id = l;
        this.processCount = l2;
        this.mmapOffset = l3;
        this.mmapLength = l4;
        this.memoryFile = randomAccessFile2;
        this.sdffFile = randomAccessFile;
        this.arrayPosition = n;
        DvDump dvDump = DvConsole.theDump;
        if (dvDump != null) {
            this.pointerSize = DvUtils.is64BitSystem(dvDump.getArchitecture()) ? 8 : 4;
            this.endian = DvUtils.isBigEndian(dvDump.getArchitecture()) ? new BigEnd() : new LittleEnd();
        }
    }

    public byte[] readBytes(DvAddress dvAddress, long l) throws DvAddressException {
        long l2 = l;
        byte[] byArray = null;
        long l3 = dvAddress.getAddressAsLong();
        DvUtils.writetoTrace("SDFFAddressSpace.readBytes - reading " + l + " bytes from 0x" + Long.toHexString(l3));
        if (null == theMemRanges) {
            DvUtils.writetoTrace("SDFFAddressSpace.readBytes - theMemRanges is null");
        } else {
            boolean bl = false;
            if (4 == DvConsole.theDump.getSystemType()) {
                bl = true;
            }
            int n = this.findAddressRangeIndex(dvAddress);
            DvUtils.writetoTrace("SDFFAddressSpace.readBytes - Found a range at " + n);
            if (-1 != n) {
                int n2;
                long l4;
                long l5 = theMemRanges[n].addressStart().getAddressAsLong();
                long l6 = l4 = l3 - l5;
                int n3 = 0;
                int n4 = 0;
                if (bl) {
                    n4 = (int)(l4 / 4096L);
                    if (n4 > 0) {
                        l4 += (long)(64 * n4);
                    }
                    n3 = (int)(l4 + l2 - (long)(n4 * 4096)) / 4096;
                    l2 += (long)(n3 * 64);
                }
                try {
                    long l7 = theMemRanges[n].getOffset() + l4;
                    n2 = (int)l2;
                    long l8 = theMemRanges[n].length() - l4;
                    if (bl) {
                        l8 += 64L * (theMemRanges[n].length() / 4096L);
                    }
                    if (l2 > l8) {
                        n2 = (int)l8;
                    }
                    byArray = new byte[n2];
                    this.memoryFile.seek(l7);
                    this.memoryFile.read(byArray, 0, n2);
                    try {
                        if ((long)n2 < l2) {
                            DvAddress dvAddress2 = new DvAddress(dvAddress.getAddressAsLong());
                            dvAddress2.offsetBy(n2);
                            byte[] byArray2 = this.readBytes(dvAddress2, l - (long)n2);
                            if (byArray2 != null && byArray2.length > 0) {
                                byte[] byArray3 = new byte[n2 + byArray2.length];
                                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                                byArray = byArray3;
                                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (IOException iOException) {
                    DvUtils.trace("IOException trying to read from 0x:" + Long.toHexString(dvAddress.getAddressAsLong()) + " for length: " + l + " (0x" + Long.toHexString(l) + ")  " + "Use \"dis mem 0x" + Long.toHexString(dvAddress.getAddressAsLong()) + "," + l + "\" and dis mmap to analyse this failure", 0, true);
                }
                if (bl && n3 > 0) {
                    byte[] byArray4 = new byte[byArray.length];
                    int n5 = 0;
                    n2 = 0;
                    boolean bl2 = false;
                    int n6 = 0;
                    while (n6 < n3 + 1) {
                        int n7;
                        if (0 == n6) {
                            n7 = (int)(4096L - l6 % 4096L);
                            if (n7 > byArray.length) {
                                n7 = byArray.length;
                            }
                            System.arraycopy(byArray, 0, byArray4, 0, n7);
                            n2 = n7;
                            n5 = n7;
                        } else {
                            n7 = byArray.length - (n5 += 64);
                            if (n7 > 4096) {
                                n7 = 4096;
                            }
                            if (n7 > 0) {
                                System.arraycopy(byArray, n5, byArray4, n2, n7);
                            }
                            n2 += n7;
                            n5 += n7;
                        }
                        ++n6;
                    }
                    if ((long)byArray4.length > l) {
                        byte[] byArray5 = new byte[(int)l];
                        System.arraycopy(byArray4, 0, byArray5, 0, (int)l);
                        return byArray5;
                    }
                    return byArray4;
                }
            } else {
                throw new DvAddressException("Address 0x" + Long.toHexString(l3) + " was not found in the dump. " + " This could be symptomatic of a partial dump missing some valid" + " memory ranges or to a bad pointer stored in a control block. " + " This event has also been seen in dump taken during a GC cycle.\n");
            }
        }
        return byArray;
    }

    public DvMemRanges[] getMemRanges() {
        int n;
        DvMemRanges[] dvMemRangesArray;
        int n2;
        Vector<SDFFMemRanges> vector = new Vector<SDFFMemRanges>();
        int n3 = 0;
        if (null == theMemRanges && this.mmapOffset != -1L) {
            n3 = SDFFMemRanges.countThem(this.mmapOffset, this.mmapLength, this.sdffFile);
            n2 = 0;
            dvMemRangesArray = new SDFFMemRanges[n3];
            n = 0;
            int n4 = 0;
            while (n4 < n3) {
                dvMemRangesArray[n] = new SDFFMemRanges();
                ((SDFFMemRanges)dvMemRangesArray[n]).loadFromFile(this.mmapOffset, this.mmapLength, this.sdffFile, n4, n, (SDFFMemRanges[])dvMemRangesArray);
                if (0L != ((SDFFMemRanges)dvMemRangesArray[n]).memory_length) {
                    ++n2;
                    ++n;
                }
                ++n4;
            }
            if (n3 != n2) {
                theMemRanges = new SDFFMemRanges[n2];
                int n5 = 0;
                while (n5 < n2) {
                    SDFFAddressSpace.theMemRanges[n5] = dvMemRangesArray[n5];
                    ++n5;
                }
            } else {
                theMemRanges = dvMemRangesArray;
            }
        }
        n2 = 0;
        while (n2 < theMemRanges.length) {
            if ((long)this.arrayPosition == SDFFAddressSpace.theMemRanges[n2].as_id) {
                vector.add(theMemRanges[n2]);
            }
            ++n2;
        }
        dvMemRangesArray = null;
        if (vector.size() > 0) {
            dvMemRangesArray = new DvMemRanges[vector.size()];
            n = 0;
            while (n < vector.size()) {
                dvMemRangesArray[n] = (DvMemRanges)vector.get(n);
                ++n;
            }
        }
        return dvMemRangesArray;
    }

    public DvAddress createAddress(long l) {
        SDFFAddress sDFFAddress = new SDFFAddress();
        sDFFAddress.setAddress(l);
        return sDFFAddress;
    }

    public static SDFFAddressSpace[] loadFromFile(long l, long l2, long l3, long l4, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) {
        long l5 = l + SdffStd.getSize();
        boolean bl = false;
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[256];
        SDFFAddressSpace[] sDFFAddressSpaceArray = null;
        Object var34_13 = null;
        try {
            randomAccessFile.seek(l5);
            long l6 = randomAccessFile.readLong();
            DvUtils.writetoTrace("Count of address spaces is: " + l6);
            sDFFAddressSpaceArray = new SDFFAddressSpace[(int)l6];
            long l7 = randomAccessFile.getFilePointer();
            int n = 0;
            while ((long)n < l6) {
                if (n > 0) {
                    randomAccessFile.seek(l7);
                }
                long l8 = randomAccessFile.readLong();
                l7 += l8;
                DvUtils.writetoTrace("Length of address space (index " + n + ") is: " + l8);
                DvUtils.writetoTrace("Checking ADDRSPC eyecatcher @ offset " + randomAccessFile.getFilePointer());
                randomAccessFile.readFully(byArray);
                String string = new String(byArray);
                if (string.equals(SdffConstants.SEGMENT_Eye_SdffAs)) {
                    DvUtils.writetoTrace("ADDRSPC eyecatcher appears valid");
                } else {
                    DvUtils.errorMsg("ADDRSPC eyecatcher invalid\nFurther failures expected", 0);
                    bl = true;
                }
                if (!bl) {
                    long l9 = randomAccessFile.readLong();
                    DvUtils.writetoTrace("ADDRSPC id is: " + l9);
                    long l10 = randomAccessFile.readLong();
                    long l11 = randomAccessFile.getFilePointer();
                    long l12 = randomAccessFile.readLong();
                    if (randomAccessFile.readByte() != 80) {
                        randomAccessFile.seek(l11);
                        int n2 = randomAccessFile.readInt();
                        DvUtils.writetoTrace("There appear to be " + l10 + " processes and current process index is " + n2);
                        byte[] byArray5 = new byte[60];
                        randomAccessFile.read(byArray5);
                    } else {
                        DvUtils.writetoTrace("There appear to be " + l10 + " processes ");
                        randomAccessFile.seek(l11);
                    }
                    sDFFAddressSpaceArray[n] = new SDFFAddressSpace(l9, l10, l3, l4, randomAccessFile, randomAccessFile2, n);
                    long l13 = randomAccessFile.getFilePointer();
                    bl = SDFFAddressSpace.loadProcesses(l13, randomAccessFile, l10, sDFFAddressSpaceArray, n);
                    if (bl) {
                        DvUtils.writetoTrace("First pass at loadProcesses failed ... retry using different format ");
                        bl = SDFFAddressSpace.loadProcesses(l13 + 64L, randomAccessFile, l10, sDFFAddressSpaceArray, n);
                        if (bl) {
                            DvUtils.errorMsg("PROCESSS eyecatcher invalid\nFurther failures expected", 0);
                        }
                    }
                }
                DvUtils.writetoTrace("Finished with process (index=" + n + ")");
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("\nIOException caught in SDFFAddressSpace:loadFromFile");
        }
        return sDFFAddressSpaceArray;
    }

    public static int countThem(long l, RandomAccessFile randomAccessFile) {
        byte[] byArray = new byte[8];
        int n = 0;
        long l2 = l + SdffStd.getSize();
        try {
            randomAccessFile.seek(l2);
            n = (int)randomAccessFile.readLong();
            long l3 = randomAccessFile.readLong();
            randomAccessFile.readFully(byArray);
            String string = new String(byArray);
            if (!string.equals(SdffConstants.SEGMENT_Eye_SdffAs)) {
                DvUtils.errorMsg("ADDRSPC eyecatcher invalid", 0);
                n = 0;
            }
        }
        catch (IOException iOException) {
            System.out.println("\nIOException caught in SDFFAddressSpace:countThem");
            n = 0;
        }
        return n;
    }

    public DvProcess[] getProcesses() {
        DvProcess[] dvProcessArray = null;
        if (this.processes.size() != 0) {
            dvProcessArray = new DvProcess[this.processes.size()];
            int n = 0;
            while (n < this.processes.size()) {
                dvProcessArray[n] = (DvProcess)this.processes.elementAt(n);
                ++n;
            }
        }
        return dvProcessArray;
    }

    public String id() {
        return Long.toString(this.id);
    }

    public byte readByte(DvAddress dvAddress) throws DvAddressException {
        byte[] byArray = this.readBytes(dvAddress, 1L);
        if (null == byArray) {
            throw new DvAddressException("No range containing this address");
        }
        byte by = byArray[0];
        return by;
    }

    public short readShort(DvAddress dvAddress) throws DvAddressException {
        return (short)this.readNumeric(dvAddress, 2);
    }

    public int readInt(DvAddress dvAddress) throws DvAddressException {
        return (int)this.readNumeric(dvAddress, 4);
    }

    public long readLong(DvAddress dvAddress) throws DvAddressException {
        return this.readNumeric(dvAddress, 8);
    }

    public long readNumeric(DvAddress dvAddress, int n) throws DvAddressException {
        long l = 0L;
        byte[] byArray = this.readBytes(dvAddress, (long)n);
        l = this.endian.toLong(byArray, n);
        return l;
    }

    public DvAddress readPointer(DvAddress dvAddress) throws DvAddressException {
        long l = this.readNumeric(dvAddress, this.pointerSize);
        return new DvAddress(l);
    }

    public DvProcess getCurrentProcess() {
        int n = DvConsole.getCurrentProcessIndex();
        return (DvProcess)this.processes.get(n);
    }

    public boolean isValid(DvAddress dvAddress) {
        return this.findAddressRangeIndex(dvAddress) != -1;
    }

    private int findAddressRangeIndex(DvAddress dvAddress) {
        long l = 0L;
        int n = -1;
        long l2 = dvAddress.getAddressAsLong();
        if (null != theMemRanges) {
            int n2 = 0;
            while (n2 < startCache.length) {
                if (l2 >= startCache[n2] && l2 < endCache[n2]) {
                    int n3 = n2;
                    cacheHits[n3] = cacheHits[n3] + 1;
                    return rangeCache[n2];
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < theMemRanges.length && n == -1) {
                l = theMemRanges[n2].addressStart().getAddressAsLong();
                if (l2 >= l && l2 < l + theMemRanges[n2].length()) {
                    n = n2;
                    int n4 = Integer.MAX_VALUE;
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < startCache.length) {
                        if (cacheHits[n6] < n4) {
                            n5 = n6;
                            n4 = cacheHits[n6];
                        }
                        ++n6;
                    }
                    SDFFAddressSpace.startCache[n5] = l;
                    SDFFAddressSpace.endCache[n5] = l + theMemRanges[n].length();
                    SDFFAddressSpace.rangeCache[n5] = n;
                    SDFFAddressSpace.cacheHits[n5] = 1;
                }
                ++n2;
            }
        }
        return n;
    }

    private static boolean loadProcesses(long l, RandomAccessFile randomAccessFile, long l2, SDFFAddressSpace[] sDFFAddressSpaceArray, int n) {
        boolean bl = false;
        long l3 = l;
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[256];
        SDFFProcess sDFFProcess = null;
        try {
            randomAccessFile.seek(l3);
            int n2 = 0;
            while ((long)n2 < l2) {
                DvUtils.writetoTrace("Checking PROCESS with index " + n2);
                sDFFAddressSpaceArray[n].processes.clear();
                long l4 = randomAccessFile.readLong();
                DvUtils.writetoTrace("Process length is " + l4);
                DvUtils.writetoTrace("Checking PROCESS eyecatcher @ offset " + randomAccessFile.getFilePointer());
                randomAccessFile.readFully(byArray);
                String string = new String(byArray);
                if (string.equals(SdffConstants.SEGMENT_Eye_SdffProc)) {
                    DvUtils.writetoTrace("PROCESS eyecatcher is valid");
                } else {
                    bl = true;
                    n2 = (int)l2;
                }
                if (!bl) {
                    long l5 = randomAccessFile.readLong();
                    long l6 = randomAccessFile.readLong();
                    long l7 = randomAccessFile.readLong();
                    long l8 = randomAccessFile.readLong();
                    randomAccessFile.readFully(byArray2);
                    String string2 = new String(byArray2, "ASCII");
                    randomAccessFile.readFully(byArray3);
                    long l9 = randomAccessFile.readLong();
                    sDFFProcess = new SDFFProcess(l5, l6, l7, l8, string2, "command_line", l3, l4, randomAccessFile, sDFFAddressSpaceArray[n]);
                    sDFFAddressSpaceArray[n].processes.add(sDFFProcess);
                    l3 += l4;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            System.err.println("\nIOException caught in SDFFAddressSpace:loadProcesses");
            bl = true;
        }
        return bl;
    }

    public void printSdff(Sdff sdff, SDFFMemoryMap sDFFMemoryMap) throws IOException {
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.write(SdffConstants.SEGMENT_Eye_SdffAs.getBytes());
        sdff.writeLong(this.id);
        sdff.writeLong(this.processes.size());
        Enumeration enumeration = this.processes.elements();
        while (enumeration.hasMoreElements()) {
            SDFFProcess sDFFProcess = (SDFFProcess)enumeration.nextElement();
            sDFFProcess.printSdff(sdff, sDFFMemoryMap);
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }

    static {
        cacheHits = new int[20];
        rangeCache = new int[20];
        startCache = new long[20];
        endCache = new long[20];
    }
}

