/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.HprofContentHandler;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.IntegerArray;
import java.io.EOFException;
import java.io.InputStream;

public class HprofParser {
    static final int HPROF_UTF8 = 1;
    static final int HPROF_LOAD_CLASS = 2;
    static final int HPROF_UNLOAD_CLASS = 3;
    static final int HPROF_FRAME = 4;
    static final int HPROF_TRACE = 5;
    static final int HPROF_ALLOC_SITES = 6;
    static final int HPROF_START_THREAD = 10;
    static final int HPROF_END_THREAD = 11;
    static final int HPROF_HEAP_DUMP = 12;
    static final int HPROF_CONTROL_SETTINGS = 14;
    static final int HPROF_GC_ROOT_UNKNOWN = 255;
    static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    static final int HPROF_GC_ROOT_JNI_LOCAL = 2;
    static final int HPROF_GC_ROOT_JAVA_FRAME = 3;
    static final int HPROF_GC_ROOT_NATIVE_STACK = 4;
    static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    static final int HPROF_GC_ROOT_THREAD_BLOCK = 6;
    static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    static final int HPROF_GC_CLASS_DUMP = 32;
    static final int HPROF_GC_INSTANCE_DUMP = 33;
    static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    static final int HPROF_GC_PRIM_ARRAY_DUMP = 35;
    InputStream input;
    HprofContentHandler handler;
    int remainder;
    IntHashtable strings = new IntHashtable();
    int tag;
    int lastTag;

    HprofParser(HprofContentHandler hprofContentHandler, InputStream inputStream) throws Exception {
        this.setContentHandler(hprofContentHandler);
        try {
            this.parse(inputStream);
        }
        catch (EOFException eOFException) {
            System.out.println("Warning: unexpected EOF, dump may not be complete, tag " + this.tag + " prev tag " + this.lastTag);
        }
    }

    final int readInputByte() throws Exception {
        int n = this.input.read();
        if (n == -1) {
            throw new EOFException("Unexpected EOF");
        }
        return n;
    }

    void setContentHandler(HprofContentHandler hprofContentHandler) {
        this.handler = hprofContentHandler;
    }

    void parse(InputStream inputStream) throws Exception {
        this.input = inputStream;
        this.handler.header(this.readString());
        this.skip(4);
        this.skip(8);
        while (true) {
            this.tag = inputStream.read();
            if (this.tag == -1) {
                return;
            }
            this.skip(4);
            this.remainder = this.readInt();
            switch (this.tag) {
                case 12: {
                    int n;
                    this.handler.beginHeapDump();
                    while (this.remainder > 0) {
                        this.tag = this.readByte();
                        switch (this.tag) {
                            case 32: {
                                n = this.readInt();
                                this.skip(4);
                                int n2 = this.readInt();
                                this.skip(20);
                                int n3 = this.readInt();
                                int n4 = this.readShort();
                                int n5 = 0;
                                while (n5 < n4) {
                                    this.skip(2);
                                    int n6 = this.readByte();
                                    this.skip(1 << (n6 & 3));
                                    ++n5;
                                }
                                n4 = this.readShort();
                                IntegerArray integerArray = new IntegerArray();
                                int n7 = 0;
                                while (n7 < n4) {
                                    this.skip(4);
                                    int n8 = this.readByte();
                                    if (n8 == 2) {
                                        integerArray.add(this.readInt());
                                    } else {
                                        this.skip(1 << (n8 & 3));
                                    }
                                    ++n7;
                                }
                                n4 = this.readShort();
                                int[] nArray = new int[n4];
                                int n9 = 0;
                                while (n9 < n4) {
                                    this.skip(4);
                                    nArray[n9] = this.readByte();
                                    ++n9;
                                }
                                this.handler.classDump(n, n2, integerArray.toArray(), nArray);
                                break;
                            }
                            case 34: {
                                n = this.readInt();
                                this.skip(4);
                                int n2 = this.readInt();
                                int n3 = this.readInt();
                                int[] nArray = new int[n2];
                                int n5 = 0;
                                while (n5 < n2) {
                                    nArray[n5] = this.readInt();
                                    ++n5;
                                }
                                this.handler.objectArrayDump(n, n3, nArray);
                                break;
                            }
                            case 35: {
                                n = this.readInt();
                                this.skip(4);
                                int n2 = this.readInt();
                                int n3 = this.readByte();
                                this.skip(n2 * (1 << (n3 & 3)));
                                this.handler.primitiveArrayDump(n, n3, n2);
                                break;
                            }
                            case 33: {
                                n = this.readInt();
                                this.skip(4);
                                int n2 = this.readInt();
                                int n3 = this.readInt();
                                short[] sArray = new short[n3];
                                int n5 = 0;
                                while (n5 < n3) {
                                    sArray[n5] = (short)this.readByte();
                                    ++n5;
                                }
                                this.handler.instanceDump(n, n2, sArray);
                                break;
                            }
                            case 255: {
                                this.skip(4);
                                break;
                            }
                            case 1: {
                                this.skip(8);
                                break;
                            }
                            case 2: {
                                this.skip(12);
                                break;
                            }
                            case 3: {
                                this.skip(12);
                                break;
                            }
                            case 5: {
                                this.skip(4);
                                break;
                            }
                            case 6: {
                                this.skip(8);
                                break;
                            }
                            case 8: {
                                this.skip(12);
                                break;
                            }
                            case 4: {
                                this.skip(8);
                                break;
                            }
                            default: {
                                this.handler.error("Unknown heap dump tag: " + this.tag);
                                return;
                            }
                        }
                    }
                    this.handler.endHeapDump();
                    break;
                }
                case 1: {
                    int n = this.readInt();
                    String string = this.readString(this.remainder);
                    this.strings.put(n, (Object)string);
                    this.handler.utf8(n, string);
                    break;
                }
                case 2: {
                    this.skip(4);
                    int n = this.readInt();
                    this.skip(4);
                    int n10 = this.readInt();
                    String string = (String)this.strings.get(n10);
                    this.handler.loadClass(n, string);
                    break;
                }
                case 3: {
                    this.skip(4);
                    break;
                }
                case 14: {
                    this.skip(6);
                    break;
                }
                case 10: {
                    this.skip(24);
                    break;
                }
                case 11: {
                    this.skip(4);
                    break;
                }
                case 5: {
                    this.skip(4);
                    this.skip(4);
                    int n = this.readInt();
                    this.skip(n * 4);
                    break;
                }
                case 4: {
                    this.skip(24);
                    break;
                }
                case 6: {
                    this.skip(this.remainder);
                    break;
                }
                default: {
                    this.handler.error("Unknown tag: " + this.tag);
                    return;
                }
            }
            this.lastTag = this.tag;
        }
    }

    final String readString() throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.readInputByte()) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    final String readString(int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append((char)this.readInputByte());
            ++n2;
        }
        return stringBuffer.toString();
    }

    final int readInt() throws Exception {
        int n = this.readInputByte();
        int n2 = this.readInputByte();
        int n3 = this.readInputByte();
        int n4 = this.readInputByte();
        this.remainder -= 4;
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    final int readShort() throws Exception {
        int n = this.readInputByte();
        int n2 = this.readInputByte();
        this.remainder -= 2;
        return (n << 8) + n2;
    }

    final int readByte() throws Exception {
        int n = this.readInputByte();
        --this.remainder;
        return n;
    }

    final void skip(int n) throws Exception {
        this.remainder -= n;
        while (n > 0) {
            n = (int)((long)n - this.input.skip(n));
        }
    }
}

