/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CTypeFile;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.findroots.NullHandler;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.DumpReader;
import com.ibm.jvm.svcdump.Function;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.Page;
import com.ibm.jvm.svcdump.Ras;
import com.ibm.jvm.svcdump.StatHandler;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Row;
import com.ibm.jvm.util.html.Table;
import com.ibm.jvm.zseries.Engine;
import com.ibm.jvm.zseries.Instruction;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class Dump
extends DvDump {
    DumpReader dumpReader;
    AddressSpace[] spaces;
    AddressSpace[] validSpaces;
    static final int HEADERSIZE = 64;
    static final int BLOCKSIZE = 4160;
    static final int DR1 = -992349888;
    static final int DR2 = -992349632;
    boolean old;
    public static boolean verbose = false;
    public static boolean debug = false;
    static boolean printArgs = false;
    static boolean analyzeHeap = false;
    static boolean printAllocCache = false;
    static boolean printExceptionObject = false;
    static boolean disassemble = false;
    static int disassembleAddress;
    static int disassembleLength;
    static boolean dumpstorage;
    static int dumpstorageAddress;
    static int dumpstorageLength;
    static boolean dumpclasses;
    static boolean dumpnative;
    static boolean tcbsummary;
    static boolean verifysubpools;
    static boolean verifyheap;
    static boolean printdosed;
    static boolean heapstats;
    static boolean printroots;
    static boolean printversion;
    static boolean printtitle;
    static boolean printtime;
    static boolean dumpverbosegc;
    static int dumpclass;
    static int dumpobject;
    static boolean dumpproperties;
    static boolean dumpapars;
    static boolean dumpmdata;
    static int mdata;
    static boolean systrace;
    static boolean hpitrace;
    static boolean search;
    static int searchvalue;
    static int defaultJvm;
    static String dvDumpName;
    Document doc;
    Ras ras;
    int defaultAsid;
    AddressSpace defaultSpace;
    static boolean fromJFormat;
    boolean svcdump;
    int samplecaa;
    static int arrayLength;
    static int arrayCount;
    static int objectCount;
    static int reg;
    static int caa;
    static /* synthetic */ Class class$com$ibm$jvm$svcdump$Dump;

    public Dump() throws Exception {
        this(dvDumpName);
    }

    public String getSuffix() {
        String string = "sov";
        return string;
    }

    public static Boolean isSupportedSource(String string) {
        DvUtils.writetoTrace(" svcdump:isSupportedSource entry with " + string);
        dvDumpName = string;
        Boolean bl = new Boolean(Dump.validFile(new File(string)));
        if (bl.booleanValue()) {
            DvUtils.writetoTrace(" Dump recognised as svc dump");
        } else {
            DvUtils.writetoTrace(" Dump not recognised as svc dump");
        }
        DvUtils.writetoTrace(" svcdump:isSupportedSource exit ");
        return bl;
    }

    public DvAddressSpace[] getAddressSpaces() {
        return this.addressSpaces();
    }

    public DvAddressSpace getCurrentAddressSpace() {
        throw new Error("unimplemented method");
    }

    public int getArchitecture() {
        return 5;
    }

    public int getSystemType() {
        return 4;
    }

    public int getSubSystemType() {
        return 11;
    }

    public int getProcessor() {
        throw new Error("unimplemented method");
    }

    public int getProcessorSubType() {
        throw new Error("unimplemented method");
    }

    public int getCurrentProcessor() {
        throw new Error("unimplemented method");
    }

    public int getProcessorCount() {
        throw new Error("unimplemented method");
    }

    public byte[] getCTypedefs() {
        this.getRas();
        if (this.ras == null) {
            return null;
        }
        return this.ras.getCTypedefs();
    }

    public DvRas getRas() {
        if (this.ras == null) {
            AddressSpace addressSpace = this.getRasAddressSpace();
            if (addressSpace == null || addressSpace.jvmRasAddress == 0) {
                if (verbose) {
                    System.out.println("Warning: ras address is zero!");
                }
                return null;
            }
            if (verbose) {
                System.out.println("getRas");
            }
            try {
                int n;
                int n2 = addressSpace.readInt(addressSpace.jvmRasAddress);
                if (n2 != 1247169874) {
                    throw new Error("Unexpected jvm ras eyecatcher: " + Dump.hex(n2));
                }
                int n3 = addressSpace.readInt(addressSpace.jvmRasAddress + 24);
                if (n3 == 0) {
                    System.out.println("Bad jvm_ras_t:");
                    n = 0;
                    while (n < 13) {
                        System.out.println(Dump.hex(addressSpace.readInt(addressSpace.jvmRasAddress + n * 4)));
                        ++n;
                    }
                }
                Dump.Assert(n3 != 0);
                n = addressSpace.readInt(addressSpace.jvmRasAddress + 28);
                Dump.Assert(n < 65536);
                if (verbose) {
                    System.out.println("Creating Ras");
                }
                this.ras = new Ras(addressSpace, (long)n3, (long)n);
            }
            catch (Exception exception) {
                throw new Error("problem: " + exception);
            }
        }
        return this.ras;
    }

    boolean validBlock(int n) {
        if (n == -992349632) {
            this.old = false;
        } else if (n == -992349888) {
            this.old = true;
        } else {
            return false;
        }
        return true;
    }

    static boolean validFile(File file) {
        try {
            DumpReader dumpReader = new DumpReader(file);
            dumpReader.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static int maxBlocks(File file) {
        return (int)file.length() / 4160;
    }

    void scanFile() throws Exception {
        AddressSpace addressSpace = null;
        try {
            byte[] byArray = new byte[4160];
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (true) {
                this.dumpReader.read(byArray);
                int n2 = Dump.getInt(byArray, 0);
                if (!this.validBlock(n2)) {
                    throw new Error("No DR2 found at record " + n + " instead found " + Dump.hex(n2));
                }
                int n3 = Dump.getInt(byArray, 3);
                int n4 = Dump.getInt(byArray, this.old ? 5 : 6);
                addressSpace = this.getAddressSpace(n3);
                addressSpace.add(n4, n);
                if (addressSpace.jvmRasAddress == 0) {
                    int n5 = 0;
                    while (n5 < 1040) {
                        int n6 = Dump.getInt(byArray, n5);
                        if (!bl) {
                            if (n6 == 1247169874) {
                                bl = true;
                                if (verbose) {
                                    System.out.println("found ras eyecatcher 1 in block " + n + " offset " + n5);
                                }
                            }
                        } else if (!bl2) {
                            if (n6 == 1095958528) {
                                bl2 = true;
                                if (verbose) {
                                    System.out.println("found ras eyecatcher 2");
                                }
                            } else {
                                bl = false;
                            }
                        } else if (!bl3) {
                            if (n6 == -1437226411) {
                                bl3 = true;
                                if (verbose) {
                                    System.out.println("found ras eyecatcher 3");
                                }
                            } else {
                                bl2 = false;
                                bl = false;
                            }
                        } else {
                            if (n6 == -1437226411) {
                                if (verbose) {
                                    System.out.println("found ras eyecatcher 4");
                                }
                                addressSpace.setJvmRasAddress(n4 + ((n5 << 2) - 64 - 12));
                            }
                            bl3 = false;
                            bl2 = false;
                            bl = false;
                        }
                        ++n5;
                    }
                }
                ++n;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public Dump(String string) throws Exception {
        block17: {
            Closeable closeable;
            Object object;
            this.spaces = new AddressSpace[0];
            this.doc = new Document();
            this.defaultAsid = -1;
            this.svcdump = true;
            this.samplecaa = 0;
            this.doc.setPlainText(!SvcdumpProperties.getBooleanProperty("svcdump.output.html", false));
            this.dumpReader = new DumpReader(string);
            try {
                object = new FileInputStream(string + ".cache");
                closeable = new ObjectInputStream((InputStream)object);
                this.spaces = (AddressSpace[])((ObjectInputStream)closeable).readObject();
                ((ObjectInputStream)closeable).close();
            }
            catch (Exception exception) {
                closeable = new FileOutputStream(string + ".cache");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)closeable);
                this.scanFile();
                objectOutputStream.writeObject(this.spaces);
                objectOutputStream.close();
            }
            object = null;
            if (debug) {
                this.doc.println("finished scanning dump");
            }
            int n = 0;
            while (n < this.spaces.length) {
                this.spaces[n].dump = this;
                this.spaces[n].sort();
                ++n;
            }
            int n2 = 0;
            while (n2 < this.spaces.length) {
                block16: {
                    object = this.spaces[n2];
                    try {
                        int n3 = ((AddressSpace)object).readInt(548L);
                        if (debug) {
                            this.doc.println("asid = " + object + ", psaaold = " + Dump.hex(n3));
                        }
                        try {
                            int n4 = ((AddressSpace)object).readInt(n3 + 108);
                            if (((AddressSpace)object).id == 1) {
                                if (debug) {
                                    this.doc.println("ascb = " + Dump.hex(n4));
                                }
                                AddressSpace.ascbasxb = n4;
                                AddressSpace.root = object;
                            }
                        }
                        catch (Exception exception) {
                            if (debug) {
                                this.doc.println("inner failed for " + ((AddressSpace)object).hexId() + " psaaold " + Dump.hex(n3) + " psaanew " + Dump.hex(((AddressSpace)object).readInt(544L)));
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!debug) break block16;
                        this.doc.println("outer failed for " + ((AddressSpace)object).hexId() + ": " + exception);
                    }
                }
                ++n2;
            }
            this.defaultAsid = SvcdumpProperties.getIntProperty("svcdump.default.asid", -1, 16);
            defaultJvm = SvcdumpProperties.getIntProperty("svcdump.default.jvm", -1);
            try {
                byte[] byArray = this.getCTypedefs();
                if (byArray != null) {
                    new CTypeFile(byArray);
                }
            }
            catch (Throwable throwable) {
                if (!debug) break block17;
                System.out.println("Warning, problem getting typedefs!");
                throwable.printStackTrace(System.out);
            }
        }
    }

    static int getInt(byte[] byArray, int n) {
        int n2 = byArray[n <<= 2] << 24;
        int n3 = byArray[n + 1] << 16 & 0xFFFFFF;
        int n4 = byArray[n + 2] << 8 & 0xFFFF;
        int n5 = byArray[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    void seek(int n) throws IOException {
        this.dumpReader.seek(n);
    }

    AddressSpace getAddressSpace(int n) {
        AddressSpace addressSpace;
        int n2 = 0;
        while (n2 < this.spaces.length) {
            addressSpace = this.spaces[n2];
            if (addressSpace.id == n) {
                return addressSpace;
            }
            ++n2;
        }
        AddressSpace[] addressSpaceArray = new AddressSpace[this.spaces.length + 1];
        System.arraycopy(this.spaces, 0, addressSpaceArray, 0, this.spaces.length);
        addressSpaceArray[this.spaces.length] = addressSpace = new AddressSpace(this, n);
        this.spaces = addressSpaceArray;
        return addressSpace;
    }

    public int[] readBlock() throws IOException {
        int[] nArray = new int[1024];
        byte[] byArray = new byte[4160];
        this.dumpReader.read(byArray);
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = Dump.getInt(byArray, n + 16);
            ++n;
        }
        return nArray;
    }

    static String hex(int n, int n2) {
        String string = Integer.toHexString(n);
        int n3 = string.length();
        while (n3 < n2) {
            string = "0" + string;
            ++n3;
        }
        return string;
    }

    public static String hex(int n) {
        return Dump.hex(n, 8);
    }

    static byte fix(int n) {
        int n2 = n & 0xFF;
        if (n2 < 64 || n2 > 64 && n2 < 75 || n2 > 80 && n2 < 90 || n2 > 97 && n2 < 106 || n2 > 111 && n2 < 121 || n2 > 169 && n2 < 188 || n2 > 249) {
            n2 = 64;
        }
        byte by = (byte)n2;
        return by;
    }

    public static String ebcdic(int n) {
        byte[] byArray = new byte[]{Dump.fix(n >> 24), Dump.fix(n >> 16), Dump.fix(n >> 8), Dump.fix(n >> 0)};
        return Dump.getEbcdicString(byArray);
    }

    public final boolean isEbcdic(short s) {
        return (s = (short)(s | 0x40)) >= 193 && s <= 201 || s >= 209 && s <= 217 || s >= 162 && s <= 169 || s >= 240 && s <= 249;
    }

    public final boolean isEbcdic(int n) {
        short s = (short)(n & 0xFF);
        short s2 = (short)(n >> 8 & 0xFF);
        short s3 = (short)(n >> 16 & 0xFF);
        short s4 = (short)(n >> 24 & 0xFF);
        return this.isEbcdic(s) && this.isEbcdic(s2) && this.isEbcdic(s3) && this.isEbcdic(s4);
    }

    public AddressSpace[] addressSpaces() {
        if (this.validSpaces != null) {
            return this.validSpaces;
        }
        Vector<AddressSpace> vector = new Vector<AddressSpace>();
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            Tcb[] tcbArray = addressSpace.tcbs();
            if (tcbArray != null) {
                vector.add(addressSpace);
            }
            ++n;
        }
        this.validSpaces = vector.toArray(new AddressSpace[1]);
        Arrays.sort(this.validSpaces, new Comparator(){

            public int compare(Object object, Object object2) {
                AddressSpace addressSpace = (AddressSpace)object;
                AddressSpace addressSpace2 = (AddressSpace)object2;
                return addressSpace2.tcbs().length - addressSpace.tcbs().length;
            }
        });
        return this.validSpaces;
    }

    /*
     * Unable to fully structure code
     */
    public void processTrace(AddressSpace var1_1) throws Exception {
        if (Dump.debug) {
            this.doc.println("found trace in asid 0x" + var1_1.hexId());
        }
        var2_2 = var1_1.addresses.get(0);
        var3_3 = var1_1.readUnsignedShort(var2_2 + 28);
        var4_4 = var1_1.readInt(var2_2 + 32);
        var5_5 = var4_4 >> 16;
        var7_6 = var5_5 <<= 48;
        var9_7 = null;
        var10_8 = 0;
        while (var10_8 < var3_3) {
            if (Dump.debug) {
                this.doc.println("*** processor " + var10_8 + " trace table ***");
            }
            var11_9 = var2_2 + 56 + var10_8 * 8;
            var12_10 = var1_1.readUnsignedShort(var11_9);
            var13_11 = var1_1.readInt(var11_9 + 4);
            var14_12 = 0;
            var15_13 = 0;
            while (var15_13 < var12_10) {
                var16_14 = var1_1.readUnsignedShort(var13_11 + var15_13 * 40 + 8);
                if (Dump.debug) {
                    this.doc.println("*** doing buffer section " + var15_13 + " flags " + Dump.hex(var16_14));
                }
                var17_15 = var1_1.readInt(var13_11 + var15_13 * 40);
                var18_16 = var1_1.readInt(var13_11 + var15_13 * 40 + 4);
                var19_17 = 0;
                var20_18 = var17_15;
                while (var20_18 < var17_15 + var18_16) {
                    block44: {
                        block45: {
                            block43: {
                                var21_19 = var1_1.readUnsignedByte(var20_18);
                                if (var21_19 >= 112) break block43;
                                switch (var21_19) {
                                    case 33: {
                                        var19_17 = 8;
                                        break;
                                    }
                                    case 50: {
                                        var19_17 = 12;
                                        break;
                                    }
                                    case 49: {
                                        var19_17 = 8;
                                        break;
                                    }
                                    case 16: {
                                        var19_17 = 4;
                                        break;
                                    }
                                    default: {
                                        if (var21_19 != 0 && Dump.debug) {
                                            this.doc.println("!!! unknown id " + Dump.hex(var21_19));
                                        }
                                        var19_17 = 4;
                                        break;
                                    }
                                }
                                break block44;
                            }
                            if (var21_19 < 128) break block45;
                            var22_20 = var1_1.readInt(var20_18);
                            var19_17 = 4;
                            if (var9_7 != null) {
                                if (Dump.debug) {
                                    this.doc.println("found branch " + Dump.hex(var22_20) + " in asid " + var9_7.hexId());
                                }
                                var9_7.addTraceEntry(0, null, var22_20, var14_12, ++var7_6);
                            }
                            break block44;
                        }
                        var22_20 = var1_1.readUnsignedShort(var20_18 + 10);
                        var14_12 = var1_1.readInt(var20_18 + 12);
                        var23_21 = var1_1.readUnsignedShort(var20_18 + 18);
                        var24_22 = var1_1.readInt(var20_18 + 28);
                        var19_17 = 16 + (var21_19 & 15) * 4;
                        var25_23 = "unknown";
                        switch (var22_20) {
                            case 1: {
                                var25_23 = "SSCH";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 3: {
                                var25_23 = "EXT";
                                break;
                            }
                            case 5: {
                                var25_23 = "SVC";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 7: {
                                var25_23 = "PGM";
                                var24_22 = var1_1.readInt(var20_18 + 40);
                                break;
                            }
                            case 11: {
                                var25_23 = "I/O";
                                break;
                            }
                            case 15: {
                                var25_23 = "DSP";
                                break;
                            }
                            case 25: {
                                var25_23 = "SUSP";
                                var24_22 = var1_1.readInt(var20_18 + 20);
                                break;
                            }
                            case 127: {
                                var25_23 = "USR";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 259: {
                                var25_23 = "EMS";
                                break;
                            }
                            case 261: {
                                var25_23 = "SVCR";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 271: {
                                var25_23 = "SRB";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 517: {
                                var25_23 = "SSRV";
                                var24_22 = var1_1.readInt(var20_18 + 20);
                                break;
                            }
                            case 527: {
                                var25_23 = "SSRB";
                                break;
                            }
                            case 771: {
                                var25_23 = "CALL";
                                break;
                            }
                            case 1025: {
                                var25_23 = "RSCH";
                                var24_22 = var1_1.readInt(var20_18 + 24);
                                break;
                            }
                            case 1027: {
                                var25_23 = "CLKC";
                                break;
                            }
                            case 3855: {
                                var25_23 = "WAIT";
                                var24_22 = var1_1.readInt(var20_18 + 20);
                                break block44;
                            }
                            default: {
                                if (Dump.debug) {
                                    this.doc.println("unknown type " + Dump.hex(var22_20) + " id " + Dump.hex(var21_19));
                                }
                                var25_23 = "UNKNOWN";
                                var24_22 = var22_20;
                                break block44;
                            }
                        }
                        if (Dump.debug) {
                            // empty if block
                        }
                        if (var24_22 != 0 && (var24_22 & 1) == 1 && Dump.debug) {
                            this.doc.println("found dodgy " + var25_23 + ", tcb = " + Dump.hex(var14_12) + " asid = " + Dump.hex(var23_21) + " psw = " + Dump.hex(var24_22));
                        }
                        if (var9_7 != null && var9_7.id == var23_21) ** GOTO lbl-1000
                        var26_24 = 0;
                        while (var26_24 < this.spaces.length) {
                            var27_26 = this.spaces[var26_24];
                            if (var27_26.id == var23_21) {
                                var9_7 = var27_26;
                                break;
                            }
                            ++var26_24;
                        }
                        if (var26_24 == this.spaces.length) {
                            var9_7 = null;
                            if (Dump.debug) {
                                this.doc.println("Warning: could not locate asid " + Dump.hex(var23_21));
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            var26_25 = 0L;
                            var28_27 = 0;
                            while (var28_27 < 6) {
                                var26_25 <<= 8;
                                var26_25 |= (long)var1_1.readUnsignedByte(var20_18 + 2 + var28_27);
                                ++var28_27;
                            }
                            var9_7.addTraceEntry(var22_20, var25_23, var24_22, var14_12, var26_25 |= var5_5);
                            var7_6 = var26_25;
                        }
                    }
                    var20_18 += var19_17;
                }
                ++var15_13;
            }
            ++var10_8;
        }
    }

    private void printTrace(Function[] functionArray) {
        Table table = new Table(new String[]{"Count", "Function"});
        int n = 0;
        while (n < functionArray.length) {
            Function function = functionArray[n];
            table.addRow(new String[]{"" + function.entryCount, function.name});
            ++n;
        }
        this.doc.addElement(table);
    }

    static final int arrayLength(int n, int n2) {
        int n3 = n >> 3;
        int n4 = 1 << (n3 & 3);
        n4 *= n2;
        return n4 += 8;
    }

    static void usage() {
        Document document = new Document();
        document.setPlainText(true);
        document.println("");
        document.println("Usage: java com.ibm.jvm.svcdump.Dump [options] <filename>");
        document.println("");
        Table table = new Table("Option", "Description");
        table.addRow("-debug", "print internal debugging info");
        table.addRow("-verbose", "print extra info");
        table.addRow("-heap", "print a table showing which classes have the most objects allocated");
        table.addRow("-cache", "print alloc cache");
        table.addRow("-exception", "print old exception objects");
        table.addRow("-dis <addr> <n>", "disassemble <n> instructions starting at <addr> (hex)");
        table.addRow("-dump <addr> <n>", "dump <n> words of storage starting at <addr> (hex)");
        table.addRow("-dumpapars", "print the apars installed");
        table.addRow("-dumpclasses", "print info about all classes");
        table.addRow("-dumpclass <addr>", "print info about class at given address");
        table.addRow("-dumpobject <addr>", "print info about object at given address");
        table.addRow("-dumpmdata <addr>", "print info about mdata at given address");
        table.addRow("-dumpprops", "print the system properties");
        table.addRow("-dumpnative", "dump all the native methods");
        table.addRow("-dumpverbosegc", "dump the verbosegc");
        table.addRow("-heapstats", "print stats about heap usage");
        table.addRow("-tcbsummary", "print a summary of what the tcbs are doing");
        table.addRow("-systrace", "print the system trace");
        table.addRow("-hpitrace", "print the hpi trace");
        table.addRow("-caa <addr>", "specify the caa to use when disassembling");
        table.addRow("-r<n>", "include saved register <n> in stack trace");
        table.addRow("-args", "print first four function arguments");
        table.addRow("-verifysubpools", "verify subpools");
        table.addRow("-verifyheap", "verify heap");
        table.addRow("-printdosed", "print pinned and dosed objects");
        table.addRow("-printroots", "print GC roots");
        table.addRow("-version", "print the version and exit");
        table.addRow("-fullversion", "print the version of the jvm in the dump and exit");
        table.addRow("-title", "print title of the dump and exit");
        table.addRow("-time", "print time of the dump and exit");
        document.addElement(table);
        document.println("");
        document.println("Visit http://w3.hursley.ibm.com/~dgriff for more info");
        document.println("");
        if (Dump.isFromJFormat()) {
            document.setPlainText(true);
        }
        document.close();
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (stringArray.length == 0) {
            Dump.usage();
        }
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            object3 = stringArray[n];
            if (((String)object3).startsWith("-")) {
                if (((String)object3).equals("-verbose")) {
                    verbose = true;
                } else if (((String)object3).equals("-debug")) {
                    debug = true;
                    verbose = true;
                } else if (((String)object3).equals("-xxxhelp")) {
                    int n2;
                    object2 = (class$com$ibm$jvm$svcdump$Dump == null ? Dump.class$("com.ibm.jvm.svcdump.Dump") : class$com$ibm$jvm$svcdump$Dump).getResourceAsStream("help.html");
                    while ((n2 = ((InputStream)object2).read()) != -1) {
                        System.out.print((char)n2);
                    }
                    System.exit(0);
                } else if (((String)object3).equals("-dumpapars")) {
                    dumpapars = true;
                } else if (((String)object3).equals("-dumpprops")) {
                    dumpproperties = true;
                } else if (((String)object3).equals("-dumpmdata")) {
                    dumpmdata = true;
                    mdata = SvcdumpProperties.parseInt(stringArray[n + 1], 16);
                    ++n;
                } else if (((String)object3).equals("-search")) {
                    search = true;
                    searchvalue = SvcdumpProperties.parseInt(stringArray[n + 1], 16);
                    ++n;
                } else if (((String)object3).equals("-systrace")) {
                    systrace = true;
                } else if (((String)object3).equals("-hpitrace")) {
                    hpitrace = true;
                } else if (((String)object3).equals("-version")) {
                    try {
                        object2 = (class$com$ibm$jvm$svcdump$Dump == null ? Dump.class$("com.ibm.jvm.svcdump.Dump") : class$com$ibm$jvm$svcdump$Dump).getResource("Dump.class");
                        URLConnection uRLConnection = ((URL)object2).openConnection();
                        object = new Date(uRLConnection.getLastModified());
                        System.out.println("");
                        System.out.println("You are using");
                        System.out.println("");
                        System.out.println("" + object2);
                        System.out.println("");
                        System.out.println("which was last modified on");
                        System.out.println("");
                        System.out.println("" + object);
                        System.out.println("");
                    }
                    catch (Exception exception) {
                        System.out.println("Unexpected exception: " + exception);
                    }
                    System.exit(0);
                } else if (((String)object3).equals("-dumpverbosegc")) {
                    dumpverbosegc = true;
                } else if (((String)object3).equals("-time")) {
                    printtime = true;
                } else if (((String)object3).equals("-title")) {
                    printtitle = true;
                } else if (((String)object3).equals("-fullversion")) {
                    printversion = true;
                } else if (((String)object3).equals("-verifysubpools")) {
                    verifysubpools = true;
                } else if (((String)object3).equals("-verifyheap")) {
                    verifyheap = true;
                } else if (((String)object3).equals("-printdosed")) {
                    printdosed = true;
                } else if (((String)object3).equals("-heapstats")) {
                    heapstats = true;
                } else if (((String)object3).equals("-printroots")) {
                    printroots = true;
                } else if (((String)object3).equals("-dumpclasses")) {
                    dumpclasses = true;
                } else if (((String)object3).equals("-dumpnative")) {
                    dumpnative = true;
                } else if (((String)object3).equals("-tcbsummary")) {
                    tcbsummary = true;
                } else if (((String)object3).equals("-dumpclass")) {
                    dumpclass = SvcdumpProperties.parseInt(stringArray[n + 1], 16);
                    ++n;
                } else if (((String)object3).equals("-dumpobject")) {
                    dumpobject = SvcdumpProperties.parseInt(stringArray[n + 1], 16);
                    ++n;
                } else if (((String)object3).equals("-heap")) {
                    analyzeHeap = true;
                } else if (((String)object3).equals("-cache")) {
                    printAllocCache = true;
                } else if (((String)object3).equals("-exception")) {
                    printExceptionObject = true;
                } else if (((String)object3).equals("-args")) {
                    printArgs = true;
                } else if (((String)object3).startsWith("-r")) {
                    reg = Integer.parseInt(((String)object3).substring(2));
                } else if (((String)object3).equals("-dis")) {
                    disassemble = true;
                    disassembleAddress = SvcdumpProperties.parseInt(stringArray[n + 1], 16);
                    disassembleLength = SvcdumpProperties.parseInt(stringArray[n + 2]);
                    n += 2;
                } else if (((String)object3).equals("-dump")) {
                    dumpstorage = true;
                    dumpstorageAddress = SvcdumpProperties.parseInt(stringArray[n + 1], 16);
                    dumpstorageLength = SvcdumpProperties.parseInt(stringArray[n + 2]);
                    n += 2;
                } else if (((String)object3).equals("-caa")) {
                    caa = SvcdumpProperties.parseInt(stringArray[n + 1], 16);
                    ++n;
                } else {
                    Dump.usage();
                }
            } else {
                string = object3;
            }
            ++n;
        }
        object3 = null;
        if (heapstats && stringArray.length == 1) {
            object2 = null;
            try {
                File file = new File(".");
                object = file.list();
                int n3 = 0;
                while (n3 < ((String[])object).length) {
                    boolean bl = false;
                    object2 = object[n3];
                    if (Dump.validFile(new File((String)object2))) {
                        System.out.println("Processing " + (String)object2);
                        try {
                            object3 = new Dump((String)object2);
                            ((Dump)object3).heapstats();
                        }
                        catch (Throwable throwable) {
                            System.out.println("Problem opening dump " + (String)object2 + ": " + throwable);
                            throwable.printStackTrace();
                        }
                    }
                    if (bl) {
                        System.out.println("Zipping " + (String)object2);
                        try {
                            Runtime.getRuntime().exec("sh ./zipper " + (String)object2).waitFor();
                        }
                        catch (Exception exception) {
                            System.out.println("Unexpected exception zipping " + (String)object2 + ": " + exception);
                        }
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {
                System.out.println("Problem opening dump " + object2 + ": " + exception);
                return;
            }
            return;
        }
        try {
            object3 = new Dump(string);
        }
        catch (Exception exception) {
            System.out.println("Problem opening dump " + string + ": " + exception);
            return;
        }
        if (disassemble) {
            ((Dump)object3).disassemble();
        } else if (dumpstorage) {
            ((Dump)object3).dumpstorage();
        } else if (tcbsummary) {
            ((Dump)object3).tcbsummary();
        } else if (dumpnative) {
            ((Dump)object3).dumpnative();
        } else if (dumpclasses) {
            ((Dump)object3).dumpclasses();
        } else if (verifysubpools) {
            ((Dump)object3).verifysubpools();
        } else if (verifyheap) {
            ((Dump)object3).verifyheap();
        } else if (printdosed) {
            ((Dump)object3).printdosed();
        } else if (heapstats) {
            ((Dump)object3).heapstats();
        } else if (printroots) {
            ((Dump)object3).printroots();
        } else if (printtime) {
            ((Dump)object3).printtime();
        } else if (printtitle) {
            ((Dump)object3).printtitle();
        } else if (printversion) {
            ((Dump)object3).printversion();
        } else if (dumpverbosegc) {
            ((Dump)object3).dumpverbosegc();
        } else if (dumpclass != 0) {
            ((Dump)object3).dumpclass(dumpclass);
        } else if (dumpobject != 0) {
            ((Dump)object3).dumpobject(dumpobject);
        } else if (dumpapars) {
            ((Dump)object3).dumpapars();
        } else if (dumpproperties) {
            ((Dump)object3).dumpproperties();
        } else if (dumpmdata) {
            ((Dump)object3).dumpmdata(mdata);
        } else if (systrace) {
            ((Dump)object3).systrace();
        } else if (hpitrace) {
            ((Dump)object3).hpitrace();
        } else if (search) {
            ((Dump)object3).search();
        } else {
            ((Dump)object3).doStuff();
        }
        ((Dump)object3).flush();
    }

    void flush() {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.close();
    }

    public AddressSpace getDefaultAddressSpace() {
        int n;
        if (this.defaultSpace != null) {
            return this.defaultSpace;
        }
        if (this.defaultAsid != -1) {
            n = 0;
            while (n < this.spaces.length) {
                if (this.spaces[n].id == this.defaultAsid) {
                    this.defaultSpace = this.spaces[n];
                    return this.spaces[n];
                }
                ++n;
            }
            System.out.println("Warning: could not find default asid " + Dump.hex(this.defaultAsid));
        }
        n = 0;
        int n2 = 0;
        while (n2 < this.spaces.length) {
            if (this.spaces[n2].isJava()) {
                ++n;
                this.defaultSpace = this.spaces[n2];
                if (debug) {
                    System.out.println("found java asid " + this.spaces[n2]);
                }
            }
            ++n2;
        }
        if (n == 0) {
            throw new Error("Could not find a Java address space!");
        }
        if (n > 1) {
            System.out.println("Warning: more than one java address space found:");
            int n3 = 0;
            while (n3 < this.spaces.length) {
                if (this.spaces[n3].isJava()) {
                    System.out.println("    asid = " + this.spaces[n3]);
                }
                ++n3;
            }
            System.out.println("You can use the svcdump.default.asid property to specify");
            System.out.println("which one you want to use (or use the jformat set asid command).");
            System.out.println("Using " + this.defaultSpace + " as default");
            System.out.println("See http://w3.hursley.ibm.com/~dgriff/ for more details");
            System.out.println("");
        }
        return this.defaultSpace;
    }

    AddressSpace getRasAddressSpace() {
        int n = 0;
        while (n < this.spaces.length) {
            if (this.spaces[n].jvmRasAddress != 0) {
                return this.spaces[n];
            }
            ++n;
        }
        return null;
    }

    public Jvm getDefaultJvm() {
        Jvm[] jvmArray = this.getDefaultAddressSpace().jvms();
        if (jvmArray.length == 1) {
            return jvmArray[0];
        }
        if (defaultJvm == -1) {
            if (heapstats) {
                return jvmArray[0];
            }
            System.err.println("More than one Jvm found in asid " + this.getDefaultAddressSpace());
            System.err.println("please use the system property -Dsvcdump.default.jvm to choose one from the following list:");
            int n = 0;
            while (n < jvmArray.length) {
                System.err.println("    " + n + "    " + jvmArray[n]);
                ++n;
            }
            System.exit(1);
        }
        if (defaultJvm > jvmArray.length) {
            System.err.println("The number " + defaultJvm + " is out of range. Needs to be from 0 to " + (jvmArray.length - 1));
            System.exit(1);
        }
        return jvmArray[defaultJvm];
    }

    public void disassemble() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        System.out.println("Disassembly starting at 0x" + Dump.hex(disassembleAddress));
        AddressSpace addressSpace = this.getDefaultAddressSpace();
        Engine engine = new Engine(addressSpace);
        if (caa == 0) {
            Instruction[] instructionArray = engine.disassemble(this.doc, disassembleAddress, disassembleLength);
        } else {
            Instruction[] instructionArray = engine.disassemble(this.doc, disassembleAddress, disassembleLength, caa);
        }
    }

    public void dumpapars() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        AddressSpace addressSpace = this.getDefaultAddressSpace();
        System.out.println("");
        System.out.println("This is the dump of the APARS in the default asid " + addressSpace);
        System.out.println("It is produced by scanning the dump for strings that look");
        System.out.println("like \"UWnnnnn.BPXINLPA\". Obviously this is not ideal so if");
        System.out.println("you know a better way please drop me a line!");
        System.out.println("");
        String[] stringArray = new String[]{"UW95333", "UW95334", "UW95335", "UW95336"};
        boolean bl = false;
        int n = 0;
        while (true) {
            try {
                n = addressSpace.search(n, -1026037815);
                if (n == -1) break;
                int n2 = addressSpace.readInt(n - 8);
                int n3 = addressSpace.readInt(n + 4);
                if (n3 == -707536959 && (n2 & 0xFFFF0000) == -454688768) {
                    byte[] byArray = new byte[7];
                    int n4 = 0;
                    while (n4 < byArray.length) {
                        byArray[n4] = addressSpace.readByte(n - 8 + n4);
                        ++n4;
                    }
                    String string = Dump.getEbcdicString(byArray);
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        if (string.equals(stringArray[n5])) {
                            bl = true;
                        }
                        ++n5;
                    }
                    System.out.println("    " + string);
                }
            }
            catch (Exception exception) {
                throw new Error("Unexpected exception: " + exception);
            }
            n += 4;
        }
        System.out.println("");
        if (!bl) {
            System.out.println("Warning! APAR OW54362 not found. This can cause pthread_quiesce failures.");
            System.out.println("");
        }
    }

    public void dumpstorage() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.println("Storage dump starting at 0x" + Dump.hex(dumpstorageAddress));
        AddressSpace addressSpace = this.getDefaultAddressSpace();
        if (dumpstorageLength == 0) {
            this.doc.println(addressSpace.readString(dumpstorageAddress));
        } else {
            int n = 0;
            while (n < dumpstorageLength) {
                int n2 = dumpstorageAddress + (n << 2);
                this.doc.println("0x" + Dump.hex(n2) + ": 0x" + Dump.hex(addressSpace.readInt(n2)));
                ++n;
            }
        }
    }

    public void dumpclasses() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Dump of all classes in asid " + jvm.space.hexId());
        try {
            jvm.dumpClasses(this.doc, new NullHandler());
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void verifysubpools() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Verifying subpools in asid " + jvm.space.hexId());
        try {
            jvm.verifysubpools();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void verifyheap() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Verifying heap in asid " + jvm.space.hexId() + " jvmp " + jvm);
        try {
            jvm.verifyheap();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void printdosed() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Print dosed/pinned in asid " + jvm.space.hexId() + " jvmp " + jvm);
        try {
            jvm.printdosed();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void heapstats() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Print heap stats in asid " + jvm.space.hexId() + " jvmp " + jvm);
        try {
            StatHandler statHandler = new StatHandler(jvm.space);
            jvm.handler = statHandler;
            jvm.analyze131Heap();
            System.out.println("objects = " + statHandler.objects);
            System.out.println("classes = " + statHandler.classes);
            System.out.println("objectarrays = " + statHandler.objectarrays);
            System.out.println("primarrays = " + statHandler.primarrays);
            System.out.println("strings = " + statHandler.strings);
            System.out.println("smallid = " + statHandler.smallid);
            System.out.println("mediumid = " + statHandler.mediumid);
            System.out.println("largeid = " + statHandler.largeid);
            System.out.println("smallrefs = " + statHandler.smallrefs);
            System.out.println("mediumrefs = " + statHandler.mediumrefs);
            System.out.println("largerefs = " + statHandler.largerefs);
            System.out.println("smallsize = " + statHandler.smallsize);
            System.out.println("mediumsize = " + statHandler.mediumsize);
            System.out.println("largesize = " + statHandler.largesize);
            int n = 0;
            while (n < statHandler.refcounts.length) {
                System.out.println("refs[" + n + "] = " + statHandler.refcounts[n]);
                ++n;
            }
            System.out.println("cachehits = " + statHandler.cachehits);
            System.out.println("cachemisses = " + statHandler.cachemisses);
            System.out.println("fithits = " + statHandler.fithits);
            System.out.println("fitmisses = " + statHandler.fitmisses);
            System.out.println("oldsize = " + statHandler.oldsize);
            System.out.println("newsize = " + statHandler.newsize);
            System.out.println("hashed = " + statHandler.hashed);
            StatHandler.totalobjects += statHandler.objects;
            StatHandler.totalclasses += statHandler.classes;
            StatHandler.totalobjectarrays += statHandler.objectarrays;
            StatHandler.totalprimarrays += statHandler.primarrays;
            StatHandler.totalstrings += statHandler.strings;
            StatHandler.totalsmallid += statHandler.smallid;
            StatHandler.totalmediumid += statHandler.mediumid;
            StatHandler.totallargeid += statHandler.largeid;
            StatHandler.totalsmallrefs += statHandler.smallrefs;
            StatHandler.totalmediumrefs += statHandler.mediumrefs;
            StatHandler.totallargerefs += statHandler.largerefs;
            StatHandler.totalsmallsize += statHandler.smallsize;
            StatHandler.totalmediumsize += statHandler.mediumsize;
            StatHandler.totallargesize += statHandler.largesize;
            int n2 = 0;
            while (n2 < statHandler.refcounts.length) {
                int n3 = n2;
                StatHandler.totalrefcounts[n3] = StatHandler.totalrefcounts[n3] + statHandler.refcounts[n2];
                ++n2;
            }
            StatHandler.totalcachehits += statHandler.cachehits;
            StatHandler.totalcachemisses += statHandler.cachemisses;
            StatHandler.totalfithits += statHandler.fithits;
            StatHandler.totalfitmisses += statHandler.fitmisses;
            StatHandler.totaloldsize += statHandler.oldsize;
            StatHandler.totalnewsize += statHandler.newsize;
            StatHandler.totalhashed += statHandler.hashed;
            System.out.println("");
            System.out.println("total objects = " + StatHandler.totalobjects);
            System.out.println("total classes = " + StatHandler.totalclasses);
            System.out.println("total objectarrays = " + StatHandler.totalobjectarrays);
            System.out.println("total primarrays = " + StatHandler.totalprimarrays);
            System.out.println("total strings = " + StatHandler.totalstrings);
            System.out.println("total smallid = " + StatHandler.totalsmallid);
            System.out.println("total mediumid = " + StatHandler.totalmediumid);
            System.out.println("total largeid = " + StatHandler.totallargeid);
            System.out.println("total smallrefs = " + StatHandler.totalsmallrefs);
            System.out.println("total mediumrefs = " + StatHandler.totalmediumrefs);
            System.out.println("total largerefs = " + StatHandler.totallargerefs);
            System.out.println("total smallsize = " + StatHandler.totalsmallsize);
            System.out.println("total mediumsize = " + StatHandler.totalmediumsize);
            System.out.println("total largesize = " + StatHandler.totallargesize);
            int n4 = 0;
            while (n4 < StatHandler.totalrefcounts.length) {
                System.out.println("total refs[" + n4 + "] = " + StatHandler.totalrefcounts[n4]);
                ++n4;
            }
            System.out.println("total cachehits = " + StatHandler.totalcachehits);
            System.out.println("total cachemisses = " + StatHandler.totalcachemisses);
            System.out.println("total fithits = " + StatHandler.totalfithits);
            System.out.println("total fitmisses = " + StatHandler.totalfitmisses);
            System.out.println("total oldsize = " + StatHandler.totaloldsize);
            System.out.println("total newsize = " + StatHandler.totalnewsize);
            System.out.println("total hashed = " + StatHandler.totalhashed);
            jvm.handler = null;
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void printroots() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Print GC roots in asid " + jvm.space.hexId() + " jvmp " + jvm);
        try {
            jvm.printroots();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void printtitle() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.println(this.dumpReader.title);
    }

    public void printtime() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.println(this.dumpReader.time);
    }

    public void printversion() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            jvm.printversion();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void dumpverbosegc() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            jvm.dumpverbosegc(this.doc);
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void dumpnative() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Dump of all native methods in asid " + jvm.space.hexId());
        try {
            jvm.dumpNative(this.doc, new NullHandler());
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void tcbsummary() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        int n = 0;
        while (n < this.spaces.length) {
            ArrayList arrayList = new ArrayList();
            AddressSpace addressSpace = this.spaces[n];
            Tcb[] tcbArray = addressSpace.tcbs();
            if (tcbArray != null && tcbArray.length != 0) {
                Object object;
                Object object2;
                Object object3;
                this.doc.println("found " + tcbArray.length + " TCBs in asid 0x" + addressSpace.hexId());
                this.doc.println("");
                int n2 = 0;
                while (n2 < tcbArray.length) {
                    object3 = tcbArray[n2];
                    if (((Tcb)object3).isKnownType()) {
                        ArrayList<Object> arrayList2;
                        boolean bl = false;
                        object2 = arrayList.iterator();
                        while (object2.hasNext()) {
                            arrayList2 = (ArrayList<Object>)object2.next();
                            object = (Tcb)arrayList2.get(0);
                            if (!((Tcb)object3).stackEquals((Tcb)object)) continue;
                            arrayList2.add(object3);
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            arrayList2 = new ArrayList<Object>();
                            arrayList2.add(object3);
                            arrayList.add(arrayList2);
                        }
                    }
                    ++n2;
                }
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    Object object4;
                    ArrayList arrayList3 = (ArrayList)object3.next();
                    object2 = (Tcb)arrayList3.get(0);
                    this.doc.println("The following tcbs had this traceback:");
                    int n3 = 0;
                    object = arrayList3.iterator();
                    while (object.hasNext()) {
                        object4 = (Tcb)object.next();
                        this.doc.print(object4 + "   ");
                        if (!object.hasNext() || ++n3 <= 7) continue;
                        this.doc.println("");
                        n3 = 0;
                    }
                    this.doc.println("");
                    this.doc.println("");
                    object4 = ((Tcb)object2).topDsa;
                    while (object4 != null) {
                        this.doc.println("    " + ((Dsa)object4).function());
                        object4 = ((Dsa)object4).previous();
                    }
                    this.doc.println("");
                }
            }
            ++n;
        }
    }

    public void dumpclass(int n) throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            HeapClass heapClass = jvm.getClass(n);
            if (heapClass == null) {
                System.out.println("Could not find class: 0x" + Dump.hex(n));
                return;
            }
            jvm.dumpClass(this.doc, heapClass, false);
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void dumpobject(int n) throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            jvm.dumpObject(this.doc, n);
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void dumpproperties() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Dump of system properties in asid " + jvm.space.hexId());
        try {
            jvm.dumpProperties(this.doc, new NullHandler());
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void hpitrace() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            AddressSpace addressSpace = this.getDefaultAddressSpace();
            Enumeration enumeration = addressSpace.getPages();
            while (enumeration.hasMoreElements()) {
                Page page = (Page)enumeration.nextElement();
                int[] nArray = page.getIntArray();
                int n = 0;
                while (n < nArray.length) {
                    int n2;
                    String string;
                    if (nArray[n] == 0x2A2A2A4A && (string = addressSpace.readString(n2 = page.getAddress() + (n << 2))).equals("***JAVA_TRACE_TABLE****") && (string = addressSpace.readString(n2 + 24)).equals("S390JAVA")) {
                        int n3;
                        int n4;
                        int n5 = addressSpace.readInt(n2 + 32);
                        int n6 = addressSpace.readInt(n2 + 44);
                        int n7 = addressSpace.readInt(n2 + 48);
                        int n8 = addressSpace.readInt(n2 + 52);
                        int n9 = n4 = n8 + n5;
                        int n10 = addressSpace.getId();
                        System.out.println("found hpi trace, offset = " + Dump.hex(n5) + " table start = " + Dump.hex(n8) + " table end = " + Dump.hex(n7) + " table size = " + Dump.hex(n6) + " asid = " + Dump.hex(n10));
                        boolean bl = false;
                        while (true) {
                            try {
                                if (addressSpace.readInt(n9 + 20) == n10 && (n3 = addressSpace.readInt(n9)) >= 32 && n3 < 100) {
                                    bl = true;
                                    break;
                                }
                            }
                            catch (Exception exception) {
                                n9 = n8 - 4;
                            }
                            if ((n9 += 4) == n4) break;
                            if (n9 < n7) continue;
                            n9 = n8;
                        }
                        if (!bl) {
                            System.out.println("could not find a valid record!");
                            return;
                        }
                        n3 = 1;
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
                        int n11 = 0;
                        int n12 = n9;
                        while (n11 < n6) {
                            if (n9 >= n4 ? n12 >= n4 && n12 < n9 : n12 >= n4) break;
                            int n13 = addressSpace.readInt(n12);
                            if (n12 + n13 >= n7) {
                                n12 += n13 - n6;
                                n11 += n13;
                                System.out.println("skipping last record");
                                continue;
                            }
                            int n14 = addressSpace.readInt(n12 + 4);
                            long l = addressSpace.readInt(n12 + 8);
                            long l2 = addressSpace.readInt(n12 + 12);
                            Date date = AddressSpace.mvsClockToDate(l << 32 | l2 & 0xFFFFFFFFL);
                            if (n3 != 0) {
                                System.out.println("Trace begins at " + date);
                                n3 = 0;
                            }
                            String string2 = simpleDateFormat.format(date);
                            String string3 = n14 == 0 ? "No format string" : addressSpace.readString(n14);
                            int n15 = addressSpace.readInt(n12 + 16);
                            int n16 = addressSpace.readInt(n12 + 24);
                            System.out.print(string2 + " tcb " + Dump.hex(n15) + " " + string3 + " ");
                            int n17 = 0;
                            while (n17 < n16) {
                                int n18 = addressSpace.readInt(n12 + 32 + (n17 << 2));
                                System.out.print(Dump.hex(n18) + " ");
                                ++n17;
                            }
                            System.out.println("");
                            n12 += n13;
                            n11 += n13;
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void dumpmdata(int n) throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            jvm.dumpMdata(this.doc, n);
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void systrace() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            if (addressSpace.isTrace()) {
                block10: {
                    try {
                        this.processTrace(addressSpace);
                    }
                    catch (Exception exception) {
                        if (!debug) break block10;
                        this.doc.println("problem processing trace!");
                    }
                }
                if (debug) {
                    this.doc.println("finished processing trace");
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.spaces.length) {
            block11: {
                AddressSpace addressSpace = this.spaces[n2];
                try {
                    if (n2 > 0) {
                        this.doc.println("");
                    }
                    addressSpace.printFullTrace(this.doc);
                }
                catch (Exception exception) {
                    if (!debug) break block11;
                    this.doc.println("problem processing trace!");
                }
            }
            ++n2;
        }
    }

    public void search() throws Exception {
        System.out.println("searching for " + Dump.hex(searchvalue) + "...");
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            int n2 = 0;
            while ((n2 = addressSpace.search(n2, searchvalue)) != -1) {
                System.out.println("found at " + Dump.hex(n2) + " in asid " + addressSpace);
                n2 += 4;
            }
            ++n;
        }
    }

    public void doStuff() {
        Object object;
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        if (debug) {
            this.doc.println("finished scan of dump");
        }
        try {
            this.doc.print("Dump title: ");
            this.printtitle();
            this.doc.print("Time of dump: ");
            this.printtime();
        }
        catch (Exception exception) {
            this.doc.println("Error processing dump title/time: " + exception);
        }
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            if (addressSpace.isTrace()) {
                block53: {
                    try {
                        this.processTrace(addressSpace);
                    }
                    catch (Exception exception) {
                        if (!debug) break block53;
                        this.doc.println("problem processing trace!");
                    }
                }
                if (debug) {
                    this.doc.println("finished processing trace");
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n2];
            if (addressSpace.isJava() && (object = addressSpace.jvms()) != null && ((Jvm[])object).length > 0) {
                System.out.print("Jvm fullversion: ");
                try {
                    ((Jvm)object[0]).printversion();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("");
                break;
            }
            ++n2;
        }
        if (debug) {
            this.doc.println("finished creating Dump instance");
        }
        int n3 = 0;
        while (n3 < this.spaces.length) {
            Tcb[] tcbArray;
            object = this.spaces[n3];
            if (verbose) {
                this.doc.println("processing asid " + ((AddressSpace)object).hexId());
            }
            if ((tcbArray = ((AddressSpace)object).tcbs()) != null && tcbArray.length != 0) {
                int n4;
                Object object2;
                this.doc.println("found " + tcbArray.length + " TCBs in asid 0x" + ((AddressSpace)object).hexId());
                this.doc.println("");
                this.samplecaa = 0;
                boolean bl = false;
                int n5 = 0;
                while (n5 < tcbArray.length) {
                    Tcb tcb = tcbArray[n5];
                    if (tcb.isKnownType()) {
                        this.printTCBStack(tcb, bl, (AddressSpace)object);
                        Function[] functionArray = tcb.traceFunctions();
                        if (functionArray != null) {
                            this.doc.println("found trace table:");
                            this.doc.println("");
                            this.printTrace(functionArray);
                            this.doc.println("");
                        }
                    } else {
                        this.doc.println("TCB of unknown type " + tcb.hexId() + " caa " + Dump.hex(tcb.caa()));
                        bl = true;
                    }
                    ++n5;
                }
                this.doc.println("");
                int n6 = 0;
                while (((AddressSpace)object).jvms() != null && n6 < ((AddressSpace)object).jvms().length) {
                    ((AddressSpace)object).jvms()[n6].checkTidChain(this.doc);
                    ++n6;
                }
                int n7 = 0;
                while (n7 < tcbArray.length) {
                    object2 = tcbArray[n7];
                    if (((Tcb)object2).tid() != 0) {
                        n4 = 0;
                        Jvm jvm = ((Tcb)object2).jvm;
                        if (jvm != null) {
                            try {
                                int n8 = jvm.rootTid;
                                while (n8 != 0) {
                                    if (((Tcb)object2).tid() == n8) {
                                        if (verbose) {
                                            this.doc.println("found " + Dump.hex(n8) + " in tid chain");
                                        }
                                        n4 = 1;
                                        if (!((Tcb)object2).isKnownType()) {
                                            this.doc.println("*** Warning! tcb " + ((Tcb)object2).hexId() + " with tid " + Dump.hex(((Tcb)object2).tid()) + " is unknown TCB type but known by Java");
                                            ((Tcb)object2).printJavaStack(this.doc);
                                        }
                                        break;
                                    }
                                    n8 = ((AddressSpace)object).readInt(n8);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (n4 == 0) {
                                this.doc.println("*** Warning! tid " + Dump.hex(((Tcb)object2).tid()) + " not found in tid chain, jvm " + jvm);
                            }
                        }
                    }
                    ++n7;
                }
                object2 = ((AddressSpace)object).traceFunctions();
                if (object2 != null && ((Object)object2).length != 0) {
                    this.doc.println("trace table for asid " + ((AddressSpace)object).hexId() + ":");
                    this.doc.println("");
                    this.printTrace((Function[])object2);
                    this.doc.println("");
                }
                if (this.samplecaa != 0) {
                    try {
                        int n9;
                        Object object3;
                        int n10;
                        int n11;
                        n4 = ((AddressSpace)object).readInt(this.samplecaa + 752);
                        int n12 = ((AddressSpace)object).readInt(n4 + 88);
                        this.doc.printHeader("environment variables:");
                        this.doc.println("");
                        Table table = new Table(new String[]{"key", "value"});
                        int n13 = 0;
                        while ((n13 = ((AddressSpace)object).readInt(n12)) != 0) {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            while ((n11 = ((AddressSpace)object).readUnsignedByte(n13++)) != 0) {
                                byteArrayOutputStream.write(n11);
                            }
                            String string = Dump.getEbcdicString(byteArrayOutputStream.toByteArray());
                            n10 = string.indexOf(61);
                            if (n10 >= 0) {
                                object3 = string.substring(0, n10);
                                String string2 = string.substring(n10 + 1);
                                table.addRow(new String[]{object3, string2});
                            }
                            n12 += 4;
                        }
                        this.doc.addElement(table);
                        this.doc.println("");
                        this.doc.printHeader("loaded dlls:");
                        this.doc.println("");
                        table = new Table(new String[]{"name", "wsa"});
                        int n14 = ((AddressSpace)object).readInt(n4 + 1096);
                        while (n14 != 0) {
                            n11 = ((AddressSpace)object).readUnsignedShort(n14 + 60);
                            int n15 = ((AddressSpace)object).readInt(n14 + 64);
                            n10 = ((AddressSpace)object).readInt(n14 + 20);
                            object3 = new ByteArrayOutputStream();
                            n9 = 0;
                            while (n9 < n11) {
                                int n16 = ((AddressSpace)object).readUnsignedByte(n15++);
                                ((ByteArrayOutputStream)object3).write(n16);
                                ++n9;
                            }
                            String string = Dump.getEbcdicString(((ByteArrayOutputStream)object3).toByteArray());
                            table.addRow(new String[]{string, Dump.hex(n10)});
                            n14 = ((AddressSpace)object).readInt(n14);
                        }
                        this.doc.addElement(table);
                        this.doc.println("");
                        this.doc.printHeader("le runtime options:");
                        this.doc.println("");
                        table = new Table(new String[]{"option", "suboption", "value"});
                        n11 = ((AddressSpace)object).readInt(n4 + 16);
                        int n17 = n11 + ((AddressSpace)object).readInt(n11 + 240);
                        n10 = ((AddressSpace)object).readUnsignedByte(n17 + 4);
                        if ((n10 & 0x80) != 0) {
                            int n18 = ((AddressSpace)object).readUnsignedByte(n17 + 5);
                            table.addRow("STORAGE", "heap_alloc_value", Dump.hex(n18, 2));
                        } else {
                            table.addRow("STORAGE", "heap_alloc_value", "NONE");
                        }
                        if ((n10 & 0x40) != 0) {
                            int n19 = ((AddressSpace)object).readUnsignedByte(n17 + 6);
                            table.addRow("STORAGE", "heap_free_value", Dump.hex(n19, 2));
                        } else {
                            table.addRow("STORAGE", "heap_free_value", "NONE");
                        }
                        if ((n10 & 0x20) != 0) {
                            int n20 = ((AddressSpace)object).readUnsignedByte(n17 + 7);
                            table.addRow("STORAGE", "dsa_alloc_value", Dump.hex(n20, 2));
                        } else {
                            table.addRow("STORAGE", "dsa_alloc_value", "NONE");
                        }
                        int n21 = n11 + ((AddressSpace)object).readInt(n11 + 232);
                        int n22 = ((AddressSpace)object).readInt(n21 + 4);
                        table.addRow("STACK", "init_size", "" + n22);
                        n9 = ((AddressSpace)object).readInt(n21 + 8);
                        table.addRow("STACK", "incr_size", "" + n9);
                        n10 = ((AddressSpace)object).readUnsignedByte(n21 + 12);
                        table.addRow("STACK", "location", (n10 & 0x80) == 0 ? "ANYWHERE" : "BELOW");
                        table.addRow("STACK", "disposition", (n10 & 0x40) == 0 ? "KEEP" : "FREE");
                        this.doc.addElement(table);
                    }
                    catch (Exception exception) {
                        this.doc.println("problem processing sample caa: " + exception);
                    }
                } else {
                    this.doc.println("no sample caa!");
                }
                Jvm[] jvmArray = ((AddressSpace)object).jvms();
                if (jvmArray != null) {
                    int n23 = 0;
                    while (n23 < jvmArray.length) {
                        Jvm jvm = jvmArray[n23];
                        if (analyzeHeap) {
                            try {
                                jvm.analyzeHeap(this.doc, new NullHandler());
                            }
                            catch (Exception exception) {
                                this.doc.println("bad heap in asid " + ((AddressSpace)object).hexId());
                                exception.printStackTrace();
                            }
                        }
                        ++n23;
                    }
                }
            }
            ++n3;
        }
    }

    public Jvm[] jvms() {
        Vector<Jvm> vector = new Vector<Jvm>();
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            Tcb[] tcbArray = addressSpace.tcbs();
            int n2 = 0;
            while (n2 < tcbArray.length) {
                Tcb tcb = tcbArray[n2];
                if (tcb.isKnownType()) {
                    Dsa dsa = tcb.topDsa;
                    while (dsa != null) {
                        dsa.function();
                        dsa = dsa.previous();
                    }
                }
                ++n2;
            }
            if (addressSpace.jvms() != null) {
                int n3 = 0;
                while (n3 < addressSpace.jvms().length) {
                    vector.addElement(addressSpace.jvms()[n3]);
                    ++n3;
                }
            }
            ++n;
        }
        return vector.toArray(new Jvm[0]);
    }

    public static String getEbcdicString(byte[] byArray) {
        try {
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] == -83) {
                    byArray[n] = 74;
                } else if (byArray[n] == -67) {
                    byArray[n] = 90;
                }
                ++n;
            }
            return new String(byArray, "Cp500");
        }
        catch (Exception exception) {
            throw new Error("No Cp500");
        }
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }

    public void printStacks() {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        if (debug) {
            this.doc.println("finished scan of dump");
        }
        int n = 0;
        while (n < this.spaces.length) {
            Tcb[] tcbArray;
            AddressSpace addressSpace = this.spaces[n];
            if (verbose) {
                this.doc.println("processing asid " + addressSpace.hexId());
            }
            if ((tcbArray = addressSpace.tcbs()) != null && tcbArray.length != 0) {
                this.doc.println("found " + tcbArray.length + " TCBs in asid 0x" + addressSpace.hexId());
                this.doc.println("");
                this.samplecaa = 0;
                boolean bl = false;
                int n2 = 0;
                while (n2 < tcbArray.length) {
                    Tcb tcb = tcbArray[n2];
                    if (tcb.isKnownType()) {
                        this.printTCBStack(tcb, bl, addressSpace);
                    } else {
                        this.doc.println("TCB of unknown type " + tcb.hexId() + " caa " + Dump.hex(tcb.caa()));
                        bl = true;
                    }
                    ++n2;
                }
                this.doc.println("");
            }
            ++n;
        }
    }

    private void printTCBStack(Tcb tcb, boolean bl, AddressSpace addressSpace) {
        Object object;
        Table table;
        int[] nArray;
        if (bl) {
            this.doc.println("");
            bl = false;
        }
        this.doc.print("TCB " + tcb.hexId() + " tid " + Dump.hex(tcb.tid()));
        if (tcb.tid_threadself() != -1L) {
            this.doc.print(" pthread id " + Long.toHexString(tcb.tid_threadself()));
        }
        if (tcb.threadIndex() != 0) {
            this.doc.print(" tindex " + Dump.hex(tcb.threadIndex()));
        }
        if (tcb.tid_type() != -1) {
            this.doc.print(" tid type 0x" + Dump.hex(tcb.tid_type()));
        }
        if (tcb.tid_state() != -1) {
            this.doc.print(" tid state 0x" + Dump.hex(tcb.tid_state()));
        }
        if (tcb.tid_singled() != -1) {
            this.doc.print(" tid singled 0x" + Dump.hex(tcb.tid_singled()));
        }
        if (tcb.jvm != null) {
            this.doc.print(" jvmp " + Dump.hex(tcb.jvm.jvmp));
            this.doc.print(" ee " + Dump.hex(tcb.ee()));
        }
        this.doc.print(tcb.caa() == 0 ? "" : " caa " + Dump.hex(tcb.caa()));
        this.doc.print(" (" + tcb.type() + ")");
        this.doc.println("");
        if (tcb.caa() != 0 && !tcb.dodgy && this.samplecaa == 0) {
            this.samplecaa = tcb.caa();
        }
        if ((nArray = tcb.failingRegisters()) != null) {
            this.doc.println("Registers at point of failure:");
            table = new Table();
            table.setBorder(0);
            table.addRow(new String[]{"r0:", Dump.hex(nArray[0]), "r1:", Dump.hex(nArray[1]), "r2:", Dump.hex(nArray[2]), "r3:", Dump.hex(nArray[3])});
            table.addRow(new String[]{"r4:", Dump.hex(nArray[4]), "r5:", Dump.hex(nArray[5]), "r6:", Dump.hex(nArray[6]), "r7:", Dump.hex(nArray[7])});
            table.addRow(new String[]{"r8:", Dump.hex(nArray[8]), "r9:", Dump.hex(nArray[9]), "r10:", Dump.hex(nArray[10]), "r11:", Dump.hex(nArray[11])});
            table.addRow(new String[]{"r12:", Dump.hex(nArray[12]), "r13:", Dump.hex(nArray[13]), "r14:", Dump.hex(nArray[14]), "r15:", Dump.hex(nArray[15])});
            table.addRow(new String[]{"psw:", Dump.hex(nArray[16]), "", Dump.hex(nArray[17])});
            this.doc.addElement(table);
            this.doc.println("");
        }
        table = new Table();
        table.suppressEmptyColumns(true);
        table.addHeaderCell("Dsa");
        table.addHeaderCell("Entry");
        table.addHeaderCell("Offset");
        if (reg != -1) {
            object = reg < 10 ? "r" + reg + " " : "r" + reg;
            table.addHeaderCell((String)object);
        }
        table.addHeaderCell("Function");
        if (tcb.isJava() && !tcb.usesXplink()) {
            table.addHeaderCell("Method");
        }
        table.addHeaderCell("Module");
        object = tcb.topDsa;
        while (object != null) {
            Row row = new Row();
            row.addCell(Dump.hex(((Dsa)object).address));
            row.addCell(Dump.hex(((Dsa)object).entryPoint()));
            row.addCell(Dump.hex(((Dsa)object).offset()));
            if (reg != -1) {
                row.addCell(Dump.hex(((Dsa)object).reg(reg)));
            }
            row.addCell(((Dsa)object).function());
            if (tcb.isJava() && !tcb.usesXplink()) {
                row.addCell(((Dsa)object).method());
            }
            row.addCell(((Dsa)object).program());
            table.addRow(row);
            object = ((Dsa)object).previous();
        }
        this.doc.addElement(table);
        if (tcb.isJava()) {
            tcb.printJavaStack(this.doc);
        }
        if (tcb.hasPendingException() || printExceptionObject) {
            tcb.printException(this.doc);
        }
        if (tcb.currentSignal() != -1) {
            this.doc.println("");
            this.doc.println("Found pending signal: " + tcb.currentSignal());
        }
        if (printAllocCache && tcb.tid() != 0) {
            tcb.printAllocCache(this.doc);
        }
        if (tcb.tid() != 0 && tcb.jvm != null) {
            int n = 0;
            Jvm jvm = tcb.jvm;
            try {
                int n2 = tcb.tid();
                while (n2 != 0) {
                    if (++n > 10000) {
                        System.out.println("Warning! loop found in tid chain!");
                        n = 0;
                        break;
                    }
                    n2 = addressSpace.readInt(n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n > jvm.longestTidChain) {
                jvm.longestTidChain = n;
                jvm.rootTid = tcb.tid();
            }
        }
        this.doc.println("");
    }

    protected static boolean isFromJFormat() {
        return fromJFormat;
    }

    public void setFromJFormat(boolean bl) {
        fromJFormat = bl;
    }

    public static void setDisassemble(boolean bl) {
        disassemble = bl;
    }

    public static void setDisassembleAddress(int n) {
        disassembleAddress = n;
    }

    public static void setDisassembleLength(int n) {
        disassembleLength = n;
    }

    public static void setDumpstorage(boolean bl) {
        dumpstorage = bl;
    }

    public static void setDumpstorageAddress(int n) {
        dumpstorageAddress = n;
    }

    public static void setDumpstorageLength(int n) {
        dumpstorageLength = n;
    }

    public static void setDumpclasses(boolean bl) {
        dumpclasses = bl;
    }

    public static void setDumpclass(int n) {
        dumpclass = n;
    }

    public static void setSystrace(boolean bl) {
        systrace = bl;
    }

    public static void setDumpmdata(boolean bl) {
        dumpmdata = bl;
    }

    public static void setAnalyzeHeap(boolean bl) {
        analyzeHeap = bl;
    }

    public static void setReg(int n) {
        reg = n;
    }

    public boolean isSvcdump() {
        return this.svcdump;
    }

    public AddressSpace[] getSpaces() {
        return this.spaces;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        dumpstorage = false;
        dumpclasses = false;
        dumpnative = false;
        tcbsummary = false;
        verifysubpools = false;
        verifyheap = false;
        printdosed = false;
        heapstats = false;
        printroots = false;
        printversion = false;
        printtitle = false;
        printtime = false;
        dumpverbosegc = false;
        dumpclass = 0;
        dumpobject = 0;
        dumpproperties = false;
        dumpapars = false;
        dumpmdata = false;
        mdata = 0;
        systrace = false;
        hpitrace = false;
        search = false;
        defaultJvm = -1;
        fromJFormat = false;
        arrayLength = 0;
        arrayCount = 0;
        objectCount = 0;
        reg = -1;
    }
}

