/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.findroots.HeapdumpContentHandler;
import com.ibm.jvm.findroots.NullHandler;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Heap;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.HeapField;
import com.ibm.jvm.svcdump.HeapMethod;
import com.ibm.jvm.svcdump.PinnedObjects;
import com.ibm.jvm.svcdump.StackSegment;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.util.BitSetArray;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.SortListener;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Element;
import com.ibm.jvm.util.html.Table;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Jvm
extends Base {
    AddressSpace space;
    boolean checkedVersion = false;
    boolean is131 = false;
    boolean printstrings;
    IntHashtable names = new IntHashtable();
    IntHashtable classes = new IntHashtable();
    Hashtable livecounts;
    Hashtable deadcounts = new Hashtable();
    public int jvmp;
    int st;
    int mh_heapbase;
    int mh_heaplimit;
    int th_heapbase;
    int th_heaplimit;
    int freeObjectCtr;
    int totalObjectCtr;
    int freeList;
    int allocbits;
    int markbits;
    int shared_slicemap_base;
    int slicemap_base;
    int lastaddress;
    HeapdumpContentHandler handler;
    int limit = 10;
    int totalLength = 0;
    int totalObjects = 0;
    static DateFormat df = DateFormat.getTimeInstance();
    boolean isPostRas;
    int stglobal;
    int st_jab;
    boolean includeDead;
    boolean isDebugBuild;
    boolean isPostMarkStack;
    int mmiLow;
    int mmiHigh;
    boolean doneInit;
    Heap heap;
    IntHashtable refArrays = new IntHashtable();
    BitSetArray badObjects;
    BitSetArray dosedObjects;
    IntegerArray validObjects;
    PinnedObjects pinnedObjects;
    static boolean includeReferences = SvcdumpProperties.getBooleanProperty("findroots.include.references", true);
    int rootTid;
    int longestTidChain = 0;
    int loadedACSClasses;
    int loadedSystemClasses;
    int loadedClasses;
    static final int VGC_MARK_STACK_OVERFLOW = 1;
    static final int VGC_TRACE_FOR_DIRTY = 2;
    static final int VGC_EXPANDED_MARK_BITS = 3;
    static final int VGC_SHRANK_MARK_BITS = 4;
    static final int VGC_EXPANDED_ALLOC_BITS = 5;
    static final int VGC_SHRANK_ALLOC_BITS = 6;
    static final int VGC_EXPANDED_HEAP = 7;
    static final int VGC_SHRANK_HEAP = 8;
    static final int VGC_AF_START = 9;
    static final int VGC_AF_ACT = 10;
    static final int VGC_CLEAR_SOFT_REFS = 11;
    static final int VGC_TOTALLY_OUT = 12;
    static final int VGC_AF_END = 13;
    static final int VGC_GC_START = 14;
    static final int VGC_GC_FREED = 15;
    static final int VGC_GC_REF = 16;
    static final int VGC_GC_REF_TERSE = 17;
    static final int VGC_GC_MOVED = 18;
    static final int VGC_GC_LONG_STOP = 19;
    static final int VGC_GC_MARK = 20;
    static final int VGC_MAX_TAG = 20;
    static final int[] vgc_record_lengths = new int[]{0, 1, 2, 9, 5, 9, 5, 13, 13, 13, 13, 1, 1, 5, 9, 17, 21, 2, 13, 9, 13};
    String[] arrayName = new String[]{"unknown array type", "unknown array type", "array of references", "unknown array type", "array of boolean", "array of char", "array of float", "array of double", "array of byte", "array of short", "array of int", "array of long", "array of unsigned byte", "array of unsigned char", "array of unsigned int", "array of unsigned long"};
    int finalClass;
    boolean foundFinalClass;

    Jvm(AddressSpace addressSpace) {
        this.space = addressSpace;
        Base.Assert(false);
    }

    Jvm(AddressSpace addressSpace, int n, boolean bl) {
        this.space = addressSpace;
        this.jvmp = n;
        this.isPostRas = bl;
    }

    public int jvmp() {
        return this.jvmp;
    }

    public int loadedACSClasses() {
        return this.loadedACSClasses;
    }

    public int loadedSystemClasses() {
        return this.loadedSystemClasses;
    }

    public int loadedClasses() {
        return this.loadedClasses;
    }

    public AddressSpace space() {
        return this.space;
    }

    public static int offsetof(String string, String string2) throws Exception {
        int n = CType.offsetof(string, string2, -1);
        if (n == -1) {
            throw new Exception("type " + string + " not found!");
        }
        return n;
    }

    void initWithCtypes() throws Exception {
        this.st = this.jvmp + Jvm.offsetof("Jvm", "facade") + Jvm.offsetof(null, "st");
        this.expect(this.st, "STOR", false);
        this.stglobal = this.space.readInt(this.st + Jvm.offsetof("StorageInterface", "dataP"));
        this.expect(this.stglobal, "STDA", false);
        this.st_jab = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "st_jab"));
        if (Dump.verbose) {
            System.out.println("st_jab = " + Jvm.hex(this.st_jab));
        }
        this.mh_heapbase = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "MH_heapbase"));
        if (Dump.verbose) {
            System.out.println("MH_heapbase = " + Jvm.hex(this.mh_heapbase));
        }
        this.mh_heaplimit = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "MH_heaplimit"));
        if (Dump.verbose) {
            System.out.println("MH_heaplimit = " + Jvm.hex(this.mh_heaplimit));
        }
        this.th_heapbase = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "TH_heapbase"));
        if (Dump.verbose) {
            System.out.println("TH_heapbase = " + Jvm.hex(this.th_heapbase));
        }
        this.th_heaplimit = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "TH_heaplimit"));
        if (Dump.verbose) {
            System.out.println("TH_heaplimit = " + Jvm.hex(this.th_heaplimit));
        }
        this.allocbits = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "allocbits"));
        if (Dump.verbose) {
            System.out.println("allocbits = " + Jvm.hex(this.allocbits));
        }
        this.markbits = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "markbits"));
        if (Dump.verbose) {
            System.out.println("markbits = " + Jvm.hex(this.markbits));
        }
        this.slicemap_base = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "slicemap_base"));
        if (Dump.verbose) {
            System.out.println("slicemap_base = " + Jvm.hex(this.slicemap_base));
        }
        this.shared_slicemap_base = this.space.readInt(this.st_jab + Jvm.offsetof("StorageJAB", "shared_slicemap_base"));
        if (Dump.verbose) {
            System.out.println("shared_slicemap_base = " + Jvm.hex(this.shared_slicemap_base));
        }
        this.loadedClasses = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "loadedClasses"));
        if (Dump.verbose) {
            System.out.println("loadedClasses = " + Jvm.hex(this.loadedClasses));
        }
        if (this.loadedClasses != 0) {
            Base.Assert(this.loadedClasses > 4096);
            this.addClassChain(this.loadedClasses);
        }
        this.loadedSystemClasses = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "loadedSystemClasses"));
        if (Dump.verbose) {
            System.out.println("loadedSystemClasses = " + Jvm.hex(this.loadedSystemClasses));
        }
        if (this.loadedSystemClasses != 0) {
            Base.Assert(this.loadedSystemClasses > 4096);
            this.addClassChain(this.loadedSystemClasses);
        }
        this.loadedACSClasses = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "loadedACSClasses"));
        if (Dump.verbose) {
            System.out.println("loadedACSClasses = " + Jvm.hex(this.loadedACSClasses));
        }
        if (this.loadedACSClasses != 0) {
            this.addClassChain(this.loadedACSClasses);
        }
        this.freeObjectCtr = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "FreeObjectCtr"));
        if (Dump.verbose) {
            System.out.println("freeObjectCtr = " + this.freeObjectCtr);
        }
        this.totalObjectCtr = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "TotalObjectCtr"));
        if (Dump.verbose) {
            System.out.println("totalObjectCtr = " + this.totalObjectCtr);
        }
        this.freeList = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "freeList"));
        if (Dump.verbose) {
            System.out.println("freeList = " + Jvm.hex(this.freeList));
        }
        if (Dump.verbose) {
            System.out.println("");
        }
    }

    public void init() throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        block74: {
            if (this.doneInit) {
                return;
            }
            this.doneInit = true;
            if (this.space.jvmRasAddress != 0) {
                this.expect(this.space.jvmRasAddress, "JVMR", true);
                if (Dump.verbose) {
                    System.out.println("found jvm ras eyecatcher");
                }
            }
            this.is131 = true;
            if (Dump.verbose) {
                System.out.println("asid = " + this.space + " jvmp = " + Jvm.hex(this.jvmp));
            }
            this.expect(this.jvmp, "MAIN", false);
            if (CType.find("Jvm") != null) {
                if (Dump.verbose) {
                    System.out.println("do new style init");
                }
                try {
                    this.initWithCtypes();
                    return;
                }
                catch (Throwable throwable) {
                    if (!Dump.verbose) break block74;
                    System.out.println("init with c types failed probably due to a mismatch between libjvm.so and the types file");
                }
            }
        }
        if (Dump.verbose) {
            System.out.println("do old style init");
        }
        if (this.isPostRas) {
            this.st = this.jvmp + 340 + 8;
            if (Dump.verbose) {
                System.out.println("is post ras");
            }
        } else {
            this.st = this.jvmp + 340;
        }
        if (Dump.verbose) {
            System.out.println("st = " + Jvm.hex(this.st));
        }
        if (this.isPostRas) {
            try {
                this.expect(this.st, "STOR", false);
            }
            catch (Error error) {
                this.st += 8;
                this.expect(this.st, "STOR", false);
            }
            this.stglobal = this.space.readInt(this.st + 404 + 8);
        } else {
            this.stglobal = this.space.readInt(this.st + 404);
        }
        if (Dump.verbose) {
            System.out.println("stglobal = " + Jvm.hex(this.stglobal));
        }
        if (this.isPostRas) {
            this.expect(this.stglobal, "STDA", false);
            this.stglobal += 16;
        }
        this.st_jab = this.space.readInt(this.stglobal + 12);
        if (Dump.verbose) {
            System.out.println("st_jab = " + Jvm.hex(this.st_jab));
        }
        this.slicemap_base = this.space.readInt(this.stglobal + 8);
        if (Dump.verbose) {
            System.out.println("slicemap_base = " + Jvm.hex(this.slicemap_base));
        }
        this.shared_slicemap_base = this.space.readInt(this.st_jab + 64);
        if (Dump.verbose) {
            System.out.println("shared_slicemap_base = " + Jvm.hex(this.shared_slicemap_base));
        }
        int n6 = this.space.readInt(this.stglobal + 20);
        if (Dump.verbose) {
            System.out.println("real_heapbase = " + Jvm.hex(n6));
        }
        int n7 = this.space.readInt(this.stglobal + 24);
        if (Dump.verbose) {
            System.out.println("real_heaptop = " + Jvm.hex(n7));
        }
        int n8 = this.space.readInt(this.stglobal + 32);
        if (Dump.verbose) {
            System.out.println("real_TH_limit = " + Jvm.hex(n8));
        }
        this.mh_heapbase = this.space.readInt(this.stglobal + 36);
        if (Dump.verbose) {
            System.out.println("mh_heapbase = " + Jvm.hex(this.mh_heapbase));
        }
        this.mh_heaplimit = this.space.readInt(this.stglobal + 40);
        if (Dump.verbose) {
            System.out.println("mh_heaplimit = " + Jvm.hex(this.mh_heaplimit));
        }
        this.th_heapbase = this.space.readInt(this.stglobal + 44);
        if (Dump.verbose) {
            System.out.println("th_heapbase = " + Jvm.hex(this.th_heapbase));
        }
        this.th_heaplimit = this.space.readInt(this.stglobal + 48);
        if (Dump.verbose) {
            System.out.println("th_heaplimit = " + Jvm.hex(this.th_heaplimit));
        }
        this.allocbits = this.space.readInt(this.stglobal + 100);
        if (Dump.verbose) {
            System.out.println("allocbits = " + Jvm.hex(this.allocbits));
        }
        this.markbits = this.space.readInt(this.stglobal + 96);
        if (Dump.verbose) {
            System.out.println("markbits = " + Jvm.hex(this.markbits));
        }
        if ((n5 = this.space.readInt(this.stglobal + 132)) != 512) {
            this.stglobal += 16;
            n5 = this.space.readInt(this.stglobal + 132);
            if (n5 == 512) {
                this.isPostMarkStack = true;
                if (Dump.verbose) {
                    System.out.println("found post mark stack build");
                }
            } else {
                this.stglobal += 4;
                n5 = this.space.readInt(this.stglobal + 132);
                if (n5 == 512) {
                    this.isPostMarkStack = true;
                    this.isDebugBuild = true;
                    if (Dump.verbose) {
                        System.out.println("found post mark stack debug build");
                    }
                } else {
                    this.stglobal -= 16;
                    n5 = this.space.readInt(this.stglobal + 132);
                    if (n5 == 512) {
                        this.isDebugBuild = true;
                        if (Dump.verbose) {
                            System.out.println("found debug build");
                        }
                    } else {
                        throw new Exception("Bad jvmp!");
                    }
                }
            }
        }
        int n9 = this.space.readInt(this.stglobal + 168 + (this.isPostMarkStack ? 8 : 0));
        if (Dump.verbose) {
            System.out.println("gcctr = " + n9);
        }
        if (n9 > 100000) {
            if (Dump.verbose) {
                System.out.println("found post 53299.1 build");
            }
            this.stglobal += 8;
        }
        this.loadedClasses = this.space.readInt(this.stglobal + 144);
        if (Dump.verbose) {
            System.out.println("loadedClasses = " + Jvm.hex(this.loadedClasses));
        }
        if (this.loadedClasses != 0) {
            Base.Assert(this.loadedClasses > 4096);
            this.addClassChain(this.loadedClasses);
        }
        this.loadedSystemClasses = this.space.readInt(this.stglobal + 136);
        if (Dump.verbose) {
            System.out.println("loadedSystemClasses = " + Jvm.hex(this.loadedSystemClasses));
        }
        if (this.loadedSystemClasses != 0) {
            Base.Assert(this.loadedSystemClasses > 4096);
            this.addClassChain(this.loadedSystemClasses);
        }
        if (this.isPostMarkStack) {
            this.stglobal += 4;
        }
        this.loadedACSClasses = this.space.readInt(this.stglobal + 140);
        if (Dump.verbose) {
            System.out.println("loadedACSClasses = " + Jvm.hex(this.loadedACSClasses));
        }
        if (this.loadedACSClasses != 0) {
            this.addClassChain(this.loadedACSClasses);
        }
        if (this.isPostMarkStack) {
            this.stglobal += 4;
        }
        int n10 = this.space.readInt(this.stglobal + 144);
        if (Dump.verbose) {
            System.out.println("loadedClasses = " + Jvm.hex(n10));
        }
        n9 = this.space.readInt(this.stglobal + 168);
        if (Dump.verbose) {
            System.out.println("gcctr = " + n9);
        }
        if (this.isPostMarkStack) {
            n4 = this.space.readInt(this.stglobal + 172);
            if (Dump.verbose) {
                System.out.println("overflowctr = " + n4);
            }
            this.stglobal += 4;
        }
        n4 = this.space.readInt(this.stglobal + 172);
        if (Dump.verbose) {
            System.out.println("last_compactgc = " + n4);
        }
        int n11 = this.space.readInt(this.stglobal + 176);
        if (Dump.verbose) {
            System.out.println("last_icompactgc = " + n11);
        }
        int n12 = this.space.readInt(this.stglobal + 180);
        if (Dump.verbose) {
            System.out.println("last_fullgc = " + n12);
        }
        int n13 = this.space.readInt(this.stglobal + 184);
        if (Dump.verbose) {
            System.out.println("onlineCPUs = " + n13);
        }
        int n14 = this.space.readInt(this.stglobal + 188);
        if (Dump.verbose) {
            System.out.println("maxedOutTLHs = " + n14);
        }
        int n15 = this.space.readInt(this.stglobal + 192);
        if (Dump.verbose) {
            System.out.println("maxTLHSize = " + Jvm.hex(n15));
        }
        int n16 = this.space.readInt(this.stglobal + 960);
        if (Dump.verbose) {
            System.out.println("num_hints = " + Jvm.hex(n16));
        }
        int n17 = this.space.readInt(this.stglobal + 964);
        if (Dump.verbose) {
            System.out.println("hint_first = " + Jvm.hex(n17));
        }
        int n18 = this.space.readInt(this.stglobal + 968);
        if (Dump.verbose) {
            System.out.println("hint_free = " + Jvm.hex(n18));
        }
        int n19 = n18;
        while (n19 != 0) {
            n3 = this.space.readInt(n19);
            n2 = this.space.readInt(n19 + 4);
            n = this.space.readInt(n19 + 8);
            if (Dump.verbose) {
                System.out.println("hint chunk: " + Jvm.hex(n2) + " len: " + Jvm.hex(n3) + " lru: " + Jvm.hex(n));
            }
            n19 = this.space.readInt(n19 + 8);
        }
        if (this.isPostRas) {
            this.stglobal += 4;
        }
        n3 = this.space.readInt(this.stglobal + 996);
        this.freeObjectCtr = this.space.readInt(this.stglobal + 1016);
        if (Dump.verbose) {
            System.out.println("freeObjectCtr = " + this.freeObjectCtr);
        }
        this.totalObjectCtr = this.space.readInt(this.stglobal + 1020);
        if (Dump.verbose) {
            System.out.println("totalObjectCtr = " + this.totalObjectCtr);
        }
        this.freeList = this.space.readInt(this.stglobal + 1036);
        if (Dump.verbose) {
            System.out.println("freeList = " + Jvm.hex(this.freeList));
        }
        n2 = this.space.readInt(this.stglobal + 1040);
        if (Dump.verbose) {
            System.out.println("freeTail = " + Jvm.hex(n2));
        }
        n = this.space.readInt(this.stglobal + 1044);
        if (Dump.verbose) {
            System.out.println("deferredList = " + Jvm.hex(n));
        }
        if (Dump.verbose) {
            System.out.println("");
        }
    }

    void checkTidChain(Document document) {
        boolean bl = false;
        if (this.rootTid != 0) {
            int n = 0;
            int n2 = 0;
            try {
                n = this.rootTid;
                while (n != 0) {
                    int n3 = this.space.readInt(n + 4);
                    if (n3 != n2) {
                        // empty if block
                    }
                    n2 = n;
                    n = this.space.readInt(n);
                }
            }
            catch (Exception exception) {
                document.println("*** uh oh " + Jvm.hex(n));
            }
        }
        if (bl) {
            document.println("");
        }
    }

    String cbName(int n) throws Exception {
        int n2;
        this.init();
        try {
            int n3 = Jvm.offsetof("Hjava_lang_Class", "obj");
            int n4 = Jvm.offsetof("Classjava_lang_Class", "name");
            n2 = this.space.readInt(n + n3 + n4);
        }
        catch (Throwable throwable) {
            n2 = this.oldCbName(n);
        }
        String string = (String)this.names.get(n2);
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                int n5;
                while ((n5 = this.space.readUnsignedByte(n2++)) != 0) {
                    stringBuffer.append((char)n5);
                }
            }
            catch (Exception exception) {
                return "(error reading " + Jvm.hex(n2) + " in cb " + Jvm.hex(n) + " is131 " + this.is131 + ")";
            }
            string = stringBuffer.toString();
            this.names.put(n2, (Object)string);
        }
        return string;
    }

    int oldCbName(int n) throws Exception {
        if (this.space.readInt(n + 28) == n) {
            if (this.checkedVersion) {
                if (this.is131 && this.space.readInt(n + 12) != n) {
                    throw new Error("Blooming heck!");
                }
            } else {
                this.is131 = false;
            }
        } else if (this.checkedVersion) {
            if (!this.is131) {
                throw new Error("Blooming heck!");
            }
        } else {
            this.is131 = true;
        }
        this.checkedVersion = true;
        int n2 = this.is131 ? this.space.readInt(n + 64) : this.space.readInt(n + 12);
        return n2;
    }

    void expect(int n, String string, boolean bl) throws Exception {
        byte[] byArray = bl ? string.getBytes("8859_1") : string.getBytes("Cp500");
        int n2 = Dump.getInt(byArray, 0);
        int n3 = this.space.readInt(n);
        if (n3 != n2) {
            throw new Error("did not find expected eyecatcher! found " + Jvm.hex(n3) + " expected " + Jvm.hex(n2));
        }
    }

    public HeapClass getClass(int n) throws Exception {
        HeapClass heapClass = (HeapClass)this.classes.get(n);
        if (heapClass == null) {
            heapClass = new HeapClass(this, n, this.cbName(n));
            this.classes.put(n, (Object)heapClass);
        }
        return heapClass;
    }

    void addClassChain(int n) {
        try {
            while (n != 0) {
                HeapClass heapClass = this.getClass(n);
                if (Dump.debug) {
                    System.out.println("adding class: " + heapClass);
                }
                n = this.space.readInt(n + 8 + CType.offsetof("MirroredClassData", "memory_table", 24));
            }
        }
        catch (Exception exception) {
            System.out.println("Warning: dodgy cb in class chain: 0x" + Jvm.hex(n));
        }
    }

    boolean isInAllocCache(int n) {
        Tcb[] tcbArray = this.space.tcbs();
        int n2 = 0;
        while (n2 < tcbArray.length) {
            if (tcbArray[n2].jvm == this && tcbArray[n2].inAllocCache(n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isLiveChunk(int n) {
        try {
            int n2 = n - this.mh_heapbase;
            int n3 = n2 >> 8;
            int n4 = n2 >> 3 & 0x1F;
            int n5 = this.space.readInt(this.allocbits + (n3 << 2));
            int n6 = Integer.MIN_VALUE >>> n4;
            boolean bl = (n5 & n6) != 0;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isMarkedChunk(int n) {
        try {
            int n2 = n - this.mh_heapbase;
            int n3 = n2 >> 8;
            int n4 = n2 >> 3 & 0x1F;
            int n5 = this.space.readInt(this.markbits + (n3 << 2));
            int n6 = Integer.MIN_VALUE >>> n4;
            boolean bl = (n5 & n6) != 0;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void processChunks(int n, int n2) throws Exception {
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            boolean bl = this.isLiveChunk(n3);
            int n5 = this.space.readInt(n3);
            int n6 = n5 & 0x3FFFFFF8;
            if (n6 > 0x10000000) {
                System.out.println("bad chunk at " + Jvm.hex(n3) + " chunk[0] = " + Jvm.hex(this.space.readInt(n3)));
                System.out.println("last address = " + Jvm.hex(this.lastaddress));
            }
            if (bl) {
                this.processObject(n3 + 4, n6 - 4);
                if (this.verbose() && (n5 & 1) == 1) {
                    System.out.println("found live swapped chunk at " + Jvm.hex(n3) + " link " + Jvm.hex(n5) + " marked " + this.isMarkedChunk(n3) + " name " + this.getName(n3 + 4));
                }
            } else {
                if (this.verbose() && (n5 & 1) == 1) {
                    System.out.println("found dead swapped chunk at " + Jvm.hex(n3) + " link " + Jvm.hex(n5) + " marked " + this.isMarkedChunk(n3));
                }
                if (this.includeDead) {
                    try {
                        this.processObject(n3 + 4, n6 - 4);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if ((this.verbose() || n4 % 131072 == 0) && this.handler != null) {
                this.handler.log("analyzing heap at " + Jvm.hex(n3) + " total objects so far = " + this.totalObjects);
            }
            if (n6 == 0 || (n3 += n6) < 0 || n3 > n2 + 16) {
                System.out.println("found bad length? " + Jvm.hex(n6));
            }
            if (n6 == 0) break;
            ++n4;
        }
    }

    public Heap getHeap() {
        if (this.heap == null) {
            this.heap = new Heap(this);
        }
        return this.heap;
    }

    void analyze131Heap() throws Exception {
        Tcb[] tcbArray;
        if (this.handler != null) {
            this.handler.log("analyzing classes");
        }
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            tcbArray = (Tcb[])enumeration.nextElement();
            if (this.handler == null) continue;
            try {
                this.handler.classDump(tcbArray.getAddress(), tcbArray.getName(), tcbArray.staticReferences(), 256);
            }
            catch (Exception exception) {
                this.handler.error("Problem dumping class: " + exception);
            }
        }
        if (this.handler != null) {
            this.handler.log("analyzing middleware heap from " + Jvm.hex(this.mh_heapbase) + " to " + Jvm.hex(this.mh_heaplimit));
        }
        this.processChunks(this.mh_heapbase, this.mh_heaplimit);
        if (this.handler != null) {
            this.handler.log("analyzing transient heap from " + Jvm.hex(this.th_heapbase) + " to " + Jvm.hex(this.th_heaplimit));
        }
        this.processChunks(this.th_heapbase, this.th_heaplimit);
        tcbArray = this.space.tcbs();
        int n = 0;
        while (n < tcbArray.length) {
            if (tcbArray[n].jvm == this) {
                int n2 = tcbArray[n].cacheBlock();
                int n3 = tcbArray[n].cacheSize();
                int n4 = tcbArray[n].cacheOrigSize();
                if (n2 != 0 && n3 != 0 && n4 != 0) {
                    try {
                        if (this.handler != null) {
                            this.handler.log("analyzing thread local heap for tcb " + tcbArray[n] + " from " + Jvm.hex(n2 + n3) + " to " + Jvm.hex(n2 + n4));
                        }
                        int n5 = n2 + n3;
                        while (n5 < n2 + n4) {
                            int n6 = this.space.readInt(n5) & 0x3FFFFFF8;
                            this.processObject(n5 + 4, n6 - 4);
                            if ((n6 == 0 || (n5 += n6) < 0) && this.handler != null) {
                                this.handler.log("found bad length? " + Jvm.hex(n6));
                            }
                            if (n6 != 0) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
    }

    int methodsToClass(int n) throws Exception {
        if (this.isPostRas) {
            return this.space.readInt(n + 8);
        }
        return this.space.readInt(n);
    }

    void searchHeap(int n) throws Exception {
        System.out.println("searchHeap: value = " + Jvm.hex(n) + " base = " + Jvm.hex(this.mh_heapbase) + " limit = " + Jvm.hex(this.mh_heaplimit));
        int n2 = this.mh_heapbase;
        while (n2 < this.mh_heaplimit) {
            int n3 = this.space.readInt(n2) & 0x3FFFFFF8;
            int n4 = n2 + 12;
            while (n4 < n2 + n3) {
                if (this.space.readInt(n4) == n) {
                    System.out.println("found it at " + Jvm.hex(n2 + 4));
                    int n5 = this.space.readInt(n2 + 4);
                    int n6 = this.space.readInt(n2 + 8);
                    if ((n6 & 2) == 2) {
                        System.out.println("found ref to " + Jvm.hex(n) + " in array at " + Jvm.hex(n2 + 4));
                    } else if (n5 != 0) {
                        int n7 = this.methodsToClass(n5);
                        String string = this.cbName(n7);
                        System.out.println("found ref to " + Jvm.hex(n) + " in object " + string + " at " + Jvm.hex(n2 + 4));
                    } else {
                        System.out.println("found ref to " + Jvm.hex(n) + " in unknown at " + Jvm.hex(n2 + 4));
                    }
                }
                n4 += 4;
            }
            n2 += n3;
        }
    }

    void analyzeHaifaHeap() throws Exception {
        IntegerArray integerArray = this.space.addresses;
        int n = 0;
        while (n < integerArray.size()) {
            int n2 = integerArray.get(n);
            if (this.space.readInt(n2) == -926820925) {
                int n3 = this.space.readInt(n2 + 24);
                if (this.verbose()) {
                    System.out.println("found HANC at " + Jvm.hex(n2) + " length = " + Jvm.hex(n3) + " in asid " + this.space.hexId());
                }
                if (n3 > 0x6000000) {
                    this.handler.log("found Haifa Java heap of size 0x" + Jvm.hex(n3));
                    int n4 = n2 + 4096;
                    while (n4 < n2 + n3) {
                        try {
                            int n5 = this.space.readInt(n4);
                            int n6 = this.space.readInt(n4 + 4);
                            n4 += this.processBlock(n4);
                        }
                        catch (Exception exception) {
                            if (this.verbose()) {
                                System.out.println("*** error reading " + Jvm.hex(n4) + " ***");
                            }
                            n4 += 4096;
                        }
                    }
                }
            }
            ++n;
        }
    }

    void analyze(HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        this.init();
        this.handler = heapdumpContentHandler;
        if (heapdumpContentHandler != null) {
            heapdumpContentHandler.log("begin heap analysis");
        }
        if (this.is131) {
            this.analyze131Heap();
        } else {
            this.analyzeHaifaHeap();
        }
    }

    public void scanHeap(HeapdumpContentHandler heapdumpContentHandler, boolean bl) throws Exception {
        this.includeDead = bl;
        this.analyze(heapdumpContentHandler);
        heapdumpContentHandler.log("");
        heapdumpContentHandler.log("end heap analysis, cache misses = " + this.space.cacheMisses);
    }

    public void analyzeHeap() {
        Document document = new Document();
        document.setPlainText(Dump.isFromJFormat());
        try {
            this.analyzeHeap(document, new NullHandler());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void analyzeHeap(Document document, HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        this.init();
        this.livecounts = new Hashtable();
        this.analyze(heapdumpContentHandler);
        document.println("");
        document.println("*** dump of live objects in the heap ***");
        document.println("");
        this.printCounts(document, this.livecounts);
        document.println("");
        document.println("end heap analysis, cache misses = " + this.space.cacheMisses);
        document.println("total objects = " + this.totalObjects + " total length = " + this.totalLength);
        if (this.is131 && this.verbose()) {
            document.println("*** dump of free list: ***");
            int n = this.freeList;
            int n2 = 0;
            while (n != 0) {
                try {
                    document.println("chunk = " + Jvm.hex(n) + " free total = " + (n2 += this.space.readInt(n)));
                    n = this.space.readInt(n + 4);
                }
                catch (Exception exception) {
                    document.println("*** problem reading chunk " + Jvm.hex(n));
                    break;
                }
            }
        }
    }

    public void dumpClass(Document document, HeapClass heapClass, boolean bl) throws Exception {
        HeapField[] heapFieldArray;
        heapClass.check();
        if (heapClass.isPrimitive()) {
            System.out.println("primitive class " + heapClass);
            return;
        }
        if (heapClass.isArray()) {
            System.out.println("array class " + heapClass);
            return;
        }
        HeapClass heapClass2 = heapClass.cbSuperclass();
        if (!bl) {
            if (heapClass2 == null) {
                System.out.println("class " + heapClass + " (" + Jvm.hex(heapClass.getAddress()) + ")");
            } else {
                System.out.println("class " + heapClass + " (" + Jvm.hex(heapClass.getAddress()) + ")" + " extends " + heapClass2 + " (" + Jvm.hex(heapClass2.getAddress()) + ")");
            }
            System.out.println("attributes: " + Jvm.hex(heapClass.attribute_flags()));
            System.out.println("shared_class_id: " + Jvm.hex(heapClass.shared_class_id()));
            System.out.println("initial_static_variable_values: " + Jvm.hex(heapClass.initial_static_variable_values()));
            System.out.println("methods:");
        }
        HeapMethod[] heapMethodArray = heapClass.getMethods();
        int n = 0;
        while (n < heapMethodArray.length) {
            heapFieldArray = heapMethodArray[n];
            if (bl) {
                if (heapFieldArray.mbIsNative()) {
                    System.out.println(heapClass + "." + heapFieldArray);
                }
            } else {
                System.out.println("    method " + heapFieldArray);
            }
            if (Dump.verbose) {
                System.out.println("        local variable count " + heapFieldArray.mbLocalVariableCount());
            }
            ++n;
        }
        if (!bl) {
            System.out.println("fields:");
            heapFieldArray = heapClass.getFields();
            int n2 = 0;
            while (n2 < heapFieldArray.length) {
                HeapField heapField = heapFieldArray[n2];
                System.out.println("    " + (heapField.fbIsStatic() ? "static " : "") + (heapField.fbIsFinal() ? "final " : "") + "field " + heapField);
                ++n2;
            }
        }
    }

    public void dumpObject(Document document, int n) throws Exception {
        System.out.println("0x" + Jvm.hex(n) + ": " + this.getName(n) + " link bits " + Jvm.hex(this.space.readInt(n - 4)) + " is live " + this.isLiveChunk(n - 4) + " is marked " + this.isMarkedChunk(n - 4));
    }

    public void dumpMdata(Document document, int n) throws Exception {
        int n2 = this.space.readInt(n);
        HeapMethod heapMethod = new HeapMethod(this, n2);
        System.out.println("Dump of mdata at 0x" + Jvm.hex(n));
        System.out.println("");
        System.out.println("Method: " + heapMethod.fullname());
        System.out.println("");
        int n3 = this.space.readInt(n + 12);
        if (n3 != 0) {
            int n4 = this.space.readInt(n3);
            System.out.println("Found " + n4 + " inlined methods");
            System.out.println("");
            int n5 = 0;
            while (n5 < n4) {
                int n6 = this.space.readInt(n3 + 4 + (n5 << 3));
                int n7 = this.space.readInt(n3 + 8 + (n5 << 3));
                System.out.print("0x" + Jvm.hex(n6) + ": ");
                boolean bl = true;
                while (n7 != 0) {
                    int n8 = this.space.readInt(n7);
                    HeapMethod heapMethod2 = new HeapMethod(this, n8);
                    System.out.print((bl ? "" : " <- ") + heapMethod2.fullname());
                    bl = false;
                    n7 = this.space.readInt(n7 + 4);
                }
                System.out.println("");
                ++n5;
            }
        }
    }

    void dumpClasses(Document document, HeapdumpContentHandler heapdumpContentHandler, boolean bl) throws Exception {
        System.out.println("Scanning heap, please wait...");
        this.analyze(null);
        System.out.println("");
        if (bl) {
            System.out.println("*** dump of all native methods in the heap ***");
        } else {
            System.out.println("*** dump of classes in the heap ***");
        }
        System.out.println("");
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            HeapClass heapClass = (HeapClass)enumeration.nextElement();
            try {
                this.dumpClass(document, heapClass, bl);
            }
            catch (Throwable throwable) {
                System.out.println("Error while dumping " + Jvm.hex(heapClass.getAddress()) + " possible corrupt heap: " + throwable);
            }
        }
    }

    public void dumpClasses(Document document, HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        this.dumpClasses(document, heapdumpContentHandler, false);
    }

    public void dumpNative(Document document, HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        this.dumpClasses(document, heapdumpContentHandler, true);
    }

    public void verifysubpools() throws Exception {
        this.init();
        int n = CType.offsetof("StorageJab", "subpool_id_table", 96);
        int n2 = CType.offsetof("SubpoolHdr", "current_extent", 12);
        System.out.println("offset = " + n);
        int n3 = 1;
        while (n3 < 8) {
            int n4 = this.space.readInt(this.st_jab + n + (n3 << 3));
            int n5 = this.space.readInt(this.st_jab + n + (n3 << 3) + 4);
            System.out.println("token = " + Jvm.hex(n4));
            System.out.println("header = " + Jvm.hex(n5));
            if (n4 != 0 && n5 != 0) {
                Base.Assert((n4 & 0xF) == n3);
                this.expect(n5, "STSM", false);
                int n6 = this.space.readInt(n5 + n2);
                while (n6 != 0) {
                    int n7 = this.space.readInt(n6 - 8);
                    int n8 = this.space.readInt(n6);
                    System.out.println("    extent = " + Jvm.hex(n6));
                    if (n8 != 0) {
                        try {
                            this.expect(n7, "HANC", false);
                        }
                        catch (Exception exception) {
                            System.out.println("    Warning! bad HANC at " + Jvm.hex(n7));
                        }
                    }
                    n6 = n8;
                }
            }
            ++n3;
        }
    }

    public void printversion() throws Exception {
        try {
            int n = Jvm.offsetof("Jvm", "fullVersion");
            int n2 = this.space.readInt(this.jvmp + n);
            System.out.println(this.space.readString(n2));
        }
        catch (Throwable throwable) {
            System.out.println("Must be an old version because there is no types file!");
        }
    }

    public void verifyheap() throws Exception {
        this.badObjects = new BitSetArray();
        this.handler = new HeapdumpContentHandler(){

            void check(int n, int[] nArray) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = nArray[n2];
                    if (!Jvm.this.stIsValidHandle(n3)) {
                        this.error("found bad reference " + Jvm.hex(n3) + " (" + Jvm.this.stIsNotValidHandleReason(n3) + " " + Jvm.this.getName(n3) + ") in object " + Jvm.hex(n) + " (" + Jvm.this.getName(n) + ")");
                    }
                    ++n2;
                }
            }

            public void instanceDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void classDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void objectArrayDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void primitiveArrayDump(int n, int n2, int n3) {
            }

            public void error(String string) {
                System.out.println("Warning: " + string);
            }

            public void log(String string) {
            }

            public void addEdge(int n, int n2) {
            }
        };
        this.analyze131Heap();
        if (this.badObjects.isEmpty()) {
            this.handler = null;
            return;
        }
        System.out.println("");
        System.out.println("Here are the objects that refer to the above objects");
        System.out.println("");
        this.handler = new HeapdumpContentHandler(){

            void check(int n, int[] nArray) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = nArray[n2];
                    if (Jvm.this.badObjects.get(n3 >>> 3)) {
                        System.out.println(Jvm.hex(n3) + " is referenced by " + Jvm.hex(n) + " (" + Jvm.this.getName(n) + ")");
                    }
                    ++n2;
                }
            }

            public void instanceDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void classDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void objectArrayDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void primitiveArrayDump(int n, int n2, int n3) {
            }

            public void error(String string) {
            }

            public void log(String string) {
            }

            public void addEdge(int n, int n2) {
            }
        };
        this.analyze131Heap();
        this.handler = null;
    }

    public void printdosed() throws Exception {
        this.dosedObjects = new BitSetArray();
        this.handler = new HeapdumpContentHandler(){

            void check(int n) {
                try {
                    int n2 = Jvm.this.space.readInt(n - 4);
                    if ((n2 & 7) != 0) {
                        System.out.println("found dosed/pinned bits " + (n2 & 7) + " in object " + Jvm.hex(n) + " " + Jvm.this.getName(n));
                        Jvm.this.dosedObjects.set(n >>> 3);
                    }
                }
                catch (Exception exception) {
                    System.out.println("unexpected exception: " + exception);
                }
            }

            public void instanceDump(int n, String string, int[] nArray, int n2) {
                this.check(n);
            }

            public void classDump(int n, String string, int[] nArray, int n2) {
                this.check(n);
            }

            public void objectArrayDump(int n, String string, int[] nArray, int n2) {
                this.check(n);
            }

            public void primitiveArrayDump(int n, int n2, int n3) {
                this.check(n);
            }

            public void error(String string) {
            }

            public void log(String string) {
            }

            public void addEdge(int n, int n2) {
            }
        };
        this.analyze131Heap();
        if (this.dosedObjects.isEmpty()) {
            this.handler = null;
            return;
        }
        System.out.println("");
        System.out.println("Here are the objects that refer to the above objects");
        System.out.println("");
        this.handler = new HeapdumpContentHandler(){

            void check(int n, int[] nArray) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = nArray[n2];
                    if (Jvm.this.dosedObjects.get(n3 >>> 3)) {
                        System.out.println(Jvm.hex(n3) + " is referenced by " + Jvm.hex(n) + " (" + Jvm.this.getName(n) + ")");
                    }
                    ++n2;
                }
            }

            public void instanceDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void classDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void objectArrayDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void primitiveArrayDump(int n, int n2, int n3) {
            }

            public void error(String string) {
            }

            public void log(String string) {
            }

            public void addEdge(int n, int n2) {
            }
        };
        this.analyze131Heap();
        this.handler = null;
    }

    boolean valid(int n) {
        return this.validObjects.indexOf(n) != -1;
    }

    public void printroots() throws Exception {
        int n;
        int n2;
        int n3;
        StackSegment[] stackSegmentArray;
        Object object;
        this.init();
        System.out.println("mh base = " + Jvm.hex(this.mh_heapbase) + " limit = " + Jvm.hex(this.mh_heaplimit));
        this.validObjects = new IntegerArray();
        this.pinnedObjects = new PinnedObjects();
        System.out.println("scanning heap for valid objects");
        this.handler = new HeapdumpContentHandler(){

            void check(int n, int[] nArray) {
                Jvm.this.validObjects.add(n);
                try {
                    int n2 = Jvm.this.space.readInt(n - 4);
                    if ((n2 & 4) != 0) {
                        Jvm.this.pinnedObjects.add(n, 0);
                    }
                }
                catch (Exception exception) {
                    System.out.println("unexpected exception: " + exception);
                }
            }

            public void instanceDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void classDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void objectArrayDump(int n, String string, int[] nArray, int n2) {
                this.check(n, nArray);
            }

            public void primitiveArrayDump(int n, int n2, int n3) {
                this.check(n, null);
            }

            public void error(String string) {
            }

            public void log(String string) {
            }

            public void addEdge(int n, int n2) {
            }
        };
        this.analyze131Heap();
        this.validObjects.sort();
        System.out.println("scanning tcb stacks");
        Tcb[] tcbArray = this.space.tcbs();
        int n4 = 0;
        while (n4 < tcbArray.length) {
            if (tcbArray[n4].jvm == this) {
                object = tcbArray[n4];
                try {
                    if (((Tcb)object).exceptionObject() != 0) {
                        this.pinnedObjects.add(((Tcb)object).exceptionObject(), 6);
                    }
                    stackSegmentArray = ((Tcb)object).stackSegments();
                    int n5 = 0;
                    while (n5 < stackSegmentArray.length) {
                        StackSegment stackSegment = stackSegmentArray[n5];
                        n3 = stackSegment.lower;
                        while (n3 < stackSegment.upper) {
                            try {
                                n2 = this.space.readInt(n3);
                                if (this.valid(n2)) {
                                    this.pinnedObjects.add(n2, 1);
                                }
                                if (this.valid(n2 - 8)) {
                                    this.pinnedObjects.add(n2 - 8, 2);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            n3 += 4;
                        }
                        ++n5;
                    }
                    n = CType.offsetof("JavaFrame", "prev", -1);
                    n3 = CType.offsetof("JavaFrame", "optop", -1);
                    n2 = CType.offsetof("JavaFrame", "javastack", -1);
                    int n6 = CType.offsetof("JavaStack", "end_data", -1);
                    int n7 = CType.offsetof("JavaStack", "data", -1);
                    int n8 = CType.offsetof("JavaFrame", "ostack", -1);
                    int n9 = CType.offsetof("JavaStack", "prev", -1);
                    int n10 = CType.offsetof("JavaFrame", "current_method", -1);
                    int n11 = ((Tcb)object).current_frame();
                    while (n11 != 0) {
                        int n12 = this.space.readInt(n11 + n3);
                        int n13 = this.space.readInt(n11 + n2);
                        int n14 = n12;
                        int n15 = this.space.readInt(n11 + n10);
                        if (n15 != 0) {
                            HeapMethod heapMethod = new HeapMethod(this, n15);
                        }
                        while (true) {
                            int n16;
                            int n17 = n13 + n7;
                            int n18 = this.space.readInt(n13 + n6);
                            boolean bl = n11 >= n17 && n11 < n18;
                            int n19 = n16 = bl ? n11 + n8 : n17;
                            while (n19 < n14) {
                                int n20 = this.space.readInt(n19);
                                if (this.valid(n20)) {
                                    this.pinnedObjects.add(n20, 3);
                                }
                                if (this.valid(n20 - 8)) {
                                    this.pinnedObjects.add(n20 - 8, 4);
                                }
                                ++n19;
                            }
                            if (bl) break;
                            n13 = this.space.readInt(n13 + n9);
                            n14 = this.space.readInt(n13 + n6);
                        }
                        n11 = this.space.readInt(n11 + n);
                    }
                }
                catch (Exception exception) {
                    System.out.println("unexpected exception: " + exception);
                }
            }
            ++n4;
        }
        System.out.println("analyzing classes");
        object = this.classes.elements();
        while (object.hasMoreElements()) {
            stackSegmentArray = (StackSegment[])object.nextElement();
            if (stackSegmentArray.cbIsInitialized()) continue;
            int[] nArray = stackSegmentArray.staticReferences();
            n = 0;
            while (n < nArray.length) {
                n3 = nArray[n];
                if (this.valid(n3)) {
                    this.pinnedObjects.add(n3, 5);
                }
                ++n;
            }
        }
        this.pinnedObjects.sort();
        int n21 = 0;
        int n22 = 0;
        n = 0;
        while (n < this.pinnedObjects.objects.size()) {
            n3 = this.pinnedObjects.objects.get(n);
            n2 = this.pinnedObjects.reasons.get(n);
            if (n3 != n22) {
                System.out.print("found stuck object: " + Jvm.hex(n3) + " reason: ");
                switch (n2) {
                    case 0: {
                        System.out.print("pinned");
                        break;
                    }
                    case 1: {
                        System.out.print("nativeobject");
                        break;
                    }
                    case 2: {
                        System.out.print("nativehandle");
                        break;
                    }
                    case 3: {
                        System.out.print("javaobject");
                        break;
                    }
                    case 4: {
                        System.out.print("javahandle");
                        break;
                    }
                    case 5: {
                        System.out.print("classstatic");
                        break;
                    }
                    case 6: {
                        System.out.print("exception");
                    }
                }
                System.out.println(" " + this.getName(n3));
            }
            if (n > 0 && n3 >= this.mh_heapbase && n3 < this.mh_heaplimit && n22 >= this.mh_heapbase && n22 < this.mh_heaplimit && n3 - n22 > n21) {
                n21 = n3 - n22;
            }
            n22 = n3;
            ++n;
        }
        System.out.println("biggest gap = " + n21);
    }

    void appendProperties(Table table, int n) throws Exception {
        int n2;
        Base.Assert(n > 0);
        Base.Assert(this.getName(n).equals("java/util/Properties"));
        int n3 = this.space.readInt(n + 8);
        int n4 = this.space.readInt(n + 12);
        int n5 = 0;
        while (n5 < n4) {
            n2 = this.space.readInt(n3 + 8 + (n5 << 2));
            while (n2 != 0) {
                int n6 = this.space.readInt(n2 + 12);
                int n7 = this.space.readInt(n2 + 16);
                String string = this.space.readStringObject(n6);
                String string2 = this.space.readStringObject(n7);
                table.addRow(string, string2);
                n2 = this.space.readInt(n2 + 20);
            }
            ++n5;
        }
        n2 = this.space.readInt(n + 40);
        if (n2 != 0) {
            this.appendProperties(table, n2);
        }
    }

    public void dumpProperties(Document document, HeapdumpContentHandler heapdumpContentHandler) throws Exception {
        System.out.println("Scanning heap, please wait...");
        this.analyze(null);
        document.println("");
        document.println("*** dump of system properties ***");
        document.println("");
        Table table = new Table("key", "value");
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            HeapClass heapClass = (HeapClass)enumeration.nextElement();
            if (!"java/lang/System".equals(heapClass.toString())) continue;
            int n = heapClass.getStaticField("props");
            this.appendProperties(table, n);
            break;
        }
        document.addElement(table);
    }

    public void dumpverbosegc(Document document) throws Exception {
        try {
            int n = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "vgc_version"));
            int n2 = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "vgc_buflen"));
            int n3 = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "vgc_offset"));
            int n4 = this.space.readInt(this.stglobal + Jvm.offsetof("STGlobal", "vgc_buf"));
            if (n != 2) {
                System.out.println("Bad vgc version! " + n);
                return;
            }
            VgcReader vgcReader = new VgcReader(n2, n3, n4);
            Table table = new Table(new String[]{"af", "size", "free", "total", "mark", "sweep", "compact", "elapsed"});
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            while (n15 < vgcReader.max_records) {
                int n16 = vgcReader.tag();
                switch (n16) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        n5 = vgcReader.readInt(0);
                        n6 = vgcReader.readInt(1);
                        n7 = vgcReader.readInt(2);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 13: {
                        n14 = vgcReader.readInt(0);
                        table.addRow(new int[]{n5, n6, n9, n10, n11, n12, n13, n14});
                        break;
                    }
                    case 14: {
                        break;
                    }
                    case 15: {
                        n8 = vgcReader.readInt(0);
                        n9 = vgcReader.readInt(1);
                        n10 = vgcReader.readInt(2);
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 17: {
                        break;
                    }
                    case 18: {
                        break;
                    }
                    case 19: {
                        break;
                    }
                    case 20: {
                        n11 = vgcReader.readInt(0);
                        n12 = vgcReader.readInt(1);
                        n13 = vgcReader.readInt(2);
                        break;
                    }
                    default: {
                        Base.Assert(false);
                    }
                }
                vgcReader.nextRecord();
                ++n15;
            }
            document.addElement(table);
        }
        catch (Throwable throwable) {
            System.out.println("No verbosegc found in this dump, are you sure it is SR22 or later?");
            this.printversion();
        }
    }

    void printCounts(Document document, Hashtable hashtable) {
        Object object;
        final String[] stringArray = new String[hashtable.size()];
        IntegerArray integerArray = new IntegerArray();
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            int n2 = (Integer)hashtable.get(object);
            stringArray[n++] = object;
            integerArray.add(n2);
        }
        integerArray.reverseSort(new SortListener(){

            public void swap(int n, int n2) {
                String string = stringArray[n];
                stringArray[n] = stringArray[n2];
                stringArray[n2] = string;
            }
        });
        object = new Table(new String[]{"count", "class"});
        n = 0;
        while (n < hashtable.size()) {
            ((Table)object).addRow(new String[]{"" + integerArray.get(n), stringArray[n]});
            ++n;
        }
        document.addElement((Element)object);
    }

    final int arrayLength(int n, int n2) {
        int n3 = n >> 3;
        int n4 = 1 << (n3 & 3);
        n4 *= n2;
        return n4 += 8;
    }

    int processBlock(int n) throws Exception {
        int n2;
        int n3;
        int n4 = this.space.readInt(n);
        int n5 = this.space.readInt(n + 4);
        if ((n5 & 2) == 2 && n5 <= 122) {
            n3 = this.arrayLength(n5, n4);
            if (n3 >= 2048) {
                this.processObject(n, n3);
                return n3 + 4095 & 0xFFFFF000;
            }
        } else {
            if (n5 != 0) {
                if (this.verbose()) {
                    System.out.println("unknown block flags at " + Jvm.hex(n));
                }
                return 4096;
            }
            n3 = 8;
        }
        int n6 = n3 + 3 & 0xFFFFFFFC;
        boolean bl = true;
        while (n6 < 2048) {
            bl = true;
            n2 = n + n6;
            while (n2 < n + 4096) {
                block17: {
                    n4 = this.space.readInt(n2);
                    n5 = this.space.readInt(n2 + 4);
                    if ((n5 & 2) == 2 && n5 <= 122) {
                        n3 = this.arrayLength(n5, n4);
                        if (n3 > n6) {
                            bl = false;
                            break;
                        }
                    } else {
                        if (n5 != 0 || n4 != 0 && n4 < 0x10000000 || (n4 & 3) != 0) {
                            bl = false;
                            break;
                        }
                        try {
                            if (n4 == 0) break block17;
                            int n7 = this.space.readInt(n4);
                            int n8 = this.space.readInt(n7 + 12);
                        }
                        catch (Exception exception) {
                            bl = false;
                            break;
                        }
                    }
                }
                n2 += n6;
            }
            if (bl) break;
            n6 += 4;
        }
        if (bl) {
            n2 = n;
            while (n2 < n + 4096) {
                this.processObject(n2, n6);
                n2 += n6;
            }
        } else if (this.verbose()) {
            System.out.println("couldn't figure out " + Jvm.hex(n));
        }
        return 4096;
    }

    boolean isMiddlewareHandle(int n) {
        try {
            int n2 = this.space.readUnsignedByte(this.slicemap_base + (n >>> 16));
            return (n2 & 4) != 0 && n >= this.mh_heapbase && n < this.mh_heaplimit;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isTransientHandle(int n) {
        try {
            int n2 = this.space.readUnsignedByte(this.slicemap_base + (n >>> 16));
            return (n2 & 8) != 0 && n >= this.th_heapbase && n < this.th_heaplimit;
        }
        catch (Exception exception) {
            return false;
        }
    }

    String stIsNotValidHandleReason(int n) {
        if ((n & 7) != 0) {
            return "bad alignment";
        }
        try {
            int n2 = this.space.readUnsignedByte(this.shared_slicemap_base + (n >>> 16));
            if ((n2 & 3) != 0) {
                return null;
            }
            if (!this.isLiveChunk(n - 4)) {
                if (this.isInAllocCache(n - 4)) {
                    return null;
                }
                return "not live";
            }
            n2 = this.space.readUnsignedByte(this.slicemap_base + (n >>> 16));
            if ((n2 & 4) != 0 && n >= this.mh_heapbase && n < this.mh_heaplimit) {
                return null;
            }
            if ((n2 & 8) != 0 && n >= this.th_heapbase && n < this.th_heaplimit) {
                return null;
            }
            return "out of range";
        }
        catch (Exception exception) {
            return "exception: " + exception;
        }
    }

    boolean stIsValidHandle(int n) {
        return this.stIsNotValidHandleReason(n) == null;
    }

    void addCount(int n) {
        String string = this.getName(n);
        Integer n2 = (Integer)this.livecounts.get(string);
        if (n2 == null) {
            this.livecounts.put(string, new Integer(1));
        } else {
            this.livecounts.put(string, new Integer(n2 + 1));
        }
    }

    public boolean is_normal_object(int n) {
        return (n & 2) == 0;
    }

    public HeapClass getObjectClass(int n) throws Exception {
        HeapClass heapClass;
        int n2 = this.space.readInt(n);
        int n3 = this.space.readInt(n + 4);
        if (this.is_normal_object(n3)) {
            int n4 = this.methodsToClass(n2);
            heapClass = this.getClass(n4);
        } else if (n3 > 0 && n3 <= 122) {
            if (n3 == 18) {
                int n5 = this.space.readInt(n + 8 + (n2 << 2));
                heapClass = this.getClass(n5);
                heapClass = heapClass.getArrayClass();
            } else {
                heapClass = HeapClass.getPrimitiveArrayClass(n3 >> 3 & 0xF);
            }
        } else {
            throw new Exception("Unknown flags: " + Jvm.hex(n3));
        }
        return heapClass;
    }

    int[] getRefArray(int n) {
        int[] nArray = (int[])this.refArrays.get(n);
        if (nArray == null) {
            nArray = new int[n];
            this.refArrays.put(n, (Object)nArray);
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void processObject(int n, int n2) throws Exception {
        this.totalLength += n2;
        ++this.totalObjects;
        this.lastaddress = n;
        int n3 = this.space.readInt(n);
        int n4 = this.space.readInt(n + 4);
        if (this.livecounts != null) {
            this.addCount(n);
        }
        boolean bl = this.isMiddlewareHandle(n);
        if (this.is_normal_object(n4)) {
            try {
                int[] nArray;
                int n5 = 0;
                HeapClass heapClass = null;
                try {
                    n5 = this.methodsToClass(n3);
                    heapClass = this.getClass(n5);
                }
                catch (Exception exception) {
                    if (this.handler == null) throw new Exception("Problem reading object at " + Jvm.hex(n) + " with methods " + Jvm.hex(n3) + ": " + exception);
                    this.handler.error("Problem reading object at " + Jvm.hex(n) + " with methods " + Jvm.hex(n3) + ": " + exception);
                    return;
                }
                if (heapClass.isJavaLangClass()) {
                    HeapClass heapClass2 = this.getClass(n);
                    if (this.handler == null) return;
                    try {
                        this.handler.classDump(n, this.cbName(n), heapClass2.staticReferences(), n2);
                        return;
                    }
                    catch (Exception exception) {
                        this.handler.error("Problem dumping class: " + exception);
                    }
                    return;
                }
                if (this.handler == null) return;
                if (!includeReferences && heapClass.isInstanceOfReference()) {
                    if (!Dump.verbose) return;
                    System.out.println("exclude reference " + Jvm.hex(n) + " " + heapClass);
                    return;
                }
                int n6 = heapClass.cbObjectOffsets();
                if (n6 != 0) {
                    int n7;
                    int n8;
                    int n9 = 0;
                    try {
                        while (true) {
                            n8 = 0;
                            try {
                                n8 = this.space.readUnsignedShort(n6);
                            }
                            catch (Exception exception) {
                                throw new Exception("Problem reading class offset for object at " + Jvm.hex(n) + " with class " + Jvm.hex(n5) + ": " + exception);
                            }
                            if (n8 != 0) {
                                if (n8 < 0 || n8 >= n2 || (n8 & 1) == 0) {
                                    throw new Exception("Bad class offset" + n8 + " for object at " + Jvm.hex(n) + " with class " + Jvm.hex(n5));
                                }
                                n7 = this.space.readInt(n + 7 + n8);
                                if (n7 != 0 && this.stIsValidHandle(n7)) {
                                    ++n9;
                                }
                                n6 += 2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        if (this.handler == null) throw exception;
                        this.handler.error("Problem reading class offset for object at " + Jvm.hex(n) + " with class " + Jvm.hex(n5) + ": " + exception);
                        return;
                    }
                    nArray = this.getRefArray(n9);
                    n6 = heapClass.cbObjectOffsets();
                    n8 = 0;
                    while ((n7 = this.space.readUnsignedShort(n6)) != 0) {
                        int n10 = this.space.readInt(n + 7 + n7);
                        if (n10 != 0) {
                            if (this.stIsValidHandle(n10)) {
                                nArray[n8++] = n10;
                                if (Dump.verbose && bl != this.isMiddlewareHandle(n10)) {
                                    this.handler.error("found cross heap reference from" + (bl ? " middleware " : " transient ") + heapClass + " " + Jvm.hex(n) + "to " + (this.isMiddlewareHandle(n10) ? "middleware " : " transient ") + Jvm.hex(n10));
                                }
                            } else {
                                this.handler.error("found bad reference " + Jvm.hex(n10) + " (" + this.stIsNotValidHandleReason(n10) + ") in object " + Jvm.hex(n) + " (" + this.getName(n) + ")");
                                if (this.badObjects != null) {
                                    this.badObjects.set(n >>> 3);
                                }
                            }
                        }
                        n6 += 2;
                    }
                } else {
                    nArray = this.getRefArray(0);
                }
                this.handler.instanceDump(n, heapClass.toString(), nArray, n2);
                return;
            }
            catch (Exception exception) {
                if (this.includeDead) throw new Error("yuk");
                exception.printStackTrace();
                throw new Error("yuk");
            }
        }
        if (n4 <= 0 || n4 > 122 || this.handler == null) return;
        if (n4 == 18) {
            int n11;
            IntegerArray integerArray = null;
            int n12 = 0;
            while (n12 < n3) {
                n11 = this.space.readInt(n + 8 + (n12 << 2));
                if (n11 != 0) {
                    if (this.stIsValidHandle(n11)) {
                        if (integerArray == null) {
                            integerArray = new IntegerArray();
                        }
                        integerArray.add(n11);
                        if (Dump.verbose && bl != this.isMiddlewareHandle(n11)) {
                            this.handler.error("found cross heap reference from" + (bl ? " middleware " : " transient ") + Jvm.hex(n) + " to " + (this.isMiddlewareHandle(n11) ? "middleware " : " transient ") + Jvm.hex(n11));
                        }
                    } else {
                        this.handler.error("found bad reference " + Jvm.hex(n11) + " (" + this.stIsNotValidHandleReason(n11) + ") in object " + Jvm.hex(n) + " (" + this.getName(n) + ")");
                        if (this.badObjects != null) {
                            this.badObjects.set(n >>> 3);
                        }
                    }
                }
                ++n12;
            }
            n11 = this.space.readInt(n + 8 + (n3 << 2));
            int[] nArray = integerArray == null ? new int[]{} : integerArray.toArray();
            this.handler.objectArrayDump(n, this.cbName(n11), nArray, n2);
            return;
        } else {
            this.handler.primitiveArrayDump(n, n4 >> 3 & 0xF, n2);
        }
    }

    public String xgetName(int n) {
        return this.getName(n);
    }

    public String getName(int n) {
        try {
            HeapClass heapClass = this.getObjectClass(n);
            String string = heapClass.toString();
            if (string.equals("java/lang/Class")) {
                string = "class " + this.cbName(n);
            }
            return string;
        }
        catch (Exception exception) {
            return "error";
        }
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    public int asid() {
        return this.space.id;
    }

    boolean isMmiFrame(Dsa dsa) {
        if (this.mmiLow == 0) {
            Dsa dsa2 = dsa.tcb.topDsa;
            while (dsa2 != null) {
                if (dsa2.simpleFunction().equals("EXECJAVA")) {
                    this.mmiLow = dsa2.entryPoint();
                    this.mmiHigh = this.mmiLow + 60000;
                    break;
                }
                dsa2 = dsa2.previous();
            }
        }
        return dsa.entryPoint() >= this.mmiLow && dsa.entryPoint() < this.mmiHigh;
    }

    public String toString() {
        return "0x" + Jvm.hex(this.jvmp);
    }

    class VgcReader {
        int vgc_buflen;
        int vgc_offset;
        int vgc_buf;
        int vgc_head;
        int vgc_ptr;
        int max_records;
        int record;

        VgcReader(int n, int n2, int n3) throws Exception {
            int n4;
            int n5;
            this.vgc_buflen = n;
            this.vgc_offset = n2;
            this.vgc_buf = n3;
            int n6 = 0;
            int n7 = 0;
            while (n7 < vgc_record_lengths.length) {
                if (vgc_record_lengths[n7] > n6) {
                    n6 = vgc_record_lengths[n7];
                }
                ++n7;
            }
            this.max_records = 0;
            this.vgc_head = n3 + n2;
            int n8 = 0;
            while (n8 < n6) {
                this.vgc_ptr = n3 + n2 + n8;
                n5 = 0;
                n4 = 0;
                while (n4 < n) {
                    int n9 = this.nextRecordLength();
                    if (n9 == -1) break;
                    n4 += n9;
                    this.vgc_ptr = this.nextRecord(this.vgc_ptr, n9);
                    ++n5;
                }
                if (n5 > this.max_records) {
                    this.vgc_head = n3 + n2 + n8;
                    this.max_records = n5;
                }
                ++n8;
            }
            this.vgc_ptr = this.vgc_head;
            if (this.max_records == 0) {
                this.vgc_ptr = n3;
                n5 = 0;
                while (n5 < n) {
                    n4 = this.nextRecordLength();
                    if (n4 == -1) break;
                    n5 += n4;
                    this.vgc_ptr = this.nextRecord(this.vgc_ptr, n4);
                    ++this.max_records;
                }
                this.vgc_ptr = n3;
            }
        }

        boolean more() {
            return this.record < this.max_records;
        }

        int tag() throws Exception {
            int n = Jvm.this.space.readUnsignedByte(this.vgc_ptr);
            if (n == 14) {
                int n2 = this.nextRecord(this.vgc_ptr, 9);
                int n3 = Jvm.this.space.readUnsignedByte(n2);
                if (n3 == 15 || n3 == 14) {
                    return 14;
                }
                return 20;
            }
            return n;
        }

        int nextRecord(int n, int n2) {
            if ((n += n2) >= this.vgc_buf + this.vgc_buflen) {
                n -= this.vgc_buflen;
            }
            return n;
        }

        int nextRecordLength() throws Exception {
            int n = this.tag();
            if (n == 0 || n > 20) {
                return -1;
            }
            return vgc_record_lengths[n];
        }

        void nextRecord() throws Exception {
            this.vgc_ptr = this.nextRecord(this.vgc_ptr, this.nextRecordLength());
        }

        int readInt(int n) throws Exception {
            return Jvm.this.space.readInt(this.vgc_ptr + 1 + (n << 2));
        }
    }
}

