/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvJavaStack;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvNativeStack;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvRegister;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.svcdump.Address;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Caa;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Function;
import com.ibm.jvm.svcdump.JavaFrame;
import com.ibm.jvm.svcdump.JavaStack;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.NativeFrame;
import com.ibm.jvm.svcdump.NativeStack;
import com.ibm.jvm.svcdump.StackSegment;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Row;
import com.ibm.jvm.util.html.Table;
import java.util.Hashtable;
import java.util.Vector;

public class Tcb
extends DvThread {
    AddressSpace space;
    int topDsaAddress;
    Dsa topDsa;
    Dsa[] stack;
    int tcbid;
    int tid;
    int ee;
    int jvmp;
    int state;
    Caa caa;
    String type;
    boolean isKnownType;
    boolean scannedTid;
    Hashtable traceTable;
    Function[] traceFunctions;
    static final int STCB = 312;
    static final int OTCB = 216;
    static final int THLI = 188;
    static final int TID = 52;
    boolean is131 = false;
    boolean is141 = false;
    boolean verbose = Dump.debug;
    boolean isPostRas = false;
    int[] failingRegisters;
    Jvm jvm;
    boolean dodgy = false;
    int cacheBlock = 0;
    int cacheSize = 0;
    int cacheOrigSize = 0;
    NativeStack nativeStack;
    JavaStack javaStack;
    boolean xplinkon;
    boolean usesXplink;
    static int debugtcb = SvcdumpProperties.getIntProperty("svcdump.debugtcb", -1, 16);
    static final int EXECMODE_BYTECODE = 0;
    static final int EXECMODE_COMPILEDCODE = 1;
    static final int EXECMODE_JITCOMPILE = 2;
    static final int EXECMODE_MASK = 3;
    static final int ftNone = 0;
    static final int ftJava = 1;
    static final int ftJITed = 2;
    static final int ftInlined = 3;
    static final int ftJITing = 4;
    static final int INVALID_JITF = 0;
    static final int INVALID_CC = 0;
    static final int INVALID_IMF = 0;
    static final int INVALID_JITPC = 0;

    public DvProcess getProcess() {
        return this.space.getProcesses()[0];
    }

    public String id() {
        return this.hexId();
    }

    public boolean isJava() {
        return this.tid != 0;
    }

    public DvAddress eeAddress() {
        return new Address(this.ee);
    }

    public DvNativeFrame[] getNativeFrames() {
        Vector<NativeFrame> vector = new Vector<NativeFrame>();
        Dsa dsa = this.topDsa;
        while (dsa != null) {
            vector.add(new NativeFrame(dsa));
            dsa = dsa.previous();
        }
        return vector.toArray(new DvNativeFrame[0]);
    }

    public DvJavaFrame[] getJavaFrames() {
        throw new Error("unimplemented method");
    }

    public DvAddress getPSW() {
        throw new Error("unimplemented method");
    }

    public DvRegister[] getRegisters() {
        return null;
    }

    public int current_frame() throws Exception {
        int n = CType.offsetof("execenv", "current_frame", 8);
        int n2 = this.space.readInt(this.ee + n);
        return n2;
    }

    public DvJavaStack get141JavaStack() {
        block4: {
            try {
                JavaFrame javaFrame = new JavaFrame(this);
                if (javaFrame.mb() == null) {
                    return null;
                }
                Vector<JavaFrame> vector = new Vector<JavaFrame>();
                while (javaFrame != null) {
                    vector.add(javaFrame);
                    javaFrame = javaFrame.previous();
                }
                DvJavaFrame[] dvJavaFrameArray = vector.toArray(new DvJavaFrame[0]);
                this.javaStack = new JavaStack(dvJavaFrameArray);
            }
            catch (Exception exception) {
                if (!this.verbose) break block4;
                System.out.println("unexpected exception: " + exception);
                exception.printStackTrace();
            }
        }
        return this.javaStack;
    }

    int getFirstPrevDSA(int n) throws Exception {
        int n2 = this.space.readInt(n + 2048);
        Tcb.Assert(n2 != 0);
        int n3 = this.space.readInt(n2 + 2048 + 12);
        if (n3 == 0) {
            return this.skipTransitionFrame(n2);
        }
        return n2;
    }

    int skipTransitionFrame(int n) throws Exception {
        throw new Error("tcb " + this + ": to be completed");
    }

    int getJitPC(int n) throws Exception {
        if (this.IsLJITFSet()) {
            int n2 = this.space.readInt(n + 2048);
            Tcb.Assert(n2 != 0);
            int n3 = this.space.readInt(n2 + 2048 + 12);
            if (n3 == 0) {
                throw new Error("tcb " + this + ": to be completed");
            }
            return this.ADDR_MASK(this.space.readInt(n + 2048 + 12));
        }
        throw new Error("tcb " + this + ": to be completed");
    }

    int stptbl_lookup(int n, int n2) throws Exception {
        int n3 = this.GET_MDATA(n);
        int n4 = this.IsLJITFSet() ? n2 & Integer.MAX_VALUE : this.g3_getpc(n);
        int n5 = this.space.readInt(n3);
        if (n5 == 0 || n5 == -1) {
            return 0;
        }
        int n6 = this.space.readInt(n5 + 20);
        if (n6 == 0) {
            return 0;
        }
        int n7 = this.space.readInt(n3 + 12);
        if (n7 == 0) {
            return 0;
        }
        int n8 = this.space.readInt(n7);
        int n9 = n7 + 4;
        int n10 = 0;
        while (n10 < n8) {
            int n11 = this.space.readInt(n9 + n10 * 8);
            if (this.ADDR_MASK(n11) == this.ADDR_MASK(n4)) {
                return this.space.readInt(n9 + n10 * 8 + 4);
            }
            if (this.ADDR_MASK(n11) > this.ADDR_MASK(n4)) break;
            ++n10;
        }
        return 0;
    }

    int ADDR_MASK(int n) {
        return n & Integer.MAX_VALUE;
    }

    int g3_getpc(int n) throws Exception {
        throw new Error("tcb " + this + ": to be completed");
    }

    int GET_MDATA(int n) throws Exception {
        int n2 = this.space.readInt(n + 2048 + 8);
        return n2 - 16 - 56;
    }

    int eeGetJITEE() throws Exception {
        int n = CType.offsetof("execenv", "jit_ee", -1);
        return this.ee + n;
    }

    int exec_mode() throws Exception {
        int n = CType.offsetof("jit_execenv", "exec_mode", -1);
        return this.space.readInt(this.eeGetJITEE() + n);
    }

    int last_frame() throws Exception {
        int n = CType.offsetof("jit_execenv", "last_frame", -1);
        return this.space.readInt(this.eeGetJITEE() + n);
    }

    boolean IsLJITFSet() throws Exception {
        int n = CType.offsetof("jit_execenv", "slot", -1);
        return this.space.readInt(this.eeGetJITEE() + n + 8) != 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DvJavaStack getJavaStack() {
        if (this.javaStack == null) {
            int n;
            Vector<void> vector;
            block14: {
                if (this.is141) {
                    return this.get141JavaStack();
                }
                vector = new Vector<void>();
                try {
                    void var3_10;
                    void var3_9;
                    n = this.last_frame();
                    if (n != 0) {
                        Dsa dsa = new Dsa(this, n);
                        if (dsa.isMmiFrame()) {
                            JavaFrame javaFrame = new JavaFrame(dsa, 0);
                        } else {
                            JavaFrame javaFrame = new JavaFrame(dsa, 2);
                        }
                    } else {
                        JavaFrame javaFrame = new JavaFrame(this.current_frame(), this);
                    }
                    if (var3_9.mb() == null && var3_9.previous() == null) {
                        return null;
                    }
                    while (var3_10 != null) {
                        vector.add(var3_10);
                        JavaFrame javaFrame = var3_10.previous();
                    }
                }
                catch (Exception exception) {
                    if (!this.verbose) break block14;
                    System.out.println("getJavaStack: " + exception + " in tcb " + this);
                    exception.printStackTrace(System.out);
                }
            }
            n = vector.size() - 1;
            while (n >= 0) {
                JavaFrame javaFrame = (JavaFrame)vector.elementAt(n);
                try {
                    if (javaFrame.mb() != null) break;
                    vector.remove(n);
                }
                catch (Exception exception) {
                    break;
                }
                --n;
            }
            DvJavaFrame[] dvJavaFrameArray = vector.toArray(new DvJavaFrame[0]);
            this.javaStack = new JavaStack(dvJavaFrameArray);
        }
        return this.javaStack;
    }

    public DvNativeStack getNativeStack() {
        if (this.nativeStack == null) {
            this.nativeStack = new NativeStack(this.getNativeFrames());
        }
        return this.nativeStack;
    }

    public int cacheBlock() {
        if (this.cacheBlock != 0) {
            return this.cacheBlock;
        }
        if (this.ee == 0) {
            return 0;
        }
        try {
            int n = this.space.readInt(this.ee + 40);
            this.space.readInt(n);
            this.cacheBlock = n;
        }
        catch (Exception exception) {}
        return this.cacheBlock;
    }

    public int cacheSize() {
        if (this.cacheSize != 0 || this.cacheBlock() == 0) {
            return this.cacheSize;
        }
        if (this.ee == 0) {
            return 0;
        }
        try {
            this.cacheSize = this.space.readInt(this.ee + 36);
        }
        catch (Exception exception) {}
        return this.cacheSize;
    }

    public int cacheOrigSize() {
        if (this.cacheOrigSize != 0 || this.cacheBlock() == 0) {
            return this.cacheOrigSize;
        }
        if (this.ee == 0) {
            return 0;
        }
        try {
            this.cacheOrigSize = this.space.readInt(this.ee + 44);
        }
        catch (Exception exception) {}
        return this.cacheOrigSize;
    }

    public boolean inAllocCache(int n) {
        try {
            if (n >= this.cacheBlock() + this.cacheSize() && n <= this.cacheBlock() + this.cacheOrigSize()) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasPendingException() {
        block3: {
            if (this.ee == 0 || !this.is131) break block3;
            try {
                if (this.exceptionKind() != 0) {
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public void printException() {
        Document document = new Document();
        document.setPlainText(Dump.isFromJFormat());
        this.printException(document);
    }

    public void printException(Document document) {
        block3: {
            if (this.ee == 0 || !this.is131) break block3;
            try {
                int n = this.exceptionObject();
                if (n != 0) {
                    document.println("");
                    String string = this.jvm.getName(n);
                    String string2 = this.space.readStringObject(this.space.readInt(n + 12));
                    String string3 = this.exceptionKind() == 0 ? "old" : "pending";
                    document.println("found " + string3 + " exception: " + string + ": " + string2);
                }
            }
            catch (Exception exception) {}
        }
    }

    int exceptionKind() throws Exception {
        return this.space.readByte(this.ee + CType.offsetof("execenv", "exceptionKind", -1));
    }

    int exceptionObject() throws Exception {
        return this.space.readInt(this.ee + CType.offsetof("execenv", "exception", -1));
    }

    public void printJavaStack(Document document) {
        DvJavaStack dvJavaStack = this.getJavaStack();
        if (dvJavaStack != null) {
            document.println("");
            document.println("Java stack:");
            document.println("");
            Table table = new Table("Method", "Location");
            int n = 0;
            while ((long)n < dvJavaStack.getNumFrames()) {
                JavaFrame javaFrame = (JavaFrame)dvJavaStack.getFrame(n);
                table.addRow(javaFrame.fullname(), javaFrame.description());
                ++n;
            }
            document.addElement(table);
        }
    }

    public void printAllocCache() {
        Document document = new Document();
        document.setPlainText(Dump.isFromJFormat());
        this.printAllocCache(document);
    }

    public void printAllocCache(Document document) {
        block9: {
            if (this.ee == 0 || !this.is131) break block9;
            try {
                int n;
                document.println("");
                document.println("alloc cache info:");
                int n2 = this.space.readInt(this.ee + 32);
                int n3 = this.space.readInt(this.ee + 68);
                document.println("cache_busy = 0x" + Tcb.hex(n2));
                document.println("cache_block = 0x" + Tcb.hex(this.cacheBlock()));
                document.println("cache_size = 0x" + Tcb.hex(this.cacheSize()) + " -> 0x" + Tcb.hex(this.cacheBlock() + this.cacheSize()));
                document.println("cache_orig_size = 0x" + Tcb.hex(this.cacheOrigSize()) + " -> 0x" + Tcb.hex(this.cacheBlock() + this.cacheOrigSize()));
                document.println("target_size = 0x" + Tcb.hex(n3));
                int n4 = 0;
                if (this.cacheBlock() != 0 && this.cacheSize() != 0) {
                    n = this.cacheOrigSize() - this.cacheSize();
                    int n5 = this.cacheBlock() + this.cacheSize();
                    int n6 = n5 + n;
                    int n7 = this.space.readInt(this.cacheBlock() - 12);
                    int n8 = this.space.readInt(this.cacheBlock() - 8);
                    int n9 = this.space.readInt(this.cacheBlock() - 4);
                    document.println("cache link size = 0x" + Tcb.hex(n7));
                    document.println("cache obj size = 0x" + Tcb.hex(n8));
                    document.println("cache flags = 0x" + Tcb.hex(n9));
                    document.println("");
                    Table table = new Table(new String[]{"address", "length", "methods", "flags", "class name"});
                    while (n5 < n6) {
                        Row row = new Row();
                        int n10 = this.space.readInt(n5) & 0x3FFFFFF8;
                        row.addCell(Tcb.hex(n5));
                        row.addCell(Tcb.hex(n10));
                        int n11 = this.space.readInt(n5 + 4);
                        int n12 = this.space.readInt(n5 + 8);
                        row.addCell(Tcb.hex(n11));
                        row.addCell(Tcb.hex(n12));
                        if (n11 != 0) {
                            String string = this.jvm.getName(n5 + 4);
                            row.addCell(string);
                        } else {
                            row.addCell("");
                        }
                        table.addRow(row);
                        if (n10 <= 0 || n10 > this.cacheOrigSize()) {
                            n4 = n5;
                            break;
                        }
                        n5 += n10;
                    }
                    document.addElement(table);
                }
                if (n4 != 0) {
                    document.println("*** dodgy alloc cache? dump follows ***");
                    n = this.cacheBlock();
                    while (n < n4 + 256) {
                        document.println("0x" + Tcb.hex(n) + ": " + Tcb.hex(this.space.readInt(n)));
                        n += 4;
                    }
                }
            }
            catch (Exception exception) {
                document.println("problem reading ee " + Tcb.hex(this.ee) + " exception: " + exception);
            }
        }
    }

    void checkEE() throws Exception {
        if (this.verbose) {
            System.out.println("asid = " + this.space.hexId() + " ee = " + Tcb.hex(this.ee));
        }
        int n = this.space.readInt(this.ee);
        if (this.verbose) {
            System.out.println("jnienv = " + Tcb.hex(n));
        }
        int n2 = this.space.readInt(n + 4);
        if (this.verbose) {
            System.out.println("reserved1 = " + Tcb.hex(n2));
        }
        if (n2 != 0) {
            throw new Exception("reserved1 is not zero! " + n2);
        }
        int n3 = this.space.readInt(this.ee + 12);
        if (this.verbose) {
            System.out.println("thread = " + Tcb.hex(n3));
        }
        if (n3 == 0) {
            throw new Exception("thread pointer in ee is zero");
        }
        int n4 = this.space.readInt(n3);
        if (this.verbose) {
            System.out.println("methodtable = " + Tcb.hex(n4));
        }
        int n5 = this.space.readInt(n4);
        if (this.verbose) {
            System.out.println("eyecatcher = " + Tcb.hex(n5));
        }
        if (n5 == 1129074004) {
            this.isPostRas = true;
        }
    }

    void oldFindEE() throws Exception {
        this.ee = this.space.readInt(this.tid + 40);
        if (this.ee < 65536) {
            this.ee = this.tid - 512;
            this.is131 = true;
            if (this.verbose) {
                System.out.println("found post 118 ee: " + Tcb.hex(this.ee));
            }
            if (this.space.readInt(this.ee - 24) == 1481459013) {
                this.ee -= 16;
                this.isPostRas = true;
                if (this.verbose) {
                    System.out.println("adjust ee for SR15: " + Tcb.hex(this.ee));
                }
            } else if (this.space.readInt(this.ee - 40) == 1481459013) {
                this.ee -= 32;
                this.isPostRas = true;
                if (this.verbose) {
                    System.out.println("adjust ee for SR18: " + Tcb.hex(this.ee));
                }
            } else {
                int n = 0;
                while (n < 256) {
                    if (this.space.readInt(this.ee + n) == 1481459013) {
                        this.ee += n + 8;
                        if (this.verbose) {
                            System.out.println("adjust ee for 141: " + Tcb.hex(this.ee));
                        }
                        this.is141 = true;
                        break;
                    }
                    n += 4;
                }
            }
            this.jvmp = this.space.readInt(this.ee + 452);
            if (this.is141) {
                this.jvmp = this.space.readInt(this.ee + 340);
            }
        } else {
            if (this.verbose) {
                System.out.println("throw exception for bad ee " + Tcb.hex(this.ee));
            }
            throw new Exception("bad ee " + Tcb.hex(this.ee));
        }
    }

    void findEE() throws Exception {
        try {
            int n = Jvm.offsetof("execenv", "sys_thr");
            this.ee = this.tid - n;
            if (this.space.readInt(this.ee - 8) != 1481459013) {
                throw new Exception("No ee eyecatcher!");
            }
            this.jvmp = this.space.readInt(this.ee + Jvm.offsetof("execenv", "jvmP"));
            this.isPostRas = true;
            this.is131 = true;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                System.out.println("findEE failed, using old method: " + throwable);
            }
            this.oldFindEE();
        }
    }

    void findDsaFromLastFrame() {
        block7: {
            if (this.verbose) {
                System.out.println("findDsaFromLastFrame begin");
            }
            try {
                int n = 0;
                n = this.is131 ? this.space.readInt(this.ee + 412) : this.space.readInt(this.ee + 64);
                if (n != 0) {
                    this.topDsa = Dsa.findTop(this, n);
                    this.isKnownType = true;
                } else if (this.verbose) {
                    System.out.println("zero last_frame for ee " + Tcb.hex(this.ee) + " is131 " + this.is131);
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block7;
                exception.printStackTrace(System.out);
            }
        }
        if (this.verbose) {
            System.out.println("findDsaFromLastFrame end");
        }
    }

    Tcb(AddressSpace addressSpace, int n) {
        if (n == debugtcb) {
            this.verbose = true;
        }
        if (this.verbose) {
            System.out.println("creating tcb " + Tcb.hex(n));
        }
        try {
            Jvm.offsetof("smcb", "firstDS");
            this.is141 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.space = addressSpace;
        this.tcbid = n;
        try {
            int n2 = addressSpace.readInt(n + 312);
            if (this.verbose) {
                System.out.println("found stcb at " + Tcb.hex(n2));
            }
            int n3 = addressSpace.readInt(n2 + 216);
            if (this.verbose) {
                System.out.println("found otcb at " + Tcb.hex(n3));
            }
            int n4 = addressSpace.readInt(n3 + 188);
            if (this.verbose) {
                System.out.println("found thli at " + Tcb.hex(n4));
            }
            this.tid = addressSpace.readInt(n4 + 52);
            if (this.verbose) {
                System.out.println("found tid at " + Tcb.hex(this.tid));
            }
            if (this.tid != 0) {
                addressSpace.mapTid(this.tid, this);
                this.findEE();
            }
        }
        catch (Exception exception) {
            if (this.verbose) {
                System.out.println("problem: " + exception);
                exception.printStackTrace(System.out);
            }
            this.ee = 0;
            this.tid = 0;
        }
        if (this.verbose) {
            System.out.println("about to call findXplinkDsa");
        }
        if (this.findXplinkDsa()) {
            if (this.verbose) {
                System.out.println("finished creating tcb " + Tcb.hex(n));
            }
            if (!this.isKnownType) {
                this.tid = 0;
                this.ee = 0;
                if (this.verbose) {
                    System.out.println("unknown type for tcb " + Tcb.hex(n));
                }
            } else {
                try {
                    if (this.verbose) {
                        System.out.println("adding jvm " + Tcb.hex(this.jvmp));
                    }
                    this.jvm = addressSpace.addJvm(this.jvmp, this.isPostRas);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        if (this.verbose) {
            System.out.println("findXplinkDsa failed, do it the old way");
        }
        if (this.isLE() || this.isRtwa() || this.isLinkage() || this.isLinkage2() || this.isIrb() || this.isCics() || this.isUsta() || this.isCaa()) {
            block39: {
                this.isKnownType = true;
                if (this.verbose) {
                    System.out.println("is known type: " + this.type);
                }
                try {
                    this.topDsa = new Dsa(this, this.topDsaAddress);
                }
                catch (Exception exception) {
                    if (!this.verbose) break block39;
                    System.out.println("could not create Dsa: " + exception);
                }
            }
            if (this.topDsa == null || this.topDsa.prevCount() < 3) {
                this.type = "dodgy";
                this.dodgy = true;
                try {
                    this.topDsaAddress = this.findBestDsa();
                    this.topDsa = new Dsa(this, this.topDsaAddress);
                }
                catch (Exception exception) {
                    if (this.verbose) {
                        System.out.println("could not create dodgy Dsa: " + exception);
                    }
                }
            }
        } else {
            this.type = "unknown";
            this.findDsaFromLastFrame();
            this.findCaa();
        }
        if (!this.isKnownType) {
            if (this.verbose) {
                System.out.println("unknown non-xplink type for tcb " + Tcb.hex(n));
            }
            this.tid = 0;
            this.ee = 0;
        } else {
            try {
                if (this.jvmp != 0) {
                    if (this.verbose) {
                        System.out.println("adding jvm " + Tcb.hex(this.jvmp));
                    }
                    this.jvm = addressSpace.addJvm(this.jvmp, this.isPostRas);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.verbose) {
            System.out.println("finished creating tcb " + Tcb.hex(n));
        }
    }

    boolean xplinkon() {
        return this.xplinkon;
    }

    String xpType() {
        return this.caa.downstack() ? "xplink" : "non-xplink";
    }

    int dsaOffset() {
        return this.caa.downstack() ? 0 : 36;
    }

    boolean usesXplink() {
        return this.usesXplink;
    }

    int currentSignal() {
        if (this.caa == null) {
            return -1;
        }
        return this.caa.currentSignal();
    }

    boolean findXplinkDsa() {
        if (!SvcdumpProperties.getBooleanProperty("svcdump.xplink", true)) {
            return false;
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = this.space.readInt(this.tcbid + 324);
            if (n9 == 0) {
                return false;
            }
            int n10 = this.space.readInt(n9);
            if (n10 == 0) {
                return false;
            }
            int n11 = this.space.readInt(n10 + 32);
            if (!this.isValidCaa(n11)) {
                return false;
            }
            int n12 = this.caa.edb();
            int n13 = this.space.readUnsignedByte(n12 + 128);
            this.xplinkon = (n13 & 6) != 0;
            int n14 = this.space.readUnsignedShort(this.tcbid + 32);
            if (n14 == 0) {
                // empty if block
            }
            if ((n14 == 0 || n14 == 1025 && this.xplinkon) && this.tryDsa(this.tcbid + 64, this.xpType())) {
                return true;
            }
            int n15 = this.space.readInt(this.tcbid + 224);
            if (n15 != 0 && (n8 = this.space.readInt(n15)) == -639380238 && this.tryDsa(n15 + 76, this.xpType() + " rtwa")) {
                this.failingRegisters = new int[18];
                int n16 = 0;
                while (n16 < this.failingRegisters.length) {
                    this.failingRegisters[n16] = this.space.readInt(n15 + 60 + (n16 << 2));
                    ++n16;
                }
                return true;
            }
            n8 = this.space.readInt(this.tcbid + 312);
            if (n8 != 0) {
                n7 = this.space.readInt(n8 + 116);
                if (n7 != (n6 = this.space.readInt(n8 + 128))) {
                    n5 = this.space.readUnsignedShort(n6 + 4);
                    if (this.verbose) {
                        System.out.println("findXplinkDsa about to walk lsdp");
                    }
                    n4 = 0;
                    int n17 = n7 - n5;
                    while (n5 > 0 && n17 >= n6) {
                        if (this.tryDsa(n17 + 24, this.xpType() + " linkage " + n4)) {
                            return true;
                        }
                        ++n4;
                        n17 -= n5;
                    }
                    if (this.verbose) {
                        System.out.println("findXplinkDsa finished walk lsdp");
                    }
                }
                if ((n5 = this.space.readInt(n8 + 116)) != 0) {
                    n4 = this.space.readUnsignedByte(n5);
                    if (n4 == 5) {
                        n4 = this.space.readUnsignedByte(n5 -= 168);
                        if (n4 == 5) {
                            n5 -= 168;
                        }
                        if (!this.caa.downstack()) {
                            n5 -= 168;
                        }
                        if (this.tryDsa(n5 + 24, this.xpType() + " usta.1")) {
                            return true;
                        }
                    } else if (this.caa.downstack() && (n5 = this.space.readInt(n8 + 128)) != 0 && this.tryDsa(n5 + 44, this.xpType() + " usta.2")) {
                        return true;
                    }
                }
            }
            n7 = this.space.readInt(548L);
            if (this.verbose) {
                System.out.println("findXplinkDsa about to walk prevascb from " + Tcb.hex(n7));
            }
            while ((n6 = this.space.readInt(n7 + 8)) != 0) {
                n7 = n6;
            }
            if (this.verbose) {
                System.out.println("findXplinkDsa finished walk prevascb at " + Tcb.hex(n7));
            }
            n5 = 0;
            while (n7 != 0 && n5 < 1000) {
                if (this.verbose) {
                    System.out.println("consider ascb at " + Tcb.hex(n7));
                }
                if ((n4 = this.space.readInt(n7 + 16)) != 0) {
                    try {
                        int n18 = this.space.readInt(n4);
                        if (n18 == -488252991 && (n3 = this.space.readInt(n4 + 120)) == this.caa.caa && this.tryDsa(n4 + 88, this.xpType() + " svra")) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                n7 = this.space.readInt(n7 + 4);
                ++n5;
            }
            if (this.verbose) {
                System.out.println("findXplinkDsa finished walk ascb");
            }
            if ((n4 = this.space.readInt(this.tcbid)) != 0 && this.tryDsa(n4 + 48, this.xpType() + " irb")) {
                return true;
            }
            int n19 = this.space.readInt(this.tcbid + 72);
            if (n19 != 0 && this.space.readInt(n19 + 112) == this.tcbid && this.tryDsa(n19 + 96, this.xpType() + " r6")) {
                return true;
            }
            if (n8 != 0 && (n3 = this.space.readInt(n8 + 216)) != 0 && (n2 = this.space.readInt(n3 + 292)) != 0 && this.tryDsa(n2 + 40, this.xpType() + " usta.3")) {
                return true;
            }
            if (this.tryDsa(this.tcbid + 64, this.xpType())) {
                return true;
            }
            n3 = this.space.readInt(this.tcbid + 160);
            if (n3 != 0 && (n = this.space.readInt((n2 = this.space.readInt(n3 + 20) & Integer.MAX_VALUE) + 20)) != 0 && this.tryDsa(n + 80, this.xpType() + " scb")) {
                return true;
            }
            if (n8 != 0 && (n2 = this.space.readInt(n8 + 216)) != 0) {
                int n20;
                n = this.space.readInt(n2 + 56);
                if (n != 0 && (n20 = this.space.readInt(n + 4)) != 0 && this.tryDsa(n20 + 40, this.xpType() + " usta.5")) {
                    return true;
                }
                n20 = this.space.readInt(n2 + 356);
                if (n20 != 0 && this.tryDsa(n20 + 40, this.xpType() + " usta.4")) {
                    return true;
                }
            }
            if (this.verbose) {
                System.out.println("findXplinkDsa last attempt");
            }
            if (this.tryDsa(this.tcbid + 52, this.xpType() + " R10 in TCB")) {
                if (this.verbose) {
                    n2 = this.caa.dummyDsa();
                    n = this.space.readInt(n2 + 76);
                    System.out.println("dummyDsa = " + Tcb.hex(n2) + " bottom dsa = " + Tcb.hex(n));
                }
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    void huntDsa(int n, int n2, boolean bl) {
        System.out.println("hunt for dsa from " + Tcb.hex(n) + " to " + Tcb.hex(n2));
        int n3 = n;
        while (n3 < n2) {
            try {
                Dsa dsa = new Dsa(this, null, n3, false, bl, 0, true);
                int n4 = dsa.prevCount();
                if (n4 > 3 && n4 < 190) {
                    boolean bl2 = false;
                    Dsa dsa2 = dsa;
                    while (dsa2 != null) {
                        if (!dsa2.function().startsWith("(unknown")) {
                            bl2 = true;
                            break;
                        }
                        dsa2 = dsa2.previous();
                    }
                    if (bl2) {
                        System.out.println("*** found good stack: ***");
                        while (dsa != null) {
                            System.out.println(Tcb.hex(dsa.address) + " " + dsa.function());
                            dsa = dsa.previous();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n3 += 4;
        }
    }

    public StackSegment[] stackSegments() throws Exception {
        int n;
        int n2;
        if (!this.isJava()) {
            throw new Exception("Sorry, cannot get stack segments for non-Java thread");
        }
        Vector<StackSegment> vector = new Vector<StackSegment>();
        int n3 = this.space.readInt(this.tid + Jvm.offsetof("sys_thread_t", "pSMCB"));
        this.space.expect(n3, "SMCB", false);
        int n4 = this.space.readInt(n3 + Jvm.offsetof("smcb", "firstUS"));
        int n5 = this.space.readInt(n3 + Jvm.offsetof("smcb", "lastUS"));
        int n6 = n4;
        while (true) {
            this.space.expect(n6, "STKU", false);
            n2 = n6;
            n = n6 + this.space.readInt(n6 + Jvm.offsetof("stackSegment", "SSlen"));
            vector.add(new StackSegment(n2, n, false));
            if (n6 == n5) break;
            n6 = this.space.readInt(n6 + Jvm.offsetof("stackSegment", "nextSS"));
        }
        if (!this.is141) {
            return vector.toArray(new StackSegment[0]);
        }
        n2 = this.space.readInt(n3 + Jvm.offsetof("smcb", "firstDS"));
        n = this.space.readInt(n3 + Jvm.offsetof("smcb", "lastDS"));
        int n7 = n2;
        while (true) {
            this.space.expect(n7, "STKD", false);
            int n8 = n7;
            int n9 = n7 - this.space.readInt(n7 + Jvm.offsetof("stackSegment", "SSlen")) + 32 + 4096;
            vector.add(new StackSegment(n9, n8, true));
            if (n7 == n) break;
            n7 = this.space.readInt(n7 + Jvm.offsetof("stackSegment", "nextSS"));
        }
        return vector.toArray(new StackSegment[0]);
    }

    boolean tryDsa(int n, String string) {
        try {
            Dsa dsa;
            int n2 = this.space.readInt(n + this.dsaOffset());
            if (n2 != 0 && (dsa = new Dsa(this, null, n2, false, this.caa.downstack(), 0, true)).prevCount() > 2) {
                this.topDsa = dsa;
                this.topDsaAddress = n2;
                this.type = string;
                this.isKnownType = true;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    Tcb(AddressSpace addressSpace, int n, int n2) {
        if (n == debugtcb) {
            this.verbose = true;
        }
        this.space = addressSpace;
        this.tid = n2;
        try {
            this.findEE();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.type = "Java thread with no TCB";
        this.findDsaFromLastFrame();
        this.isKnownType = true;
        this.findCaa();
        try {
            Jvm.offsetof("smcb", "firstDS");
            this.is141 = true;
        }
        catch (Exception exception) {}
    }

    void findCaa() {
    }

    public void addTraceEntry(int n, int n2) {
        Integer n3;
        Integer n4;
        if (this.traceTable == null) {
            this.traceTable = new Hashtable();
        }
        this.traceTable.put(n4, new Integer((n3 = (Integer)this.traceTable.get(n4 = new Integer(n2))) == null ? 1 : n3 + 1));
    }

    public Function[] traceFunctions() {
        if (this.traceFunctions == null && this.traceTable != null) {
            this.traceFunctions = this.space.traceFunctions(this.traceTable);
        }
        return this.traceFunctions;
    }

    public Dsa topDsa() {
        return this.topDsa;
    }

    Dsa topJitDsa() {
        Dsa dsa = this.topDsa();
        while (dsa != null) {
            String string = dsa.function();
            if (string.indexOf(47) != -1) {
                return dsa;
            }
            dsa = dsa.previous();
        }
        return null;
    }

    public Dsa[] stack() {
        if (this.stack == null) {
            Vector<Dsa> vector = new Vector<Dsa>();
            Dsa dsa = this.topDsa();
            while (dsa != null) {
                vector.add(dsa);
                dsa = dsa.previous();
            }
            this.stack = vector.toArray(new Dsa[0]);
        }
        return this.stack;
    }

    public String where() {
        try {
            return this.topDsa.function();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean isValidCaa(int n) {
        this.caa = Caa.create(this.space, n);
        return this.caa != null;
    }

    public int caa() {
        return this.caa == null ? 0 : this.caa.caa;
    }

    public boolean isLE() {
        try {
            int n = this.space.readInt(this.tcbid + 96);
            if (this.isValidCaa(n)) {
                this.topDsaAddress = this.space.readInt(this.tcbid + 100);
                this.type = "LE";
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return false;
    }

    public boolean isCaa() {
        try {
            int n = this.space.readInt(this.tcbid + 324);
            int n2 = this.space.readInt(n + 0);
            int n3 = this.space.readInt(n2 + 8);
            int n4 = this.space.readInt(n3 + 0);
            if (!this.isValidCaa(n4) && !this.isValidCaa(n4 = this.space.readInt(n2 + 32))) {
                if (this.verbose) {
                    System.out.println("could not find caa for this tcb");
                }
                return false;
            }
            this.type = "Caa";
            this.topDsaAddress = this.findBestDsa();
            return true;
        }
        catch (Exception exception) {
            block4: {
                if (!this.verbose) break block4;
                exception.printStackTrace(System.out);
            }
            return false;
        }
    }

    int findBestDsa() throws Exception {
        int n;
        block26: {
            int n2;
            int n3;
            int n4;
            if (this.verbose) {
                System.out.println("findBestDsa begin");
            }
            int n5 = this.caa.dummyDsa();
            int n6 = this.space.readInt(n5 + 76);
            Dsa dsa = Dsa.findTop(this, n6);
            n = dsa.stackPointer();
            int n7 = dsa.prevCount();
            this.type = "best";
            int n8 = this.space.readInt(this.tcbid + 100);
            try {
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                    this.type = "best 1";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n9 = this.space.readInt(this.tcbid + 312);
                n4 = this.space.readInt(n9 + 216);
                n3 = this.space.readInt(n4 + 56);
                n2 = this.space.readInt(n3 + 4);
                n8 = this.space.readInt(n2 + 76);
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                    this.type = "best usta";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n10 = this.space.readInt(this.tcbid + 224);
                n8 = this.space.readInt(n10 + 112);
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                    this.type = "best rtwa";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n11 = this.space.readInt(this.tcbid + 312);
                n4 = this.space.readInt(n11 + 116);
                n3 = this.space.readInt(n11 + 128);
                if (n4 != n3 && (dsa = new Dsa(this, n8 = this.space.readInt(n3 + 8 + 52))).prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                    this.type = "best estk";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n12 = this.space.readInt(this.tcbid);
                n8 = this.space.readInt(n12 + 84);
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                    this.type = "best irb";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n13 = this.space.readInt(this.tcbid + 72);
                if (this.space.readInt(n13 + 112) == this.tcbid && (dsa = new Dsa(this, n8 = this.space.readInt(n13 + 132))).prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                    this.type = "best r6";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n14 = this.space.readInt(this.tcbid + 312);
                n4 = this.space.readInt(n14 + 116);
                n3 = this.space.readInt(n14 + 128);
                if (n4 == n3) break block26;
                try {
                    n2 = this.space.readInt(n3 + 8 + 20);
                    n8 = this.space.readInt(n2 + 84);
                    dsa = new Dsa(this, n8);
                    if (dsa.prevCount() > n7) {
                        n = dsa.stackPointer();
                        n7 = dsa.prevCount();
                        this.type = "best lsdp";
                    }
                }
                catch (Exception exception) {
                    int n15 = this.space.readInt(n3 + 8 + 44);
                    n8 = this.space.readInt(n15 + 84);
                    dsa = new Dsa(this, n8);
                    if (dsa.prevCount() > n7) {
                        n = dsa.stackPointer();
                        n7 = dsa.prevCount();
                        this.type = "best r5";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.verbose) {
            System.out.println("findBestDsa end: " + Tcb.hex(n));
        }
        return n;
    }

    public boolean isUsta() {
        block4: {
            try {
                int n = this.space.readInt(this.tcbid + 312);
                int n2 = this.space.readInt(n + 216);
                int n3 = this.space.readInt(n2 + 56);
                int n4 = this.space.readInt(n3 + 4);
                int n5 = this.space.readInt(n4 + 72);
                if (this.isValidCaa(n5)) {
                    this.type = "Usta";
                    this.topDsaAddress = this.findBestDsa();
                    return true;
                }
                if (this.verbose) {
                    System.out.println("invalid caa from isUsta: " + Tcb.hex(n5));
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block4;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isLinkage() {
        block3: {
            try {
                int n;
                int n2 = this.space.readInt(this.tcbid + 312);
                int n3 = this.space.readInt(n2 + 116);
                int n4 = this.space.readInt(n2 + 128);
                if (n3 != n4 && this.isValidCaa(n = this.space.readInt(n4 + 8 + 48))) {
                    this.topDsaAddress = this.space.readInt(n4 + 8 + 52);
                    this.type = "Linkage";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isLinkage2() {
        block3: {
            try {
                int n;
                int n2;
                int n3 = this.space.readInt(this.tcbid + 312);
                int n4 = this.space.readInt(n3 + 116);
                int n5 = this.space.readInt(n3 + 128);
                if (n4 != n5 && this.space.readInt(n2 = this.space.readInt(n5 + 8 + 8)) == -454892607 && this.isValidCaa(n = this.space.readInt(n2 + 72))) {
                    this.topDsaAddress = this.space.readInt(n2 + 76);
                    this.type = "Linkage 2";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isRtwa() {
        block4: {
            try {
                int n;
                int n2 = this.space.readInt(this.tcbid + 224);
                if (n2 != 0 && this.isValidCaa(n = this.space.readInt(n2 + 108))) {
                    this.topDsaAddress = this.space.readInt(n2 + 112);
                    this.type = "Failing";
                    this.failingRegisters = new int[18];
                    int n3 = 0;
                    while (n3 < this.failingRegisters.length) {
                        this.failingRegisters[n3] = this.space.readInt(n2 + 60 + (n3 << 2));
                        ++n3;
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block4;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isIrb() {
        block3: {
            try {
                int n = this.space.readInt(this.tcbid);
                int n2 = this.space.readInt(n + 80);
                if (this.isValidCaa(n2)) {
                    this.topDsaAddress = this.space.readInt(n + 84);
                    this.type = "IRB";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isCics() {
        block3: {
            try {
                int n = this.space.readInt(this.tcbid + 72);
                if (this.space.readInt(n + 112) == this.tcbid) {
                    this.topDsaAddress = this.space.readInt(n + 132);
                    int n2 = this.space.readInt(this.topDsaAddress + 4);
                    n2 = this.space.readInt(n2 + 4);
                    this.type = "Cics";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isKnownType() {
        return this.isKnownType;
    }

    public String type() {
        return this.type;
    }

    public int tid() {
        return this.tid;
    }

    public int ee() {
        return this.ee;
    }

    public int threadIndex() {
        if (this.isJava() && this.is131) {
            try {
                return this.space.readInt(this.ee + 340);
            }
            catch (Exception exception) {
            }
        }
        return 0;
    }

    public int failingDsa(boolean bl) {
        int[] nArray = this.failingRegisters();
        if (nArray != null) {
            return nArray[bl ? 4 : 13];
        }
        return 0;
    }

    public int failingPsw() {
        int[] nArray = this.failingRegisters();
        if (nArray != null) {
            return nArray[17] & Integer.MAX_VALUE;
        }
        return 0;
    }

    public int[] failingRegisters() {
        if (this.failingRegisters != null) {
            return this.failingRegisters;
        }
        try {
            int n = this.caa.cib();
            int n2 = this.space.readInt(n + 36);
            int n3 = this.space.readInt(n2);
            if (n3 != -371932216) {
                return null;
            }
            this.failingRegisters = new int[18];
            int n4 = 0;
            while (n4 < this.failingRegisters.length) {
                this.failingRegisters[n4] = this.space.readInt(n2 + 8 + (n4 << 2));
                ++n4;
            }
            return this.failingRegisters;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int tid_type() {
        if (this.tid == 0) {
            return -1;
        }
        try {
            return this.space.readInt(this.tid + 36);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public long tid_threadself() {
        if (this.tid == 0) {
            return -1L;
        }
        try {
            return this.space.readLong(this.tid + 28);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public int tid_state() {
        if (this.tid == 0) {
            return -1;
        }
        try {
            return this.space.readInt(this.tid + 40);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int tid_singled() {
        if (this.tid == 0) {
            return -1;
        }
        try {
            return this.space.readInt(this.tid + CType.offsetof("sys_thread_t", "singled", 60));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    boolean stackEquals(Tcb tcb) {
        Dsa dsa = this.topDsa;
        Dsa dsa2 = tcb.topDsa;
        while (dsa != null) {
            if (dsa2 == null || !dsa.function().equals(dsa2.function())) {
                return false;
            }
            dsa = dsa.previous();
            dsa2 = dsa2.previous();
        }
        return true;
    }

    public String hexId() {
        return Integer.toHexString(this.tcbid);
    }

    public String toString() {
        return this.hexId();
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }
}

