/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump.examples;

import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Page;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;

public class PrintHpiTrace {
    public static void main(String[] stringArray) {
        try {
            Dump dump = new Dump(stringArray[0]);
            AddressSpace addressSpace = dump.getDefaultAddressSpace();
            Enumeration enumeration = addressSpace.getPages();
            while (enumeration.hasMoreElements()) {
                Page page = (Page)enumeration.nextElement();
                int[] nArray = page.getIntArray();
                int n = 0;
                while (n < nArray.length) {
                    int n2;
                    String string;
                    if (nArray[n] == 0x2A2A2A4A && (string = addressSpace.readString(n2 = page.getAddress() + (n << 2))).equals("***JAVA_TRACE_TABLE****") && (string = addressSpace.readString(n2 + 24)).equals("S390JAVA")) {
                        int n3;
                        int n4;
                        int n5 = addressSpace.readInt(n2 + 32);
                        int n6 = addressSpace.readInt(n2 + 44);
                        int n7 = addressSpace.readInt(n2 + 48);
                        int n8 = addressSpace.readInt(n2 + 52);
                        int n9 = n4 = n8 + n5;
                        int n10 = addressSpace.getId();
                        System.out.println("found hpi trace, offset = " + PrintHpiTrace.hex(n5) + " table start = " + PrintHpiTrace.hex(n8) + " table end = " + PrintHpiTrace.hex(n7) + " table size = " + PrintHpiTrace.hex(n6) + " asid = " + PrintHpiTrace.hex(n10));
                        boolean bl = false;
                        while (true) {
                            try {
                                if (addressSpace.readInt(n9 + 20) == n10 && (n3 = addressSpace.readInt(n9)) >= 32 && n3 < 100) {
                                    bl = true;
                                    break;
                                }
                            }
                            catch (Exception exception) {
                                n9 = n8 - 4;
                            }
                            if ((n9 += 4) == n4) break;
                            if (n9 < n7) continue;
                            n9 = n8;
                        }
                        if (!bl) {
                            System.out.println("could not find a valid record!");
                            return;
                        }
                        n3 = 1;
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
                        int n11 = 0;
                        int n12 = n9;
                        while (n11 < n6) {
                            if (n9 >= n4 ? n12 >= n4 && n12 < n9 : n12 >= n4) break;
                            int n13 = addressSpace.readInt(n12);
                            if (n12 + n13 >= n7) {
                                n12 += n13 - n6;
                                n11 += n13;
                                System.out.println("skipping last record");
                                continue;
                            }
                            int n14 = addressSpace.readInt(n12 + 4);
                            long l = addressSpace.readInt(n12 + 8);
                            long l2 = addressSpace.readInt(n12 + 12);
                            Date date = AddressSpace.mvsClockToDate(l << 32 | l2 & 0xFFFFFFFFL);
                            if (n3 != 0) {
                                System.out.println("Trace begins at " + date);
                                n3 = 0;
                            }
                            String string2 = simpleDateFormat.format(date);
                            String string3 = n14 == 0 ? "No format string" : addressSpace.readString(n14);
                            int n15 = addressSpace.readInt(n12 + 16);
                            int n16 = addressSpace.readInt(n12 + 24);
                            System.out.print(string2 + " tcb " + PrintHpiTrace.hex(n15) + " " + string3 + " ");
                            int n17 = 0;
                            while (n17 < n16) {
                                int n18 = addressSpace.readInt(n12 + 32 + (n17 << 2));
                                System.out.print(PrintHpiTrace.hex(n18) + " ");
                                ++n17;
                            }
                            System.out.println("");
                            n12 += n13;
                            n11 += n13;
                        }
                        return;
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Oops: " + exception);
        }
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }
}

