/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util.html;

import com.ibm.jvm.util.html.Base;
import com.ibm.jvm.util.html.Cell;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Element;
import com.ibm.jvm.util.html.Table;
import java.util.ArrayList;
import java.util.Iterator;

public class Row
extends Element {
    protected Table table;
    protected ArrayList cells = new ArrayList();
    protected boolean isHeader;

    public Row() {
    }

    public Row(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addCell(stringArray[n]);
            ++n;
        }
    }

    public Row(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.addCell("" + nArray[n]);
            ++n;
        }
    }

    public Row(boolean bl) {
        this.isHeader = bl;
    }

    public void setHeader(boolean bl) {
        this.isHeader = bl;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void addCell(Cell cell) {
        if (this.table != null) {
            this.table.addCellToColumn(cell, this.cells.size());
        }
        this.cells.add(cell);
    }

    public void addCell(String string) {
        Base.Assert(string != null);
        this.addCell(new Cell(string));
    }

    public void addCell(Element element) {
        this.addCell(new Cell(element));
    }

    public int size() {
        return this.cells.size();
    }

    public Cell cellAt(int n) {
        return (Cell)this.cells.get(n);
    }

    protected String toHtmlString() {
        String string = this.beautify("<tr>");
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            if (this.isHeader) {
                cell.setHeader(true);
            }
            string = string + cell.toHtmlString();
        }
        string = string + "</tr>";
        return this.beautify(string);
    }

    protected String toTextString() {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            object = (Cell)iterator.next();
            stringBuffer.append(((Cell)object).toTextString());
            int n2 = 0;
            while (n2 < ((Cell)object).column().width() - ((Cell)object).width()) {
                stringBuffer.append(' ');
                ++n2;
            }
            n = 0;
            while (n < this.table.columnGap()) {
                stringBuffer.append(' ');
                ++n;
            }
        }
        stringBuffer.append(Document.lineSeparator);
        if (this.isHeader) {
            object = this.cells.iterator();
            while (object.hasNext()) {
                Cell cell = (Cell)object.next();
                n = 0;
                while (n < cell.width()) {
                    stringBuffer.append('-');
                    ++n;
                }
                int n3 = 0;
                while (n3 < cell.column().width() - cell.width()) {
                    stringBuffer.append(' ');
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this.table.columnGap()) {
                    stringBuffer.append(' ');
                    ++n4;
                }
            }
            stringBuffer.append(Document.lineSeparator);
        }
        return stringBuffer.toString();
    }
}

