/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Security;

public final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Serializable {
    static final long serialVersionUID = -6195576206650062694L;
    private BigInteger modulus;
    private BigInteger publicExponent;

    RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(RSAPublicKey.a("o@s}\u0001,AieEHjT1\u0000bLiu\u00006\u000f") + iOException.getMessage());
        }
    }

    RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String toString() {
        String string = null;
        string = Security.getProvider(RSAPublicKey.a("EmK[&I")) == null ? new String(RSAPublicKey.a("EmK[&M")) : new String(RSAPublicKey.a("EmK[&I"));
        return string + RSAPublicKey.a(",}UPE\\Zd}\fo\u000fMt\u001c6%") + RSAPublicKey.a("a@bd\ty\\<\u001b") + this.modulus.toString() + "\n" + RSAPublicKey.a("|Zd}\fo\u000fci\u0015cAc\u007f\u00116%") + this.publicExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            this.modulus = derValueArray[0].getInteger();
            this.publicExponent = derValueArray[1].getInteger();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(RSAPublicKey.a("EApp\teK&z\u0000u\u000fpp\tyJ&\u001b") + exception.getMessage());
        }
    }

    public void zeroize() {
        this.modulus = BigInteger.ZERO;
        this.publicExponent = BigInteger.ZERO;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 12;
                        break;
                    }
                    case 1: {
                        n5 = 47;
                        break;
                    }
                    case 2: {
                        n5 = 6;
                        break;
                    }
                    case 3: {
                        n5 = 17;
                        break;
                    }
                    default: {
                        n5 = 101;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

