/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11SessionInfo {
    public static final int EXCLUSIVE_SESSION = 1;
    public static final int RW_SESSION = 2;
    public static final int SERIAL_SESSION = 4;
    public static final int INSERTION_CALLBACK = 8;
    public static final int RO_PUBLIC_SESSION = 0;
    public static final int RO_USER_FUNCTIONS = 1;
    public static final int RW_PUBLIC_SESSION = 2;
    public static final int RW_USER_FUNCTIONS = 3;
    public static final int RW_SO_FUNCTIONS = 4;
    private static final int[] flagList = new int[]{1, 2, 4, 8};
    private static final String[] flagNames = new String[]{"EXCLUSIVE_SESSION", "RW_SESSION", "SERIAL_SESSION", "INSERTION_CALLBACK"};
    private static final String[] stateStrings = new String[]{"RO_PUBLIC_SESSION", "RO_USER_FUNCTIONS", "RW_PUBLIC_SESSION", "RW_USER_FUNCTIONS", "RW_SO_FUNCTIONS"};
    private int state;
    private int flags;
    private int deviceError;

    public PKCS11SessionInfo(int n, int n2, int n3) {
        this.state = n;
        this.flags = n2;
        this.deviceError = n3;
    }

    public int state() {
        return this.state;
    }

    public int flags() {
        return this.flags;
    }

    public int deviceError() {
        return this.deviceError;
    }

    public String toString() {
        return "state=" + this.stateToString() + ", flags=" + this.flagsToString("|") + ", deviceError=" + this.deviceError;
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    public String stateToString() {
        return PKCS11SessionInfo.stateToString(this.state);
    }

    public static String stateToString(int n) {
        if (n < 0 || n > 4) {
            return Integer.toString(n);
        }
        return stateStrings[n];
    }
}

