/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs5;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.SmudgedBytes;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PKCS5 {
    public static final String MESSAGE_DIGEST_MD2 = "MD2";
    public static final String MESSAGE_DIGEST_MD5 = "MD5";
    public static final String MESSAGE_DIGEST_SHA = "SHA";
    public static final String MESSAGE_DIGEST_SHA1 = "SHA1";
    public static final String CIPHER_MODE_CBC = "CBC";
    public static final String PADDING_ALGORITHM_PKCS5 = "PKCS5Padding";
    public static final String CIPHER_ALGORITHM_DES = "DES";
    public static final String CIPHER_ALGORITHM_TRIPLE_DES = "TripleDES";
    public static final String CIPHER_ALGORITHM_DESEDE = "DESede";
    public static final String CIPHER_ALGORITHM_3DES = "3DES";
    public static final String CIPHER_ALGORITHM_RC2 = "RC2";
    public static final int PKCS5_VERSION1 = 1;
    public static final int PKCS5_VERSION2 = 2;
    public static final String KEY_ALGORITHM_PBKDF1 = "PBKDF1";
    public static final String KEY_ALGORITHM_PBKDF2 = "PBKDF2";
    public static final String ENCRYPTION_ALGORITHM_PBES1 = "PBES1";
    public static final String ENCRYPTION_ALGORITHM_PBES2 = "PBES2";
    private byte[] salt = null;
    private int iterationCount = 1000;
    private SmudgedBytes password;
    private int keyLength = 16;
    private String digestAlgorithm = "MD5";
    private String cipherAlgorithm = "DES";
    private String cipherMode = "CBC";
    private String paddingAlgorithm = "PKCS5Padding";
    private int version = 1;
    private String keyAlgorithm = "PBKDF1";
    private String encryptionAlgorithm = "PBES1";
    private String keyEncryptionFunction = "MD5";
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs5.PKCS5";
    private static final String[] supportedMessageDigests = new String[]{"MD2", "MD5", "SHA", "SHA1"};
    private static final String[] supportedKeyEncryptionFunctions = new String[]{"MD2", "MD5", "SHA", "SHA1"};
    private static final int[] maxKeyLengths = new int[]{16, 16, 20, 20};
    private static final String[] supportedCipherModes = new String[]{"CBC"};
    private static final String[] supportedPaddingAlgorithms = new String[]{"PKCS5Padding"};
    private static final String[] supportedCipherAlgorithms = new String[]{"DES", "TripleDES", "DESede", "3DES", "RC2"};
    private static final String[] supportedKeyAlgorithms = new String[]{"PBKDF1", "PBKDF2"};
    private static final String[] supportedEncryptionAlgorithms = new String[]{"PBES1", "PBES2"};

    public PKCS5(byte[] byArray, byte[] byArray2, int n) {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, byArray2, new Integer(n)};
            debug.entry(16384L, (Object)className, "PKCS5", objectArray);
        }
        this.setPassword(byArray);
        this.setSalt(byArray2);
        this.setIterationCount(n);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS5");
        }
    }

    public PKCS5(byte[] byArray, byte[] byArray2, int n, String string) {
        this(byArray, byArray2, n);
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, byArray2, new Integer(n), string};
            debug.entry(16384L, (Object)className, "PKCS5", objectArray);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS5");
        }
    }

    public PKCS5(byte[] byArray, byte[] byArray2, int n, String string, String string2, String string3, int n2) {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, byArray2, new Integer(n), string, string2, string3, new Integer(n2)};
            debug.entry(16384L, (Object)className, "PKCS5", objectArray);
        }
        this.setPassword(byArray);
        this.setSalt(byArray2);
        this.setIterationCount(n);
        if (!PKCS5.inSet(string, supportedMessageDigests)) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS5", "Digest Algorithm " + string + " not supported. Must be one of MD2, MD5, or SHA1.");
            }
            throw new IllegalArgumentException("Digest Algorithm " + string + " not supported. Must be one of MD2, MD5 or SHA1.");
        }
        this.digestAlgorithm = string.toUpperCase();
        this.setCipherAlgorithm(string2);
        if (!PKCS5.inSet(string3, supportedKeyEncryptionFunctions)) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS5", "Key Encryption Function " + string3 + " not supported. Must be one of MD2, MD5, or SHA1.");
            }
            throw new IllegalArgumentException("Key Encryption Function " + string3 + " not supported.  " + "Must be one of MD2, MD5 or SHA1.");
        }
        this.keyEncryptionFunction = string3.toUpperCase();
        if (this.digestAlgorithm.equals(MESSAGE_DIGEST_MD2) || this.digestAlgorithm.equals(MESSAGE_DIGEST_MD5)) {
            this.setKeyLength(16);
        } else if (this.digestAlgorithm.equals(MESSAGE_DIGEST_SHA) || this.digestAlgorithm.equals(MESSAGE_DIGEST_SHA1)) {
            this.setKeyLength(20);
        }
        if (n2 == 1) {
            this.setKeyAlgorithm(KEY_ALGORITHM_PBKDF1);
            this.setEncryptionAlgorithm(ENCRYPTION_ALGORITHM_PBES1);
        } else if (n2 == 2) {
            this.setKeyAlgorithm(KEY_ALGORITHM_PBKDF2);
            this.setEncryptionAlgorithm(ENCRYPTION_ALGORITHM_PBES2);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "PKCS5", "PKCS #5 version " + n2 + " not supported.");
            }
            throw new IllegalArgumentException("PKCS #5 version " + n2 + " not supported.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS5");
        }
    }

    public PKCS5(byte[] byArray, byte[] byArray2, int n, String string, String string2, String string3, int n2, String string4) {
        this(byArray, byArray2, n, string, string2, string3, n2);
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, byArray2, new Integer(n), string, string2, string3, new Integer(n2), string4};
            debug.entry(16384L, (Object)className, "PKCS5", objectArray);
        }
        if (string4 != null) {
            this.provider = new String(string4);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS5");
        }
    }

    public static boolean isSupportedMessageDigest(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isSupportedMessageDigest", string);
        }
        if (!PKCS5.inSet(string, supportedMessageDigests)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isSupportedMessageDigest", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isSupportedMessageDigest", new Boolean(true));
        }
        return true;
    }

    public byte[] getSalt() {
        if (debug != null) {
            debug.entry(16384L, className, "getSalt");
            debug.exit(16384L, (Object)className, "getSalt", this.salt.clone());
        }
        return (byte[])this.salt.clone();
    }

    public int getIterationCount() {
        if (debug != null) {
            debug.entry(16384L, className, "getIterationCount");
            debug.exit(16384L, (Object)className, "getIterationCount", this.iterationCount);
        }
        return this.iterationCount;
    }

    public int getKeyLength() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyLength");
            debug.exit(16384L, (Object)className, "getKeyLength", this.keyLength);
        }
        return this.keyLength;
    }

    public String getDigestAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", this.digestAlgorithm);
        }
        return this.digestAlgorithm;
    }

    public String getCipherAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getCipherAlgorithm");
            debug.exit(16384L, (Object)className, "getCipherAlgorithm", this.cipherAlgorithm);
        }
        return this.cipherAlgorithm;
    }

    public String getPaddingAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getPaddingAlgorithm");
            debug.exit(16384L, (Object)className, "getPaddingAlgorithm", this.paddingAlgorithm);
        }
        return this.paddingAlgorithm;
    }

    public String getCipherMode() {
        if (debug != null) {
            debug.entry(16384L, className, "getCipherMode");
            debug.exit(16384L, (Object)className, "getCipherMode", this.cipherMode);
        }
        return this.cipherMode;
    }

    public String getCipherString() {
        if (debug != null) {
            debug.entry(16384L, className, "getCipherString");
        }
        if (this.cipherAlgorithm.length() > 6 && this.cipherAlgorithm.substring(0, 7).equalsIgnoreCase("PBEWith")) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCipherString", this.cipherAlgorithm);
            }
            return this.cipherAlgorithm;
        }
        String string = this.cipherAlgorithm;
        String string2 = this.keyEncryptionFunction;
        if (string.equalsIgnoreCase(CIPHER_ALGORITHM_DESEDE) || string.equalsIgnoreCase(CIPHER_ALGORITHM_3DES)) {
            string = CIPHER_ALGORITHM_TRIPLE_DES;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCipherString", "PBEWith" + string2 + "And" + string);
        }
        return "PBEWith" + string2 + "And" + string;
    }

    public String getHMACString() {
        if (debug != null) {
            debug.entry(16384L, className, "getHMACString");
            debug.exit(16384L, (Object)className, "getHMACString", "Hmac" + this.digestAlgorithm);
        }
        return "Hmac" + this.digestAlgorithm;
    }

    public String getKeyAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyAlgorithm");
            debug.exit(16384L, (Object)className, "getKeyAlgorithm", this.keyAlgorithm);
        }
        return this.keyAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptionAlgorithm");
            debug.exit(16384L, (Object)className, "getEncryptionAlgorithm", this.digestAlgorithm);
        }
        return this.encryptionAlgorithm;
    }

    public String getKeyEncryptionFunction() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyEncryptionFunction");
            debug.exit(16384L, (Object)className, "getKeyEncryptionFunction", this.keyEncryptionFunction);
        }
        return this.keyEncryptionFunction;
    }

    public int getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public String toString() {
        String string = "PKCS #5:";
        string = string + "\r\n\tdigestAlgorithm = " + this.digestAlgorithm;
        string = string + "\r\n\tcipherAlgorithm = " + this.cipherAlgorithm;
        string = string + "\r\n\tcipherMode = " + this.cipherMode;
        string = string + "\r\n\tpaddingAlgorithm = " + this.paddingAlgorithm;
        string = string + "\r\n\tkeyAlgorithm = " + this.keyAlgorithm;
        string = string + "\r\n\tencryptionAlgorithm = " + this.encryptionAlgorithm;
        string = string + "\r\n\tkeyEncryptionFunction = " + this.keyEncryptionFunction;
        return string;
    }

    public String toDetailedString() {
        String string = "PKCS #5:";
        string = string + "\r\n\tsalt = " + this.salt;
        string = string + "\r\n\titerationCount = " + this.iterationCount;
        string = string + "\r\n\tpassword = <NOT SHOWN>";
        string = string + "\r\n\tkeyLength = " + this.keyLength;
        string = string + "\r\n\tdigestAlgorithm = " + this.digestAlgorithm;
        string = string + "\r\n\tcipherAlgorithm = " + this.cipherAlgorithm;
        string = string + "\r\n\tcipherMode = " + this.cipherMode;
        string = string + "\r\n\tpaddingAlgorithm = " + this.paddingAlgorithm;
        string = string + "\r\n\tversion = " + this.version;
        string = string + "\r\n\tkeyAlgorithm = " + this.keyAlgorithm;
        string = string + "\r\n\tencryptionAlgorithm = " + this.encryptionAlgorithm;
        string = string + "\r\n\tkeyEncryptionFunction = " + this.keyEncryptionFunction;
        return string;
    }

    public byte[] encodePBEParameters() throws NoSuchAlgorithmException, InvalidParameterSpecException, IOException {
        byte[] byArray = null;
        if (debug != null) {
            debug.entry(16384L, className, "encodePBEParameters");
        }
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBE");
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        algorithmParameters.init(pBEParameterSpec);
        byArray = algorithmParameters.getEncoded();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encodePBEParameters", byArray);
        }
        return byArray;
    }

    public byte[] encrypt(byte[] byArray) throws NoSuchAlgorithmException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encrypt", (Object)byArray);
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Data value not specified");
            }
            throw new IllegalArgumentException("Data value not specified.");
        }
        if (byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Data value has no length");
            }
            throw new IllegalArgumentException("Data value has no length.");
        }
        try {
            Cipher cipher = null;
            cipher = this.provider == null ? Cipher.getInstance(this.getCipherString()) : Cipher.getInstance(this.getCipherString(), this.provider);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            SecretKeyFactory secretKeyFactory = null;
            secretKeyFactory = this.provider == null ? SecretKeyFactory.getInstance(this.getCipherString()) : SecretKeyFactory.getInstance(this.getCipherString(), this.provider);
            byte[] byArray2 = this.getPassword();
            char[] cArray = new char[byArray2.length];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(byArray2[i] & 0x7F);
            }
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            Arrays.fill(cArray, ' ');
            Arrays.fill(byArray2, (byte)0);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            cipher.init(1, (Key)secretKey, pBEParameterSpec);
            byte[] byArray3 = cipher.doFinal(byArray);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "encrypt", byArray3);
            }
            return byArray3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", illegalArgumentException);
            }
            throw new PKCSException(illegalArgumentException, "Error encrypting data (" + illegalArgumentException.toString() + ")");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", noSuchPaddingException);
            }
            throw new PKCSException(noSuchPaddingException, "Error encrypting data (" + noSuchPaddingException.toString() + ")");
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", invalidKeyException);
            }
            throw new PKCSException(invalidKeyException, "Error encrypting data (" + invalidKeyException.toString() + ")");
        }
        catch (BadPaddingException badPaddingException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", badPaddingException);
            }
            throw new PKCSException(badPaddingException, "Error encrypting data (" + badPaddingException.toString() + ")");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", illegalBlockSizeException);
            }
            throw new PKCSException(illegalBlockSizeException, "Error encrypting data (" + illegalBlockSizeException.toString() + ")");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", invalidAlgorithmParameterException);
            }
            throw new PKCSException(invalidAlgorithmParameterException, "Error encrypting data (" + invalidAlgorithmParameterException.toString() + ")");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", invalidKeySpecException);
            }
            throw new PKCSException(invalidKeySpecException, "Error encrypting data (" + invalidKeySpecException.toString() + ")");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", noSuchProviderException);
            }
            throw new PKCSException(noSuchProviderException, "Error encrypting data (" + noSuchProviderException.toString() + ")");
        }
    }

    public byte[] decrypt(byte[] byArray) throws PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", (Object)byArray);
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Data value not specified");
            }
            throw new IllegalArgumentException("Data value not specified.");
        }
        if (byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Data value has no length.");
            }
            throw new IllegalArgumentException("Data value has no length.");
        }
        Cipher cipher = null;
        try {
            cipher = this.provider == null ? Cipher.getInstance(this.getCipherString()) : Cipher.getInstance(this.getCipherString(), this.provider);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            SecretKeyFactory secretKeyFactory = null;
            secretKeyFactory = this.provider == null ? SecretKeyFactory.getInstance(this.getCipherString()) : SecretKeyFactory.getInstance(this.getCipherString(), this.provider);
            byte[] byArray2 = this.getPassword();
            char[] cArray = new char[byArray2.length];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(byArray2[i] & 0x7F);
            }
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            Arrays.fill(cArray, ' ');
            Arrays.fill(byArray2, (byte)0);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            cipher.init(2, (Key)secretKey, pBEParameterSpec);
            byte[] byArray3 = cipher.doFinal(byArray);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decrypt", byArray3);
            }
            return byArray3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", illegalArgumentException);
            }
            throw new PKCSException(illegalArgumentException, "Error encrypting data (" + illegalArgumentException.toString() + ")");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", noSuchPaddingException);
            }
            throw new PKCSException(noSuchPaddingException, "Error encrypting data (" + noSuchPaddingException.toString() + ")");
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", invalidKeyException);
            }
            throw new PKCSException(invalidKeyException, "Error encrypting data (" + invalidKeyException.toString() + ")");
        }
        catch (BadPaddingException badPaddingException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", badPaddingException);
            }
            throw new PKCSException(badPaddingException, "Error encrypting data (" + badPaddingException.toString() + ")");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", illegalBlockSizeException);
            }
            throw new PKCSException(illegalBlockSizeException, "Error encrypting data (" + illegalBlockSizeException.toString() + ")");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", invalidAlgorithmParameterException);
            }
            throw new PKCSException(invalidAlgorithmParameterException, "Error encrypting data (" + invalidAlgorithmParameterException.toString() + ")");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", invalidKeySpecException);
            }
            throw new PKCSException(invalidKeySpecException, "Error encrypting data (" + invalidKeySpecException.toString() + ")");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", noSuchProviderException);
            }
            throw new PKCSException(noSuchProviderException, "Error encrypting data (" + noSuchProviderException.toString() + ")");
        }
    }

    public byte[] generateMAC(byte[] byArray) throws IllegalArgumentException, NoSuchAlgorithmException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateMAC", (Object)byArray);
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "generateMAC", "Data value not specified.");
            }
            throw new IllegalArgumentException("Data value not specified.");
        }
        if (byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "generateMAC", "Data value has no length.");
            }
            throw new IllegalArgumentException("Data value has no length.");
        }
        try {
            Mac mac = null;
            String string = this.getHMACString();
            mac = Mac.getInstance(string);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            SecretKeyFactory secretKeyFactory = null;
            secretKeyFactory = this.provider == null ? SecretKeyFactory.getInstance(this.getCipherString()) : SecretKeyFactory.getInstance(this.getCipherString(), this.provider);
            byte[] byArray2 = this.getPassword();
            char[] cArray = new char[byArray2.length];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(byArray2[i] & 0x7F);
            }
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            Arrays.fill(cArray, ' ');
            Arrays.fill(byArray2, (byte)0);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            mac.init(secretKey);
            byte[] byArray3 = mac.doFinal(byArray);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "generateMAC", byArray3);
            }
            return byArray3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug != null) {
                debug.exception(16384L, className, "generateMAC", illegalArgumentException);
            }
            throw new PKCSException(illegalArgumentException, "Error encrypting data (" + illegalArgumentException.toString() + ")");
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, className, "generateMAC", invalidKeyException);
            }
            throw new PKCSException(invalidKeyException, "Error encrypting data (" + invalidKeyException.toString() + ")");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (debug != null) {
                debug.exception(16384L, className, "generateMAC", invalidKeySpecException);
            }
            throw new PKCSException(invalidKeySpecException, "Error encrypting data (" + invalidKeySpecException.toString() + ")");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(16384L, className, "generateMAC", noSuchProviderException);
            }
            throw new PKCSException(noSuchProviderException, "Error encrypting data (" + noSuchProviderException.toString() + ")");
        }
    }

    public void verifyMAC(byte[] byArray, byte[] byArray2) throws PKCSException, IllegalArgumentException, NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, className, "verifyMAC", byArray, byArray2);
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "verifyMAC", "MAC value not specified.");
            }
            throw new IllegalArgumentException("MAC value not specified.");
        }
        if (byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "verifyMAC", "MAC value has no length.");
            }
            throw new IllegalArgumentException("MAC value has no length.");
        }
        int n = byArray.length;
        byte[] byArray3 = this.generateMAC(byArray2);
        int n2 = byArray3.length;
        if (n != n2) {
            if (debug != null) {
                debug.text(16384L, className, "verifyMAC", "MAC value is invalid.");
            }
            throw new PKCSException("MAC value is invalid.");
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray3[i]) continue;
            if (debug != null) {
                debug.text(16384L, className, "verifyMAC", "MAC value is invalid. (1)");
            }
            throw new PKCSException("MAC value is invalid.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "verifyMAC");
        }
    }

    private void setPassword(byte[] byArray) {
        if (debug != null) {
            debug.entry(8192L, className, "setPassword");
            debug.exit(8192L, className, "setPassword");
        }
        this.password = new SmudgedBytes(byArray);
    }

    private byte[] getPassword() {
        if (debug != null) {
            debug.entry(8192L, className, "getPassword");
            debug.exit(8192L, className, "getPassword");
        }
        if (this.password == null) {
            return null;
        }
        return this.password.getClearText();
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(8192L, className, "finalize");
            debug.exit(8192L, className, "finalize");
        }
        this.password = null;
    }

    private static boolean inSet(String string, String[] stringArray) {
        boolean bl = false;
        if (debug != null) {
            debug.entry(8192L, className, "inSet", string, stringArray);
        }
        if (stringArray != null && string != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                bl = true;
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "inSet", new Boolean(bl));
        }
        return bl;
    }

    private void setKeyAlgorithm(String string) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setKeyAlgorithm", string);
        }
        if (!PKCS5.inSet(string, supportedKeyAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setKeyAlgorithm", "Key Algorithm " + string + " not supported.");
            }
            throw new IllegalArgumentException("Key Algorithm " + string + " not supported.");
        }
        this.keyAlgorithm = string.toUpperCase();
        if (debug != null) {
            debug.exit(8192L, className, "setKeyAlgorithm");
        }
    }

    private void setEncryptionAlgorithm(String string) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncryptionAlgorithm", string);
        }
        if (!PKCS5.inSet(string, supportedEncryptionAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setEncryptionAlgorithm", "Encryption Algorithm " + this.keyAlgorithm + " not supported.");
            }
            throw new IllegalArgumentException("Encryption Algorithm " + string + " not supported.");
        }
        this.encryptionAlgorithm = string.toUpperCase();
        if (debug != null) {
            debug.exit(8192L, className, "setEncryptionAlgorithm");
        }
    }

    private void setSalt(byte[] byArray) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSalt", (Object)byArray);
        }
        if (byArray.length != 8) {
            if (debug != null) {
                debug.text(8192L, className, "setSalt", "Salt value must be 8 bytes long.");
            }
            throw new IllegalArgumentException("Salt value must be 8 bytes long.");
        }
        this.salt = (byte[])byArray.clone();
        if (debug != null) {
            debug.exit(8192L, className, "setSalt");
        }
    }

    private void setIterationCount(int n) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setIterationCount", new Integer(n));
        }
        if (n < 1) {
            if (debug != null) {
                debug.text(8192L, className, "setIterationCount", "Iteration count must be greater than 0.");
            }
            throw new IllegalArgumentException("Iteration count must be greater than 0.");
        }
        this.iterationCount = n;
        if (debug != null) {
            debug.exit(8192L, className, "setIterationCount");
        }
    }

    private void setDigestAlgorithm(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setDigestAlgorithm", string);
        }
        if (!PKCS5.inSet(string, supportedMessageDigests)) {
            if (debug != null) {
                debug.text(8192L, className, "setDigestAlgorithm", "Digest Algorithm " + string + " not supported. Must be one of MD2, MD5 or SHA1.");
            }
            throw new IllegalArgumentException("Digest Algorithm " + string + " not supported. Must be one of MD2, MD5 or SHA1.");
        }
        this.digestAlgorithm = string.toUpperCase();
        if (debug != null) {
            debug.exit(8192L, className, "setDigestAlgorithm");
        }
    }

    private void setCipherAlgorithm(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setCipherAlgorithm", string);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(8192L, className, "setCipherAlgorithm", "No algorithm given");
            }
            throw new IllegalArgumentException("No algorithm given");
        }
        int n = 0;
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        try {
            while (stringTokenizer.hasMoreTokens() && n < 3) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            if (n == 0 || n == 2 || stringTokenizer.hasMoreTokens()) {
                if (debug != null) {
                    debug.text(8192L, className, "setCipherAlgorithm", "Wrong algorithm format");
                }
                throw new IllegalArgumentException("Wrong algorithm format");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug != null) {
                debug.exception(8192L, className, "setCipherAlgorithm", illegalArgumentException);
            }
            throw new IllegalArgumentException("Wrong algorithm format");
        }
        if (!PKCS5.inSet(stringArray[0], supportedCipherAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setCipherAlgorithm", "Cipher Algorithm " + stringArray[0] + " not supported. Must be one of DES, DESede or RC2.");
            }
            throw new IllegalArgumentException("Cipher Algorithm " + stringArray[0] + " not supported. Must be one of DES, DESede or RC2.");
        }
        if (stringArray[0].equalsIgnoreCase(CIPHER_ALGORITHM_DESEDE) || stringArray[0].equalsIgnoreCase(CIPHER_ALGORITHM_3DES)) {
            stringArray[0] = CIPHER_ALGORITHM_TRIPLE_DES;
        }
        this.cipherAlgorithm = stringArray[0].toUpperCase();
        if (stringArray[1] != null) {
            if (!PKCS5.inSet(stringArray[1], supportedCipherModes)) {
                if (debug != null) {
                    debug.text(8192L, className, "setCipherAlgorithm", "Cipher Mode " + stringArray[1] + " not supported. Must be CBC.");
                }
                throw new IllegalArgumentException("Cipher Mode " + stringArray[1] + " not supported. Must be CBC.");
            }
            this.cipherMode = stringArray[1].toUpperCase();
        }
        if (stringArray[2] != null) {
            if (!PKCS5.inSet(stringArray[2], supportedPaddingAlgorithms)) {
                if (debug != null) {
                    debug.text(8192L, className, "setCipherAlgorithm", "Padding Algorithm " + stringArray[2] + " not supported. Must be PKCS5Padding.");
                }
                throw new IllegalArgumentException("Padding Algorithm " + stringArray[2] + " not supported. Must be PKCS5Padding.");
            }
            this.paddingAlgorithm = stringArray[2].toUpperCase();
        }
        if (debug != null) {
            debug.exit(8192L, className, "setCipherAlgorithm");
        }
    }

    private void setPaddingAlgorithm(String string) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setPaddingAlgorithm", string);
        }
        if (!PKCS5.inSet(string, supportedPaddingAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setPaddingAlgorithm", "Padding Algorithm " + string + " not supported.");
            }
            throw new IllegalArgumentException("Padding Algorithm " + string + " not supported.");
        }
        this.paddingAlgorithm = string.toUpperCase();
        if (debug != null) {
            debug.exit(8192L, className, "setPaddingAlgorithm");
        }
    }

    private void setCipherMode(String string) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setCipherMode", string);
        }
        if (!PKCS5.inSet(string, supportedCipherModes)) {
            if (debug != null) {
                debug.text(8192L, className, "setCipherMode", "Cipher Mode " + string + " not supported.");
            }
            throw new IllegalArgumentException("Cipher Mode " + string + " not supported.");
        }
        this.cipherMode = string.toUpperCase();
        if (debug != null) {
            debug.exit(8192L, className, "setCipherMode");
        }
    }

    private void setKeyEncryptionFunction(String string) throws IllegalArgumentException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setKeyEncryptionFunction", string);
        }
        if (!PKCS5.inSet(string, supportedKeyEncryptionFunctions)) {
            if (debug != null) {
                debug.text(8192L, className, "setKeyEncryptionFunction", "Key Encryption Function " + string + " not supported. Must be one of MD2, MD5 or SHA1.");
            }
            throw new IllegalArgumentException("Key Encryption Function " + string + " not supported.  " + "Must be one of MD2, MD5 or SHA1.");
        }
        this.keyEncryptionFunction = string.toUpperCase();
        if (debug != null) {
            debug.exit(8192L, className, "setKeyEncryptionFunction");
        }
    }

    private void setVersion(int n) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setVersion", new Integer(n));
        }
        if (n == 1) {
            this.setKeyAlgorithm(KEY_ALGORITHM_PBKDF1);
            this.setEncryptionAlgorithm(ENCRYPTION_ALGORITHM_PBES1);
            if (debug != null) {
                debug.exit(8192L, className, "setVersion");
            }
            return;
        }
        if (n == 2) {
            this.setKeyAlgorithm(KEY_ALGORITHM_PBKDF2);
            this.setEncryptionAlgorithm(ENCRYPTION_ALGORITHM_PBES2);
            if (debug != null) {
                debug.exit(8192L, className, "setVersion");
            }
            return;
        }
        if (debug != null) {
            debug.text(8192L, className, "setVersion", "PKCS #5 version " + n + " not supported.");
        }
        throw new IllegalArgumentException("PKCS #5 version " + n + " not supported.");
    }

    private void setKeyLength(int n) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setKeyLength", new Integer(n));
        }
        int n2 = 16;
        for (int i = 0; i < supportedKeyEncryptionFunctions.length; ++i) {
            if (!this.keyEncryptionFunction.equalsIgnoreCase(supportedKeyEncryptionFunctions[i])) continue;
            n2 = maxKeyLengths[i];
        }
        if (n > n2) {
            if (debug != null) {
                debug.text(8192L, className, "setKeyLength", "Key length " + n + " is too large for key derivation function " + this.keyEncryptionFunction);
            }
            throw new IllegalArgumentException("Key length " + n + " is too large for key derivation function " + this.keyEncryptionFunction);
        }
        this.keyLength = n;
        if (debug != null) {
            debug.exit(8192L, className, "setKeyLength");
        }
    }

    private void decodePBEParameters(byte[] byArray) throws NoSuchAlgorithmException, IOException, ClassNotFoundException, InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "decodePBEParameters", (Object)byArray);
        }
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBE");
        algorithmParameters.init(byArray);
        Class<?> clazz = Class.forName("PBEParameterSpec");
        PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameters.getParameterSpec(clazz);
        this.salt = pBEParameterSpec.getSalt();
        this.iterationCount = pBEParameterSpec.getIterationCount();
        if (debug != null) {
            debug.exit(8192L, className, "decodePBEParameters");
        }
    }
}

