/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public final class IssuerAlternativeNameExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.IssuerAlternativeName";
    public static final String NAME = "IssuerAlternativeName";
    public static final String ISSUER_NAME = "issuer_name";
    GeneralNames names = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.IssuerAlternativeNameExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "encodeThis");
        }
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(16384L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.names.encode(derOutputStream);
        }
        catch (GeneralNamesException generalNamesException) {
            if (debug != null) {
                debug.exception(16384L, className, "encodeThis", generalNamesException);
            }
            throw new IOException(generalNamesException.toString());
        }
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "encodeThis_2");
        }
    }

    public IssuerAlternativeNameExtension(GeneralNames generalNames) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuerAlternativeNameExtension", generalNames);
        }
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = false;
        this.names = generalNames != null ? (GeneralNames)generalNames.clone() : generalNames;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAlternativeNameExtension");
        }
    }

    public IssuerAlternativeNameExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAlternativeNameExtension");
        }
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = false;
        this.names = new GeneralNames();
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAlternativeNameExtension");
        }
    }

    public IssuerAlternativeNameExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAlternativeNameExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Array.getByte(object, i);
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        try {
            this.names = new GeneralNames(derValue);
        }
        catch (GeneralNamesException generalNamesException) {
            if (debug != null) {
                debug.exception(16384L, className, "IssuerAlternativeNameExtension", generalNamesException);
            }
            throw new IOException("IssuerAlternativeNameExtension" + generalNamesException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAlternativeNameExtension");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.names == null) {
            return "";
        }
        String string = super.toString() + "IssuerAlternativeName [\n" + this.names.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(ISSUER_NAME)) {
            if (!(object instanceof GeneralNames)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralNames.");
                }
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
            this.names = object != null ? (GeneralNames)((GeneralNames)object).clone() : (GeneralNames)object;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(ISSUER_NAME)) {
            if (this.names != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.names.clone());
                }
                return this.names.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.names);
            }
            return this.names;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(ISSUER_NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
        }
        this.names = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(ISSUER_NAME);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

