/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public final class UniqueIdentity {
    private BitArray id;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.UniqueIdentity";

    public UniqueIdentity(BitArray bitArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UniqueIdentity", bitArray);
            debug.exit(16384L, className, "UniqueIdentity");
        }
        this.id = bitArray;
    }

    public UniqueIdentity(byte[] byArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UniqueIdentity", (Object)byArray);
        }
        this.id = new BitArray(byArray.length * 8, byArray);
        if (debug != null) {
            debug.exit(16384L, className, "UniqueIdentity");
        }
    }

    public UniqueIdentity(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UniqueIdentity", derInputStream);
        }
        DerValue derValue = derInputStream.getDerValue();
        this.id = derValue.getUnalignedBitString(true);
        if (debug != null) {
            debug.exit(16384L, className, "UniqueIdentity");
        }
    }

    public UniqueIdentity(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UniqueIdentity", derValue);
        }
        this.id = derValue.getUnalignedBitString(true);
        if (debug != null) {
            debug.exit(16384L, className, "UniqueIdentity");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "UniqueIdentity:" + this.id.toString() + "\n");
        }
        return "UniqueIdentity:" + this.id.toString() + "\n";
    }

    public void encode(DerOutputStream derOutputStream, byte by) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "encode", derOutputStream, new Byte(by));
        }
        byte[] byArray = this.id.toByteArray();
        int n = byArray.length * 8 - this.id.length();
        derOutputStream.write(by);
        derOutputStream.putLength(byArray.length + 1);
        derOutputStream.write(n);
        derOutputStream.write(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean[] getId() {
        if (debug != null) {
            debug.entry(16384L, className, "getId");
        }
        if (this.id == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getId_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getId_2", this.id.toBooleanArray());
        }
        return this.id.toBooleanArray();
    }
}

