/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.DisplayText;
import com.ibm.security.x509.NoticeReference;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.Qualifier;
import java.io.IOException;
import java.io.OutputStream;

public final class UserNotice
implements Qualifier,
Cloneable {
    private ObjectIdentifier oid = PKIXExtensions.UserNotice_Id;
    private NoticeReference noticeRef;
    private DisplayText explicitText;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.UserNotice";

    public UserNotice(NoticeReference noticeReference, DisplayText displayText) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "UserNotice", noticeReference, displayText);
            debug.exit(16384L, className, "UserNotice");
        }
        this.noticeRef = noticeReference;
        this.explicitText = displayText;
    }

    public UserNotice(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UserNotice", (Object)byArray);
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "UserNotice");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.noticeRef != null) {
            this.noticeRef.encode(derOutputStream);
        }
        if (this.explicitText != null) {
            this.explicitText.encode(derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public NoticeReference getNoticeReference() {
        if (debug != null) {
            debug.entry(16384L, className, "getNoticeReference");
            debug.exit(16384L, (Object)className, "getNoticeReference", this.noticeRef);
        }
        return this.noticeRef;
    }

    public DisplayText getExplicitText() {
        if (debug != null) {
            debug.entry(16384L, className, "getExplicitText");
            debug.exit(16384L, (Object)className, "getExplicitText", this.explicitText);
        }
        return this.explicitText;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKIXExtensions.UserNotice_Id);
        }
        return PKIXExtensions.UserNotice_Id;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "UserNotice");
        }
        return "UserNotice";
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            UserNotice userNotice = new UserNotice(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", userNotice);
            }
            return userNotice;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "UserNotice: [";
        string = string + "\r\n\tObjectIdentifier: " + this.oid;
        string = string + "\r\n\tNoticeReference: ";
        string = this.noticeRef != null ? string + this.noticeRef.toString() : string + "null";
        string = string + "\r\n\tExplicitText: ";
        string = this.explicitText != null ? string + this.explicitText.toString() : string + "null";
        string = string + "\r\n]";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof UserNotice)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((UserNotice)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "UserNotice parsing error");
            }
            throw new IOException("UserNotice parsing error");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() == 48) {
            this.noticeRef = new NoticeReference(derValue2.toByteArray());
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
            } else {
                if (debug != null) {
                    debug.exit(16384L, className, "decode_1");
                }
                return;
            }
        }
        this.explicitText = new DisplayText(derValue2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "decode_2");
        }
    }
}

