/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.x509.GeneralSubtrees;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.OIDMap;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class NameChecker
extends PKIXCertPathChecker {
    static final int NAME_CONSTRAINTS_ERROR = 5;
    static final String[] myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.NameConstraints").toString(), OIDMap.getOID((String)"x509.info.extensions.SubjectAlternativeName").toString()};
    private int numberOfCertsInCertPath;
    private CertPath certPath;
    private int currentCertIndex;
    private GeneralSubtrees permittedSubtrees;
    private GeneralSubtrees excludedSubtrees;
    private String sigProvider;
    private static final Debug debug = Debug.getInstance((String)"certpath");

    public NameChecker(CertPath certPath, String string) throws CertPathValidatorException {
        this.certPath = certPath;
        List<? extends Certificate> list = certPath.getCertificates();
        this.numberOfCertsInCertPath = list.size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
        this.sigProvider = string;
        this.permittedSubtrees = null;
        this.excludedSubtrees = null;
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("The direction of forward is not supported.");
        }
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN()) || this.currentCertIndex <= 0) {
            if (this.excludedSubtrees == null) {
                try {
                    this.excludedSubtrees = new GeneralSubtrees(new Vector());
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("An internal error has occurred.", iOException);
                }
            }
            X509CertSelector x509CertSelector = null;
            try {
                NameConstraintsExtension nameConstraintsExtension = new NameConstraintsExtension(this.permittedSubtrees, this.excludedSubtrees);
                if (debug != null) {
                    int n;
                    System.out.print("CERTPATH: Checking name constraints");
                    if (this.permittedSubtrees != null) {
                        System.out.println("permitted trees:");
                        for (n = 0; n < this.permittedSubtrees.size(); ++n) {
                            System.out.println(this.permittedSubtrees.get(n));
                        }
                    }
                    if (this.excludedSubtrees != null) {
                        System.out.println("excluded trees:");
                        for (n = 0; n < this.excludedSubtrees.size(); ++n) {
                            System.out.println(this.excludedSubtrees.get(n));
                        }
                    }
                }
                x509CertSelector = new X509CertSelector();
                x509CertSelector.setNameConstraints(nameConstraintsExtension.getExtensionValue());
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
            if (!x509CertSelector.match(x509Certificate)) {
                throw new CertPathValidatorException("The certificate failed the name constraint check", null, this.certPath, this.currentCertIndex);
            }
            if (this.currentCertIndex < this.numberOfCertsInCertPath) {
                this.processNameConstraints(x509Certificate);
            }
        }
        --this.currentCertIndex;
        CertPathUtil.removeExtensions(collection, myExtensions);
    }

    public Object clone() {
        return null;
    }

    private void processNameConstraints(X509Certificate x509Certificate) throws CertPathValidatorException {
        NameConstraintsExtension nameConstraintsExtension = null;
        Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.NameConstraints", x509Certificate);
        if (objectArray[1] != null) {
            try {
                nameConstraintsExtension = new NameConstraintsExtension((Boolean)objectArray[0], objectArray[1]);
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        if (nameConstraintsExtension != null) {
            GeneralSubtrees generalSubtrees;
            if (!nameConstraintsExtension.isCritical()) {
                throw new CertPathValidatorException("The NameConstraints extension was not critical.");
            }
            try {
                generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get("permitted_subtrees");
                if (generalSubtrees != null) {
                    if (this.permittedSubtrees == null) {
                        this.permittedSubtrees = (GeneralSubtrees)generalSubtrees.clone();
                    } else {
                        GeneralSubtrees generalSubtrees2 = this.permittedSubtrees.intersect(generalSubtrees);
                        if (generalSubtrees2 != null) {
                            if (this.excludedSubtrees != null) {
                                this.excludedSubtrees.union(generalSubtrees2);
                            } else {
                                this.excludedSubtrees = (GeneralSubtrees)generalSubtrees2.clone();
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
            try {
                generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get("excluded_subtrees");
                if (generalSubtrees != null) {
                    if (this.excludedSubtrees == null) {
                        this.excludedSubtrees = (GeneralSubtrees)generalSubtrees.clone();
                    } else {
                        this.excludedSubtrees.union(generalSubtrees);
                    }
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
    }
}

