/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class ArabicEncoder
extends IBMCharsetEncoder {
    private final short[] index;
    private final char[] data;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private byte[] lamAlef;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;

    ArabicEncoder(Charset charset, short[] sArray, char[] cArray, int n, byte[] byArray, byte[] byArray2) {
        super(charset, byArray == null ? 1.0f : 1.5f, byArray == null ? 1.0f : 2.0f);
        this.index = sArray;
        this.data = cArray;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.shift = n;
        this.lamAlef = byArray;
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public boolean isLegalReplacement(byte[] byArray) {
        return true;
    }

    public boolean canEncode(char c) {
        char c2 = this.data[this.index[c >> this.shift] + (c & this.mask2)];
        return c2 != '\u0000' || c == '\u0000';
    }

    /*
     * Enabled aggressive block sorting
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            block8: {
                char c = cArray[n];
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        coderResult = this.sgp.error();
                        break;
                    }
                    coderResult = this.sgp.unmappableResult();
                    break;
                }
                char c2 = this.data[this.index[c >> this.shift] + (c & this.mask2)];
                if (c2 == '\u0000' && c != '\u0000') {
                    if (this.lamAlef != null && c > '\ufef4' && c <= '\ufefc') {
                        if (n4 - n3 < 2) {
                            coderResult = CoderResult.OVERFLOW;
                            break;
                        }
                        byArray[n3++] = this.lamAlef[0];
                        byArray[n3++] = this.lamAlef[c - 65268];
                        break block8;
                    } else {
                        coderResult = CoderResult.unmappableForLength(1);
                        break;
                    }
                }
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)c2;
            }
            ++n;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block11: {
            CoderResult coderResult2;
            block15: {
                CoderResult coderResult3;
                block14: {
                    CoderResult coderResult4;
                    block13: {
                        CoderResult coderResult5;
                        n = charBuffer.position();
                        try {
                            while (true) {
                                if (!charBuffer.hasRemaining()) {
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block11;
                                }
                                char c = charBuffer.get();
                                if (Surrogate.is(c)) {
                                    if (this.sgp.parse(c, charBuffer) < 0) {
                                        CoderResult coderResult6 = this.sgp.error();
                                        Object var9_11 = null;
                                        charBuffer.position(n);
                                        return coderResult6;
                                    }
                                    coderResult5 = this.sgp.unmappableResult();
                                    break;
                                }
                                char c2 = this.data[this.index[c >> this.shift] + (c & this.mask2)];
                                if (c2 == '\u0000' && c != '\u0000') {
                                    if (this.lamAlef != null && c > '\ufef4' && c <= '\ufefc') {
                                        if (byteBuffer.remaining() < 2) {
                                            coderResult4 = CoderResult.OVERFLOW;
                                            break block13;
                                        } else {
                                            byteBuffer.put(this.lamAlef[0]);
                                            byteBuffer.put(this.lamAlef[c - 65268]);
                                            ++n;
                                            continue;
                                        }
                                    }
                                    coderResult3 = CoderResult.unmappableForLength(1);
                                    break block14;
                                }
                                if (!byteBuffer.hasRemaining()) {
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block15;
                                }
                                ++n;
                                byteBuffer.put((byte)c2);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_17 = null;
                            charBuffer.position(n);
                            throw throwable;
                        }
                        Object var9_12 = null;
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var9_13 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var9_14 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var9_15 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var9_16 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        BidiConvert bidiConvert;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(charBuffer, IBMCharsetEncoder.UseBuffer, this.bidiParms, this.toString())) {
            int n;
            int n2;
            int n3;
            byte[] byArray = this.lamAlef;
            this.lamAlef = null;
            int n4 = charBuffer.remaining();
            if (n4 > byteBuffer.remaining()) {
                n4 = byteBuffer.remaining();
            }
            if (charBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
                char[] cArray = charBuffer.array();
                n3 = charBuffer.arrayOffset() + charBuffer.position();
                n2 = n3 + n4;
                char c = cArray[n3];
                byte by = (byte)this.data[this.index[c >> this.shift] + (c & this.mask2)];
                boolean bl = by == 0 && c != '\u0000';
                n = n3 + 1;
                while (n < n2) {
                    c = cArray[n];
                    by = (byte)this.data[this.index[c >> this.shift] + (c & this.mask2)];
                    if ((by == 0 && c != '\u0000') != bl) break;
                    ++n;
                }
                n4 = n - n3;
            } else {
                int n5 = charBuffer.position();
                n2 = n4;
                n = charBuffer.get();
                byte by = (byte)this.data[this.index[n >> this.shift] + (n & this.mask2)];
                boolean bl = by == 0 && n != 0;
                n3 = 1;
                while (n3 < n2) {
                    n = charBuffer.get();
                    by = (byte)this.data[this.index[n >> this.shift] + (n & this.mask2)];
                    if ((by == 0 && n != 0) != bl) break;
                    ++n3;
                }
                charBuffer.position(n5);
                n4 = n3;
            }
            int n6 = charBuffer.limit();
            charBuffer.limit(charBuffer.position() + n4);
            CharBuffer charBuffer2 = bidiConvert.toSbcs(charBuffer, IBMCharsetEncoder.UseBuffer, this.bidiParms, this.toString());
            charBuffer.limit(n6);
            n2 = charBuffer2.position();
            CoderResult coderResult = charBuffer2.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer ? this.encodeArrayLoop(charBuffer2, byteBuffer) : this.encodeBufferLoop(charBuffer2, byteBuffer);
            n2 = charBuffer.position() + charBuffer2.position() - n2;
            charBuffer.position(n2);
            if (coderResult == CoderResult.UNDERFLOW && charBuffer.hasRemaining()) {
                coderResult = CoderResult.OVERFLOW;
            }
            this.lamAlef = byArray;
            return coderResult;
        }
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

