/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.DBCS_Decoder;
import com.ibm.nio.cs.DBCS_Encoder;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class SJIS
extends Converter {
    static char[] JapanSingleEncode = new char[]{'\u0000', '\u007f', '\u0000', '\u00a5', '\u00a5', '\\', '\u203e', '\u203e', '~', '\uff61', '\uff9f', '\u00a1'};
    static char[] JapanSingleDecode = new char[]{'\u0000', '\u007f', '\u0000', '\u00a1', '\u00df', '\uff61'};
    private static byte[] leadBytes = new byte[256];

    public SJIS() {
        super("Shift_JIS", "JIS0208");
        this.baseName = "SJIS";
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static {
        int n = 129;
        while (n <= 159) {
            SJIS.leadBytes[n] = 1;
            ++n;
        }
        n = 224;
        while (n <= 252) {
            SJIS.leadBytes[n] = 1;
            ++n;
        }
    }

    private class Encoder
    extends DBCS_Encoder {
        private Encoder(Converter converter) {
            super(converter, converter.c2b.getIndex(), (String[])converter.c2b.getObjectData(), JapanSingleEncode, (byte)0, converter.c2b.getReplace());
        }

        protected char getValue(char c) {
            int n;
            char c2 = super.getValue(c);
            if (c2 == '\u0000') {
                return '\u0000';
            }
            int n2 = c2 >> 8 & 0xFF;
            int n3 = c2 & 0xFF;
            int n4 = n = n2 < 95 ? 112 : 176;
            int n5 = n2 % 2 == 1 ? (n3 > 95 ? 32 : 31) : 126;
            return (char)((n2 + 1 >> 1) + n << 8 | n3 + n5);
        }
    }

    private class Decoder
    extends DBCS_Decoder {
        private Decoder(Converter converter) {
            super(converter, converter.b2c.getIndex(), (String[])converter.b2c.getObjectData(), leadBytes, JapanSingleDecode, (byte)0, (byte)33, (byte)126);
        }

        protected char getUnicode(int n, int n2) {
            int n3;
            int n4 = n2 < 159 ? 1 : 0;
            int n5 = n3 = n < 160 ? 112 : 176;
            int n6 = n4 == 1 ? (n2 > 127 ? 32 : 31) : 126;
            int n7 = (n - n3 << 1) - n4;
            int n8 = n2 - n6;
            char c = super.getUnicode(n7, n8);
            return c;
        }
    }
}

