/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util.entity;

import com.ibm.xml.b2b.util.entity.EncodingDeclReader;
import java.io.IOException;

final class LatinEncodingDeclReader
extends EncodingDeclReader {
    private static final byte ___ = 0;
    private static final byte WSP = 1;
    private static final byte PER = 9;
    private static final byte LSS = 10;
    private static final byte HYP = 7;
    private static final byte USC = 8;
    private static final byte GTR = 11;
    private static final byte QST = 12;
    private static final byte SQT = 3;
    private static final byte EQL = 2;
    private static final byte DQT = 4;
    private static final byte LTR = 5;
    private static final byte DIG = 6;
    private static final byte[] fgCodePointMapLatin = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 7, 9, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 10, 2, 11, 12, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 8, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] STARTPIXML = new int[]{60, 63, 120, 109, 108};
    private static final int[] VERSION = new int[]{118, 101, 114, 115, 105, 111, 110};
    private static final int[] VERSION10 = new int[]{49, 46, 48};
    private static final int[] ENCODING = new int[]{101, 110, 99, 111, 100, 105, 110, 103};
    private static final int[] STANDALONE = new int[]{115, 116, 97, 110, 100, 97, 108, 111, 110, 101};
    private static final int[] YES = new int[]{121, 101, 115};
    private static final int[] NO = new int[]{110, 111};
    private static final int[] ENDPI = new int[]{63, 62};

    protected boolean lookingAtCodePoint(int n) throws IOException {
        this.fStream.mark(1);
        int n2 = this.fStream.read();
        this.fStream.reset();
        if (n2 == -1) {
            return false;
        }
        byte by = fgCodePointMapLatin[n2];
        return by == n;
    }

    protected boolean skipCodePoint(int n) throws IOException {
        this.fStream.mark(1);
        int n2 = this.fStream.read();
        if (n2 == -1) {
            return false;
        }
        byte by = fgCodePointMapLatin[n2];
        if (by != n) {
            this.fStream.reset();
            return false;
        }
        return true;
    }

    protected boolean skipLiteral(int n) throws IOException {
        int n2;
        int[] nArray;
        switch (n) {
            case 0: {
                int n3;
                int[] nArray2 = STARTPIXML;
                this.fStream.mark(6);
                int n4 = 0;
                while (n4 < 5) {
                    n3 = this.fStream.read();
                    if (n3 != nArray2[n4]) {
                        this.fStream.reset();
                        return false;
                    }
                    ++n4;
                }
                n3 = this.fStream.read();
                if (n3 == -1) {
                    this.fStream.reset();
                    return false;
                }
                byte by = fgCodePointMapLatin[n3];
                if (by != 1) {
                    this.fStream.reset();
                    return false;
                }
                return true;
            }
            case 1: {
                nArray = VERSION;
                n2 = 7;
                break;
            }
            case 2: {
                nArray = VERSION10;
                n2 = 3;
                break;
            }
            case 3: {
                nArray = ENCODING;
                n2 = 8;
                break;
            }
            case 4: {
                nArray = STANDALONE;
                n2 = 10;
                break;
            }
            case 5: {
                nArray = YES;
                n2 = 3;
                break;
            }
            case 6: {
                nArray = NO;
                n2 = 2;
                break;
            }
            case 7: {
                nArray = ENDPI;
                n2 = 2;
                break;
            }
            default: {
                return false;
            }
        }
        this.fStream.mark(n2);
        int n5 = 0;
        while (n5 < n2) {
            int n6 = this.fStream.read();
            if (n6 != nArray[n5]) {
                this.fStream.reset();
                return false;
            }
            ++n5;
        }
        return true;
    }

    protected boolean skipSpaces() throws IOException {
        boolean bl = false;
        while (this.skipCodePoint(1)) {
            bl = true;
        }
        return bl;
    }

    protected boolean scanEncodingName(int n) throws IOException {
        int n2;
        char[] cArray;
        block9: {
            this.fStream.mark(1);
            int n3 = this.fStream.read();
            if (n3 == -1) {
                this.fStream.reset();
                return false;
            }
            byte by = fgCodePointMapLatin[n3];
            if (by != 5) {
                this.fStream.reset();
                return false;
            }
            cArray = this.fEncodingNameBuffer;
            if (cArray == null) {
                cArray = this.fEncodingNameBuffer = new char[64];
            }
            n2 = 0;
            cArray[n2++] = (char)n3;
            block3: while (true) {
                this.fStream.mark(1);
                n3 = this.fStream.read();
                if (n3 == -1) {
                    this.fStream.reset();
                    return false;
                }
                by = fgCodePointMapLatin[n3];
                if (by == n) break block9;
                switch (by) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        if (n2 == cArray.length) {
                            this.fEncodingNameBuffer = new char[n2 << 1];
                            System.arraycopy(cArray, 0, this.fEncodingNameBuffer, 0, n2);
                            cArray = this.fEncodingNameBuffer;
                        }
                        cArray[n2++] = (char)n3;
                        continue block3;
                    }
                }
                break;
            }
            this.fStream.reset();
            return false;
        }
        this.fStream.reset();
        this.fEncodingName = new String(cArray, 0, n2);
        return true;
    }
}

