/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xslt4j.regexp;

import com.ibm.xslt4j.regexp.REProgram;
import com.ibm.xslt4j.regexp.RESyntaxException;
import java.util.Hashtable;

public class RECompiler {
    char[] instruction = new char[128];
    int lenInstruction = 0;
    String pattern;
    int len;
    int idx;
    int parens;
    static final int NODE_NORMAL = 0;
    static final int NODE_NULLABLE = 1;
    static final int NODE_TOPLEVEL = 2;
    static final char ESC_MASK = '\ufff0';
    static final char ESC_BACKREF = '\uffff';
    static final char ESC_COMPLEX = '\ufffe';
    static final char ESC_CLASS = '\ufffd';
    static final int maxBrackets = 10;
    static int brackets = 0;
    static int[] bracketStart = null;
    static int[] bracketEnd = null;
    static int[] bracketMin = null;
    static int[] bracketOpt = null;
    static final int bracketUnbounded = -1;
    static final int bracketFinished = -2;
    static Hashtable hashPOSIX = new Hashtable();

    static {
        hashPOSIX.put("alnum", new Character('w'));
        hashPOSIX.put("alpha", new Character('a'));
        hashPOSIX.put("blank", new Character('b'));
        hashPOSIX.put("cntrl", new Character('c'));
        hashPOSIX.put("digit", new Character('d'));
        hashPOSIX.put("graph", new Character('g'));
        hashPOSIX.put("lower", new Character('l'));
        hashPOSIX.put("print", new Character('p'));
        hashPOSIX.put("punct", new Character('!'));
        hashPOSIX.put("space", new Character('s'));
        hashPOSIX.put("upper", new Character('u'));
        hashPOSIX.put("xdigit", new Character('x'));
        hashPOSIX.put("javastart", new Character('j'));
        hashPOSIX.put("javapart", new Character('k'));
    }

    void ensure(int n) {
        int curlen = this.instruction.length;
        if (this.lenInstruction + n >= curlen) {
            while (this.lenInstruction + n >= curlen) {
                curlen *= 2;
            }
            char[] newInstruction = new char[curlen];
            System.arraycopy(this.instruction, 0, newInstruction, 0, this.lenInstruction);
            this.instruction = newInstruction;
        }
    }

    void emit(char c) {
        this.ensure(1);
        this.instruction[this.lenInstruction++] = c;
    }

    void nodeInsert(char opcode, int opdata, int insertAt) {
        this.ensure(3);
        System.arraycopy(this.instruction, insertAt, this.instruction, insertAt + 3, this.lenInstruction - insertAt);
        this.instruction[insertAt + 0] = opcode;
        this.instruction[insertAt + 1] = (char)opdata;
        this.instruction[insertAt + 2] = '\u0000';
        this.lenInstruction += 3;
    }

    void setNextOfEnd(int node, int pointTo) {
        char next;
        while ((next = this.instruction[node + 2]) != '\u0000') {
            node += next;
        }
        this.instruction[node + 2] = (char)(pointTo - node);
    }

    int node(char opcode, int opdata) {
        this.ensure(3);
        this.instruction[this.lenInstruction + 0] = opcode;
        this.instruction[this.lenInstruction + 1] = (char)opdata;
        this.instruction[this.lenInstruction + 2] = '\u0000';
        this.lenInstruction += 3;
        return this.lenInstruction - 3;
    }

    void internalError() throws Error {
        throw new Error("Internal error!");
    }

    void syntaxError(String s) throws RESyntaxException {
        throw new RESyntaxException(s);
    }

    void allocBrackets() {
        if (bracketStart == null) {
            bracketStart = new int[10];
            bracketEnd = new int[10];
            bracketMin = new int[10];
            bracketOpt = new int[10];
            int i = 0;
            while (i < 10) {
                RECompiler.bracketOpt[i] = -1;
                RECompiler.bracketMin[i] = -1;
                RECompiler.bracketEnd[i] = -1;
                RECompiler.bracketStart[i] = -1;
                ++i;
            }
        }
    }

    void bracket() throws RESyntaxException {
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '{') {
            this.internalError();
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        StringBuffer number = new StringBuffer();
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            number.append(this.pattern.charAt(this.idx++));
        }
        try {
            RECompiler.bracketMin[RECompiler.brackets] = Integer.parseInt(number.toString());
        }
        catch (NumberFormatException e) {
            this.syntaxError("Expected valid number");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            RECompiler.bracketOpt[RECompiler.brackets] = 0;
            return;
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != ',') {
            this.syntaxError("Expected comma");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            RECompiler.bracketOpt[RECompiler.brackets] = -1;
            return;
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        number.setLength(0);
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            number.append(this.pattern.charAt(this.idx++));
        }
        try {
            RECompiler.bracketOpt[RECompiler.brackets] = Integer.parseInt(number.toString()) - bracketMin[brackets];
        }
        catch (NumberFormatException e) {
            this.syntaxError("Expected valid number");
        }
        if (bracketOpt[brackets] <= 0) {
            this.syntaxError("Bad range");
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '}') {
            this.syntaxError("Missing close brace");
        }
    }

    char escape() throws RESyntaxException {
        if (this.pattern.charAt(this.idx) != '\\') {
            this.internalError();
        }
        if (this.idx + 1 == this.len) {
            this.syntaxError("Escape terminates string");
        }
        this.idx += 2;
        char escapeChar = this.pattern.charAt(this.idx - 1);
        switch (escapeChar) {
            case 'B': 
            case 'b': {
                return '\ufffe';
            }
            case 'D': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 's': 
            case 'w': {
                return '\ufffd';
            }
            case 'u': 
            case 'x': {
                int hexDigits = escapeChar == 'u' ? 4 : 2;
                int val = 0;
                while (this.idx < this.len && hexDigits-- > 0) {
                    char c = this.pattern.charAt(this.idx);
                    if (c >= '0' && c <= '9') {
                        val = (val << 4) + c - 48;
                    } else if ((c = Character.toLowerCase(c)) >= 'a' && c <= 'f') {
                        val = (val << 4) + (c - 97) + 10;
                    } else {
                        this.syntaxError("Expected " + hexDigits + " hexadecimal digits after \\" + escapeChar);
                    }
                    ++this.idx;
                }
                return (char)val;
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx)) || escapeChar == '0') {
                    int val = escapeChar - 48;
                    if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                        val = (val << 3) + (this.pattern.charAt(this.idx++) - 48);
                        if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                            val = (val << 3) + (this.pattern.charAt(this.idx++) - 48);
                        }
                    }
                    return (char)val;
                }
                return '\uffff';
            }
        }
        return escapeChar;
    }

    int characterClass() throws RESyntaxException {
        int CHAR_INVALID;
        if (this.pattern.charAt(this.idx) != '[') {
            this.internalError();
        }
        if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) == ']') {
            this.syntaxError("Empty or unterminated class");
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == ':') {
            ++this.idx;
            int idxStart = this.idx;
            while (this.idx < this.len && this.pattern.charAt(this.idx) >= 'a' && this.pattern.charAt(this.idx) <= 'z') {
                ++this.idx;
            }
            if (this.idx + 1 < this.len && this.pattern.charAt(this.idx) == ':' && this.pattern.charAt(this.idx + 1) == ']') {
                String charClass = this.pattern.substring(idxStart, this.idx);
                Character i = (Character)hashPOSIX.get(charClass);
                if (i != null) {
                    this.idx += 2;
                    return this.node('P', i.charValue());
                }
                this.syntaxError("Invalid POSIX character class '" + charClass + "'");
            }
            this.syntaxError("Invalid POSIX character class syntax");
        }
        int ret = this.node('[', 0);
        int last = CHAR_INVALID = 65535;
        int simpleChar = 0;
        boolean include = true;
        boolean definingRange = false;
        int idxFirst = this.idx;
        int rangeStart = 0;
        RERange range = new RERange();
        block16: while (this.idx < this.len && this.pattern.charAt(this.idx) != ']') {
            switch (this.pattern.charAt(this.idx)) {
                case '^': {
                    boolean bl = include = !include;
                    if (this.idx == idxFirst) {
                        range.include(0, 65535, true);
                    }
                    ++this.idx;
                    continue block16;
                }
                case '\\': {
                    int c = this.escape();
                    switch (c) {
                        case 65534: 
                        case 65535: {
                            this.syntaxError("Bad character class");
                        }
                        case 65533: {
                            if (definingRange) {
                                this.syntaxError("Bad character class");
                            }
                            switch (this.pattern.charAt(this.idx - 1)) {
                                case 'D': 
                                case 'S': 
                                case 'W': {
                                    this.syntaxError("Bad character class");
                                }
                                case 's': {
                                    range.include('\t', include);
                                    range.include('\r', include);
                                    range.include('\f', include);
                                    range.include('\n', include);
                                    range.include('\b', include);
                                    range.include(' ', include);
                                    break;
                                }
                                case 'w': {
                                    range.include(97, 122, include);
                                    range.include(65, 90, include);
                                    range.include('_', include);
                                }
                                case 'd': {
                                    range.include(48, 57, include);
                                }
                            }
                            last = CHAR_INVALID;
                            continue block16;
                        }
                        default: {
                            simpleChar = c;
                            break;
                        }
                    }
                    break;
                }
                case '-': {
                    if (definingRange) {
                        this.syntaxError("Bad class range");
                    }
                    definingRange = true;
                    int n = rangeStart = last == CHAR_INVALID ? 0 : last;
                    if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) != ']') continue block16;
                    simpleChar = 65535;
                    break;
                }
                default: {
                    simpleChar = this.pattern.charAt(this.idx++);
                }
            }
            if (definingRange) {
                int rangeEnd = simpleChar;
                if (rangeStart >= rangeEnd) {
                    this.syntaxError("Bad character class");
                }
                range.include(rangeStart, rangeEnd, include);
                last = CHAR_INVALID;
                definingRange = false;
                continue;
            }
            if (this.idx + 1 >= this.len || this.pattern.charAt(this.idx + 1) != '-') {
                range.include((char)simpleChar, include);
            }
            last = simpleChar;
        }
        if (this.idx == this.len) {
            this.syntaxError("Unterminated character class");
        }
        ++this.idx;
        this.instruction[ret + 1] = (char)range.num;
        int i = 0;
        while (i < range.num) {
            this.emit((char)range.minRange[i]);
            this.emit((char)range.maxRange[i]);
            ++i;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    int atom() throws RESyntaxException {
        ret = this.node('A', 0);
        lenAtom = 0;
        block8: while (this.idx < this.len) {
            if (this.idx + 1 >= this.len) ** GOTO lbl-1000
            c = this.pattern.charAt(this.idx + 1);
            if (this.pattern.charAt(this.idx) == '\\') {
                idxEscape = this.idx;
                this.escape();
                if (this.idx < this.len) {
                    c = this.pattern.charAt(this.idx);
                }
                this.idx = idxEscape;
            }
            block0 : switch (c) {
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    if (lenAtom != 0) break block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    switch (this.pattern.charAt(this.idx)) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '.': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '|': {
                            break block8;
                        }
                        case '*': 
                        case '+': 
                        case '?': 
                        case '{': {
                            if (lenAtom != 0) break block8;
                            this.syntaxError("Missing operand to closure");
                            break block8;
                        }
                        case '\\': {
                            idxBeforeEscape = this.idx;
                            c = this.escape();
                            if ((c & 65520) == 65520) {
                                this.idx = idxBeforeEscape;
                                break block8;
                            }
                            this.emit(c);
                            ++lenAtom;
                            break block0;
                        }
                        default: {
                            this.emit(this.pattern.charAt(this.idx++));
                            ++lenAtom;
                        }
                    }
                }
            }
        }
        if (lenAtom == 0) {
            this.internalError();
        }
        this.instruction[ret + 1] = (char)lenAtom;
        return ret;
    }

    int terminal(int[] flags) throws RESyntaxException {
        switch (this.pattern.charAt(this.idx)) {
            case '$': 
            case '.': 
            case '^': {
                return this.node(this.pattern.charAt(this.idx++), 0);
            }
            case '[': {
                return this.characterClass();
            }
            case '(': {
                return this.expr(flags);
            }
            case ')': {
                this.syntaxError("Unexpected close paren");
            }
            case '|': {
                this.internalError();
            }
            case ']': {
                this.syntaxError("Mismatched class");
            }
            case '\u0000': {
                this.syntaxError("Unexpected end of input");
            }
            case '*': 
            case '+': 
            case '?': 
            case '{': {
                this.syntaxError("Missing operand to closure");
            }
            case '\\': {
                int idxBeforeEscape = this.idx;
                switch (this.escape()) {
                    case '\ufffd': 
                    case '\ufffe': {
                        flags[0] = flags[0] & 0xFFFFFFFE;
                        return this.node('\\', this.pattern.charAt(this.idx - 1));
                    }
                    case '\uffff': {
                        char backreference = (char)(this.pattern.charAt(this.idx - 1) - 48);
                        if (this.parens <= backreference) {
                            this.syntaxError("Bad backreference");
                        }
                        flags[0] = flags[0] | 1;
                        return this.node('#', backreference);
                    }
                }
                this.idx = idxBeforeEscape;
                flags[0] = flags[0] & 0xFFFFFFFE;
            }
        }
        flags[0] = flags[0] & 0xFFFFFFFE;
        return this.atom();
    }

    /*
     * Enabled aggressive block sorting
     */
    int closure(int[] flags) throws RESyntaxException {
        int idxBeforeTerminal = this.idx;
        int[] terminalFlags = new int[1];
        int ret = this.terminal(terminalFlags);
        flags[0] = flags[0] | terminalFlags[0];
        if (this.idx >= this.len) {
            return ret;
        }
        boolean greedy = true;
        int closureType = this.pattern.charAt(this.idx);
        switch (closureType) {
            case 42: 
            case 63: {
                flags[0] = flags[0] | 1;
            }
            case 43: {
                ++this.idx;
            }
            case 123: {
                char opcode = this.instruction[ret + 0];
                if (opcode == '^' || opcode == '$') {
                    this.syntaxError("Bad closure operand");
                }
                if ((terminalFlags[0] & 1) == 0) break;
                this.syntaxError("Closure operand can't be nullable");
                break;
            }
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == '?') {
            ++this.idx;
            greedy = false;
        }
        if (greedy) {
            switch (closureType) {
                case 123: {
                    boolean found = false;
                    this.allocBrackets();
                    int i = 0;
                    while (i < brackets) {
                        if (bracketStart[i] == this.idx) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        if (brackets >= 10) {
                            this.syntaxError("Too many bracketed closures (limit is 10)");
                        }
                        RECompiler.bracketStart[RECompiler.brackets] = this.idx;
                        this.bracket();
                        RECompiler.bracketEnd[RECompiler.brackets] = this.idx;
                        i = brackets++;
                    }
                    int n = i;
                    bracketMin[n] = bracketMin[n] - 1;
                    if (bracketMin[n] > 0) {
                        this.idx = idxBeforeTerminal;
                        return ret;
                    }
                    if (bracketOpt[i] == -2) {
                        closureType = 42;
                        RECompiler.bracketOpt[i] = 0;
                        this.idx = bracketEnd[i];
                    } else {
                        if (bracketOpt[i] == -1) {
                            this.idx = idxBeforeTerminal;
                            RECompiler.bracketOpt[i] = -2;
                            return ret;
                        }
                        int n2 = i;
                        int n3 = bracketOpt[n2];
                        bracketOpt[n2] = n3 - 1;
                        if (n3 <= 0) {
                            this.idx = bracketEnd[i];
                            return ret;
                        }
                        this.idx = idxBeforeTerminal;
                        closureType = 63;
                    }
                }
                case 42: 
                case 63: {
                    if (!greedy) {
                        return ret;
                    }
                    if (closureType == 63) {
                        this.nodeInsert('|', 0, ret);
                        this.setNextOfEnd(ret, this.node('|', 0));
                        int nothing = this.node('N', 0);
                        this.setNextOfEnd(ret, nothing);
                        this.setNextOfEnd(ret + 3, nothing);
                    }
                    if (closureType != 42) return ret;
                    this.nodeInsert('|', 0, ret);
                    this.setNextOfEnd(ret + 3, this.node('|', 0));
                    this.setNextOfEnd(ret + 3, this.node('G', 0));
                    this.setNextOfEnd(ret + 3, ret);
                    this.setNextOfEnd(ret, this.node('|', 0));
                    this.setNextOfEnd(ret, this.node('N', 0));
                    return ret;
                }
                case 43: {
                    int branch = this.node('|', 0);
                    this.setNextOfEnd(ret, branch);
                    this.setNextOfEnd(this.node('G', 0), ret);
                    this.setNextOfEnd(branch, this.node('|', 0));
                    this.setNextOfEnd(ret, this.node('N', 0));
                }
            }
            return ret;
        }
        this.setNextOfEnd(ret, this.node('E', 0));
        switch (closureType) {
            case 63: {
                this.nodeInsert('/', 0, ret);
                break;
            }
            case 42: {
                this.nodeInsert('8', 0, ret);
                break;
            }
            case 43: {
                this.nodeInsert('=', 0, ret);
                break;
            }
        }
        this.setNextOfEnd(ret, this.lenInstruction);
        return ret;
    }

    int branch(int[] flags) throws RESyntaxException {
        int ret = this.node('|', 0);
        int chain = -1;
        int[] closureFlags = new int[1];
        boolean nullable = true;
        while (this.idx < this.len && this.pattern.charAt(this.idx) != '|' && this.pattern.charAt(this.idx) != ')') {
            closureFlags[0] = 0;
            int node = this.closure(closureFlags);
            if (closureFlags[0] == 0) {
                nullable = false;
            }
            if (chain != -1) {
                this.setNextOfEnd(chain, node);
            }
            chain = node;
        }
        if (chain == -1) {
            this.node('N', 0);
        }
        if (nullable) {
            flags[0] = flags[0] | 1;
        }
        return ret;
    }

    int expr(int[] flags) throws RESyntaxException {
        int end;
        boolean paren = false;
        int ret = -1;
        int closeParens = this.parens;
        if ((flags[0] & 2) == 0 && this.pattern.charAt(this.idx) == '(') {
            ++this.idx;
            paren = true;
            ret = this.node('(', this.parens++);
        }
        flags[0] = flags[0] & 0xFFFFFFFD;
        int branch = this.branch(flags);
        if (ret == -1) {
            ret = branch;
        } else {
            this.setNextOfEnd(ret, branch);
        }
        while (this.idx < this.len && this.pattern.charAt(this.idx) == '|') {
            ++this.idx;
            branch = this.branch(flags);
            this.setNextOfEnd(ret, branch);
        }
        if (paren) {
            if (this.idx < this.len && this.pattern.charAt(this.idx) == ')') {
                ++this.idx;
            } else {
                this.syntaxError("Missing close paren");
            }
            end = this.node(')', closeParens);
        } else {
            end = this.node('E', 0);
        }
        this.setNextOfEnd(ret, end);
        int next = -1;
        int i = ret;
        while (next != 0) {
            if (this.instruction[i + 0] == '|') {
                this.setNextOfEnd(i + 3, end);
            }
            next = this.instruction[i + 2];
            i += next;
        }
        return ret;
    }

    public REProgram compile(String pattern) throws RESyntaxException {
        this.pattern = pattern;
        this.len = pattern.length();
        this.idx = 0;
        this.lenInstruction = 0;
        this.parens = 1;
        brackets = 0;
        int[] flags = new int[]{2};
        this.expr(flags);
        if (this.idx != this.len) {
            if (pattern.charAt(this.idx) == ')') {
                this.syntaxError("Unmatched close paren");
            }
            this.syntaxError("Unexpected input remains");
        }
        char[] ins = new char[this.lenInstruction];
        System.arraycopy(this.instruction, 0, ins, 0, this.lenInstruction);
        return new REProgram(ins);
    }

    class RERange {
        int size = 16;
        int[] minRange = new int[this.size];
        int[] maxRange = new int[this.size];
        int num = 0;

        RERange() {
        }

        /*
         * Unable to fully structure code
         */
        void delete(int index) {
            if (this.num != 0 && index < this.num) ** GOTO lbl6
            return;
lbl-1000:
            // 1 sources

            {
                if (index - 1 < 0) continue;
                this.minRange[index - 1] = this.minRange[index];
                this.maxRange[index - 1] = this.maxRange[index];
lbl6:
                // 3 sources

                ** while (index++ < this.num)
            }
lbl7:
            // 1 sources

            --this.num;
        }

        void merge(int min, int max) {
            int i = 0;
            while (i < this.num) {
                if (min >= this.minRange[i] && max <= this.maxRange[i]) {
                    return;
                }
                if (min <= this.minRange[i] && max >= this.maxRange[i]) {
                    this.delete(i);
                    this.merge(min, max);
                    return;
                }
                if (min >= this.minRange[i] && min <= this.maxRange[i]) {
                    this.delete(i);
                    min = this.minRange[i];
                    this.merge(min, max);
                    return;
                }
                if (max >= this.minRange[i] && max <= this.maxRange[i]) {
                    this.delete(i);
                    max = this.maxRange[i];
                    this.merge(min, max);
                    return;
                }
                ++i;
            }
            if (this.num >= this.size) {
                this.size *= 2;
                int[] newMin = new int[this.size];
                int[] newMax = new int[this.size];
                System.arraycopy(this.minRange, 0, newMin, 0, this.num);
                System.arraycopy(this.maxRange, 0, newMax, 0, this.num);
                this.minRange = newMin;
                this.maxRange = newMax;
            }
            this.minRange[this.num] = min;
            this.maxRange[this.num] = max;
            ++this.num;
        }

        void remove(int min, int max) {
            int i = 0;
            while (i < this.num) {
                if (this.minRange[i] >= min && this.maxRange[i] <= max) {
                    this.delete(i);
                    --i;
                    return;
                }
                if (min >= this.minRange[i] && max <= this.maxRange[i]) {
                    int minr = this.minRange[i];
                    int maxr = this.maxRange[i];
                    this.delete(i);
                    if (minr < min - 1) {
                        this.merge(minr, min - 1);
                    }
                    if (max + 1 < maxr) {
                        this.merge(max + 1, maxr);
                    }
                    return;
                }
                if (this.minRange[i] >= min && this.minRange[i] <= max) {
                    this.minRange[i] = max + 1;
                    return;
                }
                if (this.maxRange[i] >= min && this.maxRange[i] <= max) {
                    this.maxRange[i] = min - 1;
                    return;
                }
                ++i;
            }
        }

        void include(int min, int max, boolean include) {
            if (include) {
                this.merge(min, max);
            } else {
                this.remove(min, max);
            }
        }

        void include(char minmax, boolean include) {
            this.include(minmax, minmax, include);
        }
    }
}

