/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.NameNode;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import java.lang.ref.SoftReference;
import java.util.Date;

class ZoneNode
extends NameNode {
    private SoftReference contentsRef = null;
    private long serialNumber = -1L;
    private Date expiration = null;

    ZoneNode(String string) {
        super(string);
    }

    protected NameNode newNameNode(String string) {
        return new ZoneNode(string);
    }

    synchronized void depopulate() {
        this.contentsRef = null;
        this.serialNumber = -1L;
    }

    synchronized boolean isPopulated() {
        return this.getContents() != null;
    }

    synchronized NameNode getContents() {
        return this.contentsRef != null ? (NameNode)this.contentsRef.get() : null;
    }

    synchronized boolean isExpired() {
        return this.expiration != null && this.expiration.before(new Date());
    }

    ZoneNode getDeepestPopulated(DnsName dnsName) {
        ZoneNode zoneNode = this;
        ZoneNode zoneNode2 = this.isPopulated() ? this : null;
        int n = 1;
        while (n < dnsName.size()) {
            if ((zoneNode = (ZoneNode)zoneNode.get(dnsName.getKey(n))) == null) break;
            if (zoneNode.isPopulated()) {
                zoneNode2 = zoneNode;
            }
            ++n;
        }
        return zoneNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NameNode populate(DnsName dnsName, ResourceRecords resourceRecords) {
        Object object;
        ResourceRecord resourceRecord;
        NameNode nameNode = new NameNode(null);
        int n = 0;
        while (n < resourceRecords.answer.size()) {
            resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(n);
            object = resourceRecord.getName();
            if (((DnsName)object).size() > dnsName.size() && ((DnsName)object).startsWith(dnsName)) {
                NameNode nameNode2 = nameNode.add((DnsName)object, dnsName.size());
                if (resourceRecord.getType() == 2) {
                    nameNode2.setZoneCut(true);
                }
            }
            ++n;
        }
        resourceRecord = (ResourceRecord)resourceRecords.answer.firstElement();
        object = this;
        synchronized (object) {
            this.contentsRef = new SoftReference<NameNode>(nameNode);
            this.serialNumber = ZoneNode.getSerialNumber(resourceRecord);
            this.setExpiration(ZoneNode.getMinimumTtl(resourceRecord));
            return nameNode;
        }
    }

    private void setExpiration(long l) {
        this.expiration = new Date(System.currentTimeMillis() + 1000L * l);
    }

    private static long getMinimumTtl(ResourceRecord resourceRecord) {
        String string = (String)resourceRecord.getRdata();
        int n = string.lastIndexOf(32) + 1;
        return Long.parseLong(string.substring(n));
    }

    int compareSerialNumberTo(ResourceRecord resourceRecord) {
        return ResourceRecord.compareSerialNumbers(this.serialNumber, ZoneNode.getSerialNumber(resourceRecord));
    }

    private static long getSerialNumber(ResourceRecord resourceRecord) {
        String string = (String)resourceRecord.getRdata();
        int n = string.length();
        int n2 = -1;
        int n3 = 0;
        while (n3 < 5) {
            n2 = n;
            n = string.lastIndexOf(32, n2 - 1);
            ++n3;
        }
        return Long.parseLong(string.substring(n + 1, n2));
    }
}

