/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import java.io.OutputStream;
import java.util.Arrays;
import javax.naming.ldap.Control;

class ClientId {
    private final int version;
    private final String hostname;
    private final int port;
    private final String protocol;
    private final Control[] bindCtls;
    private final OutputStream trace;
    private final int myHash;
    private final int ctlHash;

    ClientId(int n, String string, int n2, String string2, Control[] controlArray, OutputStream outputStream) {
        this.version = n;
        this.hostname = string.toLowerCase();
        this.port = n2;
        this.protocol = string2;
        this.bindCtls = controlArray != null ? (Control[])controlArray.clone() : null;
        this.trace = outputStream;
        this.ctlHash = ClientId.hashCodeControls(controlArray);
        this.myHash = n + n2 + (outputStream != null ? outputStream.hashCode() : 0) + (this.hostname != null ? this.hostname.hashCode() : 0) + (string2 != null ? string2.hashCode() : 0) + this.ctlHash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClientId)) {
            return false;
        }
        ClientId clientId = (ClientId)object;
        return this.myHash == clientId.myHash && this.version == clientId.version && this.port == clientId.port && this.trace == clientId.trace && (this.hostname == clientId.hostname || this.hostname != null && this.hostname.equals(clientId.hostname)) && (this.protocol == clientId.protocol || this.protocol != null && this.protocol.equals(clientId.protocol)) && this.ctlHash == clientId.ctlHash && ClientId.equalsControls(this.bindCtls, clientId.bindCtls);
    }

    public int hashCode() {
        return this.myHash;
    }

    private static int hashCodeControls(Control[] controlArray) {
        if (controlArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < controlArray.length) {
            n = n * 31 + controlArray[n2].getID().hashCode();
            ++n2;
        }
        return n;
    }

    private static boolean equalsControls(Control[] controlArray, Control[] controlArray2) {
        if (controlArray == controlArray2) {
            return true;
        }
        if (controlArray == null || controlArray2 == null) {
            return false;
        }
        if (controlArray.length != controlArray2.length) {
            return false;
        }
        int n = 0;
        while (n < controlArray.length) {
            if (!controlArray[n].getID().equals(controlArray2[n].getID()) || controlArray[n].isCritical() != controlArray2[n].isCritical() || !Arrays.equals(controlArray[n].getEncodedValue(), controlArray2[n].getEncodedValue())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static String toStringControls(Control[] controlArray) {
        if (controlArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < controlArray.length) {
            stringBuffer.append(controlArray[n].getID());
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.hostname + ":" + this.port + ":" + (this.protocol != null ? this.protocol : "") + ":" + ClientId.toStringControls(this.bindCtls);
    }
}

