/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.SimpleClientId;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.ldap.Control;

class DigestClientId
extends SimpleClientId {
    private static final String[] SASL_PROPS = new String[]{"java.naming.security.sasl.authorizationId", "java.naming.security.sasl.realm", "javax.security.sasl.qop", "javax.security.sasl.strength", "javax.security.sasl.reuse", "javax.security.sasl.server.authentication", "javax.security.sasl.maxbuffer", "javax.security.sasl.policy.noplaintext", "javax.security.sasl.policy.noactive", "javax.security.sasl.policy.nodictionary", "javax.security.sasl.policy.noanonymous", "javax.security.sasl.policy.forward", "javax.security.sasl.policy.credentials"};
    private final String[] propvals;
    private final int myHash;
    private int pHash = 0;

    DigestClientId(int n, String string, int n2, String string2, Control[] controlArray, OutputStream outputStream, String string3, Object object, Hashtable hashtable) {
        super(n, string, n2, string2, controlArray, outputStream, string3, object);
        if (hashtable == null) {
            this.propvals = null;
        } else {
            this.propvals = new String[SASL_PROPS.length];
            int n3 = 0;
            while (n3 < SASL_PROPS.length) {
                this.propvals[n3] = (String)hashtable.get(SASL_PROPS[n3]);
                if (this.propvals[n3] != null) {
                    this.pHash = this.pHash * 31 + this.propvals[n3].hashCode();
                }
                ++n3;
            }
        }
        this.myHash = super.hashCode() + this.pHash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DigestClientId)) {
            return false;
        }
        DigestClientId digestClientId = (DigestClientId)object;
        return this.myHash == digestClientId.myHash && this.pHash == digestClientId.pHash && super.equals(object) && Arrays.equals(this.propvals, digestClientId.propvals);
    }

    public int hashCode() {
        return this.myHash;
    }

    public String toString() {
        if (this.propvals != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.propvals.length) {
                stringBuffer.append(':');
                if (this.propvals[n] != null) {
                    stringBuffer.append(this.propvals[n]);
                }
                ++n;
            }
            return super.toString() + stringBuffer.toString();
        }
        return super.toString();
    }
}

