/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.ibm.jvm.ExtendedSystem;
import com.sun.jndi.ldap.DefaultResponseControlFactory;
import com.sun.jndi.ldap.EventSupport;
import com.sun.jndi.ldap.LdapAttribute;
import com.sun.jndi.ldap.LdapBindingEnumeration;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapName;
import com.sun.jndi.ldap.LdapNameParser;
import com.sun.jndi.ldap.LdapNamingEnumeration;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.LdapSchemaCtx;
import com.sun.jndi.ldap.LdapSearchEnumeration;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.ManageReferralControl;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.dir.HierMemDirCtx;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.ControlFactory;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.UnsolicitedNotificationListener;
import javax.naming.spi.DirectoryManager;

public final class LdapCtx
extends ComponentDirContext
implements EventDirContext,
LdapContext {
    private static final boolean debug = false;
    private static final boolean HARD_CLOSE = true;
    private static final boolean SOFT_CLOSE = false;
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    public static final String DEFAULT_HOST = "localhost";
    private static final boolean DEFAULT_DELETE_RDN = true;
    private static final boolean DEFAULT_TYPES_ONLY = false;
    private static final int DEFAULT_DEREF_ALIASES = 3;
    private static final int DEFAULT_LDAP_VERSION = 32;
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final int DEFAULT_REFERRAL_MODE = 3;
    private static final char DEFAULT_REF_SEPARATOR = '#';
    static final String DEFAULT_SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final int DEFAULT_REFERRAL_LIMIT = 10;
    private static final String STARTTLS_REQ_OID = "1.3.6.1.4.1.1466.20037";
    private static final String[] SCHEMA_ATTRIBUTES = new String[]{"objectClasses", "attributeTypes", "matchingRules", "ldapSyntaxes"};
    private static final String VERSION = "java.naming.ldap.version";
    private static final String BINARY_ATTRIBUTES = "java.naming.ldap.attributes.binary";
    private static final String DELETE_RDN = "java.naming.ldap.deleteRDN";
    private static final String DEREF_ALIASES = "java.naming.ldap.derefAliases";
    private static final String TYPES_ONLY = "java.naming.ldap.typesOnly";
    private static final String REF_SEPARATOR = "java.naming.ldap.ref.separator";
    private static final String SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    static final String BIND_CONTROLS = "java.naming.ldap.control.connect";
    private static final String REFERRAL_LIMIT = "java.naming.ldap.referral.limit";
    private static final String TRACE_BER = "com.sun.jndi.ldap.trace.ber";
    private static final String NETSCAPE_SCHEMA_BUG = "com.sun.jndi.ldap.netscape.schemaBugs";
    private static final String OLD_NETSCAPE_SCHEMA_BUG = "com.sun.naming.netscape.schemaBugs";
    private static final String CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String ENABLE_POOL = "com.sun.jndi.ldap.connect.pool";
    private static final String DOMAIN_NAME = "com.sun.jndi.ldap.domainname";
    private static final NameParser parser = new LdapNameParser();
    private static final ControlFactory myResponseControlFactory = new DefaultResponseControlFactory();
    private static final Control manageReferralControl = new ManageReferralControl(false);
    private static final HierMemDirCtx EMPTY_SCHEMA = new HierMemDirCtx();
    private static Class startTlsImplClass;
    private static Method startTlsInitMethod;
    int port_number;
    String hostname = null;
    LdapClient clnt = null;
    Hashtable envprops = null;
    int handleReferrals = 3;
    boolean hasLdapsScheme = false;
    String currentDN;
    Name currentParsedDN;
    Vector respCtls = null;
    Control[] reqCtls = null;
    private OutputStream trace = null;
    private boolean netscapeSchemaBug = false;
    private Control[] bindCtls = null;
    private int referralHopLimit = 10;
    private Hashtable schemaTrees = null;
    private int batchSize = 1;
    private boolean deleteRDN = true;
    private boolean typesOnly = false;
    private int derefAliases = 3;
    private char addrEncodingSeparator = (char)35;
    private Hashtable binaryAttrs = null;
    private int connectTimeout = -1;
    private boolean useSsl = false;
    private boolean useDefaultPortNumber = false;
    private boolean parentIsLdapCtx = false;
    private int hopCount = 1;
    private String url = null;
    private EventSupport eventSupport;
    private boolean unsolicited = false;
    private boolean sharable = true;
    private int enumCount = 0;
    private boolean closeRequested = false;
    static /* synthetic */ Class class$javax$naming$ldap$Control;
    static /* synthetic */ Class class$com$sun$jndi$ldap$Connection;
    static /* synthetic */ Class class$java$lang$String;

    public LdapCtx(String string, String string2, int n, Hashtable hashtable, boolean bl) throws NamingException {
        this.useSsl = this.hasLdapsScheme = bl;
        if (hashtable != null) {
            this.envprops = (Hashtable)hashtable.clone();
            if ("ssl".equals(this.envprops.get("java.naming.security.protocol"))) {
                this.useSsl = true;
            }
            this.trace = (OutputStream)this.envprops.get(TRACE_BER);
            if (hashtable.get(NETSCAPE_SCHEMA_BUG) != null || hashtable.get(OLD_NETSCAPE_SCHEMA_BUG) != null) {
                this.netscapeSchemaBug = true;
            }
        }
        this.currentDN = string != null ? string : "";
        this.currentParsedDN = new LdapName(this.currentDN);
        String string3 = this.hostname = string2 != null && string2.length() > 0 ? string2 : DEFAULT_HOST;
        if (this.hostname.charAt(0) == '[') {
            this.hostname = this.hostname.substring(1, this.hostname.length() - 1);
        }
        if (n > 0) {
            this.port_number = n;
        } else {
            this.port_number = this.useSsl ? 636 : 389;
            this.useDefaultPortNumber = true;
        }
        this.schemaTrees = new Hashtable(11, 0.75f);
        this.initEnv();
        this.connect(false);
    }

    LdapCtx(LdapCtx ldapCtx, String string) throws NamingException {
        this.useSsl = ldapCtx.useSsl;
        this.hasLdapsScheme = ldapCtx.hasLdapsScheme;
        this.useDefaultPortNumber = ldapCtx.useDefaultPortNumber;
        this.hostname = ldapCtx.hostname;
        this.port_number = ldapCtx.port_number;
        this.currentDN = string;
        this.currentParsedDN = ldapCtx.currentDN == this.currentDN ? ldapCtx.currentParsedDN : new LdapName(this.currentDN);
        this.envprops = ldapCtx.envprops;
        this.schemaTrees = ldapCtx.schemaTrees;
        this.clnt = ldapCtx.clnt;
        this.clnt.incRefCount();
        this.parentIsLdapCtx = string == null || string.equals(ldapCtx.currentDN) ? ldapCtx.parentIsLdapCtx : true;
        this.trace = ldapCtx.trace;
        this.netscapeSchemaBug = ldapCtx.netscapeSchemaBug;
        this.initEnv();
    }

    public LdapContext newInstance(Control[] controlArray) throws NamingException {
        LdapCtx ldapCtx = new LdapCtx(this, this.currentDN);
        ldapCtx.setRequestControls(controlArray);
        return ldapCtx;
    }

    protected void c_bind(Name name, Object object, Continuation continuation) throws NamingException {
        this.c_bind(name, object, null, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_bind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        Attributes attributes2 = attributes;
        try {
            this.ensureOpen();
            if (object == null) {
                if (attributes == null) {
                    throw new IllegalArgumentException("cannot bind null object with no attributes");
                }
            } else {
                attributes = Obj.determineBindAttrs(this.addrEncodingSeparator, object, attributes, false, name, this, this.envprops);
            }
            String string = this.fullyQualifiedName(name);
            attributes = LdapCtx.addRdnAttributes(string, attributes, attributes2 != attributes);
            LdapEntry ldapEntry = new LdapEntry(string, attributes);
            LdapResult ldapResult = this.clnt.add(ldapEntry, this.reqCtls);
            this.respCtls = ldapResult.resControls;
            if (ldapResult.status == 0) return;
            this.processReturnCode(ldapResult, name);
            return;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var10_16;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    try {
                        ldapReferralContext.bind(name, object, attributes2);
                        var10_16 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var10_16 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var10_16 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected void c_rebind(Name name, Object object, Continuation continuation) throws NamingException {
        this.c_rebind(name, object, null, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_rebind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        Attributes attributes2 = attributes;
        try {
            Object object2;
            Object object3;
            Attributes attributes3 = null;
            try {
                attributes3 = this.c_getAttributes(name, null, continuation);
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (attributes3 == null) {
                this.c_bind(name, object, attributes, continuation);
                return;
            }
            if (attributes == null && object instanceof DirContext) {
                attributes = ((DirContext)object).getAttributes("");
            }
            Attributes attributes4 = (Attributes)attributes3.clone();
            if (attributes == null) {
                int n;
                object3 = attributes3.get(Obj.JAVA_ATTRIBUTES[0]);
                if (object3 != null) {
                    object3 = (Attribute)object3.clone();
                    n = 0;
                    while (true) {
                        if (n >= Obj.JAVA_OBJECT_CLASSES.length) {
                            attributes3.put((Attribute)object3);
                            break;
                        }
                        object3.remove(Obj.JAVA_OBJECT_CLASSES_LOWER[n]);
                        object3.remove(Obj.JAVA_OBJECT_CLASSES[n]);
                        ++n;
                    }
                }
                n = 1;
                while (true) {
                    if (n >= Obj.JAVA_ATTRIBUTES.length) {
                        attributes = attributes3;
                        break;
                    }
                    attributes3.remove(Obj.JAVA_ATTRIBUTES[n]);
                    ++n;
                }
            }
            if (object != null) {
                attributes = Obj.determineBindAttrs(this.addrEncodingSeparator, object, attributes, attributes2 != attributes, name, this, this.envprops);
            }
            object3 = this.fullyQualifiedName(name);
            LdapResult ldapResult = this.clnt.delete((String)object3, this.reqCtls);
            this.respCtls = ldapResult.resControls;
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, name);
                return;
            }
            Exception exception = null;
            try {
                attributes = LdapCtx.addRdnAttributes((String)object3, attributes, attributes2 != attributes);
                object2 = new LdapEntry((String)object3, attributes);
                ldapResult = this.clnt.add((LdapEntry)object2, this.reqCtls);
                if (ldapResult.resControls != null) {
                    this.respCtls = LdapCtx.appendVector(this.respCtls, ldapResult.resControls);
                }
            }
            catch (NamingException namingException) {
                exception = namingException;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            if (exception != null && !(exception instanceof LdapReferralException) || ldapResult.status != 0) {
                object2 = this.clnt.add(new LdapEntry((String)object3, attributes4), this.reqCtls);
                if (((LdapResult)object2).resControls != null) {
                    this.respCtls = LdapCtx.appendVector(this.respCtls, ((LdapResult)object2).resControls);
                }
                if (exception == null) {
                    this.processReturnCode(ldapResult, name);
                }
            }
            if (exception instanceof NamingException) {
                throw exception;
            }
            if (!(exception instanceof IOException)) return;
            throw (IOException)exception;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var14_23;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    try {
                        ldapReferralContext.rebind(name, object, attributes2);
                        var14_23 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var14_23 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var14_23 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_unbind(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            String string = this.fullyQualifiedName(name);
            LdapResult ldapResult = this.clnt.delete(string, this.reqCtls);
            this.respCtls = ldapResult.resControls;
            this.adjustDeleteStatus(string, ldapResult);
            if (ldapResult.status == 0) return;
            this.processReturnCode(ldapResult, name);
            return;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var7_12;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    try {
                        ldapReferralContext.unbind(name);
                        var7_12 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var7_12 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var7_12 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_rename(Name name, Name name2, Continuation continuation) throws NamingException {
        String string = null;
        String string2 = null;
        continuation.setError((Object)this, name);
        try {
            Name name3;
            this.ensureOpen();
            if (name.isEmpty()) {
                name3 = parser.parse("");
            } else {
                Name name4 = parser.parse(name.get(0));
                name3 = name4.getPrefix(name4.size() - 1);
            }
            Name name5 = name2 instanceof CompositeName ? parser.parse(name2.get(0)) : name2;
            Name name6 = name5.getPrefix(name5.size() - 1);
            if (!name3.equals(name6)) {
                if (!this.clnt.isLdapv3) {
                    throw new InvalidNameException("LDAPv2 doesn't support changing the parent as a result of a rename");
                }
                string2 = this.fullyQualifiedName(name6.toString());
            }
            string = name5.get(name5.size() - 1);
            LdapResult ldapResult = this.clnt.moddn(this.fullyQualifiedName(name), string, this.deleteRDN, string2, this.reqCtls);
            this.respCtls = ldapResult.resControls;
            if (ldapResult.status == 0) return;
            this.processReturnCode(ldapResult, name);
            return;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            ldapReferralException.setNewRdn(string);
            if (string2 != null) {
                PartialResultException partialResultException = new PartialResultException("Cannot continue referral processing when newSuperior is nonempty: " + string2);
                partialResultException.setRootCause(continuation.fillInException(ldapReferralException));
                throw continuation.fillInException(partialResultException);
            }
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var14_19;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    try {
                        ldapReferralContext.rename(name, name2);
                        var14_19 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var14_19 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var14_19 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected Context c_createSubcontext(Name name, Continuation continuation) throws NamingException {
        return this.c_createSubcontext(name, null, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirContext c_createSubcontext(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        Attributes attributes2 = attributes;
        try {
            Object object;
            this.ensureOpen();
            if (attributes == null) {
                object = new BasicAttribute(Obj.JAVA_ATTRIBUTES[0], Obj.JAVA_OBJECT_CLASSES[0]);
                object.add("top");
                attributes = new BasicAttributes(true);
                attributes.put((Attribute)object);
            }
            object = this.fullyQualifiedName(name);
            attributes = LdapCtx.addRdnAttributes((String)object, attributes, attributes2 != attributes);
            LdapEntry ldapEntry = new LdapEntry((String)object, attributes);
            LdapResult ldapResult = this.clnt.add(ldapEntry, this.reqCtls);
            this.respCtls = ldapResult.resControls;
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, name);
                return null;
            }
            return new LdapCtx(this, (String)object);
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var9_16;
                DirContext dirContext;
                LdapReferralException ldapReferralException2;
                LdapReferralContext ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    dirContext = ldapReferralContext.createSubcontext(name, attributes2);
                    var9_16 = null;
                }
                catch (LdapReferralException ldapReferralException3) {
                    try {
                        ldapReferralException2 = ldapReferralException3;
                        var9_16 = null;
                    }
                    catch (Throwable throwable) {
                        var9_16 = null;
                        ldapReferralContext.close();
                        throw throwable;
                    }
                    ldapReferralContext.close();
                    {
                        continue;
                    }
                }
                ldapReferralContext.close();
                return dirContext;
                break;
            }
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_destroySubcontext(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            String string = this.fullyQualifiedName(name);
            LdapResult ldapResult = this.clnt.delete(string, this.reqCtls);
            this.respCtls = ldapResult.resControls;
            this.adjustDeleteStatus(string, ldapResult);
            if (ldapResult.status == 0) return;
            this.processReturnCode(ldapResult, name);
            return;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var7_12;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    try {
                        ldapReferralContext.destroySubcontext(name);
                        var7_12 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var7_12 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var7_12 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    private static Attributes addRdnAttributes(String string, Attributes attributes, boolean bl) throws NamingException {
        if (string.equals("")) {
            return attributes;
        }
        Vector vector = new LdapName.DnParser(string, true).getDn();
        LdapName.Rdn rdn = (LdapName.Rdn)vector.get(vector.size() - 1);
        Attributes attributes2 = rdn.toAttributes();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = namingEnumeration.next();
            if (attributes.get(attribute.getID()) != null || !attributes.isCaseIgnored() && LdapCtx.containsIgnoreCase(attributes.getIDs(), attribute.getID())) continue;
            if (!bl) {
                attributes = (Attributes)attributes.clone();
                bl = true;
            }
            attributes.put(attribute);
        }
        return attributes;
    }

    private static boolean containsIgnoreCase(NamingEnumeration namingEnumeration, String string) throws NamingException {
        while (namingEnumeration.hasMore()) {
            String string2 = (String)namingEnumeration.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void adjustDeleteStatus(String string, LdapResult ldapResult) {
        block3: {
            if (ldapResult.status != 32 || ldapResult.matchedDN == null) break block3;
            try {
                Name name = parser.parse(string);
                Name name2 = parser.parse(ldapResult.matchedDN);
                if (name.size() - name2.size() == 1) {
                    ldapResult.status = 0;
                }
            }
            catch (NamingException namingException) {}
        }
    }

    private static Vector appendVector(Vector vector, Vector vector2) {
        if (vector == null) {
            vector = vector2;
        } else {
            int n = 0;
            while (n < vector2.size()) {
                vector.addElement(vector2.elementAt(n));
                ++n;
            }
        }
        return vector;
    }

    protected Object c_lookupLink(Name name, Continuation continuation) throws NamingException {
        return this.c_lookup(name, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        Object object;
        Attributes attributes;
        continuation.setError((Object)this, name);
        Object object2 = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(null);
            searchControls.setReturningObjFlag(true);
            LdapResult ldapResult = this.doSearchOnce(name, "(objectClass=*)", searchControls, true);
            this.respCtls = ldapResult.resControls;
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, name);
            }
            if (ldapResult.entries == null || ldapResult.entries.size() != 1) {
                attributes = new BasicAttributes(true);
            } else {
                object = (LdapEntry)ldapResult.entries.elementAt(0);
                attributes = ((LdapEntry)object).attributes;
                Vector vector = ((LdapEntry)object).respCtls;
                if (vector != null) {
                    LdapCtx.appendVector(this.respCtls, vector);
                }
            }
            if (attributes.get(Obj.JAVA_ATTRIBUTES[2]) != null) {
                object2 = Obj.decodeObject(attributes);
            }
            if (object2 == null) {
                object2 = new LdapCtx(this, this.fullyQualifiedName(name));
            }
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var10_17;
                Object object3;
                LdapReferralException ldapReferralException2;
                LdapReferralContext ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    object3 = ldapReferralContext.lookup(name);
                    var10_17 = null;
                }
                catch (LdapReferralException ldapReferralException3) {
                    try {
                        ldapReferralException2 = ldapReferralException3;
                        var10_17 = null;
                    }
                    catch (Throwable throwable) {
                        var10_17 = null;
                        ldapReferralContext.close();
                        throw throwable;
                    }
                    ldapReferralContext.close();
                    {
                        continue;
                    }
                }
                ldapReferralContext.close();
                return object3;
                break;
            }
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
        try {
            return DirectoryManager.getObjectInstance(object2, name, this, this.envprops, attributes);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            object = new NamingException("problem generating object using object factory");
            ((NamingException)object).setRootCause(exception);
            throw continuation.fillInException((NamingException)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamingEnumeration c_list(Name name, Continuation continuation) throws NamingException {
        SearchControls searchControls = new SearchControls();
        String[] stringArray = new String[]{Obj.JAVA_ATTRIBUTES[0], Obj.JAVA_ATTRIBUTES[2]};
        searchControls.setReturningAttributes(stringArray);
        searchControls.setReturningObjFlag(true);
        continuation.setError((Object)this, name);
        LdapResult ldapResult = null;
        try {
            ldapResult = this.doSearch(name, "(objectClass=*)", searchControls, true, true);
            if (ldapResult.status != 0 || ldapResult.referrals != null) {
                this.processReturnCode(ldapResult, name);
            }
            return new LdapNamingEnumeration(this, ldapResult, name, continuation);
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var10_14;
                NamingEnumeration namingEnumeration;
                LdapReferralException ldapReferralException2;
                LdapReferralContext ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    namingEnumeration = ldapReferralContext.list(name);
                    var10_14 = null;
                }
                catch (LdapReferralException ldapReferralException3) {
                    try {
                        ldapReferralException2 = ldapReferralException3;
                        var10_14 = null;
                    }
                    catch (Throwable throwable) {
                        var10_14 = null;
                        ldapReferralContext.close();
                        throw throwable;
                    }
                    ldapReferralContext.close();
                    {
                        continue;
                    }
                }
                ldapReferralContext.close();
                return namingEnumeration;
                break;
            }
        }
        catch (LimitExceededException limitExceededException) {
            LdapNamingEnumeration ldapNamingEnumeration = new LdapNamingEnumeration(this, ldapResult, name, continuation);
            ldapNamingEnumeration.setNamingException((LimitExceededException)continuation.fillInException(limitExceededException));
            return ldapNamingEnumeration;
        }
        catch (PartialResultException partialResultException) {
            LdapNamingEnumeration ldapNamingEnumeration = new LdapNamingEnumeration(this, ldapResult, name, continuation);
            ldapNamingEnumeration.setNamingException((PartialResultException)continuation.fillInException(partialResultException));
            return ldapNamingEnumeration;
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamingEnumeration c_listBindings(Name name, Continuation continuation) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(null);
        searchControls.setReturningObjFlag(true);
        continuation.setError((Object)this, name);
        LdapResult ldapResult = null;
        try {
            ldapResult = this.doSearch(name, "(objectClass=*)", searchControls, true, true);
            if (ldapResult.status != 0 || ldapResult.referrals != null) {
                this.processReturnCode(ldapResult, name);
            }
            return new LdapBindingEnumeration(this, ldapResult, name, continuation);
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var9_13;
                NamingEnumeration namingEnumeration;
                LdapReferralException ldapReferralException2;
                LdapReferralContext ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    namingEnumeration = ldapReferralContext.listBindings(name);
                    var9_13 = null;
                }
                catch (LdapReferralException ldapReferralException3) {
                    try {
                        ldapReferralException2 = ldapReferralException3;
                        var9_13 = null;
                    }
                    catch (Throwable throwable) {
                        var9_13 = null;
                        ldapReferralContext.close();
                        throw throwable;
                    }
                    ldapReferralContext.close();
                    {
                        continue;
                    }
                }
                ldapReferralContext.close();
                return namingEnumeration;
                break;
            }
        }
        catch (LimitExceededException limitExceededException) {
            LdapBindingEnumeration ldapBindingEnumeration = new LdapBindingEnumeration(this, ldapResult, name, continuation);
            ldapBindingEnumeration.setNamingException((LimitExceededException)continuation.fillInException(limitExceededException));
            return ldapBindingEnumeration;
        }
        catch (PartialResultException partialResultException) {
            LdapBindingEnumeration ldapBindingEnumeration = new LdapBindingEnumeration(this, ldapResult, name, continuation);
            ldapBindingEnumeration.setNamingException((PartialResultException)continuation.fillInException(partialResultException));
            return ldapBindingEnumeration;
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected NameParser c_getNameParser(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return parser;
    }

    public String getNameInNamespace() {
        return this.currentDN;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        if (name instanceof LdapName && name2 instanceof LdapName) {
            Name name3 = (Name)name2.clone();
            name3.addAll(name);
            return new CompositeName().add(name3.toString());
        }
        if (!(name instanceof CompositeName)) {
            name = new CompositeName().add(name.toString());
        }
        if (!(name2 instanceof CompositeName)) {
            name2 = new CompositeName().add(name2.toString());
        }
        int n = name2.size() - 1;
        if (name.isEmpty() || name2.isEmpty() || name.get(0).equals("") || name2.get(n).equals("")) {
            return super.composeName(name, name2);
        }
        Name name4 = (Name)name2.clone();
        name4.addAll(name);
        if (this.parentIsLdapCtx) {
            String string = LdapCtx.concatNames(name4.get(n + 1), name4.get(n));
            name4.remove(n + 1);
            name4.remove(n);
            name4.add(n, string);
        }
        return name4;
    }

    private String fullyQualifiedName(Name name) {
        return name.isEmpty() ? this.currentDN : this.fullyQualifiedName(name.get(0));
    }

    private String fullyQualifiedName(String string) {
        return LdapCtx.concatNames(string, this.currentDN);
    }

    private static String concatNames(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        if (string2 == null || string2.equals("")) {
            return string;
        }
        return string + "," + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        searchControls.setReturningAttributes(stringArray);
        try {
            LdapResult ldapResult = this.doSearchOnce(name, "(objectClass=*)", searchControls, true);
            this.respCtls = ldapResult.resControls;
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, name);
            }
            if (ldapResult.entries == null || ldapResult.entries.size() != 1) {
                return new BasicAttributes(true);
            }
            LdapEntry ldapEntry = (LdapEntry)ldapResult.entries.elementAt(0);
            Vector vector = ldapEntry.respCtls;
            if (vector != null) {
                LdapCtx.appendVector(this.respCtls, vector);
            }
            this.setParents(ldapEntry.attributes, (Name)name.clone());
            return ldapEntry.attributes;
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var9_14;
                Attributes attributes;
                LdapReferralException ldapReferralException2;
                LdapReferralContext ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    attributes = ldapReferralContext.getAttributes(name, stringArray);
                    var9_14 = null;
                }
                catch (LdapReferralException ldapReferralException3) {
                    try {
                        ldapReferralException2 = ldapReferralException3;
                        var9_14 = null;
                    }
                    catch (Throwable throwable) {
                        var9_14 = null;
                        ldapReferralContext.close();
                        throw throwable;
                    }
                    ldapReferralContext.close();
                    {
                        continue;
                    }
                }
                ldapReferralContext.close();
                return attributes;
                break;
            }
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_modifyAttributes(Name name, int n, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            if (attributes == null) return;
            if (attributes.size() == 0) {
                return;
            }
            String string = this.fullyQualifiedName(name);
            int n2 = LdapCtx.convertToLdapModCode(n);
            int[] nArray = new int[attributes.size()];
            Attribute[] attributeArray = new Attribute[attributes.size()];
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            int n3 = 0;
            while (true) {
                if (n3 >= nArray.length || !namingEnumeration.hasMore()) {
                    LdapResult ldapResult = this.clnt.modify(string, nArray, attributeArray, this.reqCtls);
                    this.respCtls = ldapResult.resControls;
                    if (ldapResult.status == 0) return;
                    this.processReturnCode(ldapResult, name);
                    return;
                }
                nArray[n3] = n2;
                attributeArray[n3] = namingEnumeration.next();
                ++n3;
            }
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var13_19;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    try {
                        ldapReferralContext.modifyAttributes(name, n, attributes);
                        var13_19 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var13_19 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var13_19 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_modifyAttributes(Name name, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            if (modificationItemArray == null) return;
            if (modificationItemArray.length == 0) {
                return;
            }
            String string = this.fullyQualifiedName(name);
            int[] nArray = new int[modificationItemArray.length];
            Attribute[] attributeArray = new Attribute[modificationItemArray.length];
            int n = 0;
            while (true) {
                if (n >= nArray.length) {
                    LdapResult ldapResult = this.clnt.modify(string, nArray, attributeArray, this.reqCtls);
                    this.respCtls = ldapResult.resControls;
                    if (ldapResult.status == 0) return;
                    this.processReturnCode(ldapResult, name);
                    return;
                }
                ModificationItem modificationItem = modificationItemArray[n];
                nArray[n] = LdapCtx.convertToLdapModCode(modificationItem.getModificationOp());
                attributeArray[n] = modificationItem.getAttribute();
                ++n;
            }
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var11_17;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    try {
                        ldapReferralContext.modifyAttributes(name, modificationItemArray);
                        var11_17 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var11_17 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var11_17 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    private static int convertToLdapModCode(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid modification code");
    }

    protected DirContext c_getSchema(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            return this.getSchemaTree(name);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected DirContext c_getSchemaClassDefinition(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            Attribute attribute = this.c_getAttributes(name, new String[]{"objectclass"}, continuation).get("objectclass");
            if (attribute == null || attribute.size() == 0) {
                return EMPTY_SCHEMA;
            }
            Context context = (Context)this.c_getSchema(name, continuation).lookup("ClassDefinition");
            HierMemDirCtx hierMemDirCtx = new HierMemDirCtx();
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                String string = (String)namingEnumeration.nextElement();
                DirContext dirContext = (DirContext)context.lookup(string);
                hierMemDirCtx.bind(string, (Object)dirContext);
            }
            hierMemDirCtx.setReadOnly(new SchemaViolationException("Cannot update schema object"));
            return hierMemDirCtx;
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    private DirContext getSchemaTree(Name name) throws NamingException {
        String string = this.getSchemaEntry(name, true);
        DirContext dirContext = (DirContext)this.schemaTrees.get(string);
        if (dirContext == null) {
            dirContext = this.buildSchemaTree(string);
            this.schemaTrees.put(string, dirContext);
        }
        return dirContext;
    }

    private DirContext buildSchemaTree(String string) throws NamingException {
        SearchControls searchControls = new SearchControls(0, 0L, 0, SCHEMA_ATTRIBUTES, true, false);
        Name name = new CompositeName().add(string);
        NamingEnumeration namingEnumeration = this.searchAux(name, "(objectClass=subschema)", searchControls, false, true, new Continuation());
        if (!namingEnumeration.hasMore()) {
            throw new OperationNotSupportedException("Cannot get read subschemasubentry: " + string);
        }
        SearchResult searchResult = (SearchResult)namingEnumeration.next();
        namingEnumeration.close();
        Object object = searchResult.getObject();
        if (!(object instanceof LdapCtx)) {
            throw new NamingException("Cannot get schema object as DirContext: " + string);
        }
        return LdapSchemaCtx.createSchemaTree(this.envprops, string, (LdapCtx)object, searchResult.getAttributes(), this.netscapeSchemaBug);
    }

    private String getSchemaEntry(Name name, boolean bl) throws NamingException {
        NamingEnumeration namingEnumeration;
        SearchControls searchControls = new SearchControls(0, 0L, 0, new String[]{"subschemasubentry"}, false, false);
        try {
            namingEnumeration = this.searchAux(name, "objectclass=*", searchControls, bl, true, new Continuation());
        }
        catch (NamingException namingException) {
            if (!this.clnt.isLdapv3 && this.currentDN.length() == 0 && name.isEmpty()) {
                throw new OperationNotSupportedException("Cannot get schema information from server");
            }
            throw namingException;
        }
        if (!namingEnumeration.hasMoreElements()) {
            throw new ConfigurationException("Requesting schema of nonexistent entry: " + name);
        }
        SearchResult searchResult = (SearchResult)namingEnumeration.next();
        namingEnumeration.close();
        Attribute attribute = searchResult.getAttributes().get("subschemasubentry");
        if (attribute == null || attribute.size() < 0) {
            if (this.currentDN.length() == 0 && name.isEmpty()) {
                throw new OperationNotSupportedException("Cannot read subschemasubentry of root DSE");
            }
            return this.getSchemaEntry(new CompositeName(), false);
        }
        return (String)attribute.get();
    }

    void setParents(Attributes attributes, Name name) throws NamingException {
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            ((LdapAttribute)namingEnumeration.next()).setParent(this, name);
        }
    }

    String getURL() {
        if (this.url == null) {
            this.url = LdapURL.toUrlString(this.hostname, this.port_number, this.currentDN, this.hasLdapsScheme);
        }
        return this.url;
    }

    protected NamingEnumeration c_search(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        return this.c_search(name, attributes, null, continuation);
    }

    protected NamingEnumeration c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        String string;
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(stringArray);
        try {
            string = SearchFilter.format(attributes);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        return this.c_search(name, string, searchControls, continuation);
    }

    protected NamingEnumeration c_search(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        return this.searchAux(name, string, LdapCtx.cloneSearchControls(searchControls), true, true, continuation);
    }

    protected NamingEnumeration c_search(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        String string2;
        try {
            string2 = SearchFilter.format(string, objectArray);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        return this.c_search(name, string2, searchControls, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamingEnumeration searchAux(Name name, String string, SearchControls searchControls, boolean bl, boolean bl2, Continuation continuation) throws NamingException {
        Object object;
        LdapResult ldapResult = null;
        String[] stringArray = new String[2];
        if (searchControls == null) {
            searchControls = new SearchControls();
        }
        String[] stringArray2 = searchControls.getReturningAttributes();
        if (searchControls.getReturningObjFlag() && stringArray2 != null) {
            boolean bl3 = false;
            int n = stringArray2.length - 1;
            while (n >= 0) {
                if (stringArray2[n].equals("*")) {
                    bl3 = true;
                    break;
                }
                --n;
            }
            if (!bl3) {
                object = new String[stringArray2.length + Obj.JAVA_ATTRIBUTES.length];
                System.arraycopy(stringArray2, 0, object, 0, stringArray2.length);
                System.arraycopy(Obj.JAVA_ATTRIBUTES, 0, object, stringArray2.length, Obj.JAVA_ATTRIBUTES.length);
                searchControls.setReturningAttributes((String[])object);
            }
        }
        SearchArgs searchArgs = new SearchArgs(name, string, searchControls, stringArray2);
        continuation.setError((Object)this, name);
        try {
            if (LdapCtx.searchToCompare(string, searchControls, stringArray)) {
                ldapResult = this.compare(name, stringArray[0], stringArray[1]);
                if (!ldapResult.compareToSearchResult(this.fullyQualifiedName(name))) {
                    this.processReturnCode(ldapResult, name);
                }
            } else {
                ldapResult = this.doSearch(name, string, searchControls, bl, bl2);
                this.processReturnCode(ldapResult, name);
            }
            return new LdapSearchEnumeration(this, ldapResult, this.fullyQualifiedName(name), searchArgs, continuation);
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var15_21;
                NamingEnumeration namingEnumeration;
                LdapReferralException ldapReferralException2;
                object = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    namingEnumeration = ((LdapReferralContext)object).search(name, string, searchControls);
                    var15_21 = null;
                }
                catch (LdapReferralException ldapReferralException3) {
                    try {
                        ldapReferralException2 = ldapReferralException3;
                        var15_21 = null;
                    }
                    catch (Throwable throwable) {
                        var15_21 = null;
                        ((LdapReferralContext)object).close();
                        throw throwable;
                    }
                    ((LdapReferralContext)object).close();
                    {
                        continue;
                    }
                }
                ((LdapReferralContext)object).close();
                return namingEnumeration;
                break;
            }
        }
        catch (LimitExceededException limitExceededException) {
            LdapSearchEnumeration ldapSearchEnumeration = new LdapSearchEnumeration(this, ldapResult, this.fullyQualifiedName(name), searchArgs, continuation);
            ldapSearchEnumeration.setNamingException(limitExceededException);
            return ldapSearchEnumeration;
        }
        catch (PartialResultException partialResultException) {
            LdapSearchEnumeration ldapSearchEnumeration = new LdapSearchEnumeration(this, ldapResult, this.fullyQualifiedName(name), searchArgs, continuation);
            ldapSearchEnumeration.setNamingException(partialResultException);
            return ldapSearchEnumeration;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    LdapResult getSearchReply(LdapClient ldapClient, LdapResult ldapResult) throws NamingException {
        if (this.clnt != ldapClient) {
            throw new CommunicationException("Context's connection changed; unable to continue enumeration");
        }
        try {
            return ldapClient.getSearchReply(this.batchSize, ldapResult, this.binaryAttrs);
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
    }

    private LdapResult doSearchOnce(Name name, String string, SearchControls searchControls, boolean bl) throws NamingException {
        int n = this.batchSize;
        this.batchSize = 2;
        LdapResult ldapResult = this.doSearch(name, string, searchControls, bl, true);
        this.batchSize = n;
        return ldapResult;
    }

    private LdapResult doSearch(Name name, String string, SearchControls searchControls, boolean bl, boolean bl2) throws NamingException {
        this.ensureOpen();
        try {
            int n;
            switch (searchControls.getSearchScope()) {
                case 0: {
                    n = 0;
                    break;
                }
                default: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                }
            }
            String[] stringArray = searchControls.getReturningAttributes();
            if (stringArray != null && stringArray.length == 0) {
                stringArray = new String[]{"1.1"};
            }
            String string2 = bl ? this.fullyQualifiedName(name) : (name.isEmpty() ? "" : name.get(0));
            int n2 = searchControls.getTimeLimit();
            int n3 = 0;
            if (n2 > 0) {
                n3 = n2 / 1000 + 1;
            }
            LdapResult ldapResult = this.clnt.search(string2, n, this.derefAliases, (int)searchControls.getCountLimit(), n3, searchControls.getReturningObjFlag() ? false : this.typesOnly, stringArray, string, this.batchSize, this.reqCtls, this.binaryAttrs, bl2);
            this.respCtls = ldapResult.resControls;
            return ldapResult;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
    }

    private static boolean searchToCompare(String string, SearchControls searchControls, String[] stringArray) {
        if (searchControls.getSearchScope() != 0) {
            return false;
        }
        String[] stringArray2 = searchControls.getReturningAttributes();
        if (stringArray2 == null || stringArray2.length != 0) {
            return false;
        }
        return LdapCtx.filterToAssertion(string, stringArray);
    }

    private static boolean filterToAssertion(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        stringArray[0] = stringTokenizer.nextToken();
        stringArray[1] = stringTokenizer.nextToken();
        if (stringArray[1].indexOf(42) != -1) {
            return false;
        }
        boolean bl = false;
        int n = stringArray[1].length();
        if (stringArray[0].charAt(0) == '(' && stringArray[1].charAt(n - 1) == ')') {
            bl = true;
        } else if (stringArray[0].charAt(0) == '(' || stringArray[1].charAt(n - 1) == ')') {
            return false;
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[0], "()&|!=~><*", true);
        if (stringTokenizer2.countTokens() != (bl ? 2 : 1)) {
            return false;
        }
        stringTokenizer2 = new StringTokenizer(stringArray[1], "()&|!=~><*", true);
        if (stringTokenizer2.countTokens() != (bl ? 2 : 1)) {
            return false;
        }
        if (bl) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1].substring(0, n - 1);
        }
        return true;
    }

    private LdapResult compare(Name name, String string, String string2) throws IOException, NamingException {
        this.ensureOpen();
        String string3 = this.fullyQualifiedName(name);
        LdapResult ldapResult = this.clnt.compare(string3, string, string2, this.reqCtls);
        this.respCtls = ldapResult.resControls;
        return ldapResult;
    }

    private static SearchControls cloneSearchControls(SearchControls searchControls) {
        if (searchControls == null) {
            return null;
        }
        String[] stringArray = searchControls.getReturningAttributes();
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return new SearchControls(searchControls.getSearchScope(), searchControls.getCountLimit(), searchControls.getTimeLimit(), stringArray, searchControls.getReturningObjFlag(), searchControls.getDerefLinkFlag());
    }

    protected Hashtable p_getEnvironment() {
        return this.envprops;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.envprops == null ? new Hashtable(5, 0.75f) : (Hashtable)this.envprops.clone();
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.envprops == null || this.envprops.get(string) == null) {
            return null;
        }
        if (string.equals(REF_SEPARATOR)) {
            this.addrEncodingSeparator = (char)35;
        } else if (string.equals(TYPES_ONLY)) {
            this.typesOnly = false;
        } else if (string.equals(DELETE_RDN)) {
            this.deleteRDN = true;
        } else if (string.equals(DEREF_ALIASES)) {
            this.derefAliases = 3;
        } else if (string.equals("java.naming.batchsize")) {
            this.batchSize = 1;
        } else if (string.equals(REFERRAL_LIMIT)) {
            this.referralHopLimit = 10;
        } else if (string.equals("java.naming.referral")) {
            this.setReferralMode(null, true);
        } else if (string.equals(BINARY_ATTRIBUTES)) {
            this.setBinaryAttributes(null);
        } else if (string.equals(CONNECT_TIMEOUT)) {
            this.connectTimeout = -1;
        } else if (string.equals("java.naming.security.protocol")) {
            this.closeConnection(false);
            if (this.useSsl && !this.hasLdapsScheme) {
                this.useSsl = false;
                this.url = null;
                if (this.useDefaultPortNumber) {
                    this.port_number = 389;
                }
            }
        } else if (string.equals(VERSION) || string.equals(SOCKET_FACTORY)) {
            this.closeConnection(false);
        } else if (string.equals("java.naming.security.authentication") || string.equals("java.naming.security.principal") || string.equals("java.naming.security.credentials")) {
            this.sharable = false;
        }
        this.envprops = (Hashtable)this.envprops.clone();
        return this.envprops.remove(string);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (object == null) {
            return this.removeFromEnvironment(string);
        }
        if (string.equals(REF_SEPARATOR)) {
            this.setRefSeparator((String)object);
        } else if (string.equals(TYPES_ONLY)) {
            this.setTypesOnly((String)object);
        } else if (string.equals(DELETE_RDN)) {
            this.setDeleteRDN((String)object);
        } else if (string.equals(DEREF_ALIASES)) {
            this.setDerefAliases((String)object);
        } else if (string.equals("java.naming.batchsize")) {
            this.setBatchSize((String)object);
        } else if (string.equals(REFERRAL_LIMIT)) {
            this.setReferralLimit((String)object);
        } else if (string.equals("java.naming.referral")) {
            this.setReferralMode((String)object, true);
        } else if (string.equals(BINARY_ATTRIBUTES)) {
            this.setBinaryAttributes((String)object);
        } else if (string.equals(CONNECT_TIMEOUT)) {
            this.setConnectTimeout((String)object);
        } else if (string.equals("java.naming.security.protocol")) {
            this.closeConnection(false);
            if ("ssl".equals(object)) {
                this.useSsl = true;
                this.url = null;
                if (this.useDefaultPortNumber) {
                    this.port_number = 636;
                }
            }
        } else if (string.equals(VERSION) || string.equals(SOCKET_FACTORY)) {
            this.closeConnection(false);
        } else if (string.equals("java.naming.security.authentication") || string.equals("java.naming.security.principal") || string.equals("java.naming.security.credentials")) {
            this.sharable = false;
        }
        this.envprops = this.envprops == null ? new Hashtable(5, 0.75f) : (Hashtable)this.envprops.clone();
        return this.envprops.put(string, object);
    }

    void setProviderUrl(String string) {
        if (this.envprops != null) {
            this.envprops.put("java.naming.provider.url", string);
        }
    }

    void setDomainName(String string) {
        if (this.envprops != null) {
            this.envprops.put(DOMAIN_NAME, string);
        }
    }

    private void initEnv() throws NamingException {
        if (this.envprops == null) {
            this.setReferralMode(null, false);
            return;
        }
        this.setBatchSize((String)this.envprops.get("java.naming.batchsize"));
        this.setRefSeparator((String)this.envprops.get(REF_SEPARATOR));
        this.setDeleteRDN((String)this.envprops.get(DELETE_RDN));
        this.setTypesOnly((String)this.envprops.get(TYPES_ONLY));
        this.setDerefAliases((String)this.envprops.get(DEREF_ALIASES));
        this.setReferralLimit((String)this.envprops.get(REFERRAL_LIMIT));
        this.setBinaryAttributes((String)this.envprops.get(BINARY_ATTRIBUTES));
        this.bindCtls = LdapCtx.cloneControls((Control[])this.envprops.get(BIND_CONTROLS));
        this.setReferralMode((String)this.envprops.get("java.naming.referral"), false);
        this.setConnectTimeout((String)this.envprops.get(CONNECT_TIMEOUT));
    }

    private void setDeleteRDN(String string) {
        this.deleteRDN = string == null || !string.equalsIgnoreCase("false");
    }

    private void setTypesOnly(String string) {
        this.typesOnly = string != null && string.equalsIgnoreCase("true");
    }

    private void setBatchSize(String string) {
        this.batchSize = string != null ? Integer.parseInt(string) : 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setReferralMode(String string, boolean bl) {
        if (string != null) {
            if (string.equals("follow")) {
                this.handleReferrals = 1;
            } else if (string.equals("throw")) {
                this.handleReferrals = 2;
            } else {
                if (!string.equals("ignore")) throw new IllegalArgumentException("Illegal value for java.naming.referral property.");
                this.handleReferrals = 3;
            }
        } else {
            this.handleReferrals = 3;
        }
        if (this.handleReferrals == 3) {
            this.reqCtls = LdapCtx.addControl(this.reqCtls, manageReferralControl);
            return;
        } else {
            if (!bl) return;
            this.reqCtls = LdapCtx.removeControl(this.reqCtls, manageReferralControl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDerefAliases(String string) {
        if (string != null) {
            if (string.equals("never")) {
                this.derefAliases = 0;
                return;
            } else if (string.equals("searching")) {
                this.derefAliases = 1;
                return;
            } else if (string.equals("finding")) {
                this.derefAliases = 2;
                return;
            } else {
                if (!string.equals("always")) throw new IllegalArgumentException("Illegal value for java.naming.ldap.derefAliases property.");
                this.derefAliases = 3;
            }
            return;
        } else {
            this.derefAliases = 3;
        }
    }

    private void setRefSeparator(String string) throws NamingException {
        this.addrEncodingSeparator = string != null && string.length() > 0 ? string.charAt(0) : (char)35;
    }

    private void setReferralLimit(String string) {
        if (string != null) {
            this.referralHopLimit = Integer.parseInt(string);
            if (this.referralHopLimit == 0) {
                this.referralHopLimit = Integer.MAX_VALUE;
            }
        } else {
            this.referralHopLimit = 10;
        }
    }

    void setHopCount(int n) {
        this.hopCount = n;
    }

    private void setConnectTimeout(String string) {
        this.connectTimeout = string != null ? Integer.parseInt(string) : -1;
    }

    private static Vector extractURLs(String string) {
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(10, n)) >= 0) {
            ++n;
            ++n2;
        }
        Vector<String> vector = new Vector<String>(n2);
        boolean bl = false;
        n = string.indexOf(10);
        int n3 = n + 1;
        while ((n = string.indexOf(10, n3)) >= 0) {
            vector.addElement(string.substring(n3, n));
            n3 = n + 1;
        }
        vector.addElement(string.substring(n3));
        return vector;
    }

    private void setBinaryAttributes(String string) {
        if (string == null) {
            this.binaryAttrs = null;
        } else {
            this.binaryAttrs = new Hashtable(11, 0.75f);
            StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.binaryAttrs.put(stringTokenizer.nextToken(), Boolean.TRUE);
            }
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {}
    }

    public synchronized void close() throws NamingException {
        if (this.eventSupport != null) {
            this.eventSupport.cleanup();
            this.removeUnsolicited();
        }
        if (this.enumCount > 0) {
            this.closeRequested = true;
            return;
        }
        this.closeConnection(false);
    }

    public void reconnect(Control[] controlArray) throws NamingException {
        Hashtable hashtable = this.envprops = this.envprops == null ? new Hashtable(5, 0.75f) : (Hashtable)this.envprops.clone();
        if (controlArray == null) {
            this.envprops.remove(BIND_CONTROLS);
            this.bindCtls = null;
        } else {
            this.bindCtls = LdapCtx.cloneControls(controlArray);
            this.envprops.put(BIND_CONTROLS, this.bindCtls);
        }
        this.sharable = false;
        this.ensureOpen();
    }

    private void ensureOpen() throws NamingException {
        this.ensureOpen(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpen(boolean bl) throws NamingException {
        try {
            if (this.clnt == null) {
                this.schemaTrees = new Hashtable(11, 0.75f);
                this.connect(bl);
            } else if (!this.sharable || bl) {
                LdapClient ldapClient = this.clnt;
                synchronized (ldapClient) {
                    if (!this.clnt.isLdapv3 || this.clnt.referenceCount > 1 || this.clnt.usingSaslStreams()) {
                        this.closeConnection(false);
                    }
                }
                this.schemaTrees = new Hashtable(11, 0.75f);
                this.connect(bl);
            }
            Object var5_4 = null;
            this.sharable = true;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.sharable = true;
            throw throwable;
        }
    }

    private void connect(boolean bl) throws NamingException {
        String string = null;
        Object var3_3 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        if (this.envprops != null) {
            string = (String)this.envprops.get("java.naming.security.principal");
            var3_3 = this.envprops.get("java.naming.security.credentials");
            string5 = (String)this.envprops.get(VERSION);
            string2 = this.useSsl ? "ssl" : (String)this.envprops.get("java.naming.security.protocol");
            string3 = (String)this.envprops.get(SOCKET_FACTORY);
            string4 = (String)this.envprops.get("java.naming.security.authentication");
            bl2 = "true".equalsIgnoreCase((String)this.envprops.get(ENABLE_POOL));
        }
        if (string3 == null) {
            String string6 = string3 = "ssl".equals(string2) ? DEFAULT_SSL_FACTORY : null;
        }
        if (string4 == null) {
            string4 = string == null ? "none" : "simple";
        }
        try {
            int n;
            boolean bl3;
            boolean bl4 = bl3 = this.clnt == null;
            if (bl3) {
                n = string5 != null ? Integer.parseInt(string5) : 32;
                this.clnt = LdapClient.getInstance(bl2, this.hostname, this.port_number, string3, this.connectTimeout, this.trace, n, string4, this.bindCtls, string2, string, var3_3, this.envprops);
                if (this.clnt.authenticateCalled()) {
                    return;
                }
            } else {
                if (this.sharable && bl) {
                    return;
                }
                n = 3;
            }
            LdapResult ldapResult = this.clnt.authenticate(bl3, string, var3_3, n, string4, this.bindCtls, this.envprops);
            this.respCtls = ldapResult.resControls;
            if (ldapResult.status != 0) {
                if (bl3) {
                    this.closeConnection(true);
                }
                this.processReturnCode(ldapResult);
            }
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw ldapReferralException;
            }
            Throwable throwable = null;
            while (true) {
                String string7;
                if ((string7 = ldapReferralException.getNextReferral()) == null) {
                    if (throwable != null) {
                        throw (NamingException)throwable.fillInStackTrace();
                    }
                    throw new NamingException("Internal error processing referral during connection");
                }
                LdapURL ldapURL = new LdapURL(string7);
                this.hostname = ldapURL.getHost();
                if (this.hostname != null && this.hostname.charAt(0) == '[') {
                    this.hostname = this.hostname.substring(1, this.hostname.length() - 1);
                }
                this.port_number = ldapURL.getPort();
                try {
                    this.connect(bl);
                }
                catch (NamingException namingException) {
                    throwable = namingException;
                    continue;
                }
                break;
            }
        }
    }

    private void closeConnection(boolean bl) {
        this.removeUnsolicited();
        if (this.clnt != null) {
            this.clnt.close(this.reqCtls, bl);
            this.clnt = null;
        }
    }

    synchronized void incEnumCount() {
        ++this.enumCount;
    }

    synchronized void decEnumCount() {
        block2: {
            --this.enumCount;
            if (this.enumCount != 0 || !this.closeRequested) break block2;
            try {
                this.close();
            }
            catch (NamingException namingException) {}
        }
    }

    protected void processReturnCode(LdapResult ldapResult) throws NamingException {
        this.processReturnCode(ldapResult, null, this, null, this.envprops, null);
    }

    void processReturnCode(LdapResult ldapResult, Name name) throws NamingException {
        this.processReturnCode(ldapResult, new CompositeName().add(this.currentDN), this, name, this.envprops, this.fullyQualifiedName(name));
    }

    protected void processReturnCode(LdapResult ldapResult, Name name, Object object, Name name2, Hashtable hashtable, String string) throws NamingException {
        NamingException namingException;
        String string2 = LdapClient.getErrorMessage(ldapResult.status, ldapResult.errorMessage);
        LdapReferralException ldapReferralException = null;
        switch (ldapResult.status) {
            case 0: {
                if (ldapResult.referrals != null) {
                    string2 = "Unprocessed Continuation Reference(s)";
                    if (this.handleReferrals == 3) {
                        namingException = new PartialResultException(string2);
                        break;
                    }
                    int n = ldapResult.referrals.size();
                    LdapReferralException ldapReferralException2 = null;
                    LdapReferralException ldapReferralException3 = null;
                    string2 = "Continuation Reference";
                    int n2 = 0;
                    while (n2 < n) {
                        ldapReferralException = new LdapReferralException(name, object, name2, string2, hashtable, string, this.handleReferrals, this.reqCtls);
                        ldapReferralException.setReferralInfo((Vector)ldapResult.referrals.elementAt(n2), true);
                        if (this.hopCount > 1) {
                            ldapReferralException.setHopCount(this.hopCount);
                        }
                        if (ldapReferralException2 == null) {
                            ldapReferralException2 = ldapReferralException3 = ldapReferralException;
                        } else {
                            ldapReferralException3.nextReferralEx = ldapReferralException;
                            ldapReferralException3 = ldapReferralException;
                        }
                        ++n2;
                    }
                    ldapResult.referrals = null;
                    if (ldapResult.refEx == null) {
                        ldapResult.refEx = ldapReferralException2;
                    } else {
                        ldapReferralException3 = ldapResult.refEx;
                        while (ldapReferralException3.nextReferralEx != null) {
                            ldapReferralException3 = ldapReferralException3.nextReferralEx;
                        }
                        ldapReferralException3.nextReferralEx = ldapReferralException2;
                    }
                    if (this.hopCount > this.referralHopLimit) {
                        LimitExceededException limitExceededException = new LimitExceededException("Referral limit exceeded");
                        limitExceededException.setRootCause(ldapReferralException);
                        throw limitExceededException;
                    }
                }
                return;
            }
            case 10: {
                if (this.handleReferrals == 3) {
                    namingException = new PartialResultException(string2);
                    break;
                }
                ldapReferralException = new LdapReferralException(name, object, name2, string2, hashtable, string, this.handleReferrals, this.reqCtls);
                ldapReferralException.setReferralInfo((Vector)ldapResult.referrals.elementAt(0), false);
                if (this.hopCount > 1) {
                    ldapReferralException.setHopCount(this.hopCount);
                }
                if (this.hopCount > this.referralHopLimit) {
                    LimitExceededException limitExceededException = new LimitExceededException("Referral limit exceeded");
                    limitExceededException.setRootCause(ldapReferralException);
                    namingException = limitExceededException;
                    break;
                }
                namingException = ldapReferralException;
                break;
            }
            case 9: {
                if (this.handleReferrals == 3) {
                    namingException = new PartialResultException(string2);
                    break;
                }
                if (ldapResult.errorMessage == null || ldapResult.errorMessage == "") {
                    namingException = new PartialResultException(string2);
                    break;
                }
                ldapResult.referrals = LdapCtx.extractURLs(ldapResult.errorMessage);
                ldapReferralException = new LdapReferralException(name, object, name2, string2, hashtable, string, this.handleReferrals, this.reqCtls);
                if (this.hopCount > 1) {
                    ldapReferralException.setHopCount(this.hopCount);
                }
                if ((ldapResult.entries == null || ldapResult.entries.size() == 0) && ldapResult.referrals.size() == 1) {
                    ldapReferralException.setReferralInfo(ldapResult.referrals, false);
                    if (this.hopCount > this.referralHopLimit) {
                        LimitExceededException limitExceededException = new LimitExceededException("Referral limit exceeded");
                        limitExceededException.setRootCause(ldapReferralException);
                        namingException = limitExceededException;
                        break;
                    }
                    namingException = ldapReferralException;
                    break;
                }
                ldapReferralException.setReferralInfo(ldapResult.referrals, true);
                ldapResult.refEx = ldapReferralException;
                return;
            }
            case 34: 
            case 64: {
                if (name2 != null) {
                    namingException = new InvalidNameException(name2.toString() + ": " + string2);
                    break;
                }
                namingException = new InvalidNameException(string2);
                break;
            }
            default: {
                namingException = LdapCtx.mapErrorCode(ldapResult.status, ldapResult.errorMessage);
            }
        }
        namingException.setResolvedName(name);
        namingException.setResolvedObj(object);
        namingException.setRemainingName(name2);
        throw namingException;
    }

    public static NamingException mapErrorCode(int n, String string) {
        if (n == 0) {
            return null;
        }
        NamingException namingException = null;
        String string2 = LdapClient.getErrorMessage(n, string);
        switch (n) {
            case 36: {
                namingException = new NamingException(string2);
                break;
            }
            case 33: {
                namingException = new NamingException(string2);
                break;
            }
            case 20: {
                namingException = new AttributeInUseException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 48: {
                namingException = new AuthenticationNotSupportedException(string2);
                break;
            }
            case 68: {
                namingException = new NameAlreadyBoundException(string2);
                break;
            }
            case 14: 
            case 49: {
                namingException = new AuthenticationException(string2);
                break;
            }
            case 18: {
                namingException = new InvalidSearchFilterException(string2);
                break;
            }
            case 50: {
                namingException = new NoPermissionException(string2);
                break;
            }
            case 19: 
            case 21: {
                namingException = new InvalidAttributeValueException(string2);
                break;
            }
            case 54: {
                namingException = new NamingException(string2);
                break;
            }
            case 16: {
                namingException = new NoSuchAttributeException(string2);
                break;
            }
            case 32: {
                namingException = new NameNotFoundException(string2);
                break;
            }
            case 65: 
            case 67: 
            case 69: {
                namingException = new SchemaViolationException(string2);
                break;
            }
            case 66: {
                namingException = new ContextNotEmptyException(string2);
                break;
            }
            case 1: {
                namingException = new NamingException(string2);
                break;
            }
            case 80: {
                namingException = new NamingException(string2);
                break;
            }
            case 2: {
                namingException = new CommunicationException(string2);
                break;
            }
            case 4: {
                namingException = new SizeLimitExceededException(string2);
                break;
            }
            case 3: {
                namingException = new TimeLimitExceededException(string2);
                break;
            }
            case 12: {
                namingException = new OperationNotSupportedException(string2);
                break;
            }
            case 51: 
            case 52: {
                namingException = new ServiceUnavailableException(string2);
                break;
            }
            case 17: {
                namingException = new InvalidAttributeIdentifierException(string2);
                break;
            }
            case 53: {
                namingException = new OperationNotSupportedException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 35: {
                namingException = new NamingException(string2);
                break;
            }
            case 11: {
                namingException = new LimitExceededException(string2);
                break;
            }
            case 10: {
                namingException = new NamingException(string2);
                break;
            }
            case 9: {
                namingException = new NamingException(string2);
                break;
            }
            case 34: 
            case 64: {
                namingException = new InvalidNameException(string2);
                break;
            }
            default: {
                namingException = new NamingException(string2);
            }
        }
        return namingException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedResponse extendedOperation(ExtendedRequest extendedRequest) throws NamingException {
        boolean bl = extendedRequest.getID().equals(STARTTLS_REQ_OID);
        this.ensureOpen(bl);
        try {
            LdapResult ldapResult = this.clnt.extendedOp(extendedRequest.getID(), extendedRequest.getEncodedValue(), this.reqCtls, bl);
            this.respCtls = ldapResult.resControls;
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, new CompositeName());
            }
            int n = ldapResult.extensionValue == null ? 0 : ldapResult.extensionValue.length;
            ExtendedResponse extendedResponse = extendedRequest.createExtendedResponse(ldapResult.extensionId, ldapResult.extensionValue, 0, n);
            LdapCtx.loadStartTlsImpl();
            if (startTlsImplClass != null && startTlsImplClass.isInstance(extendedResponse)) {
                try {
                    String string = this.envprops != null ? this.envprops.get(DOMAIN_NAME) : null;
                    startTlsInitMethod.invoke((Object)extendedResponse, this.clnt.conn, string);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    ConfigurationException configurationException = new ConfigurationException("Invocation problem with Start TLS response implementation");
                    configurationException.setRootCause(throwable);
                    throw configurationException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    ConfigurationException configurationException = new ConfigurationException("Problem initializing Start TLS response implementation");
                    configurationException.setRootCause(illegalAccessException);
                    throw configurationException;
                }
            }
            return extendedResponse;
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw ldapReferralException;
            }
            while (true) {
                Object var10_19;
                ExtendedResponse extendedResponse;
                LdapReferralException ldapReferralException2;
                LdapReferralContext ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext(this.envprops, this.bindCtls);
                try {
                    extendedResponse = ldapReferralContext.extendedOperation(extendedRequest);
                    var10_19 = null;
                }
                catch (LdapReferralException ldapReferralException3) {
                    try {
                        ldapReferralException2 = ldapReferralException3;
                        var10_19 = null;
                    }
                    catch (Throwable throwable) {
                        var10_19 = null;
                        ldapReferralContext.close();
                        throw throwable;
                    }
                    ldapReferralContext.close();
                    {
                        continue;
                    }
                }
                ldapReferralContext.close();
                return extendedResponse;
                break;
            }
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
    }

    public void setRequestControls(Control[] controlArray) throws NamingException {
        this.reqCtls = this.handleReferrals == 3 ? LdapCtx.addControl(controlArray, manageReferralControl) : LdapCtx.cloneControls(controlArray);
    }

    public Control[] getRequestControls() throws NamingException {
        return LdapCtx.cloneControls(this.reqCtls);
    }

    public Control[] getConnectControls() throws NamingException {
        return LdapCtx.cloneControls(this.bindCtls);
    }

    public Control[] getResponseControls() throws NamingException {
        return this.respCtls != null ? this.convertControls(this.respCtls) : null;
    }

    Control[] convertControls(Vector vector) throws NamingException {
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        Control[] controlArray = new Control[n];
        int n2 = 0;
        while (n2 < n) {
            controlArray[n2] = myResponseControlFactory.getControlInstance((Control)vector.elementAt(n2));
            if (controlArray[n2] == null) {
                controlArray[n2] = ControlFactory.getControlInstance((Control)vector.elementAt(n2), this, this.envprops);
            }
            ++n2;
        }
        return controlArray;
    }

    private static Control[] addControl(Control[] controlArray, Control control) {
        if (controlArray == null) {
            return new Control[]{control};
        }
        int n = LdapCtx.findControl(controlArray, control);
        if (n != -1) {
            return controlArray;
        }
        Control[] controlArray2 = (Control[])ExtendedSystem.newArray((Class)(class$javax$naming$ldap$Control == null ? (class$javax$naming$ldap$Control = LdapCtx.class$("javax.naming.ldap.Control")) : class$javax$naming$ldap$Control), (int)(controlArray.length + 1), (Object)controlArray);
        System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
        controlArray2[controlArray.length] = control;
        return controlArray2;
    }

    private static int findControl(Control[] controlArray, Control control) {
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] == control) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static Control[] removeControl(Control[] controlArray, Control control) {
        if (controlArray == null) {
            return null;
        }
        int n = LdapCtx.findControl(controlArray, control);
        if (n == -1) {
            return controlArray;
        }
        Control[] controlArray2 = (Control[])ExtendedSystem.resizeArray((int)(controlArray.length - 1), (Object)controlArray, (int)0, (int)n);
        System.arraycopy(controlArray, n + 1, controlArray2, n, controlArray.length - n - 1);
        return controlArray2;
    }

    private static Control[] cloneControls(Control[] controlArray) {
        if (controlArray == null) {
            return null;
        }
        Control[] controlArray2 = new Control[controlArray.length];
        System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
        return controlArray2;
    }

    public void addNamingListener(Name name, int n, NamingListener namingListener) throws NamingException {
        this.addNamingListener(LdapCtx.getTargetName(name), n, namingListener);
    }

    public void addNamingListener(String string, int n, NamingListener namingListener) throws NamingException {
        if (this.eventSupport == null) {
            this.eventSupport = new EventSupport(this);
        }
        this.eventSupport.addNamingListener(LdapCtx.getTargetName(new CompositeName(string)), n, namingListener);
        if (namingListener instanceof UnsolicitedNotificationListener && !this.unsolicited) {
            this.addUnsolicited();
        }
    }

    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        if (this.eventSupport == null) {
            return;
        }
        this.eventSupport.removeNamingListener(namingListener);
        if (namingListener instanceof UnsolicitedNotificationListener && !this.eventSupport.hasUnsolicited()) {
            this.removeUnsolicited();
        }
    }

    public void addNamingListener(String string, String string2, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        if (this.eventSupport == null) {
            this.eventSupport = new EventSupport(this);
        }
        this.eventSupport.addNamingListener(LdapCtx.getTargetName(new CompositeName(string)), string2, LdapCtx.cloneSearchControls(searchControls), namingListener);
        if (namingListener instanceof UnsolicitedNotificationListener && !this.unsolicited) {
            this.addUnsolicited();
        }
    }

    public void addNamingListener(Name name, String string, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener(LdapCtx.getTargetName(name), string, searchControls, namingListener);
    }

    public void addNamingListener(Name name, String string, Object[] objectArray, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener(LdapCtx.getTargetName(name), string, objectArray, searchControls, namingListener);
    }

    public void addNamingListener(String string, String string2, Object[] objectArray, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        String string3 = SearchFilter.format(string2, objectArray);
        this.addNamingListener(LdapCtx.getTargetName(new CompositeName(string)), string3, searchControls, namingListener);
    }

    public boolean targetMustExist() {
        return true;
    }

    private static String getTargetName(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException("Target cannot span multiple namespaces: " + name);
            }
            if (name.size() == 0) {
                return "";
            }
            return name.get(0);
        }
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnsolicited() throws NamingException {
        this.ensureOpen();
        EventSupport eventSupport = this.eventSupport;
        synchronized (eventSupport) {
            this.clnt.addUnsolicited(this);
            this.unsolicited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnsolicited() {
        if (this.eventSupport == null) {
            return;
        }
        EventSupport eventSupport = this.eventSupport;
        synchronized (eventSupport) {
            if (this.unsolicited && this.clnt != null) {
                this.clnt.removeUnsolicited(this);
            }
            this.unsolicited = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireUnsolicited(Object object) {
        EventSupport eventSupport = this.eventSupport;
        synchronized (eventSupport) {
            if (this.unsolicited) {
                this.eventSupport.fireUnsolicited(object);
                if (object instanceof NamingException) {
                    this.unsolicited = false;
                }
            }
        }
    }

    private static synchronized void loadStartTlsImpl() {
        block2: {
            if (startTlsImplClass != null) break block2;
            try {
                startTlsImplClass = Obj.helper.loadClass("com.sun.jndi.ldap.ext.StartTlsResponseImpl");
                startTlsInitMethod = startTlsImplClass.getMethod("setConnection", class$com$sun$jndi$ldap$Connection == null ? (class$com$sun$jndi$ldap$Connection = LdapCtx.class$("com.sun.jndi.ldap.Connection")) : class$com$sun$jndi$ldap$Connection, class$java$lang$String == null ? (class$java$lang$String = LdapCtx.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Exception exception) {
                startTlsImplClass = null;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        EMPTY_SCHEMA.setReadOnly(new SchemaViolationException("Cannot update schema object"));
    }

    static final class SearchArgs {
        Name name;
        String filter;
        SearchControls cons;
        String[] reqAttrs;

        SearchArgs(Name name, String string, SearchControls searchControls, String[] stringArray) {
            this.name = name;
            this.filter = string;
            this.cons = searchControls;
            this.reqAttrs = stringArray;
        }
    }
}

