/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.pool.Connections;
import com.sun.jndi.ldap.pool.ConnectionsRef;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.pool.PooledConnectionFactory;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.naming.NamingException;

public final class Pool {
    static final boolean debug = LdapPoolManager.debug;
    private final int maxSize;
    private final int prefSize;
    private final int initSize;
    private final Map map = new WeakHashMap();

    public Pool(int n, int n2, int n3) {
        this.prefSize = n2;
        this.maxSize = n3;
        this.initSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection(Object object, long l, PooledConnectionFactory pooledConnectionFactory) throws NamingException {
        Connections connections;
        this.d("get(): ", object);
        this.d("size: ", this.map.size());
        Map map = this.map;
        synchronized (map) {
            connections = this.getConnections(object);
            if (connections == null) {
                this.d("get(): creating new connections list for ", object);
                connections = new Connections(object, this.initSize, this.prefSize, this.maxSize, pooledConnectionFactory);
                this.map.put(object, new ConnectionsRef(connections));
            }
        }
        this.d("get(): size after: ", this.map.size());
        return connections.get(l, pooledConnectionFactory);
    }

    private Connections getConnections(Object object) {
        ConnectionsRef connectionsRef = (ConnectionsRef)this.map.get(object);
        return connectionsRef != null ? connectionsRef.getConnections() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(long l) {
        Map map = this.map;
        synchronized (map) {
            Collection collection = this.map.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Connections connections = ((ConnectionsRef)iterator.next()).getConnections();
                if (!connections.expire(l)) continue;
                this.d("expire(): removing ", connections);
                iterator.remove();
            }
        }
    }

    public void showStats(PrintStream printStream) {
        printStream.println("===== Pool start ======================");
        printStream.println("maximum pool size: " + this.maxSize);
        printStream.println("preferred pool size: " + this.prefSize);
        printStream.println("initial pool size: " + this.initSize);
        printStream.println("current pool size: " + this.map.size());
        Set set = this.map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Connections connections = ((ConnectionsRef)entry.getValue()).getConnections();
            printStream.println("   " + k + ":" + connections.getStats());
        }
        printStream.println("====== Pool end =====================");
    }

    public String toString() {
        return super.toString() + this.map.toString();
    }

    private void d(String string, int n) {
        if (debug) {
            System.err.println(this + "." + string + n);
        }
    }

    private void d(String string, Object object) {
        if (debug) {
            System.err.println(this + "." + string + object);
        }
    }
}

