/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.dns;

import com.sun.jndi.url.dns.dnsURLContext;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

public class dnsURLContextFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        if (object == null) {
            return new dnsURLContext(hashtable);
        }
        if (object instanceof String) {
            return dnsURLContextFactory.getUsingURL((String)object, hashtable);
        }
        if (object instanceof String[]) {
            return dnsURLContextFactory.getUsingURLs((String[])object, hashtable);
        }
        throw new ConfigurationException("dnsURLContextFactory.getObjectInstance: argument must be a DNS URL String or an array of them");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getUsingURL(String string, Hashtable hashtable) throws NamingException {
        Object object;
        dnsURLContext dnsURLContext2 = new dnsURLContext(hashtable);
        try {
            object = dnsURLContext2.lookup(string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dnsURLContext2.close();
            throw throwable;
        }
        dnsURLContext2.close();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getUsingURLs(String[] stringArray, Hashtable hashtable) throws NamingException {
        if (stringArray.length == 0) {
            throw new ConfigurationException("dnsURLContextFactory: empty URL array");
        }
        dnsURLContext dnsURLContext2 = new dnsURLContext(hashtable);
        try {
            NamingException namingException = null;
            int n = 0;
            while (true) {
                Object object;
                if (n >= stringArray.length) {
                    throw namingException;
                }
                try {
                    object = dnsURLContext2.lookup(stringArray[n]);
                }
                catch (NamingException namingException2) {
                    namingException = namingException2;
                    ++n;
                    continue;
                }
                Object var7_7 = null;
                dnsURLContext2.close();
                return object;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            dnsURLContext2.close();
            throw throwable;
        }
    }
}

