/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    private Naming() {
    }

    public static Remote lookup(String string) throws NotBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        if (parsedNamingURL.name == null) {
            return registry;
        }
        return registry.lookup(parsedNamingURL.name);
    }

    public static void bind(String string, Remote remote) throws AlreadyBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        if (remote == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.bind(parsedNamingURL.name, remote);
    }

    public static void unbind(String string) throws RemoteException, NotBoundException, MalformedURLException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        registry.unbind(parsedNamingURL.name);
    }

    public static void rebind(String string, Remote remote) throws RemoteException, MalformedURLException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        if (remote == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.rebind(parsedNamingURL.name, remote);
    }

    public static String[] list(String string) throws RemoteException, MalformedURLException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        String string2 = "";
        if (parsedNamingURL.port > 0 || !parsedNamingURL.host.equals("")) {
            string2 = string2 + "//" + parsedNamingURL.host;
        }
        if (parsedNamingURL.port > 0) {
            string2 = string2 + ":" + parsedNamingURL.port;
        }
        string2 = string2 + "/";
        String[] stringArray = registry.list();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = string2 + stringArray[n];
            ++n;
        }
        return stringArray;
    }

    private static Registry getRegistry(ParsedNamingURL parsedNamingURL) throws RemoteException {
        return LocateRegistry.getRegistry(parsedNamingURL.host, parsedNamingURL.port);
    }

    private static ParsedNamingURL parseURL(String string) throws MalformedURLException {
        try {
            int n;
            String string2;
            URI uRI = new URI(string);
            if (uRI.getFragment() != null) {
                throw new MalformedURLException("invalid character, '#', in URL name: " + string);
            }
            if (uRI.getQuery() != null) {
                throw new MalformedURLException("invalid character, '?', in URL name: " + string);
            }
            if (uRI.getUserInfo() != null) {
                throw new MalformedURLException("invalid character, '@', in URL host: " + string);
            }
            String string3 = uRI.getScheme();
            if (string3 != null && !string3.equals("rmi")) {
                throw new MalformedURLException("invalid URL scheme: " + string);
            }
            String string4 = uRI.getPath();
            if (string4 != null) {
                if (string4.startsWith("/")) {
                    string4 = string4.substring(1);
                }
                if (string4.length() == 0) {
                    string4 = null;
                }
            }
            if ((string2 = uRI.getHost()) == null) {
                String string5;
                string2 = "";
                if (uRI.getPort() == -1 && (string5 = uRI.getAuthority()) != null && string5.startsWith(":")) {
                    string5 = "localhost" + string5;
                    uRI = new URI(null, string5, null, null, null);
                }
            }
            if ((n = uRI.getPort()) == -1) {
                n = 1099;
            }
            return new ParsedNamingURL(string2, n, string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (MalformedURLException)new MalformedURLException("invalid URL string: " + string).initCause(uRISyntaxException);
        }
    }

    private static class ParsedNamingURL {
        String host;
        int port;
        String name;

        ParsedNamingURL(String string, int n, String string2) {
            this.host = string;
            this.port = n;
            this.name = string2;
        }
    }
}

