/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class IconUtilities {
    private int iconWidth;
    private int iconHeight;

    public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        boolean bl = jComponent.getWidth() != n3 || jComponent.getHeight() != n4;
        Rectangle rectangle = jComponent.getBounds();
        jComponent.setBounds(n, n2, n3, n4);
        SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
        jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (bl) {
            jComponent.validate();
        }
    }

    public void adjustIcons(JDesktopPane jDesktopPane) {
        JInternalFrame.JDesktopIcon jDesktopIcon = new JInternalFrame.JDesktopIcon(new JInternalFrame());
        Dimension dimension = jDesktopIcon.getPreferredSize();
        this.iconWidth = dimension.width;
        this.iconHeight = dimension.height;
        JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            jDesktopIcon = jInternalFrameArray[n].getDesktopIcon();
            dimension = jDesktopIcon.getPreferredSize();
            Point point = jDesktopIcon.getLocation();
            this.adjustBoundsForIcon(jDesktopIcon, point.x, point.y + dimension.height);
            ++n;
        }
    }

    protected void adjustBoundsForIcon(JInternalFrame.JDesktopIcon jDesktopIcon, int n, int n2) {
        JDesktopPane jDesktopPane = jDesktopIcon.getDesktopPane();
        int n3 = jDesktopPane.getHeight();
        int n4 = jDesktopPane.getWidth();
        int n5 = this.iconWidth;
        int n6 = this.iconHeight;
        jDesktopPane.repaint(n, n2, n5, n6);
        n = n < 0 ? 0 : n;
        n2 = n2 < 0 ? 0 : n2;
        n2 = n2 >= n3 ? n3 - 1 : n2;
        int n7 = n / n5 * n5;
        int n8 = n3 % n6;
        int n9 = (n2 - n8) / n6 * n6 + n8;
        int n10 = n - n7;
        int n11 = n2 - n9;
        int n12 = n = n10 < n5 / 2 ? n7 : n7 + n5;
        int n13 = n11 < n6 / 2 ? n9 : (n2 = n9 + n6 < n3 ? n9 + n6 : n9);
        if (n + n5 > n4) {
            n = 0;
            n2 -= this.iconHeight;
        }
        while (this.getIconAt(jDesktopPane, jDesktopIcon, n, n2) != null) {
            if ((n += n5) + n5 <= n4) continue;
            n = 0;
            n2 -= this.iconHeight;
        }
        if (n > jDesktopPane.getWidth()) {
            return;
        }
        if (jDesktopIcon.getParent() != null) {
            this.setBoundsForFrame(jDesktopIcon, n, n2, n5, n6);
        } else {
            jDesktopIcon.setLocation(n, n2);
        }
    }

    protected JInternalFrame.JDesktopIcon getIconAt(JDesktopPane jDesktopPane, JInternalFrame.JDesktopIcon jDesktopIcon, int n, int n2) {
        Object var5_5 = null;
        Component[] componentArray = jDesktopPane.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            Component component = componentArray[n3];
            if (component instanceof JInternalFrame.JDesktopIcon && component != jDesktopIcon) {
                Point point = component.getLocation();
                if (point.x == n && point.y == n2) {
                    return (JInternalFrame.JDesktopIcon)component;
                }
            }
            ++n3;
        }
        return null;
    }
}

